\name{clustIndex}
\title{Cluster Indexes}
\usage{ clustIndex ( y, x, index = "all" ) }
\alias{clustIndex}
\arguments{
\item{y}{Object of class \code{"cclust"} returned by a clustering algorithm such as \code{\link{kmeans}}}
\item{x}{Data matrix where columns correspond to variables and rows to observations}
\item{index}{The indexes that are calculated \code{"calinski"},
  \code{"cindex"}, \code{"db"}, \code{"hartigan"}, \code{"ratkowsky"},
  \code{"scott"}, \code{"marriot"}, \code{"ball"}, \code{"trcovw"},
  \code{"tracew"}, \code{"friedman"}, \code{"rubin"}, \code{"ssi"},
  \code{"likelihood"}, and \code{"all"} for all the
  indexes. Abbreviations of these names are also accepted.}
}

\description{
    \code{y} is the result of a clustering algorithm of class such
    as \code{"cclust"}.
    This function is calculating the values of several clustering
    indexes. The values of the indexes can be independenly used in order
    to determine the number of clusters existing in a data set.
}

\details{
    The description of the indexes is categorized into 3 groups, based
    on the statistics mainly used to compute them.\cr
    The first group is based on the sum of squares within (\eqn{SSW})
    and between (\eqn{SSB}) the clusters. These statistics measure the
    dispersion of the data points in a cluster and between the clusters
    respectively. These indexes are:
    \describe{
    	\item \bold{calinski}:
    	\eqn{(SSB/(k-1))/(SSW/(n-k))}, where \eqn{n} is the
    	number of data points and \eqn{k} is the number of clusters.
    	\item \bold{hartigan}: then \eqn{\log(SSB/SSW)}.
    	\item \bold{ratkowsky}: 
    	\eqn{mean(\sqrt{(varSSB/varSST)})}, where \eqn{varSSB} stands for
    	the \eqn{SSB} for every variable and \eqn{varSST} for the total sum of
    	squares for every variable.
    	\item \bold{ball}: \eqn{SSW/k}, where \eqn{k} is the
    	number of clusters.}
    The second group is based on the statistics of \eqn{T}, i.e., the
    scatter matrix of the data points, and \eqn{W}, which is the sum of the
    scatter matrices in every group. These indexes are:
    \describe{
    	\item \bold{scott}: \eqn{n\log(|T|/|W|)}, where \eqn{n}
    	is the number of data points and \eqn{|\cdot|} stands for the
    	determinant of a matrix.
    	\item \bold{marriot}: \eqn{k^2 |W|}, where \eqn{k} is
    	the number of clusters.
    	\item \bold{trcovw}: \eqn{Trace Cov W}.
    	\item \bold{tracew}: \eqn{Trace W}.
    	\item \bold{friedman}: \eqn{Trace W^{(-1)} B}, where
    	\eqn{B} is the scatter matrix of the cluster centers.
    	\item \bold{rubin}: \eqn{|T|/|W|}.}
    The third group consists of four algorithms not belonging to the
    previous ones and not having anything in common.
    \describe{
    	\item \bold{cindex}: if the data set is binary,
    	then while the C-Index is a cluster
    	similarity measure, is expressed as:\cr
    	\eqn{[d_{(w)}-\min(d_{(w)})]/[\max(d_{(w)})-\min(d_{(w)})]}, where
	\eqn{d_{(w)}}
    	is the sum of all \eqn{n_{(d)}} within cluster distances,
    	\eqn{\min(d_{(w)})} is the sum of the \eqn{n_{(d)}} smallest pairwise
    	distances in the data set, and \eqn{\max (d_{(w)})} is the sum of the
    	\eqn{n_{(d)}} biggest pairwise distances. In order to compute the
    	C-Index all pairwise distances in the data set have to be computed and
    	stored. In the case of binary data, the storage of the distances is
    	creating no problems since there are only a few possible
    	distances. However, the computation of all distances can make this
    	index prohibitive for large data sets.
    	\item \bold{db}: \eqn{R=(1/n)*sum(R_{(i)})}
    	where \eqn{R_{(i)}} stands for the maximum value of \eqn{R_{(ij)}} for
    	\eqn{i\neq j}, and \eqn{R_{(ij)}} for
    	\eqn{R_{(ij)}=(SSW_{(i)}+SSW_{(j)})/DC_{(ij)}}, where \eqn{DC_{(ij)}} is the
    	distance between the centers of two clusters \eqn{i, j}.
    	\item \bold{likelihood}: under the assumption of
    	independence of the variables within a cluster, a cluster solution
    	can be regarded as a mixture model for the data, where the cluster
    	centers give the probabilities for each variable to be
    	\eqn{1}. Therefore, the negative Log-likelihood can be computed and
    	used as a quantity measure for a cluster solution. Note that the
    	assumptions for applying special penalty terms, like in AIC or BIC,
    	are not fulfilled in this model, and also they show no effect for
    	these data sets.
    	\item \bold{ssi}: this ``Simple Structure Index''
    	combines three elements which influence the interpretability of a
    	solution, i.e., the maximum difference of each variable between the
    	clusters, the sizes of the most contrasting clusters and the
    	deviation of a variable in the cluster centers compared to its
    	overall mean. These three elements are multiplicatively combined and
    	normalized to give a value between \eqn{0} and \eqn{1}.}    
}

\value{
    Returns an vector with the indexes values.
}
\references{Andreas Weingessel, Evgenia Dimitriadou and Sara Dolnicar,
    An Examination Of Indexes For Determining The Number
    Of Clusters In Binary Data Sets,\cr
    \url{http://www.wu-wien.ac.at/am/wp99.htm#29}\cr
    and the references therein.
}
\author{Evgenia Dimitriadou and Andreas Weingessel
}

\seealso{\code{\link{cclust}}, \code{\link{kmeans}}}

\examples{
# a 2-dimensional example
x<-rbind(matrix(rnorm(100,sd=0.3),ncol=2),
         matrix(rnorm(100,mean=1,sd=0.3),ncol=2))
cl<-cclust(x,2,20,verbose=TRUE,method="kmeans")
resultindexes <- clustIndex(cl,x, index="all")
resultindexes   
}
\keyword{cluster}





\eof
\name{cclust}
\title{Convex Clustering }
\usage{
cclust (x, centers, iter.max=100, verbose=FALSE, dist="euclidean",
        method= "kmeans", rate.method="polynomial", rate.par=NULL)
}
\alias{cclust}
\alias{kmeans}
\alias{hardcl}
\alias{neuralgas}
\alias{print.cclust}
\arguments{
\item{x}{Data matrix where columns correspond to variables and rows to observations}
\item{centers}{Number of clusters or initial values for cluster centers}
\item{iter.max}{Maximum number of iterations}
\item{verbose}{If \code{TRUE}, make some output during learning}
\item{dist}{If \code{"euclidean"}, then mean square error, if \code{"manhattan "}, the mean absolute error is used}
\item{method}{If \code{"kmeans"}, then we have the kmeans clustering method,
              if \code{"hardcl"} we have the On-line Update (Hard Competitive
	      learning) method, and if \code{"neuralgas"}, we have the Neural
	      Gas (Soft Competitive learning) method. Abbreviations of
	      the method names are accepted.}
\item{rate.method}{If \code{"kmeans"}, then k-means learning rate, otherwise
                   exponential decaying learning rate.
                   It is used only for the Hardcl method.}
\item{rate.par}{The parameters of the learning rate.} 
}
\description{

  The data given by \code{x} is clustered by an algorithm.
      
  If \code{centers} is a matrix, its rows are taken as the initial cluster
  centers. If \code{centers} is an integer, \code{centers} rows
  of \code{x} are randomly chosen as initial values.

  The algorithm stops, if no cluster center has changed during the last
  iteration or the maximum number of iterations (given by
  \code{iter.max}) is reached.

  If \code{verbose} is \code{TRUE}, only for \code{"kmeans"} method, displays
  for each iteration the number of the iteration and the numbers
  of cluster indices which have changed since the last iteration is given.

  If \code{dist} is \code{"euclidean"}, the distance between the cluster center
  and the data points is the Euclidian distance (ordinary kmeans
  algorithm). If \code{"manhattan"}, the distance between the
  cluster center and the data points is the sum of the absolute values
  of the distances of the coordinates.

  If \code{method} is \code{"kmeans"}, then we have the kmeans clustering
  method, which works by repeatedly moving all cluster centers
  to the mean of their Voronoi sets. If \code{"hardcl"} we have the On-line
  Update (Hard Competitive learning) method, which works by performing
  an update directly after each input signal, and if \code{"neuralgas"} we have
  the Neural Gas (Soft Competitive learning) method, that sorts for each
  input signal the units of the network according to the distance
  of their reference vectors to input signal.


  If \code{rate.method} is \code{"polynomial"}, the polynomial learning rate
  is used, that means \eqn{1/t}, where t stands for the number of input
  data for which a particular cluster has benn the winner so far.
  If \code{"exponentially decaying"}, the exponential decaying learning rate
  is used according to \eqn{par1*{(par2/par1)}^{(iter/itermax)}} where \eqn{par1}
  and \eqn{par2} are the initial and final values of the l.rate.
    
  The parameters \code{rate.par} of the learning rate, where
  if \code{rate.method} is \code{"polynomial"} then by default rate.par=1.0,
  otherwise rate.par=(0.5,1e-5)}.
  
}
\value{
  \code{cclust} returns an object of class \code{"cclust"}.
  \item{centers}{The final cluster centers.}
  \item{initcenters}{The initial cluster centers.}
  \item{ncenters}{The number of the centers.}
  \item{cluster}{Vector containing the indices of the clusters where
      the data points are assigned to.}
  \item{size}{The number of data points in each cluster.}
  \item{iter}{The number of iterations performed.}
  \item{changes}{The number of changes performed in each iteration
      step with the Kmeans algorithm.}
  \item{dist}{The distance measure used.}
  \item{method}{The agorithm method being used.}
  \item{rate.method}{The learning rate being used by the Hardcl clustering
      method.}
  \item{rate.par}{The parameters of the learning rate.}
  \item{call}{Returns a call in which all of the arguments are
      specified by their names.}
  \item{withinss}{Returns the sum of square distances within the clusters.}
}
\author{Evgenia Dimitriadou}
\seealso{\code{\link{predict.cclust}}}
\examples{
# a 2-dimensional example
x<-rbind(matrix(rnorm(100,sd=0.3),ncol=2),
         matrix(rnorm(100,mean=1,sd=0.3),ncol=2))
cl<-cclust(x,2,20,verbose=TRUE,method="kmeans")
plot(x, col=cl$cluster)   

# a 3-dimensional example 
x<-rbind(matrix(rnorm(150,sd=0.3),ncol=3),
         matrix(rnorm(150,mean=1,sd=0.3),ncol=3),
         matrix(rnorm(150,mean=2,sd=0.3),ncol=3))
cl<-cclust(x,6,20,verbose=TRUE,method="kmeans")
plot(x, col=cl$cluster)

# assign classes to some new data
y<-rbind(matrix(rnorm(33,sd=0.3),ncol=3),
         matrix(rnorm(33,mean=1,sd=0.3),ncol=3),
         matrix(rnorm(3,mean=2,sd=0.3),ncol=3))
         ycl<-predict(cl, y)
         plot(y, col=ycl$cluster)
}
\keyword{cluster}





\eof
\name{predict.cclust}
\title{Assign clusters to new data}
\usage{
\method{predict}{cclust}(object, newdata, \dots)
}
\alias{predict.cclust}
\arguments{
 \item{object}{Object of class \code{"cclust"} returned by a clustering algorithm such as \code{\link{cclust}}}
 \item{newdata}{Data matrix where columns correspond to variables and
   rows to observations}
  \item{...}{currently not used}
}
\description{
  Assigns each data point (row in \code{newdata}) the cluster corresponding to
  the closest center found in \code{object}.
}
\value{
  \code{predict.cclust} returns an object of class \code{"cclust"}.
  Only \code{size} is changed as compared to the argument
  \code{object}. 
  \item{cluster}{Vector containing the indices of the clusters where
    the data is mapped.}
  \item{size}{The number of data points in each cluster.}
}
\author{Evgenia Dimitriadou}
\seealso{\code{\link{cclust}}}
}
\examples{
# a 2-dimensional example
x<-rbind(matrix(rnorm(100,sd=0.3),ncol=2),
         matrix(rnorm(100,mean=1,sd=0.3),ncol=2))
cl<-cclust(x,2,20,verbose=TRUE,method="kmeans")
plot(x, col=cl$cluster)   

# a 3-dimensional example
x<-rbind(matrix(rnorm(150,sd=0.3),ncol=3),
         matrix(rnorm(150,mean=1,sd=0.3),ncol=3),
         matrix(rnorm(150,mean=2,sd=0.3),ncol=3))
cl<-cclust(x,6,20,verbose=TRUE,method="kmeans")
plot(x, col=cl$cluster)

# assign classes to some new data
y<-rbind(matrix(rnorm(33,sd=0.3),ncol=3),
         matrix(rnorm(33,mean=1,sd=0.3),ncol=3),
         matrix(rnorm(3,mean=2,sd=0.3),ncol=3))
ycl<-predict(cl, y)
plot(y, col=ycl$cluster)
}
\keyword{cluster}



\eof
