grd.box.ts             package:clim.pact             R Documentation

_G_r_i_d _b_o_x _t_i_m_e _s_e_r_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plots time series from field objects, eg from `retrieve.nc'. Uses
     a bilinear interpolation scheme (`link{interp}') from the `akima'
     package.

_U_s_a_g_e:

     grd.box.ts(x,lon,lat,what="abs",greenwich=TRUE,mon=NULL,
                            col="grey10",lwd=1,lty=1,pch=26,add=FALSE,
                            filter=NULL)

_A_r_g_u_m_e_n_t_s:

       x: A field object.

     lon: Longitude to plot.

     lat: Latitude to plot.

    what: What to draw: "ano"-> anomalies, "cli"-> climatological
          values, "abs" -> absolute values.

greenwich: Maps centre on the Greenwich meridian.

     mon: Month to extract

     col: Colour.

     lwd: Line width

     lty: Line style.

     pch: Plot character.

     add: 'TRUE' adds curve to old plot.

  filter: If not NULL, this is a vector specifying window weighting
          argument of same name in `link{filter}'.

_V_a_l_u_e:

     A station object with interpolated values (see `station.obj' and
     `station.obj.dm') that can be plotted using eg `plotStation'.

_A_u_t_h_o_r(_s):

     R.E. Benestad

_E_x_a_m_p_l_e_s:

     slp <- retrieve.nc("ncep_slp.nc")
     grd.box.ts(slp,0,60,what="ano",mon=1)

