station.obj.dm           package:clim.pact           R Documentation

_M_a_k_e _d_a_i_l_y _c_l_i_m_a_t_e _s_t_a_t_i_o_n _s_e_r_i_e_s _o_b_j_e_c_t.

_D_e_s_c_r_i_p_t_i_o_n:

     Create a station object for use as predictand in empirical
     downscaling on monthly data. Also see `station.obj'.

_U_s_a_g_e:

     station.obj.dm(t2m,precip,dd,mm,yy,
                            obs.name=NULL,unit=NULL,ele=NULL,
                            station=NULL,lat=NULL,lon=NULL,alt=NULL,
                            location="unspecified",wmo.no=NULL,
                            start=NULL,yy0=NULL,country=NULL,ref=NULL)

_A_r_g_u_m_e_n_t_s:

     t2m: a vector holding daily mean temperature. 

  precip: a vector holding daily precipitation. 

      dd: a vector holding day of month.

      mm: a vector holding the month.

      yy: a vector holding the year.

obs.name: the name of observation:  eg c("Daily mean
          temperature","Daily precipitation"). 

    unit: the unite of observation: eg c("deg C","mm/day").

     ele: element code: eg c("tam","rr").

 station: local (national) station number.

     lat: latitude.

     lon: longitude.

     alt: altitude.

location: name of location. 

  wmo.no: WMO number of station.

   start: start of measurements.

     yy0: first year of record.

 country: name of country.

     ref: reference to the data.

_V_a_l_u_e:

     a "daily.station.record"-class object.

       t2m       a vector holding daily mean temperature.
       precip    a vector holding daily precipitation.
       day       a vector holding day of month.
       month     a vector holding the month.
       year      a vector holding the year.
       obs.name  the name of observation:
                 eg c("Daily mean temperature","Daily precipitation").
       unit      the unite of observation: eg c("deg C","mm/day").
       ele       element code: eg c("tam","rr").
       station   local (national) station number.
       lat       latitude.
       lon       longitude.
       alt       altitude.
       location  name of location.
       wmo.no    WMO number of station.
       start     start of measurements.
       yy0       first year of record.
       country   name of country.
       ref       reference to the data.

_A_u_t_h_o_r(_s):

     R.E. Benestad

_E_x_a_m_p_l_e_s:

     blindern.raw <-read.table("~/data/stations/blindern_rr_day.dat",header=TRUE)
     blindern.raw$rr[blindern.raw$rr < 0] <- NA
     yy <- floor(blindern.raw$yyyymmdd/10000)
     mm <- floor(blindern.raw$yyyymmdd/100) - 10000*yy
     dd <- blindern.raw$yyyymmdd - 100*mm  - 10000*yy
     blindern <- station.obj.dm(t2m=rep(NA,length(blindern.raw$rr)),
                                precip=blindern.raw$rr,
                                dd=dd,mm=mm,yy=yy,
                                obs.name=c("T(2m)","recip"),
                                unit=c("deg C","mm/day"),ele=NULL,
                                station=18700,lat=59.95,lon=10.71,alt=94,
                                location="Oslo-Blindern",wmo.no=NULL,
                                start=NULL,yy0=1937,country="Norway",
                                ref="www.met.no")

