\name{conf.design}
\alias{conf.design}
\title{
Construct symmetric confounded factorial designs.
}
\description{
Construct designs with specified treatment contrasts confounded with blocks.
}
\usage{
conf.design(G, p, block.name="Blocks", treatment.names=<<see below>>)
}
\arguments{
\item{G}{
Matrix whose rows define the contrasts to be confounded.  For example in a
\code{3^4} experiment with \code{A B^2 C} and \code{B C D} confounded with blocks (together with
their generalized interactions), the matrix G would be rbind(c(1,2,1,0)),
c(0,1,1,1)).  The number of columns of G is the number of factors.
}
\item{p}{
The common number of levels for each factor.  Must be a prime number.
}
\item{block.name}{
Name to be given to the factor defining the blocks of the design.  
}
\item{treatment.names}{
Name to be given to the treatment factors of the design.  If G has a
dimnames attribute, then dimnames[[2]] is the default, otherwise T1, T2,
}}
\value{
A design with a Blocks factor defining the blocks and Treatment factors
defining the way treatments are allocated to each plot.  Not in random
order. 
}
\section{Side Effects}{
None.
}
\details{
For a single replicate of treatments, blocks are calculated using the
confounded contrasts in the standard textbook way.  The method is related
to that of Collings (1989).
}
\references{
Collings, B. J. (1989) Quick confounding.  Technometrics, v31, pp107-110.
}
\seealso{
conf.set, direct.sum, fac.design, fractionate
}
\examples{
# Generate a 3^4 factorial with A B^2 C and B C D confounded with blocks.  
 d34 <- conf.design(rbind(c(1,2,1,0), c(0,1,1,1)), p=3, treatment.names
= LETTERS[1:4])
}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{conf.set}
\alias{conf.set}
\title{
Find confounded effects.
}
\description{
Find minimal complete sets of confounded effects from a defining set for
symmetric confounded factorial designs. Useful for checking if a low order
interaction will be unintentionally confounded with blocks. As in the
usual convention, only effects whose leading factor has an index of one are
listed.
}
\usage{
conf.set(G, p)
}
\arguments{
\item{G}{
Matrix whose rows define the effects to be confounded with blocks, in the
same way as for conf.design().
}
\item{p}{
Number of levels for each factor.  Must be a prime number.
}}
\value{
A matrix like G with a minimal set of confounded with blocks defined in the
rows.
}
\section{Side Effects}{
None
}
\details{
The function constructs all linear functions of the rows of G (over GF(p)),
and removes those rows whose leading non-zero component is not one.
}
\seealso{
conf.design
}
\examples{
 G <- rbind(c(1,2,1,0), c(0,1,1,1))
 dimnames(G) <- list(NULL, LETTERS[1:4])
 conf.set(G, 3)
 #     A B C D 
 # [1,] 1 2 1 0
 # [2,] 0 1 1 1
 # [3,] 1 0 2 1
 # [4,] 1 1 0 2
 # If A B^2 C and B C D are confounded with blocks, then so are A C^2 D
 # and A B D^2.  Only three-factor interactions are confounded, so the
 # design is presumably useful.
}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{direct.sum}
\alias{direct.sum}
\title{
Form the direct sum of designs.
}
\description{
Constructs the direct sum of two or more designs.  Each plot of one design
is matched with every plot of the other.  (This might also be called the
Cartesian product of two designs).
}
\usage{
direct.sum(D1, D2, \dots, tiebreak=letters)
}
\arguments{
\item{D1}{
First component design.
}
\item{D2}{
Second component design.
}
\item{...}{
Additional component designs, if any.
}
\item{tiebreak}{
Series of characters or digits to be used for breaking ties (or repeats) in
the variable names in the component designs.
}}
\value{
The direct sum of all component designs.
}
\section{Side Effects}{
None.
}
\details{
Each plot of one design is matched with every plot of the other, and so on
recursively.
}
\seealso{
conf.design, fac.design, fractionate
}
\examples{
 # Generate a half replicate of a 2^3 x 3^2 experiment.  The factors are
 # to be A, B, C, D, E.  The fractional relation is to be I = ABC and the
 # DE effect is to be confounded with blocks.


 # First construct the 2^3 design, confounded in two blocks:
 d1 <- conf.design(c(1,1,1), p=2, treatment.names=LETTERS[1:3])


 # Next the 3^2 design, with DE confounded in blocks:
 d2 <- conf.design(c(1,1), p=3, treatment.names=LETTERS[4:5])


 # Now extract the principal block from the 2^3 design and form the direct
 # sum withthe 3^2 design
 dsn <- direct.sum(d1[d1$Blocks=="0",], d2)


}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{factorize}
\alias{factorize}
\alias{factorize.default}
\alias{factorize.factor}
\title{
Generic function.
}
\description{
The default method factorizes positive numeric integer arguments, returning
a vector of prime factors.  The factor method can be used to generate
pseudo-factors.  It accepts a factor, f, as principal argument and returns
a design with factors fa, fb, \dots{} each with a prime number of levels such
that f is model equivalent to join(fa, fb, \dots{}).
}
\usage{
factorize(x, \dots)
}
\arguments{
  \item{x}{Principal argument.  At this stage, it may be a numeric
    vector to elicit the default method, or a factor to elicit the
    factor method.}
  \item{\dots}{Additional arguments, if any.}
}
\value{
  A vector of (numeric) factors for numeric arguments, or a design with
  (S-PLUS) factors with prime numbers of levels for factor arguments.
}
\section{Side Effects}{
  None.
}
\details{
  Factorizes by a clumsy though effective enough way for small integers.
  May become very slow if some prime factors are large.  For the factor
  method it generates pseudo factors in the usual way.
}
\seealso{
conf.design, join
}
\examples{
 factorize(18)
 # [1] 2 3 3
 f <- factor(rep(0,5), rep(6,5))
 fd <- factorize(f)
}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{join}
\alias{join}
\title{
Amalgamate two or more factors.
}
\description{
Joins two or more factors together into a single composite factor defining
the subclasses.  In a model formula join(f1, f2, f3) is equivalent to
f1:f2:f3.
}
\usage{
join(\dots)
}
\arguments{
\item{...}{
Two or more factors or numeric vectors, or objects of mode list containing
these kinds of component.
}}
\value{
A single composite factor with levels made up of the distinct combinations
of levels or values of the arguments which occur.
}
\section{Side Effects}{
None.
}
\details{
Similar in effect to paste(), which it uses.
}
\seealso{
paste, rjoin, direct.sum
}
\examples{
 d1 <- conf.design(c(1,1,1), 2, treatment.names=LETTERS[1:3])
 d2 <- conf.design(c(0,1,1), 2, treatment.names=LETTERS[1:3])
 fd1d2 <- join(d1,d2)
}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{primes}
\alias{primes}
\title{
Prime numbers
}
\description{
Generate a table of prime numbers.
}
\usage{
primes(n)
}
\arguments{
\item{n}{
Positive integer value.
}}
\value{
A vector of all prime numbers less than the argument.  1 is not a prime.
}
\section{Side Effects}{
None
}
\details{
Uses an elementary sieve method, not suitable for very large n.  This
function is no longer used as part of the design library and is included
for curiosity value only.
}
\seealso{
factorize
}
\examples{
 primes(50)
 # [1]  2  3  5  7 11 13 17 19 23 29 31 37 41 43 47
}
\keyword{design}
% Converted by Sd2Rd version 1.10.
\eof
\name{rjoin}
\alias{rjoin}
\title{
Concatenate designs by rows.
}
\description{
Combine two or more designs with the same names into a single design by row
concatenation.
}
\usage{
rjoin(\dots, part.name="Part")
}
\arguments{
\item{...}{
Two or more designs with identical component names.
}
\item{part.name}{
Name for an additional factor to identify the original components in the result.
}}
\value{
A single design with the arguments stacked above each other (in a similar
manner to rbind()), together with an additional factor whose levels
identify the original component designs, or \code{parts}.
}
\section{Side Effects}{
None.
}
\details{
Almost the same as rbind(), but an additional factor in the result
separates the original components.
}
\seealso{
conf.design, join, direct.sum
}
\examples{
 # A two replicate partially confounded factorial design.
 d1 <- conf.design(c(1,1,1), 2, treatment.names=LETTERS[1:3])
 d2 <- conf.design(c(0,1,1), 2, treatment.names=LETTERS[1:3])
 dsn <- rjoin(d1, d2)
}
\keyword{design}
% Converted by Sd2Rd version 1.10.

\eof
