### Name: autosearch
### Title: Greedy search
### Aliases: autosearch heuristic makenw as.network modelstreng
### Keywords: models

### ** Examples

data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit,12)
fit       <- learn(fit,rats,fit.prior)$nw
fit       <- insert(fit,2,1,rats,fit.prior)$nw
fit       <- insert(fit,1,3,rats,fit.prior)$nw
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE)
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE,removecycles=TRUE) # slower
plot(hisc$nw)

hisc2     <- heuristic(fit,rats,fit.prior,restart=10,trace=FALSE)
plot(hisc2$nw)
print(modelstreng(hisc2$nw))
plot(makenw(hisc2$tabel,fit))



