### Name: network
### Title: Bayesian network data structure
### Aliases: network plot.network prob.network print.network banlist
###   banlist<-
### Keywords: models

### ** Examples

A <- factor(rep(c("A1","A2"),50))
B <- factor(rep(rep(c("B1","B2"),25),2))
thisnet <- network( data.frame(A,B) )

set.seed(109)
sex     <- gl(2,4,label=c("male","female"))
age     <- gl(2,2,8)
yield   <- rnorm(length(sex))
weight  <- rnorm(length(sex))
mydata  <- data.frame(sex,age,yield,weight)
mynw    <- network(mydata)

# adjust prior probability distribution
mynw$nodes$sex$prob[1:2]   <- c(0.4,0.6)
mynw$nodes$age$prob[1:2]   <- c(0.6,0.4)
mynw$nodes$yield$prob[1:2] <- c(2,0)
mynw$nodes$weight$prob[1:2]<- c(1,0)

print(mynw)
plot(mynw)

prior <- jointprior(mynw)
mynw  <- learn(mynw,mydata,prior)$nw
thebest <- autosearch(mynw,mydata,prior)$nw

print(mynw,condposterior=TRUE)

##Don't run: savenet(mynw,"yield.net")



