### Name: predict.inbagg
### Title: Predictions from an Inbagg Object
### Aliases: predict.inbagg
### Keywords: misc

### ** Examples

library(mvtnorm)
y <- as.factor(sample(1:2, 100, replace = TRUE))
W <- rmvnorm(200, mean = rep(0, 3))

X <- rmvnorm(200, mean = rep(2, 3))
colnames(W) <- c("w1", "w2", "w3")
colnames(X) <- c("x1", "x2", "x3")
DATA <- data.frame(y, W, X)

pFUN <- list(list(formula = w1~x1+x2, model = lm),
list(model = rpart))

RES <- inbagg(y~w1+w2+w3~x1+x2+x3, data = DATA, pFUN = pFUN)
predict(RES, newdata = X)



