\name{find.ice}
\alias{find.ice}
\title{
minimum of information criteria aic or bic
}
\description{
  internal function used by pear to calculate the minimum aic or bic
  values
}
\keyword{internal}
% Converted by Sd2Rd version 1.21.
\eof
\name{fraser}
\alias{fraser}
\title{
Fraser River at Hope, mean monthly flow (cms),  1912.3-1991.12
}
\description{
Mean monthly flow data.
}
\usage{data(fraser)}
\format{A ts object containing monthly data for 1912.3-1991.12}
\source{Environment Canada CDROM}
\keyword{datasets}
% Converted by Sd2Rd version 1.21.
\eof
\name{ozone}
\alias{ozone}
\title{
Ozone concentration, downtown L.A., 1955.1-1972.12
}
\description{
Ozone concentration, downtown L.A., 1955.1-1972.12
in parts per hundred million
}
\usage{data(ozone)}
\format{A ts object containing monthly data for 1955.1-1972.12.}
\source{}
\keyword{datasets}
% Converted by Sd2Rd version 1.21.
\eof
\name{peacf}
\alias{peacf}
\title{
Periodic Autocorrelation Function
}
\description{
The periodic autocorrelation for a time series with period p may be
defined as for period (m=1,\dots,p) and lag, l=1,2,\dots by
r(m, l) = c(m, l)/sqrt(c(m, 0)*c(m-l, 0))
where c(m, l) is the periodic autocovariance defined by
c(m, l) = sum(z[t] * z[t-l])
where the sum is over all data in period m.
When p=1, peacf produces output which is equivalent to that produced
by Splus function acf.


}
\usage{
peacf(z, lag.max, plot=TRUE)
}
\arguments{
\item{z}{
a univariate time series object. Note that the period of
z is given by attr(z, "tsp")[3]. Additional information about
the time series can be provided in a title string by setting
attr(z, "title") to the desired string. This title will then
be displayed on the plot. Abbreviations for the periods may
be provided in attr(z, "abb"). For example, to use the standard
monthly abbreviations: attr(z, "abb")<-month.abb. These abbreviations 
will be used to aid one in interpreting the output.
}
\item{lag.max}{
maximum lag, if missing default is 0.25*length(z)/p, where
p = attr(z, "tsp")[3]
}
\item{plot}{
if plot=TRUE, a plot of the periodic autocorrelations is produced.
}}
\value{
a list is returned with the following components: 
means                      periodic means
standard.deviations	   periodic standard deviations
acf			   matrix of periodic autocorrelations
benchmark.sd		   1/sqrt(nyrs), nyrs=ceiling(length(z)/p)
sub.lengths		   number of observations in each period
period			   p = attr(z, "tsp")[3]
title			   title = attr(z, "title")
periodicity.test	   list: test for periodic correlation at lag 1
                                 The components of this list are:
				 Q1 = scalar value, the test statistic
				 Q1.sl = signifiance level (upper tail)
portmanteau.test	   list: portmanteau test at various lags
                                 The components of this list are:
				 QM = matrix of portmanteau statistics
				      for each period and lag
				 QM.df = corresponding df of QM
}
\section{Side Effects}{
a plot may be produced if plot=TRUE
}
\details{
The use of the periodic autocorrelation and its plot are discussed
in McLeod (1994) and a portmanteau model adequacy test is developed
therein. The periodicity test is discussed in McLeod (1993).
For more details, see the references below.
}
\references{
Hipel, K.W. and McLeod, A.I. (1994) "Time Series Modelling of 
Water Resources and Environmental Systems"  Elsevier, Amsterdam
ISBN 0--444--89270--2.  (1013 pages).
McLeod, A.I. (1993), "Parsimony, Model Adequacy and Periodic Correlation
in Time Series Forecasting", International Statistical Review, 
Vol. 61, No. 3, pp.387--393.
McLeod, A.I. (1994), "Diagnostic Checking of Periodic Autoregression"
Journal of Time Series Analysis, Vol. 15, No. 2, pp.221--233.
}
\seealso{
peacf.plot, pepacf, peplot, peboxplot, pear, acf, acf.plot
}
\examples{
data(fraser)
peacf(log(fraser))
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.




\eof
\name{peacf.plot}
\alias{peacf.plot}
\title{
periodic correlation plot
}
\description{
Produces auto and partial periodic correlation plots using the output
from peacf and pepacf. If plot=TRUE in the argument to peacf or pepacf
then these functions call peacf.plot.
}
\usage{
peacf.plot(r)
}
\arguments{
\item{r}{
list returned from peacf or pepacf
}}
\value{
NULL
}
\section{Side Effects}{
plot produced
}
\details{
The plot shows the periodic correlations at various lags along
with benchmark 95\% limits for no correlation effect. 
}
\references{
McLeod, A.I. (1994), "Diagnostic Checking of Periodic Autoregression"
Journal of Time Series Analysis, Vol. 15, No. 2, pp.221--233.
}
\seealso{
peacf, pepacf
}
\examples{
data(fraser)
acf.out <- peacf(log(fraser), plot=FALSE)
peacf.plot(acf.out)
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.
\eof
\name{pear}
\alias{pear}
\title{
fit a periodic autoregression model
}
\description{
Periodic time series models of any order, say m[j], for the j-th
period, j=1,\dots,p can be fit to a periodic time series of period p.
A generalization of the Yule-Walker method is used so that when p=1
the results from this function will be equivalent to the Splus
function ar.yw(). If desired the aic or bic criterion can be used
to select the model orders. Otherwise the user can select based on
the partial autocorrelation function as suggested in Box and Jenkins
(1976) and McLeod (1994). 
}
\usage{
pear(z, m, ic="none")
}
\arguments{
\item{z}{
a univariate time series object. Note that the period of
z is given by attr(z, "tsp")[3]. Additional information about
the time series can be provided in a title string by setting
attr(z, "title") to the desired string. This title will then
be displayed on the plot. Abbreviations for the periods may
be provided in attr(z, "abb"). For example, to use the standard
monthly abbreviations: attr(z, "abb")<-month.abb. These abbreviations 
will be used to aid one in interpreting the output.
}
\item{m}{
If ic="none" then m is a required argument. In this case m
specifies the order of the periodic autoregression to be fitted.
Typically m is specified as a vector of length p where p is the
period and m[k], k=1,\dots,p indicates the order for the k-th period.
For convenience, if all periods are the same order then m can
just be that scalar value. When ic="aic" or ic="bic" then the
argument m is ignored.
}
\item{ic}{
The default ic="none" means the model orders are supplied.
Otherwise if ic="aic" or ic="bic" the automatic criteria aic or bic
are used.
}}
\value{
a list with the following named components:
model.orders              vector of length p, indicating the fitted
                          ar order for each period k, k=1,\dots,p
phi			  matrix of dimension p by m where m = 
                          max(model.orders). The (i,j) entry is
			  phi[i,j] which is the autoregression 
			  coefficient for period i and lag j.
se.phi			  matrix of standard deviations for the
                          estimated phi's. For those phi's set
			  to 0, the corresponding se.phi's are 
			  also set to 0.
resvar			  vector of length p
residuals		  time series object of length(z)
portmanteau.test	   list: portmanteau test at various lags
                                 The named components of this list are:
				 QM = matrix of portmanteau statistics
				      for each period and lag
				 QM.df = corresponding df of QM
				 QM.sl = corresponding sl of QM
residual.acf		  residual autocorrelation matrix
residual.acf.sd           estimated standard errors of the residual
                          autocorrelations
cov			  list with p components:
                                 cov[[i]] is the estimated covariance
				 matrix for the parameters of period i
}
\section{Side Effects}{
none
}
\details{
Let z[t] be a period time series with period p and let m[j] denote
the order of the autoregressive model for the j-th period, j=1,\dots,p.
The parameters of this model can be estimated using the Yule-Walker
type equations given in McLeod eq (3.1) and (3.2). The covariance
matrix of the autoregressive parameters is obtained by replacing
the theoretical autocovariances in eq (3.3, note addendum correction)
with their sample values.


}
\references{
Box, G.E.P. and Jenkins, G.M. (1976), "Time Series Analysis: Forecasting
and Control", Holden-Day: San Franciso.
Hipel, K.W. and McLeod, A.I. (1994) "Time Series Modelling of 
Water Resources and Environmental Systems"  Elsevier, Amsterdam
ISBN 0-444-89270-2.  (1013 pages).
McLeod, A.I. (1994), "Diagnostic Checking of Periodic Autoregression"
Journal of Time Series Analysis, Vol. 15, No. 2, pp.221--233.
McLeod, A.I. (1995), Errata (see file errata.tex included
with these files)
}
\seealso{
peacf, pepacf, ar.yw
}
\examples{
data(fraser)
pear(log(fraser), ic="bic")
}
\keyword{ts}
% Converted by Sd2Rd version 1.10.
\eof
\name{peboxplot}
\alias{peboxplot}
\title{
boxplots of a periodic time series
}
\description{
Side-by-side boxplots are produced for each period in a periodic
time series. These plots can reveal many important features in a
periodic time series such as the need for a variance stablizing
transformation, outliers, heteroscedasticity not removable by a
power transformation, etc. The peboxplot is a useful adjunct to
the Splus functions tsplot and monthplot.
}
\usage{
peboxplot(z, \dots)
}
\arguments{
\item{z}{
a univariate time series object. Note that the period of
z is given by attr(z, "tsp")[3]. Additional information about
the time series can be provided in a title string by setting
attr(z, "title") to the desired string. This title will then
be displayed on the plot. Abbreviations for the periods may
be provided in attr(z, "abb"). For example, to use the standard
monthly abbreviations: attr(z, "abb")<-month.abb. These abbreviations 
will be used to aid one in interpreting the output.
}
\item{...}{
optional arguments which are passed to the Splus boxplot function
}}
\value{
NULL
}
\section{Side Effects}{
plot produced
}
\details{
Boxplots of seasonal data are vary useful in many applications. See
Hipel and McLeod (1994) for examples.
}
\references{
Hipel, K.W. and McLeod, A.I. (1994) "Time Series Modelling of 
Water Resources and Environmental Systems"  Elsevier, Amsterdam
ISBN 0--444--89270--2.  (1013 pages).
}
\seealso{
peplot, monthplot, tsplot
}
\examples{
data(fraser)
peboxplot(log(fraser))
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.
\eof
\name{pepacf}
\alias{pepacf}
\title{
periodic partial autocorrelation function
}
\description{
The periodic partial autocorrelation function of a periodic
time series is calculated and plotted if the argument
plot=TRUE. When the period, p=1, this reduces to the usual partial 
autocorrelation function as defined in Box and Jenkins (1976)
and is equivalent then to the Splus function acf(type="partial").
As discussed in Box and Jenkins (1976), McLeod (1994) and 
Hipel and McLeod (1994) the partial autocorrelation is a 
valuable tool in selecting the model order.
}
\usage{
pepacf(z, lag.max, plot=TRUE, acf.out)
}
\arguments{
\item{z}{
a univariate time series object. Note that the period of
z is given by attr(z, "tsp")[3]. Additional information about
the time series can be provided in a title string by setting
attr(z, "title") to the desired string. This title will then
be displayed on the plot. Abbreviations for the periods may
be provided in attr(z, "abb"). For example, to use the standard
monthly abbreviations: attr(z, "abb")<-month.abb. These abbreviations 
will be used to aid one in interpreting the output.
}
\item{lag.max}{
maximum lag, if missing default is 0.25*length(z)/p, where
p = attr(z, "tsp")[3]
}
\item{plot}{
if plot=TRUE, a plot of the periodic autocorrelations is produced.
}
\item{acf.out}{
output from peacf function. If this is provided, execution will
proceed faster, otherwise it is calculated from scratch.
}}
\value{
a list containing the following components:
 acf.out	      output list from peacf
 pacf		      matrix of partial autocorrelations
 residual.sd 	      matrix of residual standard deviations of
                      the fitted models of order m, m=1,2,\dots,lag.max
 phi		      matrix of autoregressive coefficients in the final 
                      model of order lag.max for each period
 aic		      matrix of aic values for each period and lag
 bic		      matrix of bic values for each period and lag
 maice		      vector of length p of the minimum aic models
 mbice		      vector of length p of the minimum bic models
}
\section{Side Effects}{
a plot is produced if plot=TRUE
}
\details{
For the detailed derivation of the algorithm see Sakai (1982).
Note that our partial autocorrelation is the negative of that
given in Sakai's paper. 
}
\references{
Box, G.E.P. and Jenkins, G.M. (1976), "Time Series Analysis: Forecasting
and Control", Holden-Day: San Franciso.
Hipel, K.W. and McLeod, A.I. (1994) "Time Series Modelling of 
Water Resources and Environmental Systems"  Elsevier, Amsterdam
ISBN 0--444--89270--2.  (1013 pages).
McLeod, A.I. (1994), "Diagnostic Checking of Periodic Autoregression"
Journal of Time Series Analysis, Vol. 15, No. 2, pp.221--233.
Sakai, H. (1982), "Circular lattice filtering using Pagano's Method",
IEEE Transactions, Acoust. Speech, Signal Processing, Vol. 30, pp.279--287.
}
\seealso{
peacf, peacf.plot, peplot, acf, acf.plot
}
\examples{
data(fraser)
pepacf(log(fraser))
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.
\eof
\name{peplot}
\alias{peplot}
\title{
Periodic Correlation Visualization Plot
}
\description{
In order to visualize dependence at lag k in a periodic series it
is useful to plot z[t] vs z[t-k] for each period, m=1,2,\dots,p.
For example in a monthly series we look at scatter plots of Jan vs
Dec (previous year), Feb vs Jan, Mar vs Feb, etc. for the lag 1 plots.
}
\usage{
peplot(z, lag=1, label=FALSE, mfrow=c(2, 2))
}
\arguments{
\item{z}{
a univariate time series object. Note that the period of
z is given by attr(z, "tsp")[3]. Additional information about
the time series can be provided in a title string by setting
attr(z, "title") to the desired string. This title will then
be displayed on the plot. Abbreviations for the periods may
be provided in attr(z, "abb"). For example, to use the standard
monthly abbreviations: attr(z, "abb")<-month.abb. These abbreviations 
will be used to aid one in interpreting the output.
}
\item{lag}{
lag separation
}
\item{label}{
if label = TRUE, the Splus identify() function will be called allowing
one to identify and label particular data points on the plots.
}
\item{mfrow}{
Since many plots may be produced, the default is to produced 4 plots 
per page.
}}
\value{
NULL
}
\section{Side Effects}{
plot produced
}
\details{
The importance of looking at these plots was noted by Cox (1981)
}
\references{
Cox, D.R. (1981), "Statistical Analysis of Time Series: Some Recent
Developments", Scandinavian Journal of Statistics, Vol. 8, pp.93--115.
}
\seealso{
}
\examples{
data(fraser)
peplot(log(fraser))
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.
\eof
\name{pepsi}
\alias{pepsi}
\title{
moving average expansion of a periodic autoregression
}
\description{
A periodic autoregression can be represented as an infinite
periodic moving average process. This function calculates
the coefficients in this expansion. These coefficients are
needed in various time series computations such as in computing
the variances of forecasts, variances of residual autocorrelations
and theoretical autocovariances of a periodic autoregression.
The function pepsi is used by pear to calculate the estimated
standard deviations of the residual autocorrelations in a fitted
periodic autoregression.
}
\usage{
pepsi(phi, lag.max)
}
\arguments{
\item{phi}{
matrix with (i,j)-entry phi[i, j] where phi[i,j] is the 
autoregressive coefficient for period i at lag j. Here i=1,\dots,p 
and j=1,\dots,m where m is highest ar order specified.
}
\item{lag.max}{
maximum number of lags to calculate in the moving average expansion.
}}
\value{
matrix with (i,j)-entry psi[i, j] where psi[i,j] is the 
autoregressive coefficient for period i at lag j. Here i=1,\dots,p 
and j=1,\dots,lag.max.
}
\section{Side Effects}{
none
}
\details{
The moving average expansion for a periodic autoregressive is defined
in equation (1.4) of McLeod (1994) and the algorithm implements
the recursion given in equation (1.5).
}
\references{
McLeod, A.I. (1994), "Diagnostic Checking of Periodic Autoregression"
Journal of Time Series Analysis, Vol. 15, No. 2, pp.221--233.
}
\seealso{
pear
}
\examples{
data(fraser)
pear.out <- pear(log(fraser), ic="bic")
pepsi(pear.out$phi,lag.max=20)
}
\keyword{ts}
% Converted by Sd2Rd version 1.21.
\eof
\name{var.periodic.correlation}
\alias{var.periodic.correlation}
\title{
variance of the periodic autocorrelations
}
\description{
  internal function used by pear to calculate the variance of periodic
  autocorrelations.
}
\keyword{internal}
% Converted by Sd2Rd version 1.21.
\eof
