\name{filtering}
\alias{filtering}
\title{
Filter data before feeding som algorithm for gene expression data
}
\description{
Filtering data by certain floor, ceiling, max/min ratio, and max - min difference. 
}
\usage{
filtering(x, lt=20, ut=16000, mmr=3, mmd=200)
}
\arguments{
  \item{x}{
    a data frame or matrix of input data.
  }
  \item{lt}{
    floor value replaces those less than it with the value
  }
  \item{ut}{
    ceiling value replaced those greater than it with the value
  }
  \item{mmr}{
    the max/min ratio, rows with max/min < mmr will be removed
  }
  \item{mmd}{
    the max - min difference, rows with (max - min) < mmd will be removed
  }
}
\value{
  An dataframe or matrix after the filtering
}
\author{
  Jun Yan <jyan@stat.uiowa.edu>
}
\seealso{
\code{\link{normalize}}.
}
\keyword{
  manip
}

\eof
\name{normalize}
\alias{normalize}
\title{
normalize data before feeding som algorithm
}
\description{
Normalize the data so that each row has mean 0 and variance 1.
}
\usage{
normalize(x, byrow=TRUE)
}
\arguments{
  \item{x}{
    a data frame or matrix of input data.
  }
  \item{byrow}{
    whether normalizing by row or by column, default is byrow.
  }
}
\value{
  An dataframe or matrix after the normalizing.
}
\author{
  Jun Yan <jyan@stat.uiowa.edu>
}
\seealso{
  \code{\link{filtering}}.
}
\keyword{
  manip
}


\eof
\name{plot.som}
\alias{plot.som}
\title{ Visualizing a SOM }
\description{
 Plot the SOM in a 2-dim map with means and sd bars.
}
\usage{
\method{plot}{som}(x, sdbar=1, ylim=c(-5, 5), color=TRUE,
ntik=3, yadj=0.1, xlab="", ylab="", ...)
}
\arguments{
  \item{x}{ a som object }
  \item{sdbar}{ the length of sdbar in sd, no sdbar if sdbar=0 }
  \item{ylim}{ the range of y axies in each cell of the map }
  \item{color}{ whether or not use color plotting }
  \item{ntik}{ the number of tiks of the vertical axis }
  \item{yadj}{ the proportion used to put the number of obs }
  \item{xlab}{ x label }
  \item{ylab}{ y label }
  \item{\dots}{ other options to plot }
}
\note{
  This function is not cleanly written. The original purpose was to
  mimic what GENECLUSTER does. The ylim is hardcoded so that only
  standardized data could be properly plotted.

  There are visualization methods like umat and sammon in SOM\_PAK3.1,
  but not implemented here. 
}
\author{ Jun Yan <jyan@stat.uiowa.edu> }
\examples{
foo <- som(matrix(rnorm(1000), 250), 3, 5)
plot(foo, ylim=c(-1, 1))
}
\keyword{
  hplot
}
\eof
\name{qerror}
\alias{qerror}
\title{ quantization accuracy }
\description{
  get the average distortion measure
}
\usage{
qerror(obj, err.radius=1)
}
\arguments{
  \item{obj}{ a `som' object }
  \item{err.radius}{ radius used calculating qerror }
}
\value{
  An average of the following quantity (weighted distance measure) over all x in the sample,
  \deqn{\sum ||x - m_i|| h_{ci}}{sum |x - m\_i| h\_{ci}}
  where \eqn{h_{ci}}{h\_{ci}} is the neighbourhood kernel for the ith code.
}
\author{
  Jun Yan <jyan@stat.uiowa.edu>
}
\examples{
foo <- som(matrix(rnorm(1000), 100), 2, 4)
qerror(foo, 3)
}
\keyword{arith}
\eof
\name{som-internal}
\alias{ciplot}
\alias{inrange}
\alias{plotcell}
\alias{somgrids}
\alias{somsum}
\alias{som.par}
\title{Internal som functions}
\description{
  Internal som Functions.
}
\usage{
ciplot(x, y, se, n=1, d, ywindow)
inrange(x, xlim)
plotcell(x, y, dat, code, n, sdbar=1, ylim, yadj)
somgrids(xdim, ydim, color, yadj=0.1, hexa, ntik, ylim)
somsum(obj)
som.par(obj)
}
\details{
  These are not to be called directly by the user.
}
\keyword{internal}
\eof
\name{som}
\alias{som.init}
\alias{som}
\alias{som.train}
\alias{som.update}
\alias{som.project}
\title{
Function to train a Self-Organizing Map
}
\description{
Produces an object of class "som" which is a Self-Organizing Map fit of the data.
}
\usage{
som.init(data, xdim, ydim, init="linear")
som(data, xdim, ydim, init="linear", alpha=NULL, alphaType="inverse",
neigh="gaussian", topol="rect", radius=NULL, rlen=NULL, err.radius=1,
inv.alp.c=NULL)
som.train(data, code, xdim, ydim, alpha=NULL, alphaType="inverse",
neigh="gaussian", topol="rect", radius=NULL, rlen=NULL, err.radius=1, inv.alp.c=NULL)
som.update(obj, alpha = NULL, radius = NULL, rlen = NULL, err.radius =
1, inv.alp.c = NULL)
som.project(obj, newdat)
}
\arguments{
  \item{obj}{a `som' object.}
  \item{newdat}{a new dataset needs to be projected onto the map.}
  \item{code}{a matrix of initial code vector in the map.}
  \item{data}{
    a data frame or matrix of input data.
  }
  \item{xdim}{
    an integer specifying the x-dimension of the map.
  }
  \item{ydim}{
    an integer specifying the y-dimension of the map.
  }
  \item{init}{
    a character string specifying the initializing method. The following
    are permitted:
    \code{"sample"} uses a radom sample from the data;
    \code{"random"} uses random draws from N(0,1);
    \code{"linear"} uses the linear grids upon the first two principle
    components directin.
  }
  \item{alpha}{
    a vector of initial learning rate parameter for the two training
    phases. Decreases linearly to zero during training.
  }
  \item{alphaType}{
    a character string specifying learning rate funciton type. Possible
    choices are linear function (\code{"linear"}) and inverse-time type
    function (\code{"inverse"}).
  }
  \item{neigh}{
    a character string specifying the neighborhood function type. The
    following are permitted:

    \code{"bubble"}
    \code{"gaussian"}
  }
  \item{topol}{
    a character string specifying the topology type when measuring
    distance in the map. The following are permitted:

    \code{"hexa"}
    \code{"rect"}
  }
  \item{radius}{
    a vector of initial radius of the training area in som-algorithm for
    the two training phases. Decreases linearly to one during training.
  }
  \item{rlen}{
    a vector of running length (number of steps) in the two training phases.
  }
  \item{err.radius}{
    a numeric value specifying the radius when calculating average
    distortion measure.
  }
  \item{inv.alp.c}{
    the constant C in the inverse learning rate function:
    alpha0 * C / (C + t);
  }
}
\value{
  `som.init' initializes a map and returns the code matrix. `som' does
  the two-step som training in a batch fashion and return a `som'
  object. `som.train' takes data, code, and traing parameters and
  perform the requested som training. `som.update' takes a `som' object
  and further train it with updated paramters. `som.project' projects
  new data onto the map.
  
  An object of class \code{"som"} representing the fit, which is a list
  containing the following components:
  
  \item{data}{the dataset on which som was applied.}
  \item{init}{a character string indicating the initializing method.}
  \item{xdim}{an integer specifying the x-dimension of the map.}
  \item{ydim}{an integer specifying the y-dimension of the map.}
  \item{code}{a metrix with nrow = xdim*ydim, each row corresponding to
    a code vector of a cell in the map. The mapping from cell coordinate
    (x, y) to the row index in the code matrix is:
    rownumber = x + y * xdim
  }
  \item{visual}{a data frame of three columns, with the same number of
    rows as in data: x and y are the coordinate of the corresponding
    observation in the map, and qerror is the quantization error
    computed as the squared distance (depends topol) between the observation
    vector and its coding vector.
  }
  \item{alpha0}{a vector of initial learning rate parameter for the two
    training phases.}
  \item{alpha}{a character string specifying learning rate funciton
    type.}
  \item{neigh}{a character string specifying the neighborhood function
    type.}
  \item{topol}{a character string specifying the topology type when measuring
    distance in the map.}
  \item{radius0}{a vector of initial radius of the training area in
    som-algorithm for the two training phases.}
  \item{rlen}{a vector of running length in the two training phases.}
  \item{qerror}{a numeric value of average distortion measure.}
  \item{code.sum}{a dataframe summaries the number of observations in
    each map cell.}
}
\references{
  Kohonen, Hynninen, Kangas, and Laaksonen (1995), SOM-PAK, the
  Self-Organizing Map Program Package (version 3.1).
  http://www.cis.hut.fi/research/papers/som\_tr96.ps.Z}
\author{
  Jun Yan <jyan@stat.uiowa.edu>
}
\examples{
data(yeast)
yeast <- yeast[, -c(1, 11)]
yeast.f <- filtering(yeast)
yeast.f.n <- normalize(yeast.f)
foo <- som(yeast.f.n, xdim=5, ydim=6)
foo <- som(yeast.f.n, xdim=5, ydim=6, topol="hexa", neigh="gaussian")
}
plot(foo)
\keyword{cluster}
\eof
\name{summary.som}
\alias{summary.som}
\alias{print.som}
\title{ summarize a som object }
\description{print out the configuration parameters of a som object
}
\usage{
\method{summary}{som}(object, \dots)
\method{print}{som}(x, \dots)
}

\arguments{
  \item{object, x}{ a `som' object }
  \item{\dots}{nothing yet}
}

\author{
  Jun Yan <jyan@stat.uiowa.edu>
}

\keyword{print}

\eof
\name{yeast}
\alias{yeast}
\title{ yeast cell cycle }
\usage{
data(yeast)
}
\description{
  The \code{yeast} data frame has 6601 rows and 18 columns, i.e., 6601
  genes, measured at 18 time points.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Gene}{a character vector of gene names}
    \item{zero}{
      a numeric vector    }
    \item{ten}{
      a numeric vector
    }
    \item{twenty}{
      a numeric vector
    }
    \item{thirty}{
      a numeric vector
    }
    \item{fourty}{
      a numeric vector
    }
    \item{fifty}{
      a numeric vector
    }
    \item{sixty}{
      a numeric vector
    }
    \item{seventy}{
      a numeric vector
    }
    \item{eighty}{
      a numeric vector
    }
    \item{ninety}{
      a numeric vector
    }
    \item{hundred}{
      a numeric vector
    }
    \item{one.ten}{
      a numeric vector
    }
    \item{one.twenty}{
      a numeric vector
    }
    \item{one.thirty}{
      a numeric vector
    }
    \item{one.fourty}{
      a numeric vector
    }
    \item{one.fifty}{
      a numeric vector
    }
    \item{one.sixty}{
      a numeric vector
    }
  }
}
\references{
  Tamayo et. al. (1999), Interpreting patterns of gene expression with
  self-organizing maps: Methods and application to hematopoietic
  differentiation, PNAS V96, pp2907-2912, March 1999.
}
\source{
  http://genomics.stanford.edu
}
\keyword{datasets}
\eof
