### Name: burkitt
### Title: Burkitt's lymphoma in Uganda
### Aliases: burkitt burbdy burpts
### Keywords: datasets

### ** Examples

data(burkitt)
try.obj <- try(library(chron))
if (!is.na(match("chron", try.obj))) {
burdates <- chron(burkitt$t, out.format="y-m-d",
        origin=c(day=1, month=1, year=1960))
froms <- seq.dates(chron("7/1/1960", origin=c(1,1,1960)),
        chron("7/1/1975", origin=c(1,1,1960)), "years")
tos <- seq.dates(chron("9/30/1960", origin=c(1,1,1960)),
        chron("9/30/1975", origin=c(1,1,1960)), "years")
burd <- density(burdates, bw=100)
plot(chron(burd$x, origin=c(day=1, month=1, year=1960)), burd$y,
        type="n", xaxp=c(chron("1/1/1960", origin=c(1,1,1960)),
        chron("1/1/1976", origin=c(1,1,1960)),16), xlab="time",
ylab="density")
for (i in 1:length(tos)) polygon(c(froms[i], tos[i], tos[i], froms[i]),
        c(par("usr")[3], par("usr")[3], par("usr")[4], par("usr")[4]), 
        col="grey", border=NULL)
lines(chron(burd$x, origin=c(day=1, month=1, year=1960)), burd$y,
        lwd=3, col="red")
title("Density plot of Burkitt's lymphoma in West Nile district, 3Q grey shaded")
op <- par(mfrow=c(3,5))
for (i in 1961:1975) {
        polymap(burbdy)
        pointmap(burpts[which(years(burdates) == i),], add=TRUE, pch=19)
        title(i)
}
par(op)
op <- par(mfrow=c(2,2))
for (i in 1:4) {
        polymap(burbdy)
        pointmap(burpts[which(unclass(quarters(burdates)) == i),], add=TRUE,
pch=19)
        title(paste(i, "Q", sep=""))
}
par(op)
op <- par(mfrow=c(3,4))
for (i in 1:12) {
        polymap(burbdy)
        pointmap(burpts[which(unclass(months(burdates)) == i),], add=TRUE, pch=19)
        title(levels(months(burdates, FALSE))[i])
}
par(op)
}




