\name{btrf}
\alias{btrf}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Generalized inverse-logit transform }
\description{ maps real line onto open interval (xl, xu) using the
  transform y = (exp(xt) * xu + xl)/(1.+exp(xt)) where xt is a numeric
  vector with -Inf < xt < Inf
}
\usage{
btrf(xt, xl, xu)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{xt}{ a numeric vector }
  \item{xl}{ a numeric vector of same length as x}
  \item{xu}{ a numeric vector of same length as x, and xu > xl}
}
\value{
  returns the inverse-logit transform (numeric) of xt
}
\author{ E. Georg Luebeck (FHCRC) }
\seealso{ \code{\link{ftrf}} }
\keyword{ optimize }% at least one, from doc/KEYWORDS
\keyword{ misc }% __ONLY ONE__ keyword per line
\eof
\name{dfp} 
\alias{dfp}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Function minimization with box-constraints
}
\description{
  This Davidon-Fletcher-Powell optimization algorithm has been `hand-tuned'
  for minimal setup configuration and for efficency. It uses an internal
  logit-type transformation based on the pre-specified box-constraints.
  Therefore, it usually does not require rescaling (see help for the R
  optim function). \code{dfp} automatically computes step sizes for each
  parameter to operate with sufficient sensitivity in the functional
  output. Performance is comparable to the BFGS algorithm in the R
  function \code{optim}. \code{dfp} interfaces with \code{newton} to
  ascertain convergence, compute the eigenvalues of the Hessian, and 
  provide 95\% confidence intervals when the function to be minimized is a
  negative log-likelihood.
 
  The dfp function minimizes a function \code{f} over the parameters
  specified in the input list \code{x}. The algorithm is based on Fletcher's
  "Switching Method" (Comp.J. 13,317 (1970))
}
\usage{
dfp(x, f, tol=1e-05, nfcn=0)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{f}{ the function that is to be minimized over the parameter 
             vector defined by the list \code{x} }
  \item{tol}{ a tolerance used to indicate when convergence }
  \item{nfcn}{ number of function calls }
}
\details{
  the code has been 'transcribed' from Fortran source code into R
}
\value{
  list with the following components:
  \item{fmin }{ the function value f at the minimum }
  \item{label }{ the labels taken from list \code{x} }
  \item{est }{ a vector of the estimates at the minimum. dfp
    does not overwrite \code{x} }
  \item{status }{ 0 indicates convergence, 1 indicates non-convergence }
  \item{nfcn }{ no. of function calls }
}
\references{ Fletcher's Switching Method (Comp.J. 13,317, 1970)
}
\author{ E. Georg Luebeck (FHCRC)
}
\note{ This function is part of the Bhat exploration tool
}
% ~Make other sections like WARNING with \section{WARNING }{....} ~
\seealso{ optim, \code{\link{newton}}, \code{\link{ftrf}}, \code{\link{btrf}}, \code{\link{logit.hessian}}
}
\examples{
        # generate some Poisson counts on the fly
          dose <- c(rep(0,50),rep(1,50),rep(5,50),rep(10,50))
          data <- cbind(dose,rpois(200,20*(1+dose*.5*(1-dose*0.05))))

        # neg. log-likelihood of Poisson model with 'linear-quadratic' mean: 
          lkh <- function (x) { 
          ds <- data[, 1]
          y  <- data[, 2]
          g <- x[1] * (1 + ds * x[2] * (1 - x[3] * ds)) 
          return(sum(g - y * log(g)))
          }

	# for example define
          x <- list(label=c("a","b","c"),est=c(10.,10.,.01),low=c(0,0,0),upp=c(100,20,.1))

	# call:
	  results <- dfp(x,f=lkh)
}
\keyword{ optimize }% at least one, from doc/KEYWORDS
\keyword{ methods }% __ONLY ONE__ keyword per line

\eof
\name{dqstep}
\alias{dqstep}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ step size generator }
\description{
  \code{dqstep} determines the smallest steps ds from s so that
  abs(f(s+ds)-f(s)) equals a pre-specified sensitivity 
}
\usage{
dqstep(x, f, sens)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{f}{ the function that is to be minimized over the parameter 
             vector defined by the list \code{x} }
  \item{sens}{ target sensitivity (i.e. the value of f(s+ds)-f(s)) }
}
\details{ 
  uses simple quadratic interpolation
}
\value{
  returns a vector with the desired step sizes
}
\author{ E. Georg Luebeck (FHCRC) }
\note{ This function is part of the Bhat exploration tool
}
% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ \code{\link{dfp}}, \code{\link{newton}}, \code{\link{logit.hessian}} }

\examples{
  ## Rosenbrock Banana function
   fr <- function(x) {
         x1 <- x[1]
         x2 <- x[2]
         100 * (x2 - x1 * x1)^2 + (1 - x1)^2
    }
  ## define
   x <- list(label=c("a","b"),est=c(1,1),low=c(0,0),upp=c(100,100))
   dqstep(x,fr,sens=1)
}
\keyword{ optimize }% at least one, from doc/KEYWORDS
\keyword{ iteration }% __ONLY ONE__ keyword per line
\eof
\name{ftrf}
\alias{ftrf}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Generalized logit transform }
\description{
  maps a bounded parameter x onto the real line according to
  y=log((x-xl)/(xu-x))), with xl < x < xu. If this constraint is
  violated, an error occurs. x may be vector  
}
\usage{
ftrf(x, xl, xu)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a numeric vector }
  \item{xl}{ a numeric vector of same length as x with x > xl }
  \item{xu}{ a numeric vector of same length as x with x < xu }
}
\value{
  returns numerical vector of transforms
}
\author{ E. Georg Luebeck (FHCRC) }
\seealso{ \code{\link{btrf}} }
\keyword{ optimize }% at least one, from doc/KEYWORDS
\keyword{ misc }% __ONLY ONE__ keyword per line
\eof
\name{logit.hessian}
\alias{logit.hessian}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Hessian (curvature matrix) }
\description{
  Numerical evaluation of the Hessian of a real function f: \eqn{R^n
    \rightarrow R}{R^n -> R}
  on a generalized logit scale, i.e. using transformed parameters
  according to x'=log((x-xl)/(xu-x))), with xl < x < xu.
}
\usage{
logit.hessian(x=x, f=f, del=rep(0.002, length(x$est)), dapprox=FALSE, nfcn=0)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{f}{ the function for which the Hessian is to be computed at
    point x }
  \item{del}{ step size on logit scale (numeric) }
  \item{dapprox}{ logical variable. If TRUE the off-diagonal elements
    are set to zero. If FALSE (default) the full Hessian is computed }
  \item{nfcn}{ number of function calls }
}
\details{
  This version uses a symmetric grid for the numerical evaluation
  computation of first and second derivatives.
}
\value{
  returns list with
  \item{df }{ first derivatives (logit scale) }
  \item{ddf }{ Hessian (logit scale) }
  \item{nfcn }{ number of function calls }
  \item{eigen }{ eigen values (logit scale) }
}
\author{ E. Georg Luebeck (FHCRC) }
\note{ This function is part of the Bhat exploration tool }
\seealso{ \code{\link{dfp}}, \code{\link{newton}}, \code{\link{ftrf}}, \code{\link{btrf}}, \code{\link{dqstep}} } 
\examples{
  ## Rosenbrock Banana function
   fr <- function(x) {
         x1 <- x[1]
         x2 <- x[2]
         100 * (x2 - x1 * x1)^2 + (1 - x1)^2
    }
  ## define
   x <- list(label=c("a","b"),est=c(1,1),low=c(-100,-100),upp=c(100,100))
   logit.hessian(x,f=fr,del=dqstep(x,f=fr,sens=0.01))
  ## shows the differences in curvature at the minimum of the Banana
  ## function along principal axis (in a logit-transformed coordinate system)
}
\keyword{ array }% at least one, from doc/KEYWORDS
\keyword{ iteration }% __ONLY ONE__ keyword per line
\keyword{ methods }% __ONLY ONE__ keyword per line
\keyword{ optimize }% __ONLY ONE__ keyword per line


\eof
\name{mcmc}
\alias{mcmc}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Adaptive Multivariate MCMC sampler  }
\description{ This function generates MCMC-based samples from a (posterior)
  density f (not necessarily normalized). It uses a Metropolis algorithm
  in conjunction with a multivariate normal proposal distribution which
  is updated adaptively by monitoring the correlations of succesive increments
  of at least 2 pilot chains. The method is described in De Gunst,
  Dewanji and Luebeck (submitted). The adaptive method is similar to the
  one proposed in Gelfand and Sahu (JCGS 3:261--276, 1994).
}
\usage{
mcmc(x, nlogf, m1, m2=m1, m3, scl1=0.5, scl2=2, skip=1, covm=0, nfcn=0, plot=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{nlogf}{ negative log of the density function (not necessarily
    normalized) for which samples are to be obtained }
  \item{m1}{ length of first pilot run (not used when covm supplied) }
  \item{m2}{ length of second pilot run (not used when covm supplied )}
  \item{m3}{ length of final run }
  \item{scl1}{ scale for covariance of mv normal proposal (second pilot
    run) } 
  \item{scl2}{ scale for covariance of mv normal proposal (final run) }
  \item{skip}{ number of cycles skipped for graphical output }
  \item{covm}{ covariance matrix for multivariate normal proposal
    distribution. If supplied, all pilot runs will be skipped and a
    run of length m3 will be produced. Useful to continue a
    simulation from a given point with specified covm }
  \item{nfcn}{ number of function calls }
  \item{plot}{ logical variable. If TRUE the chain and the negative
    log density (nlogf) is plotted. The first m1+m2 cycles are shown
    in green, other cycles in red }
}
\details{
  standard output reports a summary of the acceptance fraction, the
  current values of nlogf and the parameters for every (100*skip) th
  cycle. Plotted chains show values only for every (skip) th cycle.
}
\value{
  list with the following components:
  \item{f }{ values of nlogf for the samples obtained }
  \item{mcmc }{ the chain (samples obtained) }
  \item{covm }{ current covariance matrix for mv normal proposal distribution}
}
\references{ too numerous to be listed here }
\author{ E. Georg Luebeck (FHCRC) }
\note{ This function is part of the Bhat exploration tool
}
%  ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ \code{\link{dfp}}, \code{\link{newton}}, \code{\link{logit.hessian}} }

\examples{
# generate some Poisson counts on the fly
  dose <- c(rep(0,50),rep(1,50),rep(5,50),rep(10,50))
  data <- cbind(dose,rpois(200,20*(1+dose*.5*(1-dose*0.05))))

# neg. log-likelihood of Poisson model with 'linear-quadratic' mean: 
  nlogf <- function (x) { 
  ds <- data[, 1]
  y  <- data[, 2]
  g <- x[1] * (1 + ds * x[2] * (1 - x[3] * ds)) 
  return(sum(g - y * log(g)))
  }

# start MCMC near mle
  x <- list(label=c("a","b","c"), est=c(20, 0.5, 0.05), low=c(0,0,0), upp=c(100,10,.1))
# samples from posterior density (~exp(-nlogf))) with non-informative
# (random uniform) priors for "a", "b" and "c".
out <- mcmc(x, nlogf, m1=2000, m2=2000, m3=10000, scl1=0.5, scl2=2, skip=10, plot=TRUE)
# start MCMC from some other point: e.g. try x$est <- c(16,.2,.02)
}
\keyword{ iteration }% __ONLY ONE__ keyword per line
\keyword{ methods }% __ONLY ONE__ keyword per line
\keyword{ optimize }% __ONLY ONE__ keyword per line

\eof
\name{newton}
\alias{newton}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Function minimization with box-constraints }
\description{
  Newton-Raphson algorithm for minimizing a function \code{f} over the
  parameters specified in the input list \code{x}. Note, a
  Newton-Raphson search is very efficient in the 'quadratic region'
  near the optimum. In higher dimensions it tends to be rather
  unstable and may behave chaotically. Therefore, a (local or global)
  minimum should be available to begin with. Use the \code{optim} or
  \code{dfp} functions to search for optima.
}
\usage{
newton(x, f, eps=0.1, itmax=10, relax=0, nfcn=0)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{f}{ the function that is to be minimized over the parameter 
             vector defined by the list \code{x} }
  \item{eps}{ converges when all (logit-transformed) derivatives are
    smaller \code{eps} }  
  \item{itmax}{ maximum number of Newton-Raphson iterations }
  \item{relax}{ numeric. If 0, take full Newton step, otherwise
    'relax' step incrementally until a better value is found }
  \item{nfcn}{ number of function calls }
}
\value{
  list with the following components:
  \item{fmin }{ the function value f at the minimum }
  \item{label }{ the labels }
  \item{est }{ a vector of the parameter estimates at the minimum. newton
    does not overwrite \code{x} }
  \item{low }{ lower 95\% (Wald) confidence bound }
  \item{upp }{ upper 95\% (Wald) confidence bound }
  The confidence bounds assume that the function \code{f} is a negative
  log-likelihood 
}
\author{ E. Georg Luebeck (FHCRC) }
\note{
  \code{newton} computes the (logit-transformed) Hessian of \code{f}
  (using logit.hessian). This function is part of the Bhat exploration
  tool
}
%  ~Make other sections like WARNING with \section{WARNING }{....} ~
\seealso{ \code{\link{dfp}}, \code{\link{ftrf}}, \code{\link{btrf}}, \code{\link{logit.hessian}}, \code{\link{plkhci}} }
\examples{
        # generate some Poisson counts on the fly
          dose <- c(rep(0,100),rep(1,100),rep(5,100),rep(10,100))
          data <- cbind(dose,rpois(400,20*(1+dose*.5*(1-dose*0.05))))

        # neg. log-likelihood of Poisson model with 'linear-quadratic' mean: 
          lkh <- function (x) { 
          ds <- data[, 1]
          y  <- data[, 2]
          g <- x[1] * (1 + ds * x[2] * (1 - x[3] * ds)) 
          return(sum(g - y * log(g)))
          }

	# for example define
          x <- list(label=c("a","b","c"),est=c(10.,10.,.01),low=c(0,0,0),upp=c(100,20,.1))

	# calls:
	  r <- dfp(x,f=lkh)
          x$est <- r$est
          results <- newton(x,lkh)
}
\keyword{ optimize }% at least one, from doc/KEYWORDS
\keyword{ methods }% __ONLY ONE__ keyword per line



\eof
\name{plkhci}
\alias{plkhci}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Profile-likelihood based confidence intervals }
\description{
  function to find \code{prob}*100\% confidence intervals using
  profile-likelihood. Numerical solutions are obtained via a  
  modified  Newton-Raphson algorithm. The method is described in
  Venzon and Moolgavkar, Journal of the Royal Statistical Society,
  Series C vol 37, no.1, 1988, pp. 87-94. 
}
\usage{
plkhci(x, nlogf, label, prob=0.95, eps=.001, nmax=10, nfcn=0)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ a list with components 'label' (of mode character), 'est'
    (the parameter vector with the initial guess), 'low' (vector with
    lower bounds), and 'upp' (vector with upper bounds) }
  \item{nlogf}{ the negative log of the density function (not necessarily
    normalized) for which samples are to be obtained }
  \item{label}{ parameter for which confidence bounds are computed }
  \item{prob}{ probability associated with the confidence interval }
  \item{eps}{ a numerical value. Convergence results when all
    (logit-transformed) derivatives are smaller \code{eps} }  
  \item{nmax}{ maximum number of Newton-Raphson iterations in each direction }
  \item{nfcn}{ number of function calls }
}
\value{
  2 component vector giving lower and upper p\% confidence bounds 
}
\author{ E. Georg Luebeck (FHCRC) }
\note{ At this point, only a single parameter label can be passed to
  plkhci.  This function is part of the Bhat exploration tool}

%  ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ \code{\link{dfp}}, \code{\link{newton}}, \code{\link{logit.hessian}} }

\examples{
        # generate some Poisson counts on the fly
          dose <- c(rep(0,50),rep(1,50),rep(5,50),rep(10,50))
          data <- cbind(dose,rpois(200,20*(1+dose*.5*(1-dose*0.05))))

        # neg. log-likelihood of Poisson model with 'linear-quadratic' mean: 
          nlogf <- function (x) { 
          ds <- data[, 1]
          y  <- data[, 2]
          g <- x[1] * (1 + ds * x[2] * (1 - x[3] * ds)) 
          return(sum(g - y * log(g)))
          }

	# for example define
          x <- list(label=c("a","b","c"),est=c(10.,10.,.01),low=c(0,0,0),upp=c(100,20,.1))

	# get MLEs using dfp:
	  r <- dfp(x,f=nlogf)
          x$est <- r$est
          plkhci(x,nlogf,"a")
          plkhci(x,nlogf,"b")
          plkhci(x,nlogf,"c")
	# e.g. 90\% confidence bounds for "c" 
          plkhci(x,nlogf,"c",prob=0.9)
        
}
\keyword{ distribution }% at least one, from doc/KEYWORDS
\keyword{ multivariate }% __ONLY ONE__ keyword per line




\eof
