### Name: BradleyTerry
### Title: Bradley-Terry model and extensions
### Aliases: BTm drop1.BTm add1.BTm terms.BTm formula.BTm BTresiduals
###   BTabilities
### Keywords: models

### ** Examples

##
##  Statistics journal citation data from Stigler (1994)
##  -- see also Agresti (2002, p448)
journals <- c("Biometrika", "Comm Statist", "JASA", "JRSS-B")
citedata <- matrix(c(NA,33,320,284,
                     730,NA,813,276,
                     498,68,NA,325,
                     221,17,142,NA),
                   4,4,
                   dimnames = list(winner = journals, loser = journals))
citedata <- as.data.frame.table(citedata)
                 
##  First fit the "standard" Bradley-Terry model
print(mymodel <- BTm(citedata ~ ..))

##  Now the same thing with a different "reference" journal
print(mymodel2 <- update(mymodel, . ~ ., refcat = "JASA"))

##  Is the "citeability" of a journal predicted by its country of origin?
origin <- factor(c("UK", "USA", "USA", "UK"))
print(mynewmodel <- BTm(citedata ~ origin))

##  Hmm... not so sure about the origin of "Comm Statist" ...
is.na(origin[2]) <- TRUE
mynewmodel2 <- update(mynewmodel, . ~ .)
BTabilities(mynewmodel2)

##  Now an example with an order effect -- see Agresti (2002) p438
teams <- c("Milwaukee", "Detroit", "Toronto",
           "New York", "Boston", "Cleveland", "Baltimore")
baseball <- data.frame(
  winner = factor(rep(rep(1:7, rep(7,7)), 2), labels =  teams),
  loser = factor(rep(rep(1:7, 7), 2), labels = teams),
  Freq = c(NA,4,4,4,6,4,6,  # home wins
           3,NA,4,4,6,6,4,
           2,4,NA,2,4,4,6,
           3,5,2,NA,4,4,6,
           5,2,3,4,NA,5,6,
           2,3,3,4,4,NA,2,
           2,1,1,2,1,3,NA,
           NA,3,5,3,1,5,5,  # away wins
           3,NA,3,1,5,3,5,
           2,2,NA,5,3,4,6,
           3,3,4,NA,2,3,4,
           1,0,3,3,NA,2,6,
           2,1,2,2,2,NA,4,
           0,3,0,1,0,4,NA),
   home.adv = rep(c(1, -1), c(49,49)))

##  Simple Bradley-Terry model as in Agresti p437
print(baseball.model <- BTm(baseball ~ ..))
BTresiduals(baseball.model)

##  Introduce order effect as in Agresti p438
update(baseball.model, order.effect = baseball$home.adv)   




