### Name: HTMLtools
### Title: Utility Functions for Writing in HTML
### Aliases: CGIwithR HTMLheader tag untag comments br linkto mailto img lf
### Keywords: interface

### ** Examples


useUnquotedTagnames <- TRUE

testpage<-function(){
    tag(HTML)
        tag(HEAD)
            tag(TITLE)
                cat("An example HTML page")
            untag(TITLE)
        untag(HEAD)
        lf()
        comments("Some comments to be ignored by the web browser")
        lf(2)
        tag(BODY, bgcolor = "yellow")
        lf(2)
        tag(h1)
            cat("A large heading")
        untag(h1)
        lf(2)
        tag(p)
            cat("A table of results:")
            tag(pre)
                lf()
                indentPrint(data.frame(Est = c(1.23,3.45),
                                       StErr = c(0.86,0.78),
                                       row.names = c("b0","b1")))
                lf()
            untag(pre)
        untag(p)
        lf(2)
        cat("Here is a graph:") ; br()
        img(src="http://www.stats.ox.ac.uk/~firth/CGIwithR/test.png") ; br(2)
        lf(2)
        cat("The author is ")
        mailto("David Firth", "david.firth@nuffield.ox.ac.uk")
        cat(" and here is his ")
        linkto("website.", "http://www.stats.ox.ac.uk/~firth/") ; br()
        lf()
        tag(p)
            cat("Output produced at ", date())
        untag(p)
        lf()
        untag(BODY)
        lf()
    untag(HTML)
    lf()
    }
    
# sink("temp.html")
testpage()

## The output if pasted into a file should be viewable by
## a web browser.  Or if the this-is-escaped-codenormal-bracket73bracket-normal was done, 
## just view temp.html in the web browser.
    



