CAIV.plot               package:CoCoAn               R Documentation

_B_i_p_l_o_t _o_r _T_r_i_p_l_o_t _a_f_t_e_r _u_s_i_n_g _t_h_e _C_A_I_V _f_u_n_c_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     'CAIV' performs correspondence analysis or constrained
     correspondence analysis. 'CAIV.plot' allows a two-dimensional
     representation (biplot) of row, column and coefficients of
     variables.

_U_s_a_g_e:

     CAIV.plot(obj, x=1, y=2, add.row=TRUE, add.col=TRUE, add.var=FALSE,
               row.names="", col.names="", var.names="")

_A_r_g_u_m_e_n_t_s:

     obj: an object created by the CAIV function

       x: an integer that defines which score corresponds to x axis

       y: an integer that defines which score corresponds to y axis

 add.row: TRUE to add rows on biplot FALSE otherwise

 add.col: TRUE to add columns on biplot FALSE otherwise

 add.var: TRUE to add variables on biplot FALSE otherwise (only for
          constrained analysis)

row.names: a vector of strings containing row names (Ri otherwise)

col.names: a vector of strings containing columns names (Ci otherwise)

var.names: a vector of strings containing variables names (Vari
          otherwise)

_A_u_t_h_o_r(_s):

     Stephane DRAY dray@biomserv.univ-lyon1.fr

_S_e_e _A_l_s_o:

     'CAIV'

_E_x_a_m_p_l_e_s:

     ## correspondence analysis
     L <- matrix(c(4,2,0,2,0,5,1,3,2,4,0,2,2,0,3,1),4,4)
     CAIV.plot(CAIV(L))
     CAIV.plot(CAIV(L),row.names=c("a","b","c","d"))
     ## canonical correspondence analysis
     E <- matrix(c(1.5,2.3,2,1.6,0.9,0.8,1.2,1.5),4,2)
     CAIV.plot(CAIV(L,E))
     CAIV.plot(CAIV(L,E),add.var=TRUE)

