\name{DBI-internal}
\alias{dbDataType.default}
\alias{make.db.names.default}
\alias{isSQLKeyword.default}
\alias{.SQL92Keywords}
%\alias{.__C__DBIDriver}
%\alias{.__C__DBIConnection}
%\alias{.__C__DBIDriver}
%\alias{.__C__DBIObject}
%\alias{.__C__DBIResult}
%\alias{.__M__dbCallProc}
%\alias{.__M__dbClearResult}
%\alias{.__M__dbColumnInfo}
%\alias{.__M__dbCommit}
%\alias{.__M__dbConnect}
%\alias{.__M__dbDataType}
%\alias{.__M__dbDisconnect}
%\alias{.__M__dbExistsTable}
%\alias{.__M__dbGetConnection}
%\alias{.__M__dbGetException}
%\alias{.__M__dbGetInfo}
%\alias{.__M__dbGetQuery}
%\alias{.__M__dbGetStatement}
%\alias{.__M__dbHasCompleted}
%\alias{.__M__dbListConnections}
%\alias{.__M__dbListFields}
%\alias{.__M__dbListResults}
%\alias{.__M__dbListTables}
%\alias{.__M__dbReadTable}
%\alias{.__M__dbRemoveTable}
%\alias{.__M__dbRollback}
%\alias{.__M__dbSendQuery}
%\alias{.__M__dbSetDataMappings}
%\alias{.__M__dbUnloadDriver}
%\alias{.__M__dbWriteTable}
%\alias{.__M__fetch}
%\alias{.__M__format}
%\alias{.__M__isSQLKeyword}
%\alias{.__M__make.db.names}
%\alias{.__M__print}
%\alias{.__M__SQLKeywords}
%\alias{.__M__summary}

\title{Version 4 meta-objects}
\description{
  Helper functions and version 4 meta objects (many!).
}
\keyword{internal}
% vim: syntax=tex

\eof
% $Id: DBIConnection-class.Rd,v 1.1 2003/10/07 16:24:09 dj Exp $
\name{DBIConnection-class}
\docType{class}
\alias{DBIConnection-class}
\title{Class DBIConnection}
\description{
   Base class for all DBMS connection classes.  Individual
   drivers (ODBC, Oracle, PostgreSQL, MySQL, etc.) 
   extend this class in a database-specific manner.
}
\section{Objects from the Class}{
   A virtual Class: No objects may be created from it.
}

\section{Extends}{
Class \code{"DBIObject"}, directly.
}
\section{Generator}{
    The main generator is \code{\link{dbConnect}}.  
 }
\section{Methods}{

The following methods take objects from classes derived
from \code{DBIConnection}:

    \describe{
Create and close connections:

    \item{\link{dbConnect}}{\code{signature(drv = "DBIConnection")}: ... }
    \item{\link{dbDisconnect}}{\code{signature(conn = "DBIConnection")}: ... }

Execute SQL commands:

    \item{\link{dbSendQuery}}{\code{signature(conn = "DBIConnection", statement = "character")}: ... }
    \item{\link{dbGetQuery}}{\code{signature(conn = "DBIConnection", statement = "character")}: ... }

    \item{\link{dbCallProc}}{\code{signature(conn = "DBIConnection")}: ... }

Transaction management:

    \item{\link{dbCommit}}{\code{signature(conn = "DBIConnection")}: ... }
    \item{\link{dbRollback}}{\code{signature(conn = "DBIConnection")}: ... }

Meta-data:
    \item{\link{dbListResults}}{\code{signature(conn = "DBIConnection")}: ... }
    \item{\link{dbGetInfo}}{\code{signature(dbObj = "DBIConnection")}: ... }
    \item{\link{summary}}{\code{signature(object = "DBIConnection")}: ... }

Exceptions:

    \item{\link{dbGetException}}{\code{signature(conn = "DBIConnection")}: ... }

    \item{\link{dbListFields}}{\code{signature(conn = "DBIConnection", name = "character")}: ... }

    Convenience functions:

    \item{\link{dbListTables}}{\code{signature(conn = "DBIConnection")}: ... }

    \item{\link{dbReadTable}}{\code{signature(conn = "DBIConnection", name = "character")}: ... }
    \item{\link{dbExistsTable}}{\code{signature(conn = "DBIConnection", name = "character")}: ... }
    \item{\link{dbRemoveTable}}{\code{signature(conn = "DBIConnection", name = "character")}: ... }
    \item{\link{dbWriteTable}}{\code{signature(conn = "DBIConnection", name = "character", value = "data.frame")}: ... }
   }
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\author{R-SIG-DB}

\seealso{
 DBI classes:
 \code{\link{DBIObject-class}}
 \code{\link{DBIDriver-class}}
 \code{\link{DBIConnection-class}}
 \code{\link{DBIResult-class}}
}

\examples{\dontrun{
ora <- dbDriver("Oracle")
con <- dbConnect(ora, "user/password@dbname")

pg <- dbDriver("PostgreSQL")
con <- dbConnect(pg, "user", "password")
}
}
\keyword{classes}
\keyword{database}
\keyword{interface}
% vim: syntax=tex

\eof
% $Id: DBIDriver-class.Rd,v 1.1 2003/10/07 16:24:09 dj Exp $
\name{DBIDriver-class}
\docType{class}
\alias{DBIDriver-class}
\title{Class DBIDriver}
\description{  
   Base class for all DBMS drivers (e.g., ODBC, Oracle, MySQL, PostgreSQL).
}
\section{Objects from the Class}{
   A virtual Class: No objects may be created from it.
}
\section{Extends}{
Class \code{"DBIObject"}, directly.
}

\section{Generator}{
   The generator for classes that extend \code{DBIDriver} is
   \code{\link{dbDriver}}.  
}
\section{Methods}{
  The following methods are defined for classes that extend
  \code{DBIDriver}:

  \describe{
    \item{\link{dbUnloadDriver}}{\code{signature(drv = "DBIDriver")}: ... }
    \item{\link{dbConnect}}{\code{signature(drv = "DBIDriver")}: ... }
    \item{\link{dbGetInfo}}{\code{signature(dbObj = "DBIDriver")}: ... }
    \item{\link{dbListConnections}}{\code{signature(drv = "DBIDriver")}: ... }
    \item{\link{summary}}{\code{signature(object = "DBIDriver")}: ... }
  }
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\author{R-SIG-DB}
\seealso{
 DBI classes:
 \code{\link{DBIObject-class}}
 \code{\link{DBIDriver-class}}
 \code{\link{DBIConnection-class}}
 \code{\link{DBIResult-class}}

 The function \code{\link{dbConnect}} is the main generator.

 In addition see the help of the methods above.
}

\examples{\dontrun{
drv <- dbDriver("ODBC")
summary(drv)
dbListConnections(drv)
}
}
\keyword{classes}
\keyword{database}
\keyword{interface}
% vim: syntax=tex

\eof
% $Id: DBIObject-class.Rd,v 1.1 2003/10/07 16:24:09 dj Exp $
\name{DBIObject-class}
\docType{class}
\alias{DBIObject-class}
\title{Class DBIObject}
\description{ 
   Base class for all other DBI classes (e.g., drivers, connections).
}
\section{Objects from the Class}{
   A virtual Class: No objects may be created from it.
}
\section{Methods}{
  Methods defined for classes that extend \code{DBIObject}:
  \describe{
    \item{\link{dbDataType}}{\code{signature(dbObj = "DBIObject")}: ... }
    \item{\link{isSQLKeyword}}{\code{signature(dbObj = "DBIObject")}: ... }
    \item{\link{make.db.names}}{\code{signature(dbObj = "DBIObject")}: ... }
    \item{\link{SQLKeywords}}{\code{signature(dbObj = "DBIObject")}: ... }
    \item{\link{summary}}{\code{signature(object = "DBIObject")}: ... }
  }
  Plus many other specific to the other DBI classes.
}
\references{ 
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or
  \url{http://developer.r-project.org/db}.
}
\author{R-SIG-DB}

\seealso{
 DBI classes:
 \code{\link{DBIObject-class}}
 \code{\link{DBIDriver-class}}
 \code{\link{DBIConnection-class}}
 \code{\link{DBIResult-class}}
}

\examples{\dontrun{
drv <- dbDriver("MySQL")
con <- dbConnect(drv, group = "rs-dbi")
res <- dbSendQuery(con, "select * from vitalSuite")
is(drv, "DBIObject")   ## True
is(con, "DBIObject")   ## True
is(res, "DBIObject")
}
}
\keyword{classes}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: DBIResult-class.Rd,v 1.1 2003/10/07 16:24:09 dj Exp $
\name{DBIResult-class}
\docType{class}
\alias{DBIResult-class}
\title{Class DBIResult}
\description{
   Base class for all DBMS-specific result objects.
}
\section{Objects from the Class}{
   A virtual Class: No objects may be created from it.
}
\section{Extends}{
   Class \code{"DBIObject"}, directly.
}
\section{Generator}{
   The main generator is \code{\link{dbSendQuery}}.
}
\section{Methods}{

  \describe{
Fetching methods:

    \item{\link{fetch}}{\code{signature(res = "DBIResult", n = "numeric")}: ... }
    \item{\link{fetch}}{\code{signature(res = "DBIResult", n = "missing")}: ... }
Close result set:

    \item{\link{dbClearResult}}{\code{signature(res = "DBIResult")}: ... }

Meta-data:

    \item{\link{dbColumnInfo}}{\code{signature(res = "DBIResult")}: ... }
    \item{\link{dbGetException}}{\code{signature(conn = "DBIResult")}: ... }
    \item{\link{dbGetInfo}}{\code{signature(dbObj = "DBIResult")}: ... }
    \item{\link{dbGetRowCount}}{\code{signature(res = "DBIResult")}: ... }
    \item{\link{dbGetRowsAffected}}{\code{signature(res = "DBIResult")}: ... }
    \item{\link{dbGetStatement}}{\code{signature(res = "DBIResult")}: ... }
    \item{\link{dbHasCompleted}}{\code{signature(res = "DBIResult")}: ... }
    \item{\link{dbListFields}}{\code{signature(conn = "DBIResult", name = "missing")}: ... }
    \item{summary}{\code{signature(object = "DBIResult")}: ... }
    \item{\link{coerce}}{\code{signature(from = "DBIConnection", to = "DBIResult")}: ... }
  }
}

\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\author{R-SIG-DB}

\seealso{
 DBI classes:
 \code{\link{DBIObject-class}}
 \code{\link{DBIDriver-class}}
 \code{\link{DBIConnection-class}}
 \code{\link{DBIResult-class}}
}

\examples{\dontrun{
 drv <- dbDriver("Oracle")
 con <- dbConnect(drv, "user/password@dbname")
 res <- dbSendQuery(con, "select * from LASERS where prdata > '2002-05-01'")
 summary(res)
 while(dbHasCompleted(res)){
    chunk <- fetch(res, n = 1000)
    process(chunk)
 }
}
}
\keyword{classes}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbCallProc-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbCallProc-methods}
\docType{methods}
\alias{dbCallProc}
\alias{dbCallProc-methods}
\alias{dbCallProc,DBIConnection-method}
\title{
  Call an SQL stored procedure
}
\description{
  Calls a stored procedure on a remote RDBMS
}
\usage{
  dbCallProc(conn, ...)
}
\arguments{
\item{conn}{
  a \code{DBIConnection} object.
}
\item{\dots }{
  additional arguments are passed to the implementing method.
}
}
\details{
  Not yet implemented.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbCommit-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbCommit-methods}
\docType{methods}
\alias{dbCommit}
\alias{dbRollback}
\alias{dbCommit-methods}
\alias{dbRollback-methods}
\alias{dbCommit,DBIConnection-method}
\alias{dbRollback,DBIConnection-method}
\title{
  DBMS Transaction Management
}
\description{
  Commit/rollback SQL transactions
}
\usage{
  dbCommit(conn, ...)
  dbRollback(conn, ...)
}
\arguments{
\item{conn}{
  a \code{DBIConnection} object, as produced by the function 
\code{dbConnect}.
}
\item{\dots }{
  any database-specific arguments.
}
}
\value{
  a logical indicating whether the operation succeeded or not.
}
\section{Side Effects}{
  The current transaction on the connections \code{con}
  is committed or rolled back.
}
\details{
  Not all database engines implement transaction management,
  older versions of MySQL, for instance.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or
  \url{http://developer.r-project.org/db}.
}
\seealso{
\code{\link{dbConnect}}
\code{\link{dbSendQuery}}
\code{\link{dbGetQuery}}
\code{\link{fetch}}
\code{\link{dbCommit}}
\code{\link{dbGetInfo}}
\code{\link{dbReadTable}}
}
\examples{\dontrun{
ora <- dbDriver("Oracle")
con <- dbConnect(ora)
rs <- dbSendQuery(con, 
      "delete * from PURGE as p where p.wavelength<0.03")
if(dbGetInfo(rs, what = "rowsAffected") > 250){
  warning("dubious deletion -- rolling back transaction")
  dbRollback(con)
}
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbConnect-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbConnect-methods}
\docType{methods}
\alias{dbDisconnect}
\alias{dbConnect}
\alias{dbDisconnect-methods}
\alias{dbConnect-methods}
\alias{dbDisconnect,DBIConnection-method}
\alias{dbConnect,DBIDriver-method}
\title{
  Create a connection to a DBMS
}
\description{
  Connect to a DBMS going through the appropriate authorization
  procedure.
}
\usage{
  dbConnect(drv, ...)
  dbDisconnect(conn, ...)
}
\arguments{
\item{drv}{
  an object that inherits from \code{DBIDriver},
  a character string specifying the DBMS driver, e.g., "RPgSQL", 
  "ROracle", "Informix", "RSQLite", or possibly another \code{dbConnect} object.
  }
\item{conn}{
  a  connection object as produced by \code{dbConnect}.
  }
\item{\dots }{
  authorization arguments needed by the DBMS instance; these
  typically include \code{user}, \code{password}, \code{dbname},
  \code{host}, \code{port}, etc.  For details see the appropriate
  \code{DBIDriver}.
  }
}
\value{
  An object that extends \code{DBIConnection} in a database-specific
  manner.  For instance \code{dbConnect("MySQL")} produces an object
  of class \code{MySQLConnection}.
  This object is used to direct commands to the database engine.

  \code{dbDisconnect} returns a logical value indicating whether
  the operation succeeded or not.
}
\section{Side Effects}{
  A connection between R/S-Plus and the database server is established,
  and the R/S-Plus program becomes a client of the database engine.
  Typically the connections is through the TCP/IP protocol, 
  but this will depend on vendor-specific details.
}
\details{
  Some implementations  may allow you to have multiple connections 
  open, so you may invoke this function repeatedly assigning its 
  output to different objects.
  
  The authorization mechanism is left unspecified, so check the 
  documentation of individual drivers for details.
}
\notes{
  Make sure you close the connection using \code{dbDisconnect(conn)}
  when it is not longer needed.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbConnect}}
  \code{\link{dbSendQuery}}
  \code{\link{dbGetQuery}}
  \code{\link{fetch}}
  \code{\link{dbCommit}}
  \code{\link{dbGetInfo}}
  \code{\link{dbReadTable}}
}
\examples{\dontrun{
# create an Oracle instance and create one connection.
drv <- dbDriver("Oracle")

# open the connection using user, passsword, etc., as
con <- dbConnect(drv, "user/password@dbname")

# Run an SQL statement by creating first a resultSet object
rs <- dbSendQuery(con, statement = paste(
                      "SELECT w.laser_id, w.wavelength, p.cut_off",
                      "FROM WL w, PURGE P", 
                      "WHERE w.laser_id = p.laser_id", 
                      "SORT BY w.laser_id")
# we now fetch records from the resultSet into a data.frame
data <- fetch(rs, n = -1)   # extract all rows
dim(data)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbDataType-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbDataType-methods}
\docType{methods}
\alias{dbDataType}
\alias{dbDataType-methods}
\alias{dbDataType,DBIObject-method}
\title{
  Determine the SQL Data Type of an S object
}
\description{
  Determine an (approximately) appropriate SQL data type for an R/S-Plus object.
}
\usage{
  dbDataType(dbObj, obj, ...)
}
\arguments{
\item{dbObj}{
  a \code{DBIDriver} object, e.g., \code{ODBCDriver},
  \code{OracleDriver}.
}
\item{obj}{
  R/S-Plus object whose SQL type we want to determine.
}
\item{\dots }{
  any other parameters that individual methods may need.
}
}
\value{
  A character string specifying the SQL data type for \code{obj}.
}
\details{
  This is a generic function.  The default method determines the
  SQL type of an R/S-Plus object according to the SQL 92 specification,
  which may serve as a starting point for driver implementations.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{isSQLKeyword}}
  \code{\link{make.db.names}}
}
\examples{\dontrun{
data(quakes)
ora <- dbDriver("MySQL")
sql.type <- dbDataType(ora, quakes)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% docclass is function
% Converted by Sd2Rd version 1.15.2.1.
% vim: syntax=tex

\eof
% $Id: dbDriver-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbDriver-methods}
\docType{methods}
\alias{dbDriver}
\alias{dbUnloadDriver}
\alias{dbDriver-methods}
\alias{dbUnloadDriver-methods}
\alias{dbDriver,character-method}
\alias{dbUnloadDriver,DBIDriver-method}
\title{
  Database Interface (DBI) Classes and drivers
}
\description{
  The \emph{virtual} classes and generics in the \code{DBI} package
  define the interface to database management systems (DBMS).  They 
  are extended by packages or drivers that implement the methods in 
  the context of specific DBMS (e.g., Informix, MySQL, Oracle, ODBC, 
  PostgreSQL, SQLite).
}
\usage{
  dbDriver(drvName, ...)
  dbUnloadDriver(drv, ...)     ## free up all resources
}
\arguments{
\item{drvName}{
  character name of the driver to instantiate.
  }
\item{drv}{
  an object that inherits from \code{DBIDriver} as created by
  \code{dbDriver}.
}
\item{...}{
  any other arguments are passed to the driver \code{drvName}.
  }
}
\value{
  In the case of \code{dbDriver}, an driver object whose class 
  extends \code{DBIDriver}.  This object may be used to create connections 
  to the actual DBMS engine.
  
  In the case of \code{dbUnloadDriver}, a logical indicating whether
  the operation succeeded or not.
}
\section{Side Effects}{
  The client part of the database communication is initialized (typically
  dynamically loading C code, etc.) but note that connecting to the 
  database engine itself needs to be done through calls to \code{dbConnect}.

}
\details{
  The virtual class \code{DBIDriver} defines the operations 
  for creating connections and defining data type mappings.
  Actual driver classes, for instance \code{RSQLite}, \code{RMySQL}, etc.
  implement these operations in a DBMS-specific manner.

  More generally, the DBI defines a very small set of classes and
  methods that allows users and applications access DBMS with a common
  interface.  The virtual classes are \code{DBIDriver} that individual
  drivers extend, \code{DBIConnection} that represent instances of
  DBMS connections, and \code{DBIResult} that represent the result
  of a DBMS statement.  These three classes extend the basic class
  of \code{DBIObject}, which serves as the root or parent of the
  class hierarchy.
}
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or
  \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbConnect}},
  \code{\link{dbSendQuery}},
  \code{\link{dbGetQuery}},
  \code{\link{fetch}},
  \code{\link{dbCommit}},
  \code{\link{dbGetInfo}},
  \code{\link{dbListTables}},
  \code{\link{dbReadTable}}.
}
\examples{\dontrun{
# create a MySQL instance for capacity of up to 25 simultaneous
# connections.
m <- dbDriver("MySQL", max.con = 25)
p <- dbDriver("PgSQL")

# open the connection using user, password, etc., as
con <- dbConnect(m, user="ip", password = "traffic", dbname="iptraffic")
rs <- dbSubmitQuery(con, 
         "select * from HTTP_ACCESS where IP_ADDRESS = '127.0.0.1'")
df <- fetch(rs, n = 50)
df2 <- fetch(rs, n = -1)
dbClearResult(rs)

pcon <- dbConnect(p, "user", "password", "dbname")
dbListTables(pcon)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbGetInfo-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbGetInfo-methods}
\docType{methods}
\alias{dbGetInfo}
\alias{dbGetDBIVersion}
\alias{dbGetStatement}
\alias{dbGetRowCount}
\alias{dbGetRowsAffected}
\alias{dbColumnInfo}
\alias{dbHasCompleted}
\alias{dbGetInfo-methods}
\alias{dbGetDBIVersion-methods}
\alias{dbGetStatement-methods}
\alias{dbGetRowCount-methods}
\alias{dbGetRowsAffected-methods}
\alias{dbColumnInfo-methods}
\alias{dbHasCompleted-methods}
\alias{dbGetInfo,DBIObject-method}
\alias{dbGetDBIVersion,-method}
\alias{dbGetStatement,DBIResult-method}
\alias{dbGetRowCount,DBIResult-method}
\alias{dbGetRowsAffected,DBIResult-method}
\alias{dbColumnInfo,DBIResult-method}
\alias{dbHasCompleted,DBIResult-method}
\title{
  Database interface meta-data
}
\description{
  Extract meta-data associated with various objects
}
\usage{
  dbGetInfo(dbObj, ...)       # meta-data for any DBIObject
  dbGetDBIVersion()           # DBI version 
  dbGetStatement(res, ...)    # statement that produced result "res"
  dbGetRowCount(res, ...)     # number of rows fetched so far
  dbGetRowsAffected(res, ...) # number of affected rows (e.g., DELETE)
  dbColumnInfo(res, ...)      # result set data types
  dbHasCompleted(res, ...)    # are there more rows to fetch on "res"?
}
\arguments{
\item{dbObj}{
  any object that implements some functionality in the R/S-Plus
  interface to databases (a driver, a connection or a result set).
}
\item{res}{
  refers to a \code{DBIResult} object.
}
\item{\dots}{
  driver-specific arguments. 
}
}
\value{
  \code{dbGetDBIVersion} returns a character string with the version
  of the database interface API.

  \code{dbGetInfo} produces either a character vector or a named list 
  of (name, value) pairs.

  \code{dbGetStatement} returns a character string with the statement 
  associated with the result set \code{res}.

  \code{dbGetRowCount} returns the number of rows fetched so far.

  \code{dbGetRowsAffected} returns the number of affected rows (e.g., 
  how many rows were deleted, inserted).  Some drivers may set this
  to the total number of rows a query produces.

  \code{dbColumnInfo} returns a data.frame with one row per output field
  in \code{res}.  The columns should report field name, field data type,
  scale and precision (as understood by the DBMS engine), whether the
  field can store \code{NULL} values, and possibly other DBMS-specific
  information.

  \code{dbHasCompleted} a logical describing whether the operations has
  been completed by the DBMS or not.

}
\details{
  These functions implement a minimal set of meta-data describing the 
  most important aspects of the R/S-Plus to DBMS interface.

  The \code{dbGetInfo} works very similarly to the function
  \code{options} in that it attempts to extract what the user may
  request, possibly \code{NULL} if it can't locate the specific piece
  of meta-data.
}
\section{Note}{
  Meta-data associated with a driver should include the version of the
  package, plus the version of the underlying client library.  Connection
  objects should report the version of the DBMS engine, database name, user, 
  possibly password, etc.  Results should include the statement being
  executed, how many rows have been fetched so far (in the case of queries),
  how many rows were affected (deleted, inserted, changed, or total number
  of records to be fetched).
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbDriver}},
  \code{\link{dbConnect}},
  \code{\link{dbSendQuery}},
  \code{\link{dbGetQuery}},
  \code{\link{fetch}},
  \code{\link{dbCommit}},
  \code{\link{dbGetInfo}},
  \code{\link{dbListTables}},
  \code{\link{dbReadTable}}.
}
\examples{\dontrun{
drv <- dbDriver("SQLite")
con <- dbConnect(drv)

dbListTables(con)

rs <- dbSendQuery(con, query.sql)
dbGetStatement(rs)
dbHasCompleted(rs)

info <- dbGetInfo(rs)
names(dbGetInfo(drv))  

# DBIConnection info
names(dbGetInfo(con))

# DBIResult info
names(dbGetInfo(rs)) 
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbListTables-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbListTables-methods}
\docType{methods}
\alias{dbListTables}
\alias{dbListFields}
\alias{dbListConnections}
\alias{dbListResults}
\alias{dbListTables-methods}
\alias{dbListFields-methods}
\alias{dbListConnections-methods}
\alias{dbListResults-methods}
\alias{dbListTables,DBIConnection-method}
\alias{dbListFields,DBIConnection,character-method}
\alias{dbListConnections,DBIDriver-method}
\alias{dbListResults,DBIConnection-method}
\title{
  List items from a remote DBMS and from objects that implement
  the database interface DBI.
}
\description{
  List remote tables, fields of a remote table, opened connections
  and pending statements in a connection.
}
\usage{
  dbListTables(conn, ...)
  dbListFields(conn, name, ...)
  dbListConnections(drv, ...)
  dbListResults(conn, ...)
}
\arguments{

  \item{drv}{a driver object (e.g., \code{ODBC}, \code{Oracle})}
  \item{conn}{a connection object}
  \item{name}{a character string with the name of the remote table.}
  \item{\dots}{optional arguments for the actual driver implementation.}

}
\value{
  \code{dbListTables} returns a character vector with the names of the
  tables in the remote database associated with the connection in 
  \code{conn} object.

  \code{dbListFields} returns a character vector with the names of the
  fields of the \code{res} result object (it must be a query statement).

  \code{dbListConnections} returns a list of all currently open
  connections on driver \code{drv}.  Drivers that implement single
  connections would return the one single connection object.

  \code{dbListResults} returns a list of objects for all pending results 
  (statements) on the \code{conn} connection.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or
  \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbGetInfo}},
  \code{\link{dbColumnInfo}},
  \code{\link{dbDriver}},
  \code{\link{dbConnect}},
  \code{\link{dbSendQuery}}
}

\examples{\dontrun{
drv <- dbDriver("RSQLite")
# after working awhile...
for(con in dbListConnections(odbc)){
   dbGetStatement(dbListResults(con))
}
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbReadTable-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbReadTable-methods}
\docType{methods}
\alias{dbReadTable}
\alias{dbWriteTable}
\alias{dbExistsTable}
\alias{dbRemoveTable}
\alias{dbReadTable-methods}
\alias{dbWriteTable-methods}
\alias{dbExistsTable-methods}
\alias{dbRemoveTable-methods}
\alias{dbReadTable,DBIConnection,character-method}
\alias{dbWriteTable,DBIConnection,character,data.frame-method}
\alias{dbExistsTable,DBIConnection,character-method}
\alias{dbRemoveTable,DBIConnection,character-method}
\title{
  Convenience functions for Importing/Exporting DBMS tables
}
\description{
  These functions mimic their R/S-Plus counterpart 
  \code{get},
  \code{assign},
  \code{exists}, 
  \code{remove}, and
  \code{objects},
  except that they generate code that gets remotely executed
  in a database engine.
}
\synopsis{
  dbReadTable(conn, name, ...)
  dbWriteTable(conn, name, value, ...)
  dbExistsTable(conn, name, ...)
  dbRemoveTable(conn, name, ...)
}
\usage{
  dbReadTable(conn, name, row.names = "row_names", ...)
  dbWriteTable(conn, name, value, row.names = T, ...,
              overwrite = F, append = F)
  dbExistsTable(conn, name, ...)
  dbRemoveTable(conn, name, ...)
}
\arguments{

\item{conn}{
  a database connection object.
  }
\item{name}{
  a character string specifying a DBMS table name.
  }
\item{value}{
  a data.frame (or coercible to data.frame).
  }
\item{row.names}{
  in the case of \code{dbReadTable}, this argument can be a string or
  an index specifying the column in the DBMS table to be used as 
  \code{row.names} in the output data.frame (a \code{NULL}, \code{""}, or 0 
  specifies that no column should be used as \code{row.names} in the output).

  In the case of \code{dbWriteTable}, this argument should be a logical
  specifying whether the \code{row.names} should be output to the
  output DBMS table; if \code{TRUE}, an extra field whose name will be 
  whatever the R/S-Plus identifier \code{"row.names"} maps to the DBMS
  (see \code{\link{make.db.names}}).
  }
\item{overwrite}{
  a logical specifying whether to overwrite an existing table
  or not.  Its default is \code{FALSE}.
  }
\item{append}{
  a logical specifying whether to append to an existing table
  in the DBMS.  Its default is \code{FALSE}.
  }
\item{\dots }{
  any optional arguments that the underlying database driver
  supports. 
  }

}

\value{
  \code{dbReadTable} returns a data.frame; all other functions
  return \code{TRUE} or \code{FALSE} denoting whether the operation
  was successful or not.
}

\section{Side Effects}{
A DBMS statement is generated and remotely executed on a database
engine; the result set it produces is fetched in its entirety.
These operations may failed if the underlying database driver runs
out of available connections and/or result sets, or the operation
violates DBMS integrity constraints (e.g., attempting to write
duplicate values on a field that's defined as a primary key).

\code{dbWritetable} slightly extend the semantics of \code{assign} to 
allow overwriting or appending to an existing table.  
}
\note{The translation of identifiers between R/S-Plus and SQL is done through
  calls to \code{\link{make.names}} and \code{\link{make.db.names}}, 
  but we cannot guarantee that the conversion is reversible.  For
  details see \code{\link{make.db.names}}.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbDriver}},
  \code{\link{dbConnect}},
  \code{\link{dbSendQuery}},
  \code{\link{dbGetQuery}},
  \code{\link{fetch}},
  \code{\link{dbCommit}},
  \code{\link{dbGetInfo}},
  \code{\link{dbListTables}},
  \code{\link{dbReadTable}}.
}
\examples{\dontrun{
conn <- dbConnect("MySQL", group = "vitalAnalysis")
con2 <- dbConnect("Oracle", username = "user", password = "pwd")
if(dbExistsTable(con2, "fuel_frame")){
   fuel.frame <- dbReadTable(con2, "fuel_frame")
   dbRemoveTable(conn, "fuel_frame")
   dbWriteTable(conn, "fuel_frame", fuel.frame)
}
if(dbExistsTable(conn, "RESULTS")){
   dbWriteTable(conn, "RESULTS", results2000, append = T)
else
   dbWriteTable(conn, "RESULTS", results2000)
}
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbSendQuery-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbSendQuery-methods}
\docType{methods}
\alias{dbSendQuery}
\alias{dbGetQuery}
\alias{dbClearResult}
\alias{dbGetException}
\alias{dbSendQuery-methods}
\alias{dbGetQuery-methods}
\alias{dbClearResult-methods}
\alias{dbGetException-methods}
\alias{dbSendQuery,DBIConnection,character-method}
\alias{dbGetQuery,DBIConnection,character-method}
\alias{dbClearResult,DBIResult-method}
\alias{dbGetException,DBIConnection-method}
\title{
  Execute a statement on a given database connection
}
\description{
  Methods for submiting and executing arbitrary SQL statements on a
  specific connection, clearing result sets, and extracting exception
  information from the DBMS.
}
\usage{
  dbSendQuery(conn, statement, ...)
  dbGetQuery(conn, statement, ...)
  dbClearResult(res, ...)
  dbGetException(conn, ...) 
}
\arguments{
\item{conn}{
  a connection object.
}
\item{statement}{
  a character vector of length 1 with the SQL statement.
}
\item{res}{
  a result set object (i.e., the value of \code{dbSendQuery}).
}
\item{\dots }{
  database-specific parameters may be specified.
}
}
\value{
  \code{dbSendQuery} returns a result set object, i.e., an object
  that inherits from \code{DBIResult};  if the statement generates
  output (e.g., a \code{SELECT} statement) the result set can be
  used with \code{\link{fetch}} to extract records.

  \code{dbGetQuery} returns a data.frame with the output (if any)
  of the query.  

  \code{dbClearResult} returns a logical indicating whether clearing
  the result set was successful or not.
  
  \code{dbGetException} returns a list with elements \code{errNum} 
  (an integer error number) and \code{errMsg} (a character string)
  describing the last error in the connection \code{conn}.
}
\section{Side Effects}{
  The statement is submitted for synchronous execution to the server 
  connected through the \code{conn} object.  The DBMS executes the
  statement, possibly generating vast amounts of data.  Where these
  data reside is driver-specific:  some drivers may choose to leave the
  output on the server and transfer them piecemeal to R/S-Plus, others may
  transfer all the data to the client -- but not necessarily to the 
  memory that R/S-Plus manages.  See the individual drivers' 
  \code{\link{dbSendQuery}} method for implementation details.
}
\details{
  The function \code{dbSendQuery} only submits and synchronously executes 
  the SQL statement to the database engine.  It does \emph{not} extracts any
  records ---  for that you need to use the function 
  \code{\link{fetch}} (make sure you invoke \code{dbClearResult} when you 
  finish fetching the records you need).

  The function \code{dbGetQuery} does all these in one operation (submits
  the statement, fetches all output records, and clears the result set).

  \code{dbClearResult} frees all resources (local and remote) associated
  with a result set.  It some cases (e.g., very large result sets) this can 
  be a critical step to avoid exhausting resources (memory, file descriptors, 
  etc.)
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbDriver}}
  \code{\link{dbConnect}}
  \code{\link{fetch}}
  \code{\link{dbCommit}}
  \code{\link{dbGetInfo}}
  \code{\link{dbReadTable}}
}
\examples{\dontrun{
drv <- dbDriver("MySQL")
con <- dbConnect(drv)
res <- dbSendQuery(con, "SELECT * from liv25")
data <- fetch(res, n = -1)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: dbSetDataMappings-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{dbSetDataMappings-methods}
\docType{methods}
\alias{dbSetDataMappings}
\alias{dbSetDataMappings-methods}
\alias{dbSetDataMappings,DBIResult,data.frame-method}
\title{
  Set data mappings between an DBMS and R/S-Plus
}
\description{
  Sets one or more conversion functions to handle the translation 
  of DBMS data types to R/S-Plus objects.  
  This may be only needed for non-primitive data, since all DBI drivers 
  handle the common base types (integers, numeric, strings, etc.)
}
\usage{
  dbSetDataMappings(res, flds, ...)
}
\arguments{
\item{res}{
  a \code{DBIResult} object as returned by \code{dbSendQuery}.
  }
\item{flds}{
  a data.frame with field descriptions as returned by 
  \code{\link{dbColumnInfo}}.
  }
\item{\dots }{
  any additional arguments are passed to the implementing method.
  }
}
\value{
  a logical specifying whether the conversion functions were
  successfully installed or not.
}
\section{Side Effects}{
  Conversion functions are set up to be invoked for each element of
  the corresponding fields in the result set.
}
\details{
  The details on conversion functions (e.g., arguments,
  whether they can invoke initializers and/or destructors)
  have not been specified.
}
\note{
  No driver has yet implemented this functionality.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbSendQuery}},
  \code{\link{fetch}},
  \code{\link{dbColumnInfo}}.
}
\examples{\dontrun{
makeImage <- function(x) {
  .C("make_Image", as.integer(x), length(x))
}

res <- dbSendQuery(con, statement)
flds <- dbColumnInfo(res)
flds[3, "Sclass"] <- makeImage

dbSetDataMappings(rs, flds)

im <- fetch(rs, n = -1)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: fetch-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{fetch-methods}
\docType{methods}
\alias{fetch}
\alias{fetch-methods}
\alias{fetch,DBIResult,numeric-method}
\title{
  Fetch records from a previously executed query
}
\description{
  Fetch records from a previously executed query
}
\usage{
  fetch(res, n, ...)
}
\arguments{

\item{res}{
  a result set object (one whose class extends \code{DBIResult}).
  This object needs to be the result of a statement that produces
  output, such as SQL's \code{SELECT} or \code{SELECT}-like statement,
  this object \code{res} is typically produced by a call to
  or \code{dbSendQuery}.
  }
\item{n}{
  maximum number of records to retrieve per fetch.
  Use \code{n = -1} to retrieve all pending records.
  Some implementations may recognize other special values, e.g.,
  \code{RMySQL}, \code{ROracle}, and \code{RSQLite} use a value 
  of \code{n = 0} for fetching the defined \code{fetch.default.rec} in 
  the \code{\link{dbDriver}} invocation.
  }
\item{\dots }{
  any other database-engine specific arguments.
  }
}

\value{
  a data.frame with as many rows as records  were fetched
  and as many columns as fields in the result set.
}

\section{Side Effects}{
  As the R/S-Plus client fetches records the remote database server
  updates its cursor accordingly.
}
\details{
  How the actual fetching is done is implementation-dependent.
  Some implementations may leave the result in the DBMS and bring
  chunks of size \code{n} to prevent exhausting 
  the R/S-Plus memory, but there may be a performance penalty;  
  other implementations may copy the entire result set to the a 
  memory space under the driver's control;
 others may yet return the entire result set directly to R/S-Plus.
  See the individual drivers' documentation.
}
\note{
  Make sure you close the result set with \code{\link{dbClearResult}}
  as soon as you finish retrieving the records you want.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbConnect}},
  \code{\link{dbSendQuery}},
  \code{\link{dbGetQuery}},
  \code{\link{dbClearResult}},
  \code{\link{dbCommit}},
  \code{\link{dbGetInfo}},
  \code{\link{dbReadTable}}.
}
\examples{\dontrun{
# Run an SQL statement by creating first a resultSet object
drv <- dbDriver("Oracle")
con <- dbConnect(drv, ...)
res <- dbSendQuery(con, statement = paste(
                      "SELECT w.laser_id, w.wavelength, p.cut_off",
                      "FROM WL w, PURGE P", 
                      "WHERE w.laser_id = p.laser_id",
                      "ORDER BY w.laser_id"))
# we now fetch the first 100 records from the resultSet into a data.frame
data1 <- fetch(res, n = 100)   
dim(data1)

dbHasCompleted(res)

# let's get all remaining records
data2 <- fetch(res, n = -1)
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: make.db.names-methods.Rd,v 1.1 2003/10/15 18:38:34 dj Exp dj $
\name{make.db.names-methods}
\docType{methods}
\alias{make.db.names}
\alias{SQLKeywords}
\alias{isSQLKeyword}
\alias{make.db.names-methods}
\alias{SQLKeywords-methods}
\alias{isSQLKeyword-methods}
\alias{make.db.names,DBIObject,character-method}
\alias{SQLKeywords,DBIObject-method}
\alias{SQLKeywords,missing-method}
\alias{isSQLKeyword,DBIObject,character-method}
\title{
  Make R/S-Plus identifiers into legal SQL identifiers
}
\description{
  Produce legal SQL identifiers from a character vector.
}
\synopsis{
  make.db.names(dbObj, snames, ...)
  SQLKeywords(dbObj, ...)
  isSQLKeyword(dbObj, name, ...)
}
\usage{
  make.db.names(dbObj, snames, unique=T, allow.keywords=T)
  SQLKeywords(dbObj, ...)
  isSQLKeyword(dbObj, name, keywords=.SQL92Keywords, 
                  case=c("lower", "upper", "any")[3])
}
\arguments{
\item{dbObj}{
  any DBI object (e.g., \code{DBIDriver}).
  }
\item{snames}{
  a character vector of R/S-Plus identifiers (symbols) from which
  we need to make SQL identifiers.
  }
\item{name}{
  a character vector of SQL identifiers we want to check against
  keywords from the DBMS.
}
\item{unique}{
  logical describing whether the resulting set of SQL names should
  be unique.  Its default is \code{TRUE}.  Following the SQL 92
  standard, uniqueness of SQL identifiers is determined regardless
  of whether letters are upper or lower case.
  }
\item{allow.keywords }{
  logical describing whether SQL keywords should be allowed in the
  resulting set of SQL names.  Its default is \code{TRUE}
  }
\item{keywords}{
  a character vector with SQL keywords, by default it's 
  \code{.SQL92Keywords} defined in the \code{DBI} package.
  }
\item{case}{
  a character string specifying whether to make the comparison
  as lower case, upper case, or any of the two.
  it defaults to \code{any}.
  }
\item{\dots}{
  any other argument are passed to the driver implementation.
}
}
\value{
  \code{make.db.names} returns a character vector of legal SQL 
  identifiers corresponding to its \code{snames} argument.
 
  \code{SQLKeywords} returns a character vector of all known 
  keywords for the database-engine associated with \code{dbObj}.

  \code{isSQLKeyword} returns a logical vector parallel to
  \code{name}.
}
\details{
  The algorithm in \code{make.db.names} first invokes \code{make.names}
  and then replaces each occurrence of a dot ``.'' by an underscore
  ``\_''.  If \code{allow.keywords} is \code{FALSE} and identifiers
  collide with SQL keywords, a small integer is appended to the
  identifier in the form of \code{"_n"}.

  The set of SQL keywords is stored in the character
  vector \code{.SQL92Keywords} and reflects the SQL ANSI/ISO 
  standard as documented
  in "X/Open SQL and RDA", 1994, ISBN 1-872630-68-8.
  Users can easily override or update this vector.
}
\section{Bugs}{
  The current mapping is not guaranteed to be fully reversible: some 
  SQL identifiers that get mapped into S identifiers with \code{make.names}
  and then back to SQL with \code{\link{make.db.names}}
  will not be equal to the original SQL identifiers (e.g., compound
  SQL identifiers of the form \code{username.tablename} will 
  loose the dot ``.'').
}
\references{
  The set of SQL keywords is stored in the character vector
  \code{.SQL92Keywords} and reflects the SQL ANSI/ISO standard as
  documented in "X/Open SQL and RDA", 1994, ISBN 1-872630-68-8.
  Users can easily override or update this vector.

  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{
  \code{\link{dbReadTable}},
  \code{\link{dbWriteTable}},
  \code{\link{dbExistsTable}},
  \code{\link{dbRemoveTable}},
  \code{\link{dbListTables}}.
}
\examples{\dontrun{
# This example shows how we could export a bunch of data.frames
# into tables on a remote database.

con <- dbConnect("Oracle", user="iptraffic", pass = pwd)

export <- c("trantime.email", "trantime.print", "round.trip.time.email")
tabs <- make.db.names(export, unique = T, allow.keywords = T)

for(i in seq(along = export) )
   dbWriteTable(con, name = tabs[i],  get(export[i]))

# Oracle's extensions to SQL keywords
oracle.keywords <- c("CLUSTER", "COLUMN", "MINUS", "DBNAME")
isSQLKeyword(nam, c(.SQL92Keywords, oracle.keywords))
[1]  T  T  T  F
}
}
\keywords{methods}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
% $Id: print.list.pairs.Rd,v 1.1 2003/10/07 16:24:09 dj Exp $
\name{print.list.pairs}
\alias{print.list.pairs}
\alias{print}
\alias{summary}
\alias{format}
\title{Support functions}
\description{
  Some of these functions are conditionally elevated to 
  generic functions (e.g., \code{print}, \code{summary}).
  Others are low-level support functions.
}
\usage{
print.list.pairs(x, ...)
}
\arguments{
  \item{x}{a list of key, value pairs}
  \item{\dots}{additional arguments to be passed to \code{cat}}
}
\value{
  the (invisible) value of x.
}
\references{
  See the Database Interface definition document
  \code{DBI.pdf} in the base directory of this package
  or \url{http://developer.r-project.org/db}.
}
\seealso{ 
  \code{\link{print.default}},
  \code{\link{summary.default}},
  \code{\link{cat}}.
}
\examples{\dontrun{
print.list.pairs(list(a =1, b = 2))
}
}
\keyword{interface}
\keyword{database}
% vim: syntax=tex

\eof
\name{summary-methods}
\docType{methods}
\alias{summary-methods}
\alias{summary,DBIObject-method}
\title{Summarize a DBI object}
\description{Prints metadata information for a DBI object}
\section{Methods}{\describe{

\item{object = "DBIObject"}{
   Provides relevant metadata information on \code{object}, 
   for instance, the DBMS server the object is connected to, the
   SQL statement associated with a result set, etc.  
   For details see individual driver's implementation.
   }
}
}
\keyword{methods}
\keyword{database}
\keyword{interface}
% vim: syntax=tex

\eof
