achisq.boot             package:DCluster             R Documentation

_B_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _P_e_a_r_s_o_n'_s _C_h_i-_s_q_u_a_r_e _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of the Pearson's Chi-square
     statistic (function _achisq.stat_), by means of function _boot_
     from _boot_ library. Notice that these functions should not  be
     used separately but as argument _statistic_ when calling function
     _boot_.

     _achisq.boot_ is used when performing a non-parametric bootstrap.

     _achisq.pboot_ is used when performing a parametric bootstrap.

_U_s_a_g_e:

     achisq.boot(data, i, ...)
     achisq.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe containing the data, as specified in _DCluster_
          manpage.

       i: Permutation generated by the non-parametric bootstrap
          procedure.

     ...: Additional arguments passed when performing a bootstrap.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Potthoff, R. F. and Whittinghill, M.(1966). Testing for
     Homogeneity: I. The Binomial and Multinomial Distributions.
     Biometrika 53, 167-182.

     Potthoff, R. F. and Whittinghill, M.(1966). Testing for
     Homogeneity: The Poisson Distribution. Biometrika 53, 183-190.

_S_e_e _A_l_s_o:

     DCluster, boot, achisq, achisq.stat

_E_x_a_m_p_l_e_s:

     library(boot)
     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))

     niter<-100

     #Permutation  model
     chq.perboot<-boot(sids, statistic=achisq.boot, R=niter)
     plot(chq.perboot)#Display results

     #Multinomial model
     chq.mboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=multinom.sim,  R=niter)
     plot(chq.mboot)#Display results

     #Poisson model
     chq.pboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=poisson.sim,  R=niter)
     plot(chq.pboot)#Display results

     #Poisson-Gamma model
     chq.pgboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=negbin.sim, R=niter)
     plot(chq.pgboot)#Display results

