kullnagar.boot           package:DCluster           R Documentation

_G_e_n_e_r_a_t_e _b_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _K_u_l_l_d_o_r_f_f _a_n_d _N_a_g_a_r_w_a_l_l_a'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of Kulldorff and Nagarwalla's
     statistic, by calling functions _boot_ and _kullnagar.stat_.

     _kullnagar.boot_ is used when using non-parametric bootstrap to
     estimate the distribution of the statistic.

     _kullnagar.pboot_ is used when performing parametric bootstrap.

_U_s_a_g_e:

     kullnagar.boot(data, i, ...)
     kullnagar.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe with the data as explained in _DCluster_.

       i: Permutation created in non-parametric bootstrap.

     ...: Additional arguments passed to the functions.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Kulldorff, Martin and Nagarwalla, Neville (1995). Spatial Disease
     Clusters: Detection and Inference. Statistics in Medicine 14,
     799-810.

_S_e_e _A_l_s_o:

     DCluster, boot, kullnagar, kullnagar.stat, kn.iscluster

_E_x_a_m_p_l_e_s:

     library(boot)
     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
     sids<-cbind(sids, Population=nc.sids$BIR74, x=nc.sids$x, y=nc.sids$y)

     niter<-100

     #Permutation  model
     kn.perboot<-boot(sids, statistic=kullnagar.boot, R=niter, fractpop=.2)
     plot(kn.perboot)#Display results

     #Multinomial model
     kn.mboot<-boot(sids, statistic=kullnagar.pboot, sim="parametric", 
             ran.gen=multinom.sim,  R=niter, fractpop=.2)
     plot(kn.mboot)#Display results

     #Poisson model
     kn.pboot<-boot(sids, statistic=kullnagar.pboot, sim="parametric", 
             ran.gen=poisson.sim,  R=niter, fractpop=.2)
     plot(kn.pboot)#Display results

     #Poisson-Gamma model
     kn.pgboot<-boot(sids, statistic=kullnagar.pboot, sim="parametric", 
             ran.gen=negbin.sim, R=niter, fractpop=.2)
     plot(kn.pgboot)#Display results

