pottwhitt.boot           package:DCluster           R Documentation

_B_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _P_o_t_t_h_o_f_f-_W_h_i_t_t_i_n_g_h_i_l_l'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of Potthoff-Whittinghill's statistic
     (function _pottwhitt.stat_), by means of function _boot_ from the
     _boot_ library. Notice that these functions should not  be used
     separately but as argument _statistic_ when calling function
     _boot_.

     _pottwhitt.boot_ is used when performing a non-parametric
     bootstrap.

     _pottwhitt.pboot_ is used when performing a parametric bootstrap.

_U_s_a_g_e:

     pottwhitt.boot(data, i)
     pottwhitt.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe containing the data, as specified in the 
          *DCluster*  manual page.

       i: Permutation generated by the bootstrap procedure

     ...: Additional arguments passed when performing a bootstrap.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Potthoff, R. F. and Whittinghill, M.(1966). Testing for
     Homogeneity: I. The Binomial and Multinomial Distributions.
     Biometrika 53, 167-182.

     Potthoff, R. F. and Whittinghill, M.(1966). Testing for
     Homogeneity: The Poisson Distribution. Biometrika 53, 183-190.

_S_e_e _A_l_s_o:

     DCluster, pottwhitt, pottwhitt.stat

_E_x_a_m_p_l_e_s:

     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
     sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

     niter<-100

     #Permutation model
     pw.boot<-boot(sids, statistic=pottwhitt.boot, R=niter)
     plot(pw.boot)#Plot results

     #Multinomial model
     pw.mboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=multinom.sim,  R=niter)
     plot(pw.mboot)#Plot results

     #Poisson model
     pw.pboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=poisson.sim,  R=niter)
     plot(pw.pboot)#Plot results

     #Poisson-Gamma model
     pw.pgboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=negbin.sim, R=niter)
     plot(pw.pgboot)#Plot results

