tango.boot             package:DCluster             R Documentation

_G_e_n_e_r_a_t_e _b_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_d _o_f _T_a_n_g_o'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicated of Tango's statistic for general
     clustering, by means of function _boot_ from _boot_ library.
     Notice that these functions should not be used separately but as
     argument _statistic_ when calling function _boot_.

     _tango.boot_ is used when performing non-parametric bootstrap.

     _tango.pboot_ must be used for parametric bootstrap.

_U_s_a_g_e:

     tango.boot(data, i, ...)
     tango.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: Dataframe with the data as described in _DCluster_.

       i: Permutation generated by the non-parametric boostrap
          procedure.

     ...: Additional arguments passed when performing a bootstrap.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Tango, Toshiro (1995). A Class of Tests for Detecting 'General'
     and 'Focused' Clustering of Rare Diseases. Statistics in Medicine
     14, 2323-2334.

_S_e_e _A_l_s_o:

     DCluster, boot, tango, tango.stat

_E_x_a_m_p_l_e_s:

     library(boot)
     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74) )
     sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

     #Calculate neighbours based on distance
     coords<-as.matrix(sids[,c("x", "y")])

     dlist<-dnearneigh(coords, 0, Inf)
     dlist<-include.self(dlist)
     dlist.d<-nbdists(dlist, coords)

     #Calculate weights. They are globally standardised but it doesn't
     #change significance.
     col.W.tango<-nb2listw(dlist, glist=lapply(dlist.d, function(x) {exp(-x)}),
             style="C")
             
     niter<-100

     #Permutation model
     tn.boot<-boot(sids, statistic=tango.boot, R=niter, listw=col.W.tango, 
             zero.policy=TRUE)
     plot(tn.boot)#Display results

     #Multinomial model
     tn.mboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
             ran.gen=multinom.sim,  R=niter, listw=col.W.tango, zero.policy=TRUE)
                     
     plot(tn.mboot)#Display results

     #Poisson model
     tn.pboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
             ran.gen=poisson.sim,  R=niter, listw=col.W.tango, zero.policy=TRUE)
                     
     plot(tn.pboot)#Display results

     #Poisson-Gamma model
     tn.pgboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
             ran.gen=negbin.sim, R=niter, listw=col.W.tango, zero.policy=TRUE)
     plot(tn.pgboot)#Display results

