\name{Davies}
\alias{Davies}
\alias{ddavies}
\alias{pdavies}
\alias{qdavies}
\alias{rdavies}
\alias{ddavies.p}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{The Davies distribution}
\description{
 Density, distribution function, quantile function and random
  generation for the Davies distribution}
\usage{
 ddavies(x, params)
 pdavies(x, params)
 qdavies(p, params)
 rdavies(n, params)
ddavies.p(x,params)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{quantile}
  \item{p}{vector of probabilities}
  \item{n}{number of observations.  If \code{length(n) > 1}, the length
    is taken to be the number required}
  \item{params}{A three-member vector holding~\eqn{C}{C} ,
    \eqn{\lambda_1}{lambda1} and~\eqn{\lambda_2}{lambda2}}
}
\details{
  The Davies distribution is defined in terms of its quantile function:
  \deqn{Cp^{\lambda_1}(1-p)^\lambda_2}{Cp^lambda_1.(1-p)^lambda2}

  It does not have a closed-form  probability density function or
  cumulative density function, so numerical solution is used.
}

\value{
  \code{ddavies} gives the density,
  \code{pdavies} gives the distribution function,
  \code{qdavies} gives the quantile function, and
  \code{rdavies} generates random deviates.
}
\references{draft MS available from the author on request}
\author{Robin K. S. Hankin}
\seealso{\code{\link{Gld}}, \code{\link{fit.davies.p}},
  \code{\link{least.squares}}, \code{\link{skewness}}}

\examples{
params <- c(10,0.1,-0.1)
x <- seq(from=4,to=20,by=0.2)
p <- seq(from=1e-3,to=1-1e-3,len=50)

rdavies(n=5,params)
least.squares(rdavies(100,params))
plot(pdavies(x,params))


plot(p,qdavies(p,params))
plot(x,ddavies(x,params),type="b")

}
\keyword{distribution}% at least one, from doc/KEYWORDS

\eof
\name{Gld}
\alias{Gld}
\alias{dgld}
\alias{dgld.p}
\alias{pgld}
\alias{qgld}
\alias{rgld}
\title{The Generalized Lambda Distribution}
\description{
  Density, distribution function, quantile function and random
  generation for the Generalized Lambda Distribution}
}
\usage{
dgld(x, params)
dgld.p(x, params)
pgld(x, params)
qgld(p, params)
rgld(n, params)
expected.gld(n=1, i=1, params)
}
\arguments{
  \item{x,q}{vector of quantiles.}
  \item{p}{vector of probabilities.}
  \item{n}{number of observations.  If \code{length(n)> 1}, the
    length is taken to be the number required}
  \item{i}{order statistic.  Thus if \eqn{i=1}{i=1}, we consider the smallest
    observation and if \eqn{i=n}{i=n} we consider the largest.}
\item{params}{vector of parameters:  \eqn{params[1]==lambda1} etseq}
}
\value{
  \code{dgld} gives the density,
  \code{dgld.p} gives the density in terms of the quantile,
  \code{pgld} gives the distribution function,
  \code{qgld} gives the quantile function, and
  \code{rgld} generates random deviates.
}
\details{
  The Generalized Lambda distribution has quantile function
  \deqn{f(x)=\lambda_1 +(p^\lambda_3 - (1-p)^\lambda_4)/\lambda_2}{f(x)=lambda1 +(p^lambda3 - (1-p)^lambda_4)/lambda_2}
}
\seealso{
\code{\link{Davies}}, \code{\link{expected.gld}}
}
\references{
  Wichura, M. J. (1988)
  Algorithm AS 241: The Percentage Points of the Normal Distribution.
  \emph{Applied Statistics}, \bold{37}, 477--484.

  A. \"{O}zt\"{u}rk and R. F. Dale, "Least squares estimation
  of the parameters of the generalized lambda distribution",
  Technometrics 1985,  27(1):84
  
}
\examples{
params <- c(4.114,0.1333,0.0193,0.1588)  #taken straight from some paper

gld.rv <- rgld(100,params)

hist(gld.rv)
fit.davies.q(gld.rv)  #remember the Davies distn has 3 DF and the GLD 4...
}
\keyword{distribution}
\eof
\name{davies.moment}
\alias{davies.moment}
\alias{kurtosis}
\alias{skewness}
\alias{expected.value}
\alias{expected.value.approx}
\alias{mu}
\alias{variance}
\alias{M}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Moments of the Davies distribution}
\description{
  Moments of order statistics of RVs drawn from a Davies distribution
}
\usage{
davies.moment(n=1 , i=1 , order=1 , params)
M(order,params)
mu(params)
expected.value(n,i,params)
expected.value.approx(n,i,params)
variance(params)
skewness(params)
kurtosis(params)
}
\arguments{
  \item{params}{A three-member vector holding~\eqn{C}{C} ,
    \eqn{\lambda_1}{lambda1} and~\eqn{\lambda_2}{lambda2}}
  \item{n}{The number of observations}
  \item{i}{Return information about the ith order statistic (ie i=1
    means the smallest, i=n means the biggest)}
  \item{order}{The order (eg order=2 gives the square)}
}
\details{
  \item\code{davies.moment} gives the rth moment of the ith order statistic of
  n observations.  The following aliases are just newbie wrappers with
  \eqn{n=i=1}{n=i=1} (ie moments of one observation from a Davies
  distribution)
  \item\code{M} gives the r-th moment for n=i=1
  \item\code{mu} gives the first moment of a Davies distribution (ie the mean)
  \item\code{variance} gives the second {\em central} moment of a Davies
  distribution
  \item\code{skewness} gives the normalized skewness of a Davies distribution
  \item\code{kurtosis} gives the normalized kurtosis of a Davies distribution
}


\author{Robin K. S. Hankin}
\seealso{\code{\link{expected.value}}, \code{\link{expected.gld}}}
\examples{
params <- c(10,0.1,-0.1)
davies.moment(n=100,i=99,2,params) # ie the second moment of the 99th smallest
                            # observation of 100 drawn from a Davies
                            # distribution with parameters p


mean(rdavies(1e6,params))-mu(params)

#now reproduce the S-K graph:

f <- function(x,y){c(skewness(c(1,x,y)),kurtosis(c(1,x,y)))}
g <- function(j,vector,pp,qq=1){points(t(sapply(vector,f,y=j)),type="l",col="black",lty=qq)}

vector <- c((0:300)/100 , (0:300)/10000 , seq(from=3,to=10,len=100))
vector <- sort(unique(vector))

plot(t(sapply((0:10)/10,f,y=0)),xlim=c(-3,3),ylim=c(0,10),type="n",xlab="skewness",ylab="kurtosis")
g(-0.001,vector,"red",qq=1)
g(-0.01,vector,"yellow",qq=2)
g(-0.02,vector,"green",qq=3)
g(-0.05,vector,"blue",qq=4)
g(-0.1 ,vector,"purple",qq=5)
g(-0.14,vector,"black",qq=6)

x <- seq(from=-3,to=3,len=30)
points(x,x^2+1,type="l",lwd=2)

leg.txt <- expression(lambda[2]==-0.001,lambda[2]==-0.01,lambda[2]==-0.02,lambda[2]==-0.05,lambda[2]==-0.1,lambda[2]==-0.14)
legend(-1.1,10,leg.txt,col="black",lty=1:6)
}
\keyword{distribution}
\eof
\name{davies.start}
\alias{davies.start}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{start value for Davies minimization routines}
\description{
  Gives a ``start'' value for the optimization routines.  Uses
  heuristics that seem to work.
}
\usage{
davies.start(x, threeps=c(0.1,0.5,0.9), small = 0.01) 
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{dataset to be used}
  \item{threeps}{a three-element vector representing the quantiles to be
    balanced.  The default values balance the first and ninth deciles
    and the median.  These seem to work for me pretty well; YMMV}
  \item{small}{a ``small'' value to be used for \eqn{\lambda_1}{lambda1}
  and \eqn{\lambda_1}{lambda1} because exactly zero sucks}
}
\details{
Returns a ``start'' value of the pararametes for use in one of the
Davies fitting routines maximum.likelihood() or least.squares().

Uses three heuristic methods (one assuming \eqn{\lambda_1=
  -\lambda_2}{lambda1=-lambda2}, one with \eqn{\lambda_1=0}{lambda1=0},
and one with \eqn{\lambda_2=0}{lambda2=0}).  Returns the best one of the
three, as measured by \code{objective()}.
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{least.squares}} , \code{\link{maximum.likelihood}},
  \code{\link{objective}}
}
\examples{
data <- rnorm(100)^2
davies.start(data)
least.squares(data)


params <- c(10 , 0.1 , -0.1)
x <- rdavies(100 , params)
davies.start(x)

f <- function(threeps){objective(davies.start(x,threeps),x)}

(jj<-optim(c(0.1,0.5,0.9),f))
davies.start(x,jj$par)
least.squares(x)


#not bad at all.

}
\keyword{distribution}

\eof
\name{expected.gld}
\alias{expected.gld}
\alias{expected.gld.approx}
\title{expected value of the Generalized Lambda Distribution}
\description{Returns the expected value of the Generalized
  Lambda Distribution}

\usage{
expected.gld(n=1, i=1, params)
expected.gld.approx(n=1, i=1, params)
}
\arguments{
  \item{n}{Number of observations}
  \item{i}{Order statistic: \eqn{i=1}{i=1} means the smallest of
    \eqn{n}{n}, and \eqn{n=i}{n=i} means the largest}
  \item{params}{The four parameters of a GLD distribution}
}
\details{
  \code{expected.gld} and \code{expected.approx} return the exact and
  approximate values of the expected value of a Generalized Lambda
  Distribution RV.
  
  Exploits the fact that the \code{gld} quantile function is the sum of
  a constant and two \code{davies} quantile functions.
  
}
\references{A. \"{O}zt\"{u}rk and R. F. Dale, "Least squares estimation
  of the parameters of the generalized lambda distribution",
  Technometrics 1985,  27(1):84
}
\seealso{\code{\link{Gld}} , \code{\link{expected.value}}}
\examples{
params <- c(4.114,0.1333,0.0193,0.1588)
mean(rgld(1000,params))
expected.gld(n=1,i=1,params)
expected.gld.approx(n=1,i=1,params)


f <- function(n){apply(matrix(rgld(n+n,params),2,n),2,min)}
#ie f(n) gives the smaller of 2 rgld RVs, n times.

mean(f(1000))
expected.gld(n=2,i=1,params)
expected.gld.approx(n=2,i=1,params)

plot(1:100,expected.gld.approx(n=100,i=1:100,params)-expected.gld(n=100,i=1:100,params))
# not bad, eh? ....yyyeeeeesss, but the parameters given by Ozturk give
#an almost zero second derivative for d(qgld)/dp, so the good agreement
#isn't surprising really.  Observe that the error is minimized at about
#p=0.2, where the point of inflection is.

}
\author{Robin K. S. Hankin}
\keyword{distribution}
\eof
\name{fit.davies.p}
\alias{fit.davies.p}
\alias{fit.davies.q}
\title{Fits and plots Davies distributions to datasets}
\description{
  A newbie wrapper (and pretty-printer) for maximum.likelihood() and
  least.squares().  Draws an empirical quantile function (fit.davies.p())
  or PDF (fit.davies.q()) and the dataset
}
\usage{
fit.davies.p(x , print.fit=FALSE , use.q=TRUE , params=NULL, small=1e-5 , ...)
fit.davies.q(x , print.fit=FALSE, use.q=TRUE  , params=NULL, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{dataset to be fitted and plotted}
  \item{print.fit}{Boolean flag with TRUE meaning print details of the fit}
  \item{use.q}{Boolean flag with TRUE meaning use \code{least.squares()}
    (rather than \code{maximum.likelihood()})}
  \item{params}{three-element vector holding the three parameters of the
    davies dataset.  If NULL, determine the parameters using the method
    indicated by \code{use.q}}
  \item{is.sorted}{Boolean flag with TRUIE meaning that \code{dataset}
    is sorted from lowest to highest}
  \item{small}{small positive number showing range of quantiles to plot}
  \item{\dots}{Additional parameters passed to \code{plot()}}
}
\value{If \code{print.fit} is TRUE, return the optimal parameters}
\author{Robin K. S. Hankin}
\seealso{\code{\link{least.squares}} ,  \code{\link{maximum.likelihood}}
}

\examples{
  fit.davies.q(rnorm(100)^2)
  fit.davies.p(exp(rnorm(100))) 

  data(x00m700p4)
  fit.davies.q(x00m700p4)
}
\keyword{distribution}
\eof
\name{hypergeo}
\alias{hypergeo}
\title{The hypergeometric function}
\description{
The hypergeometric function as defined by Abramowicz and Stegun
}
\usage{
hypergeo(A, B, C, z, tol = 1e-06)
}
\arguments{
  \item{A}{first top parameter}
  \item{B}{second top parameter}
  \item{C}{first bottom parameter}
  \item{z}{argument}
  \item{tol}{absolute tolerance}
}
\references{Abramowicz and Stegun,
      Handbook of mathematical functions with formulas, 
      graphs and mathematical tables (AMS-55),
      1955,
      National Bureau of Standards}
\author{Robin K. S. Hankin}
\examples{
hypergeo(1,1,1,0.234)
hypergeo(1,1,1,(1:10)/10)
}
\keyword{distribution}

\eof
\name{least.squares}
\alias{least.squares}
\alias{maximum.likelihood}
\title{Finds the optimal Davies distribution for a dataset}
\description{
  Finds the best-fit Davies distribution using either the least-squares
  criterion (\code{least.squares}) or maximum likelihood (\code{maximum.likelihood}).
}
\usage{
least.squares(data, do.print = FALSE, start.v = NULL)
maximum.likelihood(data, do.print = FALSE, start.v = NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{dataset to be fitted}
  \item{do.print}{Boolean flag with TRUE meaning print  a GFM}
  \item{start.v}{A suitable starting vector of parameters
    c(C,lambda1,lambda2).   If NULL, use start()}
}
\details{
 Uses \code{optim()}  to find the best-fit Davies distribution to a set
 of data.
}
\value{
Returns the parameters \eqn{C,\lambda_1,\lambda_2}{C,lambda1,lambda2} of
the best-fit Davies distribution to the dataset \code{data}
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{davies.start}}, \code{\link{optim}},
  \code{\link{objective}}, \code{\link{likelihood}}}
\note{BUGS: can be screwed with bad value for \code{start.v}.
  maximum.likelihod() is very slow.  It  might be possible to
  improve this by using some sort of hot-start for optim().
}
\examples{
p <- c(10 , 0.1 , -0.1)
data <-rdavies(50,p)
system.time(print(maximum.likelihood(data)))
                           #observe how long this takes.
                           #The time is taken in repeated calls
                           #to pdavies(), which uses uniroot().

system.time(print(least.squares(data)))
                           #Much faster.
}
\keyword{distribution}
\eof
\name{likelihood}
\alias{likelihood}
\alias{neg.log.likelihood}
\title{likelihood for the Davies distribution }
\description{
  likelihood of observing \code{data}, on the hypothesis of
  their coming from a Davies distribution of parameters \code{params}.

  \code{neg.log.likelihood} gives minus the loglikelihood
}
\usage{
likelihood(params, data)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{params}{Parameters of the Davies distribution}
  \item{data}{dataset for which the likelihood is computed}
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{Davies}}}

\examples{
p1 <- c(10,0.1,-0.1)
p2 <- c(10,0.4,-0.1)
data <- rdavies(100,p1)
likelihood(p1,data)
likelihood(p2,data)                 #should be smaller.
neg.log.likelihood(p1,rstupid(100)) #should be large negative.
}
\keyword{distribution}
\eof
\name{normsquare}
\alias{normsquare}
\alias{do.normsquare}
\alias{do.many.normsquare}
\alias{lognorm}
\alias{do.lognorm}
\alias{do.many.lognorm}
\alias{gld.ozturk}
\alias{do.gld.ozturk}
\alias{do.many.gld.ozturk}
\title{Square normal distribution}
\description{
  A suite of functions to analyze  random
  variables (eg \eqn{X^2}{X^2}, \eqn{\exp(X)}{exp(X)} with
  \eqn{X\sim\rm Norm(0,1)}{X~Norm(0,1)}; and GLD) in terms
  of the Davies distribution
}
\usage{
normsquare(n)
do.normsquare(n,m)
do.many.normsquare(vector,times)
lognorm(n)
do.lognorm(n,m)
do.many.lognorm(vector,times)
gld.ozturk(n)
do.gld.ozturk(n,m)
do.many.gld.ozturk(vector,times)
}
\arguments{
  \item{n}{size of random sample}
  \item{m}{How often to carry out the resampling process}
  \item{vector}{vector of "n"s}
  \item{times}{how many resamplings to do}
}
\details{
  \code{lognorm} gives p-values by parametrically resampling from a
  lognormal distribution
  \code{normsquare} gives p-values by parametrically resampling from a
  square normal distribution
  \code{gld.ozturk} gives p-values by parametrically resampling from a
  gld distribution
  \code{do.lognorm} is a wrapper for \code{lognorm}
  \code{do.normsquare} is a wrapper for \code{normsquare}
  \code{do.gld.ozturk} is a wrapper for \code{gld.ozturk}
  \code{do.many.lognorm} is a wrapper for \code{do.lognorm} used for table N
  \code{do.many.normsquare} is a wrapper for \code{do.normsquare} used for
  table N
  \code{do.manygld.ozturk} is a wrapper for \code{do.gld.ozturk} used for
  table N.
}
\author{Robin K. S. Hankin}
\note{\code{do.many.normsquare} is very slow for large values of n.
}
\examples{
 do.many.normsquare(c(20,30),4)

#carries out resampling on a
#square-normal random dataset of size 20 and 30, four times.
#Takes a long time.

}
  \keyword{distribution}

\eof
\name{objective}
\alias{objective}
\alias{objective.approx}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{The objective function for fitting the Davies distribution}
\description{The ``distance"   %"
  of a dataset from a particular Davies distribution
}
\usage{
objective(params, dataset)
objective.approx(params, dataset)
}
\arguments{
  \item{params}{A three-member vector holding~\eqn{C}{C} ,
    \eqn{\lambda_1}{lambda1} and \eqn{\lambda_2}{lambda2}}
  \item{dataset}{The dataset to be considered}
}
\details{
Used by the fit.davies.p() and fit.davies.q() functions.
}
\value{
  \code{objective} returns the ``distance" of a  %"
  dataset from a particular
  Davies distribution as measured by the sums of the squares of the
  differences between observed (\code{dataset} and
  expected (\code{expected.value()}) values.

  \code{objective.approx()} uses \code{expected.approx()} rather than
  \code{expected()} to calculate expectations, as per equation 6.
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{fit.davies.p}}, \code{\link{fit.davies.q}}}
\examples{
params <- c(10,0.1,-0.1)
x <- rdavies(100,params)
objective(params,x)
objective.approx(params,x)

objective(least.squares(x),x)
objective(davies.start(x),x)


  }
\keyword{distribution}

\eof
\name{plotcf}
\alias{plotcf}
\title{p-value investigation}
\description{
Plots sorted p-values showing which ones would have been rejected.
}
\usage{
plotcf(y, q=0.05)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{y}{dataset}
  \item{q}{p-value of critical region}
}
\details{
Sorts p-values and plots the order statistic.  Useful for investigating
a statistical test by using it when the null hypothesis is KNOWN to be
true, just to check if the probability of rejection really is alpha.

Also can be used when H0 is wrong, showing what beta is.
}

\author{Robin K. S. Hankin}
\seealso{\code{\link{resample.ls}}}

\examples{
library(ctest)
f.H0.T <- function(n,free=5){t.test(rt(n,df=free))$p.value}
f.H0.F <- function(n,free=5){t.test(rf(n,df1=free,df2=free))$p.value}

plotcf(sapply(rep(10,100),f.H0.T))  # should reject about 5: thus
                                     # probability of a type I error is
                                     # about 0.05 (as it should be; this
                                     # is an exact test
plotcf(sapply(rep(10,100),f.H0.F))  # should reject about 80: thus
                                     # probability of a type II error is
                                     # about 0.2 for this H_A.


}
\keyword{distribution}
\eof
\name{resample.ls}
\alias{resample.ls}
\alias{resample.ml}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Parametric resampling from a Davies distribution}
\description{
  Carries out parametric resampling on the null of the dataset
  being drawn from a Davies distribution}
\usage{
resample.ls(data, n = 99)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{dataset to be resampled}
  \item{n}{number of trials to be carried out}
}
\details{
Carries out parametric resampling.  Essentially fits a Davies
distribution to \code{data}, determines an error for this set of
parameters, then draws n `ghost' datasets drawn from a Davies
distribution
with this set of optimized parameters.  Comparing the original error
with the distribution of `ghost' errors allows one to assess how close
to a Davies distribution the original dataset (\code{data}) was.
}
\value{
Returns as list with three components:
  \item{errors}{A vector of length \code{n} corresponding to the `ghost' errors}
  \item{statistic}{Error of the original dataset from the optimal fit
    Davies distribution}
  \item{p-value}{The p-value of this.  Will be \code{runif()} if
    \code{data} is in fact drawn from a Davies distribution}
}
\references{W. H. Press and others, Numerical recipes: the art of
  scientific computing, 1989, Cambridge University Press}
\author{Robin K. S. Hankin}

\examples{
hist(resample.ls(rnorm(50)^2)$errors)
fit.davies.q(resample.ls(rnorm(80)^2)$errors)
}
\keyword{distribution}

\eof
\name{rstupid}
\alias{rstupid}
\title{A stupid PDF}
\description{
  a contrived PDF that cannot be closely approximated by a Davies distribution.
}
\usage{
rstupid(n, a = 1, b = 2, c = 3, d = 4)
}
\arguments{
  \item{n}{Number of observations}
  \item{a}{start of first uniform bit}
  \item{b}{end of first uniform bit}
  \item{c}{start of second uniform bit}
  \item{d}{end of second uniform bit}
}
\details{
 The \code{stupid} distribution is composed of two separate uniform
 distributions: one from a to b, and one from c to d.  It is
 specifically designed to be NOT fittable to any Davies
 distribution.

 You could probably come up with a more stupid distribution
 if you tried.
}

\author{Robin K. S. Hankin}
\seealso{\code{\link{Davies}}}

\examples{
stupid <-rstupid(500)
fit.davies.q(stupid)

}
\keyword{distribution}

\eof
\name{twolines.vert}
\alias{twolines.vert}
\title{Order statistic comparison}
\description{
Plots two lines and shades the bit in between them
}
\usage{
twolines.vert(p, y1, y2, ...)
}
\arguments{
  \item{p}{vector of quantiles}
  \item{y1}{First set of ordinates}
  \item{y2}{Second set of ordinates}
  \item{...}{Extra arguments, passed to \code{segments()}, for
    the vertical lines}
}
\details{
Plots p against y1, and p against y2, and shades the bit in between
using vertical lines.  This is useful for comparing two order statistics.
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{Davies}},\code{\link{qqplot}}}

\examples{
twolines.vert(1:100,sort(rnorm(100)),sort(rnorm(100)))
params <- c(10 , 0.1 , -0.1)
twolines.vert(1:100 , sort(rdavies(100,params)) , sort(rdavies(100,params)))
}
\keyword{distribution}
\eof
\name{x00m700p4}
\alias{x00m700p4}
\title{Peak concentration for 100 instantaneous releases}
\description{
  This data set gives the peak concentration for 100 independent
  instantaneous releases of neutral-buoyancy gas in a windtunnel}
}
\usage{data(x00m700p4)}
\format{A vector containing 100 observations}
\references{
  D. J. Hall and others, Repeat variability in instantaneously released heavy
  gas clouds---some wind tunnel model experiments,
  technical report LR 804 (PA), Warren Spring
  Laboratory,
  Gunnels Wood Road, Stevenage, Hertfordshire SG1 2BX,
  1991
}
\examples{
data(x00m700p4)
fit.davies.q(x00m700p4)
}

\keyword{datasets}
\eof
