### Name: calibrate
### Title: Resampling Model Calibration
### Aliases: calibrate calibrate.default calibrate.cph calibrate.psm
###   print.calibrate print.calibrate.default plot.calibrate
###   plot.calibrate.default
### Keywords: methods models regression survival hplot

### ** Examples

set.seed(1)
d.time <- rexp(200)
x1 <- runif(200)
x2 <- factor(sample(c('a','b','c'),200,TRUE))
f <- cph(Surv(d.time) ~ pol(x1,2)*x2, x=TRUE, y=TRUE, surv=TRUE, time.inc=2)
#or f <- psm(S ~ ...)
cal <- calibrate(f, u=2, m=50, B=20)  # usually B=200 or 300
plot(cal)

y <- sample(0:2, 200, TRUE)
x1 <- runif(200)
x2 <- runif(200)
x3 <- runif(200)
x4 <- runif(200)
f <- lrm(y ~ x1+x2+x3*x4, x=TRUE, y=TRUE)
cal <- calibrate(f, kint=2, predy=seq(.2,.8,length=60), 
                 group=y)
# group= does k-sample validation: make resamples have same 
# numbers of subjects in each level of y as original sample

plot(cal)
#See the example for the validate function for a method of validating
#continuation ratio ordinal logistic models.  You can do the same
#thing for calibrate



