### Name: latex.cph
### Title: LaTeX Representation of a Fitted Cox Model
### Aliases: latex.cph latex.lrm latex.ols latex.pphsm latex.psm
### Keywords: regression character survival interface models

### ** Examples

## Not run: 
##D units(ftime) <- "Day"
##D f <- cph(Surv(ftime, death) ~ rcs(age)+sex, surv=TRUE, time.inc=60)
##D w <- latex(f)  #Interprets fitted model and makes table of S0(t)
##D                #for t=0,60,120,180,...   Creates file f.tex
##D w              #displays image, if viewer installed
##D latex(f,file="")   # send LaTeX code to the screen
## End(Not run)



