### Name: xmp13.04
### Title: data from Example 13.4
### Aliases: xmp13.04
### Keywords: datasets

### ** Examples

data(xmp13.04)
plot(Ethylene ~ time, data = xmp13.04,
     xlab = "Exposure time (min)",
     ylab = "Ethylene content (nL/g dry wt)",
     main = "Compare to Figure 13.5 (a), page 556")
fm1 <- lm(Ethylene ~ time, data = xmp13.04)
abline(fm1)
plot(resid(fm1) ~ xmp13.04$time)
abline(h = 0, lty = 2)
title(main = "Compare to Figure 13.5 (b), page 556")
title(sub = "Using raw residuals instead of standardized")
fm2 <- lm(log(Ethylene) ~ time, data = xmp13.04)
plot(resid(fm2) ~ xmp13.04$time)
abline(h = 0, lty = 2)
title(main = "Compare to Figure 13.6 (a), page 557")
title(sub = "Using raw residuals instead of standardized")
summary(fm2)
plot(exp(fitted(fm2)) ~ xmp13.04$Ethylene)



