\name{ex01.11}
\alias{ex01.11}
\docType{data}
\title{data from exercise 1.11}
\description{
The \code{ex01.11} data frame has 40 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Scores}{
      a numeric vector
    }
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.11)
str(ex01.11)
}
\keyword{datasets}
\eof
\name{ex01.13}
\alias{ex01.13}
\docType{data}
\title{data from exercise 1.13}
\description{
  Data on tensile ultimate strength (ksi)
}
\usage{data(ex01.13)}
\format{
  A data frame with 153 observations on the following variable.
  \describe{
    \item{strength}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  Establishing Mechanical Property Allowables for Metals,
  \emph{J. Testing and Evaluation}, 1998: 293-299.
}
\examples{
data(ex01.13)
str(ex01.13)
}
\keyword{datasets}
\eof
\name{ex01.14}
\alias{ex01.14}
\docType{data}
\title{data from exercise 1.14}
\description{
    The \code{ex01.14} data frame has 129 rows and 1 columns.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{Rate}{
	    a numeric vector of shower-flow rates (L/min)
	}
    }
}
\details{
    The shower-flow rates for a sample of houses in Perth, Australia.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury 
}
\references{    
  James, I. R. and Knuiman, M. W. (1987) An application of Bayes
  methodology to the analysis of diary records in a water use
  study. \emph{Journal of the American  Statistical Association},
  \bold{82}, 705--711.
}
\examples{
data(ex01.14)
str(ex01.14)
}
\keyword{datasets}
\eof
\name{ex01.15}
\alias{ex01.15}
\docType{data}
\title{data from exercise 1.15}
\description{
  Scores for different brands of peanut butter according to type.
}
\usage{data(ex01.15)}
\format{
  A data frame with 37 observations on the following 2 variables.
  \describe{
    \item{Score}{a numeric vector}
    \item{Type}{a factor with levels \code{Creamy} \code{Crunchy}}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  \emph{Consumer Reports}, Sept. 1990.
}
\examples{
data(ex01.15)
str(ex01.15)
}
\keyword{datasets}
\eof
\name{ex01.17}
\alias{ex01.17}
\docType{data}
\title{data from exercise 1.17}
\description{
The \code{ex01.17} data frame has 60 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.17)
}
\keyword{datasets}
\eof
\name{ex01.18}
\alias{ex01.18}
\docType{data}
\title{data from exercise 1.18}
\description{
The \code{ex01.18} data frame has 18 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number.of.papers}{
a numeric vector
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.18)
}
\keyword{datasets}
\eof
\name{ex01.19}
\alias{ex01.19}
\docType{data}
\title{data from exercise 1.19}
\description{
The \code{ex01.19} data frame has 15 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number.of.particles}{
a numeric vector
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.19)
}
\keyword{datasets}
\eof
\name{ex01.20}
\alias{ex01.20}
\docType{data}
\title{data from exercise 1.20}
\description{
The \code{ex01.20} data frame has 47 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.20)
}
\keyword{datasets}
\eof
\name{ex01.21}
\alias{ex01.21}
\docType{data}
\title{data from exercise 1.21}
\description{
The \code{ex01.21} data frame has 47 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{y}{
a numeric vector
}
\item{z}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.21)
}
\keyword{datasets}
\eof
\name{ex01.23}
\alias{ex01.23}
\docType{data}
\title{data from exercise 1.23}
\description{
The \code{ex01.23} data frame has 100 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{cycles}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.23)
}
\keyword{datasets}
\eof
\name{ex01.24}
\alias{ex01.24}
\docType{data}
\title{data from exercise 1.24}
\description{
The \code{ex01.24} data frame has 100 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{ShearStr}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.24)
}
\keyword{datasets}
\eof
\name{ex01.25}
\alias{ex01.25}
\docType{data}
\title{data from exercise 1.25}
\description{
The \code{ex01.25} data frame has 40 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{IDT}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.25)
}
\keyword{datasets}
\eof
\name{ex01.27}
\alias{ex01.27}
\docType{data}
\title{data from exercise 1.27}
\description{
  Number of cycles of strain to breakage for 100 yarn samples.
}
\usage{data(ex01.27)}
\format{
  A data frame with 50 observations on the following variable.
  \describe{
    \item{lifetime}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\references{
  \emph{Technometrics}, 1982: 63.
}
\examples{
data(ex01.27)
str(ex01.27)
}
\keyword{datasets}
\eof
\name{ex01.28}
\alias{ex01.28}
\docType{data}
\title{data from exercise 1.28}
\description{
The \code{ex01.28} data frame has 60 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{radiation}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.28)
}
\keyword{datasets}
\eof
\name{ex01.29}
\alias{ex01.29}
\docType{data}
\title{data from exercise 1.29}
\description{
The \code{ex01.29} data frame has 60 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{complaint}{
a factor with levels
\code{B} 
\code{C} 
\code{F} 
\code{J} 
\code{M} 
\code{N} 
\code{O} 
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.29)
}
\keyword{datasets}
\eof
\name{ex01.32}
\alias{ex01.32}
\docType{data}
\title{data from exercise 1.32}
\description{
The \code{ex01.32} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Value}{
a numeric vector
}
\item{Cumulative}{
a numeric vector of cumulative percentages
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.32)
}
\keyword{datasets}
\eof
\name{ex01.33}
\alias{ex01.33}
\docType{data}
\title{data from exercise 1.33}
\description{
The \code{ex01.33} data frame has 14 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.33)
}
\keyword{datasets}
\eof
\name{ex01.34}
\alias{ex01.34}
\docType{data}
\title{data from exercise 1.34}
\description{
The \code{ex01.34} data frame has 11 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.34)
}
\keyword{datasets}
\eof
\name{ex01.35}
\alias{ex01.35}
\docType{data}
\title{data from exercise 1.35}
\description{
The \code{ex01.35} data frame has 8 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.35)
}
\keyword{datasets}
\eof
\name{ex01.36}
\alias{ex01.36}
\docType{data}
\title{data from exercise 1.36}
\description{
The \code{ex01.36} data frame has 26 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.36)
}
\keyword{datasets}
\eof
\name{ex01.37}
\alias{ex01.37}
\docType{data}
\title{data from exercise 1.37}
\description{
The \code{ex01.37} data frame has 11 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.37)
}
\keyword{datasets}
\eof
\name{ex01.38}
\alias{ex01.38}
\docType{data}
\title{data from exercise 1.38}
\description{
The \code{ex01.38} data frame has 9 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{pressure}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.38)
}
\keyword{datasets}
\eof
\name{ex01.39}
\alias{ex01.39}
\docType{data}
\title{data from exercise 1.39}
\description{
The \code{ex01.39} data frame has 16 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{lives}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.39)
}
\keyword{datasets}
\eof
\name{ex01.43}
\alias{ex01.43}
\docType{data}
\title{data from exercise 1.43}
\description{
The \code{ex01.43} data frame has 10 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Lifetime}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.43)
}
\keyword{datasets}
\eof
\name{ex01.44}
\alias{ex01.44}
\docType{data}
\title{data from exercise 1.44}
\description{
The \code{ex01.44} data frame has 10 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.44)
}
\keyword{datasets}
\eof
\name{ex01.45}
\alias{ex01.45}
\docType{data}
\title{data from exercise 1.45}
\description{
The \code{ex01.45} data frame has 5 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.45)
}
\keyword{datasets}
\eof
\name{ex01.46}
\alias{ex01.46}
\docType{data}
\title{data from exercise 1.46}
\description{
The \code{ex01.46} data frame has 5 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.46)
}
\keyword{datasets}
\eof
\name{ex01.49}
\alias{ex01.49}
\docType{data}
\title{data from exercise 1.49}
\description{
The \code{ex01.49} data frame has 17 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{area}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.49)
}
\keyword{datasets}
\eof
\name{ex01.50}
\alias{ex01.50}
\docType{data}
\title{data from exercise 1.50}
\description{
  Monetary awards in lawsuits.
}
\usage{data(ex01.50)}
\format{
  A data frame with 27 observations on the following variable.
  \describe{
    \item{awards}{a numeric vector}
  }
}
\details{
  Awards is a "normative" group of 27 cases similar to
  \emph{Genessy v. Digital Equipment Corp.}
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
%\references{}
\examples{
data(ex01.50)
str(ex01.50)
}
\keyword{datasets}
\eof
\name{ex01.51}
\alias{ex01.51}
\docType{data}
\title{data from exercise 1.51}
\description{
The \code{ex01.51} data frame has 19 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{InducTm}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.51)
}
\keyword{datasets}
\eof
\name{ex01.54}
\alias{ex01.54}
\docType{data}
\title{data from exercise 1.54}
\description{
The \code{ex01.54} data frame has 11 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.54)
}
\keyword{datasets}
\eof
\name{ex01.56}
\alias{ex01.56}
\docType{data}
\title{data from exercise 1.56}
\description{
The \code{ex01.56} data frame has 26 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.56)
}
\keyword{datasets}
\eof
\name{ex01.59}
\alias{ex01.59}
\docType{data}
\title{data from exercise 1.59}
\description{
The \code{ex01.59} data frame has 78 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{conc}{
a numeric vector
}
\item{cause}{
a factor with levels
\code{ED} 
\code{non-ED} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.59)
}
\keyword{datasets}
\eof
\name{ex01.60}
\alias{ex01.60}
\docType{data}
\title{data from exercise 1.60}
\description{
The \code{ex01.60} data frame has 23 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{strength}{
a numeric vector of weld strengths
}
\item{type}{
a factor with levels \code{Cannister} or \code{Test} indicating the type
of weld.
}
}
}
\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.60)
}
\keyword{datasets}
\eof
\name{ex01.63}
\alias{ex01.63}
\docType{data}
\title{data from exercise 1.63}
\description{
The \code{ex01.63} data frame has 7 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{FlowRate.125}{
a numeric vector
}
\item{FlowRate.160}{
a numeric vector
}
\item{FlowRate.200}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.63)
}
\keyword{datasets}
\eof
\name{ex01.64}
\alias{ex01.64}
\docType{data}
\title{data from exercise 1.64}
\description{
The \code{ex01.64} data frame has 26 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.64)
}
\keyword{datasets}
\eof
\name{ex01.65}
\alias{ex01.65}
\docType{data}
\title{data from exercise 1.65}
\description{
The \code{ex01.65} data frame has 4 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{HC}{
a numeric vector
}
\item{CO}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.65)
}
\keyword{datasets}
\eof
\name{ex01.67}
\alias{ex01.67}
\docType{data}
\title{data from exercise 1.67}
\description{
The \code{ex01.67} data frame has 15 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{CO.conc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.67)
}
\keyword{datasets}
\eof
\name{ex01.70}
\alias{ex01.70}
\docType{data}
\title{data from exercise 1.70}
\description{
  Oxygen consumption for 15 subjects on two types of exercise
}
\usage{data(ex01.70)}
\format{
  A data frame with 15 observations on the following 2 variables.
  \describe{
    \item{Weight}{a numeric vector of oxygen consumption when weight training}
    \item{Treadmill}{a numeric vector of oxygen consumption on a treadmill}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Effect of Weight Training Exercise and Treadmill Exercise on
  Post-Exercise Oxygen Consumption'', \emph{Medicine and Science in
    Sport and Exercise}, 1998: 518--522.
}
\examples{
data(ex01.70)
}
\keyword{datasets}
\eof
\name{ex01.72}
\alias{ex01.72}
\docType{data}
\title{data from exercise 1.72}
\description{
  Benzodiazepine receptor binding in individuals suffering from
  Posttraumatic Stress Disorder (PTSD).
}
\usage{data(ex01.72)}
\format{
  A data frame with 13 observations on the following 2 variables.
  \describe{
    \item{PTSD}{a numeric vector of receptor binding measures for
      individuals suffering from PTSD.}
    \item{Healthy}{a numeric vector of receptor binding measures for
      healthy individuals}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Decreased Benzodiazepine Receptor Binding in Prefrontal Cortex in
  Combat-Related Posttraumatic Stress Disorder'', \emph{Amer. J. of
    Psychiatry}, 2000: 1120--1126.
}
\examples{
data(ex01.72)
}
\keyword{datasets}
\eof
\name{ex01.73}
\alias{ex01.73}
\docType{data}
\title{data from exercise 1.73}
\description{
The \code{ex01.73} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.73)
}
\keyword{datasets}
\eof
\name{ex01.75}
\alias{ex01.75}
\docType{data}
\title{data from exercise 1.75}
\description{
The \code{ex01.75} data frame has 15 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type.1}{
a numeric vector
}
\item{Type.2}{
a numeric vector
}
\item{Type.3}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.75)
}
\keyword{datasets}
\eof
\name{ex01.77}
\alias{ex01.77}
\docType{data}
\title{data from exercise 1.77}
\description{
  The \code{ex01.77} data frame has 46 rows and 1 columns.
}
\usage{data(ex01.77)}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Time}{
      a numeric vector of active repair times (hours) for airborne
      communications receivers.
    }
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex01.77)
str(ex01.77)
}
\keyword{datasets}
\eof
\name{ex01.80}
\alias{ex01.80}
\docType{data}
\title{data from exercise 1.80}
\description{
  Frequency table of the lengths (km) of bus routes.
}
\usage{data(ex01.80)}
\format{
  A data frame with 15 observations on the following 2 variables.
  \describe{
    \item{Length}{a factor with levels \code{10-<12} \code{12-<14} \code{14-<16} \code{16-<18} \code{18-<20} \code{20-<22} \code{22-<24} \code{24-<26} \code{26-<28} \code{28-<30} \code{30-<35} \code{35-<40} \code{40-<45} \code{6-<8} \code{8-<10}}
    \item{Frequency}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\references{
  Planning of City Bus Routes, \emph{J. of the Institute of Engineers},
  1995: 211-215.
}
\examples{
data(ex01.80)
}
\keyword{datasets}
\eof
\name{ex01.83}
\alias{ex01.83}
\docType{data}
\title{data from exercise 1.83}
\description{
  Rainfall (acre-feet) from 26 seeded clouds.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{rainfall}{
      a numeric vector
    }
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\reference{
  A Bayesian Analysis of a Multiplicative Treatment Effect in Weather
  Modification, \emph{Technometrics}, 1975: 161-166.
}
\examples{
data(ex01.83)
}
\keyword{datasets}
\eof
\name{ex04.82}
\alias{ex04.82}
\docType{data}
\title{data from exercise 4.82}
\description{
    The \code{ex04.82} data frame has 10 rows and 1 columns of bearing
    lifetimes.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{lifetime}{
	    a numeric vector
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury

    (1985), "Modified Moment Estimation for the three-parameter
    Log-normal distribution", \emph{Journal of Quality Technology},
    92--99.
}
\examples{
data(ex04.82)
attach(ex04.82)
boxplot(lifetime, ylab = "Lifetime (hr)",
        main = "Bearing lifetimes from exercise 4.82",
        col = "lightgray")
## Normal probability plot on the original time scale
qqnorm(lifetime, ylab = "Lifetime (hr)", las = 1)
qqline(lifetime)
## Try normal probability plot of the log(lifetime)
qqnorm(log(lifetime), ylab = "log(lifetime) (log(hr))",
       las = 1)
qqline(log(lifetime))
detach()
}
\keyword{datasets}
\eof
\name{ex04.83}
\alias{ex04.83}
\docType{data}
\title{data from exercise 4.83}
\description{
  Coating thickness for low-viscosity paint.
}
\usage{data(ex04.83)}
\format{
  A data frame with 16 observations on the following variable.
  \describe{
    \item{thickness}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Achieving a Target Value for a Manufacturing Process: A Case
  Study'', \emph{J. of Quality Technology}, 1992: 22--26.
}
\examples{
data(ex04.83)
}
\keyword{datasets}
\eof
\name{ex04.84}
\alias{ex04.84}
\docType{data}
\title{data from exercise 4.84}
\description{
  Toughness for high-strength concrete and values for Weibull plot
}
\usage{data(ex04.84)}
\format{
  A data frame with 18 observations on the following 2 variables.
  \describe{
    \item{obsv}{a numeric vector}
    \item{p}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``A Probabilistic Model of Fracture in Concrete and Size Effects on
  Fracture Toughness'', \emph{Magazine of Concrete Research}, 1996:
  311-320.
}
\examples{
data(ex04.84)
}
\keyword{datasets}
\eof
\name{ex04.86}
\alias{ex04.86}
\docType{data}
\title{data from exercise 4.86}
\description{
    The \code{ex04.86} data frame has 20 rows and 1 columns of bearing
    load lifetimes.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{loadlife}{
	    a numeric vector of bearing load life (million revs) for
	    bearings tested at a 6.45 kN load.
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury

    (1984) "The load-life relationship for M50 bearings with silicon
    nitrate ceramic balls", \emph{Lubrication Engineering}, 153--159.
}
\examples{
data(ex04.86)
attach(ex04.86)
boxplot(loadlife, ylab = "Load-Life (million revs)",
        main = "Bearing load-lifes from exercise 4.86",
        col = "lightgray")
## Normal probability plot
qqnorm(loadlife, ylab = "Load-life (million revs)")
qqline(loadlife)
## Weibull probability plot
plot(
  log(-log(1 - (seq(along = loadlife) - 0.5)/length(loadlife))),
  log(sort(loadlife)), xlab = "Theoretical Quantiles",
  ylab = "log(load-life) (log(million revs))",
  main = "Weibull Q-Q Plot", las = 1)
detach()
}
\keyword{datasets}
\eof
\name{ex04.88}
\alias{ex04.88}
\docType{data}
\title{data from exercise 4.88}
\description{
    The \code{ex04.88} data frame has 30 rows and 1 columns of
    precipitation during March in Minneapolis-St. Paul.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{preciptn}{
	    a numeric vector of precipitation (in) during March in
	    Minneapolis-St. Paul.
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex04.88)
attach(ex04.88)
## Normal probability plot
qqnorm(preciptn, ylab = "Precipitation (in)",
   main = "Precipitation during March in Minneapolis-St. Paul")
qqline(preciptn)
## Normal probability plot on square root scale
qqnorm(sqrt(preciptn),
   ylab = expression(sqrt("Precipitation (in)")),
   main =
     "Precipitation during March in Minneapolis-St. Paul")
qqline(sqrt(preciptn))
detach()   
}
\keyword{datasets}
\eof
\name{ex04.90}
\alias{ex04.90}
\docType{data}
\title{data from exercise 4.90}
\description{
  Sample of measurement errors
}
\usage{data(ex04.90)}
\format{
  A data frame with 10 observations on the following variable.
  \describe{
    \item{measerr}{a numeric vector - probably simulated.}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
%\references{}
\examples{
data(ex04.90)
}
\keyword{datasets}
\eof
\name{ex04.91}
\alias{ex04.91}
\docType{data}
\title{data from exercise 4.91}
\description{
  Failure times for accelerated life testing of integrated circuits.
}
\usage{data(ex04.91)}
\format{
  A data frame with 16 observations on the following variable.
  \describe{
    \item{failtime}{a numeric vector of failure times (1000's of hours)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
%\references{}
\examples{
data(ex04.91)
}
\keyword{datasets}
\eof
\name{ex06.01}
\alias{ex06.01}
\docType{data}
\title{data from exercise 6.1}
\description{
The \code{ex06.01} data frame has 27 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.01)
}
\keyword{datasets}
\eof
\name{ex06.02}
\alias{ex06.02}
\docType{data}
\title{data from exercise 6.2}
\description{
The \code{ex06.02} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a factor with levels
\code{C} 
\code{H} 
\code{S} 
\code{T} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.02)
}
\keyword{datasets}
\eof
\name{ex06.03}
\alias{ex06.03}
\docType{data}
\title{data from exercise 6.3}
\description{
The \code{ex06.03} data frame has 16 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.03)
}
\keyword{datasets}
\eof
\name{ex06.04}
\alias{ex06.04}
\docType{data}
\title{data from exercise 6.4}
\description{
The \code{ex06.04} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.04)
}
\keyword{datasets}
\eof
\name{ex06.05}
\alias{ex06.05}
\docType{data}
\title{data from exercise 6.5}
\description{
The \code{ex06.05} data frame has 5 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Book.value}{
a numeric vector
}
\item{Audited.value}{
a numeric vector
}
\item{Error}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.05)
}
\keyword{datasets}
\eof
\name{ex06.06}
\alias{ex06.06}
\docType{data}
\title{data from exercise 6.6}
\description{
The \code{ex06.06} data frame has 31 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Strmflow}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.06)
}
\keyword{datasets}
\eof
\name{ex06.09}
\alias{ex06.09}
\docType{data}
\title{data from exercise 6.9}
\description{
  The \code{ex06.09} data frame has 8 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{scratches}{
      a numeric vector
    }
    \item{frequency}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.09)
}
\keyword{datasets}
\eof
\name{ex06.15}
\alias{ex06.15}
\docType{data}
\title{data from exercise 6.15}
\description{
The \code{ex06.15} data frame has 10 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.15)
}
\keyword{datasets}
\eof
\name{ex06.25}
\alias{ex06.25}
\docType{data}
\title{data from exercise 6.25}
\description{
The \code{ex06.25} data frame has 10 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{strength}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex06.25)
}
\keyword{datasets}
\eof
\name{ex07.10}
\alias{ex07.10}
\docType{data}
\title{data from exercise 7.10}
\description{
The \code{ex07.10} data frame has 15 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{lifetime}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.10)
}
\keyword{datasets}
\eof
\name{ex07.26}
\alias{ex07.26}
\docType{data}
\title{data from exercise 7.26}
\description{
The \code{ex07.26} data frame has 11 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number.of.absences}{
a numeric vector
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.26)
}
\keyword{datasets}
\eof
\name{ex07.33}
\alias{ex07.33}
\docType{data}
\title{data from exercise 7.33}
\description{
The \code{ex07.33} data frame has 17 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.33)
}
\keyword{datasets}
\eof
\name{ex07.37}
\alias{ex07.37}
\docType{data}
\title{data from exercise 7.37}
\description{
The \code{ex07.37} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.37)
}
\keyword{datasets}
\eof
\name{ex07.45}
\alias{ex07.45}
\docType{data}
\title{data from exercise 7.45}
\description{
The \code{ex07.45} data frame has 22 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{toughnss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.45)
}
\keyword{datasets}
\eof
\name{ex07.46}
\alias{ex07.46}
\docType{data}
\title{data from exercise 7.46}
\description{
The \code{ex07.46} data frame has 15 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.46)
}
\keyword{datasets}
\eof
\name{ex07.47}
\alias{ex07.47}
\docType{data}
\title{data from exercise 7.47}
\description{
The \code{ex07.47} data frame has 48 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{strength}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.47)
}
\keyword{datasets}
\eof
\name{ex07.49}
\alias{ex07.49}
\docType{data}
\title{data from exercise 7.49}
\description{
The \code{ex07.49} data frame has 18 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{ResidGas}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.49)
}
\keyword{datasets}
\eof
\name{ex07.56}
\alias{ex07.56}
\docType{data}
\title{data from exercise 7.56}
\description{
The \code{ex07.56} data frame has 16 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{pul.comp}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.56)
}
\keyword{datasets}
\eof
\name{ex07.58}
\alias{ex07.58}
\docType{data}
\title{data from exercise 7.58}
\description{
The \code{ex07.58} data frame has 6 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex07.58)
}
\keyword{datasets}
\eof
\name{ex08.32}
\alias{ex08.32}
\docType{data}
\title{data from exercise 8.32}
\description{
The \code{ex08.32} data frame has 12 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.32)
}
\keyword{datasets}
\eof
\name{ex08.54}
\alias{ex08.54}
\docType{data}
\title{data from exercise 8.54}
\description{
  Amount of organic matter in soil samples.
}
\usage{data(ex08.54)}
\format{
  A data frame with 30 observations on the following variable.
  \describe{
    \item{percorg}{a numeric vector of percentages of organic matter}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Engineering Proeprties of Soil'', \emph{Soil Science}, 1998: 93--102.
}
\examples{
data(ex08.54)
}
\keyword{datasets}
\eof
\name{ex08.55}
\alias{ex08.55}
\docType{data}
\title{data from exercise 8.55}
\description{
The \code{ex08.55} data frame has 13 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{times}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.55)
}
\keyword{datasets}
\eof
\name{ex08.57}
\alias{ex08.57}
\docType{data}
\title{data from exercise 8.57}
\description{
The \code{ex08.57} data frame has 6 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{CO.conc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.57)
}
\keyword{datasets}
\eof
\name{ex08.66}
\alias{ex08.66}
\docType{data}
\title{data from exercise 8.66}
\description{
The \code{ex08.66} data frame has 8 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{SoilHeat}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.66)
}
\keyword{datasets}
\eof
\name{ex08.70}
\alias{ex08.70}
\docType{data}
\title{data from exercise 8.70}
\description{
The \code{ex08.70} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{time}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.70)
}
\keyword{datasets}
\eof
\name{ex08.80}
\alias{ex08.80}
\docType{data}
\title{data from exercise 8.80}
\description{
The \code{ex08.80} data frame has 10 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex08.80)
}
\keyword{datasets}
\eof
\name{ex09.07}
\alias{ex09.07}
\docType{data}
\title{data from exercise 9.7}
\description{
The \code{ex09.07} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Gender}{
a factor with levels
\code{Females} 
\code{Males} 
}
\item{Sample.Size}{
a numeric vector
}
\item{Sample.Mean}{
a numeric vector
}
\item{Sample.Standard.Deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.07)
}
\keyword{datasets}
\eof
\name{ex09.12}
\alias{ex09.12}
\docType{data}
\title{data from exercise 9.12}
\description{
The \code{ex09.12} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Age}{
a numeric vector
}
\item{n}{
a numeric vector
}
\item{Mean}{
a numeric vector
}
\item{StdDev}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.12)
}
\keyword{datasets}
\eof
\name{ex09.16}
\alias{ex09.16}
\docType{data}
\title{data from exercise 9.16}
\description{
The \code{ex09.16} data frame has 2 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type}{
a numeric vector
}
\item{Sample.Average}{
a numeric vector
}
\item{Sample.Standard.Deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.16)
}
\keyword{datasets}
\eof
\name{ex09.23}
\alias{ex09.23}
\docType{data}
\title{data from exercise 9.23}
\description{
The \code{ex09.23} data frame has 32 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{extens}{
a numeric vector
}
\item{quality}{
a factor with levels
\code{H} 
\code{P} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.23)
}
\keyword{datasets}
\eof
\name{ex09.25}
\alias{ex09.25}
\docType{data}
\title{data from exercise 9.25}
\description{
The \code{ex09.25} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Condition}{
a factor with levels
\code{LBP} 
\code{No LBP} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.SD}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.25)
}
\keyword{datasets}
\eof
\name{ex09.27}
\alias{ex09.27}
\docType{data}
\title{data from exercise 9.27}
\description{
The \code{ex09.27} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type.of.Player}{
a factor with levels
\code{Advanced} 
\code{Intermediate} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.standard.deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.27)
}
\keyword{datasets}
\eof
\name{ex09.28}
\alias{ex09.28}
\docType{data}
\title{data from exercise 9.28}
\description{
  Single-step recovery from a forward fall
}
\usage{data(ex09.28)}
\format{
  A data frame with 15 observations on the following 2 variables.
  \describe{
    \item{Lean}{a numeric vector of the maximum lean angle from which a
      subject could still recover in one step.}
    \item{Age}{a factor with levels \code{O} \code{Y} indicating if the
      subject is an older female (67-81 years) or a younger female
      (21-29 years)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury

}
\references{
  ``Age and Gender Differences in Single-Step Recovery from a Forward
  Fall'', \emph{J. of Gerontology}, 1999: M44-M50.
}
\examples{
data(ex09.28)
}
\keyword{datasets}
\eof
\name{ex09.29}
\alias{ex09.29}
\docType{data}
\title{data from exercise 9.29}
\description{
The \code{ex09.29} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Beverage}{
a factor with levels
\code{Cola} 
\code{Strawberry drink} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.standard.deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.29)
}
\keyword{datasets}
\eof
\name{ex09.30}
\alias{ex09.30}
\docType{data}
\title{data from exercise 9.30}
\description{
The \code{ex09.30} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type}{
a factor with levels
\code{Commercial carbon grid} 
\code{Fiberglass grid} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.standard.deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.30)
}
\keyword{datasets}
\eof
\name{ex09.31}
\alias{ex09.31}
\docType{data}
\title{data from exercise 9.31}
\description{
The \code{ex09.31} data frame has 11 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.31)
}
\keyword{datasets}
\eof
\name{ex09.32}
\alias{ex09.32}
\docType{data}
\title{data from exercise 9.32}
\description{
The \code{ex09.32} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type.of.wood}{
a factor with levels
\code{Douglas fir} 
\code{Red oak} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.standard.deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.32)
}
\keyword{datasets}
\eof
\name{ex09.33}
\alias{ex09.33}
\docType{data}
\title{data from exercise 9.33}
\description{
The \code{ex09.33} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Treatment}{
a factor with levels
\code{Control} 
\code{Steroid} 
}
\item{Sample.size}{
a numeric vector
}
\item{Sample.mean}{
a numeric vector
}
\item{Sample.standard.deviation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.33)
}
\keyword{datasets}
\eof
\name{ex09.36}
\alias{ex09.36}
\docType{data}
\title{data from exercise 9.36}
\description{
The \code{ex09.36} data frame has 8 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Fabric}{
a numeric vector
}
\item{U}{
a numeric vector
}
\item{A}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.36)
}
\keyword{datasets}
\eof
\name{ex09.37}
\alias{ex09.37}
\docType{data}
\title{data from exercise 9.37}
\description{
The \code{ex09.37} data frame has 33 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{House}{
a numeric vector
}
\item{Indoor}{
a numeric vector
}
\item{Outdoor}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.37)
}
\keyword{datasets}
\eof
\name{ex09.38}
\alias{ex09.38}
\docType{data}
\title{data from exercise 9.38}
\description{
The \code{ex09.38} data frame has 15 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Test.condition}{
a numeric vector
}
\item{Normal}{
a numeric vector
}
\item{High}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.38)
}
\keyword{datasets}
\eof
\name{ex09.39}
\alias{ex09.39}
\docType{data}
\title{data from exercise 9.39}
\description{
The \code{ex09.39} data frame has 14 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Infant}{
a numeric vector
}
\item{Isotopic.method}{
a numeric vector
}
\item{Test.weighing.method}{
a numeric vector
}
\item{Difference}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.39)
}
\keyword{datasets}
\eof
\name{ex09.40}
\alias{ex09.40}
\docType{data}
\title{data from exercise 9.40}
\description{
The \code{ex09.40} data frame has 16 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Period}{
a numeric vector
}
\item{Pipe}{
a numeric vector
}
\item{Brush}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.40)
}
\keyword{datasets}
\eof
\name{ex09.41}
\alias{ex09.41}
\docType{data}
\title{data from exercise 9.41}
\description{
The \code{ex09.41} data frame has 9 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Subject}{
a numeric vector
}
\item{Black}{
a numeric vector
}
\item{White}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.41)
}
\keyword{datasets}
\eof
\name{ex09.43}
\alias{ex09.43}
\docType{data}
\title{data from exercise 9.43}
\description{
  Difference between age at onset and at diagnosis for children with childhood
  Cushing's disease.
}
\format{
This data frame contains 15 observations on the following variable:
\describe{
\item{difference}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Treatment of Cushing's Disease in Childhood and Adolescence by
  Transphenoidal Microadenomectomy'', \emph{New England J. of Medicine},
  1984: 889.
}
\examples{
data(ex09.43)
}
\keyword{datasets}
\eof
\name{ex09.44}
\alias{ex09.44}
\docType{data}
\title{data from exercise 9.44}
\description{
  Modulus of elasticity of lumber samples at different times after loading
}
\usage{data(ex09.44)}
\format{
  A data frame with 16 observations on the following 2 variables.
  \describe{
    \item{X1min}{a numeric vector giving the modulus of elasticity
      1 minute after loading}
    \item{X4weeks}{a numeric vector giving the modulus of elasticity
      4 weeks after loading}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
%\references{}
\examples{
data(ex09.44)
}
\keyword{datasets}
\eof
\name{ex09.63}
\alias{ex09.63}
\docType{data}
\title{data from exercise 9.63}
\description{
The \code{ex09.63} data frame has 4 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Epoxy}{
a numeric vector
}
\item{MMA}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.63)
}
\keyword{datasets}
\eof
\name{ex09.65}
\alias{ex09.65}
\docType{data}
\title{data from exercise 9.65}
\description{
The \code{ex09.65} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Method}{
a factor with levels
\code{Fixed} 
\code{Floating} 
}
\item{n}{
a numeric vector
}
\item{mean}{
a numeric vector
}
\item{SD}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.65)
}
\keyword{datasets}
\eof
\name{ex09.66}
\alias{ex09.66}
\docType{data}
\title{data from exercise 9.66}
\description{
The \code{ex09.66} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Fertilizer.plots}{
a numeric vector
}
\item{Control.plots}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.66)
}
\keyword{datasets}
\eof
\name{ex09.68}
\alias{ex09.68}
\docType{data}
\title{data from exercise 9.68}
\description{
The \code{ex09.68} data frame has 35 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{density}{
a numeric vector
}
\item{sampling}{
a factor with levels
\code{block} 
\code{pitcher} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.68)
}
\keyword{datasets}
\eof
\name{ex09.70}
\alias{ex09.70}
\docType{data}
\title{data from exercise 9.70}
\description{
The \code{ex09.70} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Type}{
a factor with levels
\code{With.side.coating} 
\code{Without.side.coating} 
}
\item{size}{
a numeric vector
}
\item{mean}{
a numeric vector
}
\item{SD}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.70)
}
\keyword{datasets}
\eof
\name{ex09.72}
\alias{ex09.72}
\docType{data}
\title{data from exercise 9.72}
\description{
The \code{ex09.72} data frame has 17 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Motor}{
a numeric vector
}
\item{Commutator}{
a numeric vector
}
\item{Pinion}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.72)
}
\keyword{datasets}
\eof
\name{ex09.76}
\alias{ex09.76}
\docType{data}
\title{data from exercise 9.76}
\description{
The \code{ex09.76} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Site}{
a factor with levels
\code{Clean} 
\code{Steam.plant} 
}
\item{size}{
a numeric vector
}
\item{mean}{
a numeric vector
}
\item{SD}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.76)
}
\keyword{datasets}
\eof
\name{ex09.77}
\alias{ex09.77}
\docType{data}
\title{data from exercise 9.77}
\description{
The \code{ex09.77} data frame has 5 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Twist.multiple}{
a numeric vector
}
\item{Control.strength}{
a numeric vector
}
\item{Heated.strength}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.77)
}
\keyword{datasets}
\eof
\name{ex09.78}
\alias{ex09.78}
\docType{data}
\title{data from exercise 9.78}
\description{
The \code{ex09.78} data frame has 2 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Group}{
a factor with levels
\code{Elderly.men} 
\code{Young} 
}
\item{size}{
a numeric vector
}
\item{mean}{
a numeric vector
}
\item{stdError}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.78)
}
\keyword{datasets}
\eof
\name{ex09.79}
\alias{ex09.79}
\docType{data}
\title{data from exercise 9.79}
\description{
The \code{ex09.79} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Good.visibility}{
a numeric vector
}
\item{Poor.visibility}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.79)
}
\keyword{datasets}
\eof
\name{ex09.82}
\alias{ex09.82}
\docType{data}
\title{data from exercise 9.82}
\description{
  Energy intake compared to energy expenditure for 7 soccer players
}
\usage{data(ex09.82)}
\format{
  A data frame with 7 observations on the following 2 variables.
  \describe{
    \item{expend}{a numeric vector}
    \item{intake}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Measurement of Total Energy Expenditure by the Double Labelled Water
  Method in Professional Soccer Players'', \emph{J. of Sport Sciences},
  2002: 391--397.
}
\examples{
data(ex09.82)
}
\keyword{datasets}
\eof
\name{ex09.86}
\alias{ex09.86}
\docType{data}
\title{data from exercise 9.86}
\description{
The \code{ex09.86} data frame has 4 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Treatment}{
a numeric vector
}
\item{n}{
a numeric vector
}
\item{SD}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.86)
}
\keyword{datasets}
\eof
\name{ex09.88}
\alias{ex09.88}
\docType{data}
\title{data from exercise 9.88}
\description{
The \code{ex09.88} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Carpet}{
a numeric vector
}
\item{NoCarpet}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.88)
}
\keyword{datasets}
\eof
\name{ex09.92}
\alias{ex09.92}
\docType{data}
\title{data from exercise 9.92}
\description{
The \code{ex09.92} data frame has 8 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number}{
a numeric vector
}
\item{Region1}{
a numeric vector
}
\item{Region2}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex09.92)
}
\keyword{datasets}
\eof
\name{ex10.06}
\alias{ex10.06}
\docType{data}
\title{data from exercise 10.6}
\description{
The \code{ex10.06} data frame has 40 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{totalFe}{
a numeric vector
}
\item{type}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.06)
}
\keyword{datasets}
\eof
\name{ex10.08}
\alias{ex10.08}
\docType{data}
\title{data from exercise 10.8}
\description{
The \code{ex10.08} data frame has 35 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{stiffnss}{
a numeric vector
}
\item{length}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.08)
}
\keyword{datasets}
\eof
\name{ex10.09}
\alias{ex10.09}
\docType{data}
\title{data from exercise 10.9}
\description{
The \code{ex10.09} data frame has 6 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Wheat}{
a numeric vector
}
\item{Barley}{
a numeric vector
}
\item{Maize}{
a numeric vector
}
\item{Oats}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.09)
}
\keyword{datasets}
\eof
\name{ex10.18}
\alias{ex10.18}
\docType{data}
\title{data from exercise 10.18}
\description{
The \code{ex10.18} data frame has 20 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{growth}{
a numeric vector
}
\item{hormone}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.18)
}
\keyword{datasets}
\eof
\name{ex10.22}
\alias{ex10.22}
\docType{data}
\title{data from exercise 10.22}
\description{
The \code{ex10.22} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{yield}{
a numeric vector
}
\item{EC}{
a numeric vector
}
\item{ECf}{
a factor with levels
\code{A} 
\code{B} 
\code{C} 
\code{D} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.22)
}
\keyword{datasets}
\eof
\name{ex10.26}
\alias{ex10.26}
\docType{data}
\title{data from exercise 10.26}
\description{
The \code{ex10.26} data frame has 26 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{PAPFUA}{
a numeric vector
}
\item{brand}{
a factor with levels
\code{BlueBonnet} 
\code{Chiffon} 
\code{Fleischman} 
\code{Imperial} 
\code{Mazola} 
\code{Parkay} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.26)
}
\keyword{datasets}
\eof
\name{ex10.27}
\alias{ex10.27}
\docType{data}
\title{data from exercise 10.27}
\description{
The \code{ex10.27} data frame has 24 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Folacin}{
a numeric vector
}
\item{Brand}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.27)
}
\keyword{datasets}
\eof
\name{ex10.32}
\alias{ex10.32}
\docType{data}
\title{data from exercise 10.32}
\description{
The \code{ex10.32} data frame has 5 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{A}{
a numeric vector
}
\item{B}{
a numeric vector
}
\item{C}{
a numeric vector
}
\item{D}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.32)
}
\keyword{datasets}
\eof
\name{ex10.36}
\alias{ex10.36}
\docType{data}
\title{data from exercise 10.36}
\description{
The \code{ex10.36} data frame has 4 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{L.D}{
a numeric vector
}
\item{R}{
a numeric vector
}
\item{R.L}{
a numeric vector
}
\item{C}{
a numeric vector
}
\item{C.L}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.36)
}
\keyword{datasets}
\eof
\name{ex10.37}
\alias{ex10.37}
\docType{data}
\title{data from exercise 10.37}
\description{
  Motor vibration for 5 different brands of motor bearing
}
\usage{data(ex10.37)}
\format{
  A data frame with 30 observations on the following 2 variables.
  \describe{
    \item{vibration}{a numeric vector}
    \item{Brand}{a factor with levels \code{1} \code{2} \code{3} \code{4} \code{5}}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Increasing Market Share Through Improved Product and Process Design:
  An Experimental Approach'', \emph{Quality Engineering}, 1991: 361-369.
}
\examples{
data(ex10.37)
}
\keyword{datasets}
\eof
\name{ex10.41}
\alias{ex10.41}
\docType{data}
\title{data from exercise 10.41}
\description{
The \code{ex10.41} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Percenta}{
a numeric vector
}
\item{Lab}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.41)
}
\keyword{datasets}
\eof
\name{ex10.42}
\alias{ex10.42}
\docType{data}
\title{data from exercise 10.42}
\usage{data(ex10.42)}
\description{
  The \code{ex10.42} data frame has 19 rows and 2 columns of critical
  flicker frequencies according to eye color.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{cff}{a numeric vector of critical flicker frequencies}
    \item{color}{eye color - a factor with levels \code{Blue},
      \code{Brown}, and \code{Green}}
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.42)
str(ex10.42)
boxplot(cff ~ color, ex10.42, horizontal = TRUE, las = 1,
  xlab = "Critical Flicker Frequency (Hz)")
fm1 <- aov(cff ~ color, data = ex10.42)
summary(fm1)
}
\keyword{datasets}
\eof
\name{ex10.44}
\alias{ex10.44}
\docType{data}
\title{data from exercise 10.44}
\description{
The \code{ex10.44} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Strength}{
a numeric vector
}
\item{Mortar}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex10.44)
}
\keyword{datasets}
\eof
\name{ex11.02}
\alias{ex11.02}
\docType{data}
\title{data from exercise 11.2}
\description{
The \code{ex11.02} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{corrosn}{
a numeric vector
}
\item{coating}{
a numeric vector
}
\item{SoilType}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.02)
}
\keyword{datasets}
\eof
\name{ex11.03}
\alias{ex11.03}
\docType{data}
\title{data from exercise 11.3}
\description{
The \code{ex11.03} data frame has 16 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{transfer}{
a numeric vector
}
\item{gas}{
a numeric vector
}
\item{liquid}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.03)
}
\keyword{datasets}
\eof
\name{ex11.04}
\alias{ex11.04}
\docType{data}
\title{data from exercise 11.4}
\description{
The \code{ex11.04} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Coverage}{
a numeric vector
}
\item{Roller}{
a numeric vector
}
\item{Paint}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.04)
}
\keyword{datasets}
\eof
\name{ex11.05}
\alias{ex11.05}
\docType{data}
\title{data from exercise 11.5}
\description{
The \code{ex11.05} data frame has 20 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{force}{
a numeric vector
}
\item{angle}{
a numeric vector
}
\item{connectr}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.05)
}
\keyword{datasets}
\eof
\name{ex11.08}
\alias{ex11.08}
\docType{data}
\title{data from exercise 11.8}
\description{
The \code{ex11.08} data frame has 30 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{epiniphr}{
a numeric vector
}
\item{Anesthet}{
a numeric vector
}
\item{Subject}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.08)
}
\keyword{datasets}
\eof
\name{ex11.09}
\alias{ex11.09}
\docType{data}
\title{data from exercise 11.9}
\description{
The \code{ex11.09} data frame has 36 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{effort}{
a numeric vector
}
\item{Type}{
a factor with levels
\code{T1} 
\code{T2} 
\code{T3} 
\code{T4} 
}
\item{Subject}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.09)
}
\keyword{datasets}
\eof
\name{ex11.10}
\alias{ex11.10}
\docType{data}
\title{data from exercise 11.10}
\description{
  Strength of concrete according to batch and test method
}
\usage{data(ex11.10)}
\format{
  A data frame with 30 observations on the following 3 variables.
  \describe{
    \item{strength}{a numeric vector of compressive strength (MPa)}
    \item{Method}{a factor with levels \code{A} \code{B} \code{C}}
    \item{Batch}{a factor with levels \code{1} \code{2} \code{3} \code{4} \code{5} \code{6} \code{7} \code{8} \code{9} \code{10}}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
%\references{}
\examples{
data(ex11.10)
xtabs(strength ~ Batch + Method, data = ex11.10)
}
\keyword{datasets}
\eof
\name{ex11.15}
\alias{ex11.15}
\docType{data}
\title{data from exercise 11.15}
\description{
The \code{ex11.15} data frame has 18 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sand}{
a numeric vector
}
\item{Carbon}{
a numeric vector
}
\item{Hardness}{
a numeric vector
}
\item{Strength}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.15)
}
\keyword{datasets}
\eof
\name{ex11.16}
\alias{ex11.16}
\docType{data}
\title{data from exercise 11.16}
\description{
The \code{ex11.16} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Response}{
a numeric vector
}
\item{Formulat}{
a numeric vector
}
\item{Speed}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.16)
}
\keyword{datasets}
\eof
\name{ex11.17}
\alias{ex11.17}
\docType{data}
\title{data from exercise 11.17}
\description{
The \code{ex11.17} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{acidity}{
a numeric vector
}
\item{Coal}{
a numeric vector
}
\item{NaOH}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.17)
}
\keyword{datasets}
\eof
\name{ex11.18}
\alias{ex11.18}
\docType{data}
\title{data from exercise 11.18}
\description{
The \code{ex11.18} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Yield}{
a numeric vector
}
\item{Speed}{
a numeric vector
}
\item{Formulation}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.18)
}
\keyword{datasets}
\eof
\name{ex11.20}
\alias{ex11.20}
\docType{data}
\title{data from exercise 11.20}
\description{
The \code{ex11.20} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{current}{
a numeric vector
}
\item{glass}{
a numeric vector
}
\item{phosphor}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.20)
}
\keyword{datasets}
\eof
\name{ex11.29}
\alias{ex11.29}
\docType{data}
\title{data from exercise 11.29}
\description{
The \code{ex11.29} data frame has 96 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{length}{
a numeric vector
}
\item{time}{
a numeric vector
}
\item{heat}{
a numeric vector
}
\item{machine}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.29)
}
\keyword{datasets}
\eof
\name{ex11.31}
\alias{ex11.31}
\docType{data}
\title{data from exercise 11.31}
\description{
The \code{ex11.31} data frame has 27 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Yield}{
a numeric vector
}
\item{time}{
a numeric vector
}
\item{tempture}{
a numeric vector
}
\item{pressure}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.31)
}
\keyword{datasets}
\eof
\name{ex11.34}
\alias{ex11.34}
\docType{data}
\title{data from exercise 11.34}
\description{
The \code{ex11.34} data frame has 36 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sales}{
a numeric vector
}
\item{store}{
a numeric vector
}
\item{week}{
a numeric vector
}
\item{shelf}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.34)
}
\keyword{datasets}
\eof
\name{ex11.35}
\alias{ex11.35}
\docType{data}
\title{data from exercise 11.35}
\description{
The \code{ex11.35} data frame has 25 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Moisture}{
a numeric vector
}
\item{plant}{
a numeric vector
}
\item{leafsize}{
a numeric vector
}
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.35)
}
\keyword{datasets}
\eof
\name{ex11.39}
\alias{ex11.39}
\docType{data}
\title{data from exercise 11.39}
\description{
The \code{ex11.39} data frame has 24 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{cleaning}{
a numeric vector
}
\item{detergnt}{
a numeric vector
}
\item{carbonat}{
a numeric vector
}
\item{cellulos}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.39)
}
\keyword{datasets}
\eof
\name{ex11.40}
\alias{ex11.40}
\docType{data}
\title{data from exercise 11.40}
\description{
The \code{ex11.40} data frame has 32 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{sizing}{
a numeric vector
}
\item{conc}{
a numeric vector
}
\item{pH}{
a numeric vector
}
\item{tempture}{
a numeric vector
}
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.40)
}
\keyword{datasets}
\eof
\name{ex11.42}
\alias{ex11.42}
\docType{data}
\title{data from exercise 11.42}
\description{
The \code{ex11.42} data frame has 48 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{consump}{
a numeric vector
}
\item{roof}{
a numeric vector
}
\item{power}{
a numeric vector
}
\item{scrap}{
a numeric vector
}
\item{charge}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.42)
}
\keyword{datasets}
\eof
\name{ex11.43}
\alias{ex11.43}
\docType{data}
\title{data from exercise 11.43}
\description{
The \code{ex11.43} data frame has 16 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{duration}{
a numeric vector
}
\item{vibratn}{
a numeric vector
}
\item{tempture}{
a numeric vector
}
\item{altitude}{
a numeric vector
}
\item{firing}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.43)
}
\keyword{datasets}
\eof
\name{ex11.48}
\alias{ex11.48}
\docType{data}
\title{data from exercise 11.48}
\description{
The \code{ex11.48} data frame has 8 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{thrust}{
a numeric vector
}
\item{vibratn}{
a numeric vector
}
\item{tempture}{
a numeric vector
}
\item{altitude}{
a numeric vector
}
\item{firing}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.48)
}
\keyword{datasets}
\eof
\name{ex11.50}
\alias{ex11.50}
\docType{data}
\title{data from exercise 11.50}
\description{
The \code{ex11.50} data frame has 45 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Smooth}{
a numeric vector
}
\item{Drying}{
a numeric vector
}
\item{Fabric}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.50)
}
\keyword{datasets}
\eof
\name{ex11.52}
\alias{ex11.52}
\docType{data}
\title{data from exercise 11.52}
\description{
The \code{ex11.52} data frame has 16 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{clover}{
a numeric vector
}
\item{plot}{
a numeric vector
}
\item{rate}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.52)
}
\keyword{datasets}
\eof
\name{ex11.53}
\alias{ex11.53}
\docType{data}
\title{data from exercise 11.53}
\description{
The \code{ex11.53} data frame has 8 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Run}{
a numeric vector
}
\item{Spray.Volume}{
a factor with levels
\code{+} 
\code{-} 
}
\item{Belt.Speed}{
a factor with levels
\code{+} 
\code{-} 
}
\item{Brand}{
a factor with levels
\code{+} 
\code{-} 
}
\item{Replication.1}{
a numeric vector
}
\item{Replication.2}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.53)
}
\keyword{datasets}
\eof
\name{ex11.54}
\alias{ex11.54}
\docType{data}
\title{data from exercise 11.54}
\description{
The \code{ex11.54} data frame has 8 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sample.number}{
a numeric vector
}
\item{Factor.A}{
a numeric vector
}
\item{Factor.B}{
a numeric vector
}
\item{Factor.C}{
a numeric vector
}
\item{Resonse.EC50}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.54)
}
\keyword{datasets}
\eof
\name{ex11.55}
\alias{ex11.55}
\docType{data}
\title{data from exercise 11.55}
\description{
The \code{ex11.55} data frame has 16 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Extraction}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.55)
}
\keyword{datasets}
\eof
\name{ex11.56}
\alias{ex11.56}
\docType{data}
\title{data from exercise 11.56}
\description{
The \code{ex11.56} data frame has 30 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Rating}{
a numeric vector
}
\item{pH}{
a factor with levels
\code{pH 3} 
\code{pH 5.5} 
\code{pH 7} 
}
\item{Health}{
a factor with levels
\code{Diseased} 
\code{Healthy} 
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.56)
}
\keyword{datasets}
\eof
\name{ex11.57}
\alias{ex11.57}
\docType{data}
\title{data from exercise 11.57}
\description{
The \code{ex11.57} data frame has 54 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{permeability}{
a numeric vector
}
\item{Pressure}{
a numeric vector
}
\item{Temp}{
a numeric vector
}
\item{Fabric}{
a factor with levels
\code{420-D} 
\code{630-D} 
\code{840-D} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.57)
}
\keyword{datasets}
\eof
\name{ex11.59}
\alias{ex11.59}
\docType{data}
\title{data from exercise 11.59}
\description{
The \code{ex11.59} data frame has 36 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Cure.Time.1}{
a numeric vector
}
\item{Adhesive.type}{
a factor with levels
\code{Copper} 
\code{Nickel} 
}
\item{Adhesive.factor}{
a numeric vector
}
\item{Cure.Time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.59)
}
\keyword{datasets}
\eof
\name{ex11.61}
\alias{ex11.61}
\docType{data}
\title{data from exercise 11.61}
\description{
The \code{ex11.61} data frame has 25 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{weight}{
a numeric vector
}
\item{volume}{
a numeric vector
}
\item{color}{
a numeric vector
}
\item{size}{
a numeric vector
}
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex11.61)
}
\keyword{datasets}
\eof
\name{ex12.01}
\alias{ex12.01}
\docType{data}
\title{data from exercise 12.1}
\description{
The \code{ex12.01} data frame has 24 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Temp}{
a numeric vector
}
\item{Ratio}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.01)
}
\keyword{datasets}
\eof
\name{ex12.02}
\alias{ex12.02}
\docType{data}
\title{data from exercise 12.2}
\description{
The \code{ex12.02} data frame has 10 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Engine}{
a numeric vector
}
\item{Age}{
a numeric vector
}
\item{Baseline}{
a numeric vector
}
\item{Reformulated}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.02)
}
\keyword{datasets}
\eof
\name{ex12.03}
\alias{ex12.03}
\docType{data}
\title{data from exercise 12.3}
\description{
The \code{ex12.03} data frame has 20 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.03)
}
\keyword{datasets}
\eof
\name{ex12.04}
\alias{ex12.04}
\docType{data}
\title{data from exercise 12.4}
\description{
The \code{ex12.04} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.04)
}
\keyword{datasets}
\eof
\name{ex12.05}
\alias{ex12.05}
\docType{data}
\title{data from exercise 12.5}
\description{
The \code{ex12.05} data frame has 7 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.05)
}
\keyword{datasets}
\eof
\name{ex12.13}
\alias{ex12.13}
\docType{data}
\title{data from exercise 12.13}
\description{
  Rate of deposition versus current density
}
\usage{data(ex12.13)}
\format{
  A data frame with 4 observations on the following 2 variables.
  \describe{
    \item{x}{a numeric vector of current densities (mA/cm-sq)}
    \item{y}{a numeric vector of deposition rates (micrometers/min)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Plating of 60/40 Tin/Lead Solder for Head Termination Metallurgy'',
  \emph{Plating and Surface Finishing}, Jan. 1997: 38--40
}
\examples{
data(ex12.13)
}
\keyword{datasets}
\eof
\name{ex12.15}
\alias{ex12.15}
\docType{data}
\title{data from exercise 12.15}
\description{
The \code{ex12.15} data frame has 27 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{MoE}{
a numeric vector
}
\item{Strength}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.15)
}
\keyword{datasets}
\eof
\name{ex12.16}
\alias{ex12.16}
\docType{data}
\title{data from exercise 12.16}
\description{
The \code{ex12.16} data frame has 15 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.16)
}
\keyword{datasets}
\eof
\name{ex12.19}
\alias{ex12.19}
\docType{data}
\title{data from exercise 12.19}
\description{
The \code{ex12.19} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{area}{
a numeric vector
}
\item{emission}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.19)
}
\keyword{datasets}
\eof
\name{ex12.20}
\alias{ex12.20}
\docType{data}
\title{data from exercise 12.20}
\description{
The \code{ex12.20} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{deposition}{
a numeric vector
}
\item{LichenN}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.20)
}
\keyword{datasets}
\eof
\name{ex12.21}
\alias{ex12.21}
\docType{data}
\title{data from exercise 12.21}
\description{
The \code{ex12.21} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{space}{
a numeric vector
}
\item{distance}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.21)
}
\keyword{datasets}
\eof
\name{ex12.24}
\alias{ex12.24}
\docType{data}
\title{data from exercise 12.24}
\description{
The \code{ex12.24} data frame has 6 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{SO.2dep.}{
a numeric vector
}
\item{Wt.loss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.24)
}
\keyword{datasets}
\eof
\name{ex12.29}
\alias{ex12.29}
\docType{data}
\title{data from exercise 12.29}
\description{
The \code{ex12.29} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
\item{Data.Set}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.29)
}
\keyword{datasets}
\eof
\name{ex12.36}
\alias{ex12.36}
\docType{data}
\title{data from exercise 12.36}
\description{
  Mist generation versus fluid flow from metal removal fluids
}
\usage{data(ex12.36)}
\format{
  A data frame with 7 observations on the following 2 variables.
  \describe{
    \item{x}{a numeric vector of fluid flow velocities for a 5\% soluble
    oil (cm/sec)}
    \item{y}{a numeric vector of the extent of mist droplets having a
      diameter less than 10 micrometers (mg/m-sq)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury

}
\references{
  ``Variables Affecting Mist Generation from Metal Removing Fluids'',
  \emph{Lubrication Engr.}, 2002: 10--17.
}
\examples{
data(ex12.36)
}
\keyword{datasets}
\eof
\name{ex12.37}
\alias{ex12.37}
\docType{data}
\title{data from exercise 12.37}
\description{
The \code{ex12.37} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{pressure}{
a numeric vector
}
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.37)
}
\keyword{datasets}
\eof
\name{ex12.46}
\alias{ex12.46}
\docType{data}
\title{data from exercise 12.46}
\description{
The \code{ex12.46} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.46)
}
\keyword{datasets}
\eof
\name{ex12.50}
\alias{ex12.50}
\docType{data}
\title{data from exercise 12.50}
\description{
  Relaxation time in crystals as a function of the strength of the
  external biasing magnetic field.
}
\format{
  This data frame contains 11 observations on the following variables:
  \describe{
    \item{field}{
      a numeric vector of the strength of the magnetic field (KG)
    }
    \item{time}{
      a numeric vector of the relaxation time (microseconds)
    }
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury}
\references{
  ``An Optical Faraday Rotation Technique for the Determination of
  Magnetic Relaxation Times'', \emph{IEEE Trans. Magnetics}, June 1968:
  175--178.
}
\examples{
data(ex12.50)
}
\keyword{datasets}
\eof
\name{ex12.52}
\alias{ex12.52}
\docType{data}
\title{data from exercise 12.52}
\description{
The \code{ex12.52} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.52)
}
\keyword{datasets}
\eof
\name{ex12.54}
\alias{ex12.54}
\docType{data}
\title{data from exercise 12.54}
\description{
The \code{ex12.54} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{distance}{
a numeric vector
}
\item{yield}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.54)
}
\keyword{datasets}
\eof
\name{ex12.55}
\alias{ex12.55}
\docType{data}
\title{data from exercise 12.55}
\description{
The \code{ex12.55} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{age}{
a numeric vector
}
\item{damaged}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.55)
}
\keyword{datasets}
\eof
\name{ex12.58}
\alias{ex12.58}
\docType{data}
\title{data from exercise 12.58}
\description{
The \code{ex12.58} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{TOST}{
a numeric vector
}
\item{RBOT}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.58)
}
\keyword{datasets}
\eof
\name{ex12.59}
\alias{ex12.59}
\docType{data}
\title{data from exercise 12.59}
\description{
The \code{ex12.59} data frame has 18 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.59)
}
\keyword{datasets}
\eof
\name{ex12.61}
\alias{ex12.61}
\docType{data}
\title{data from exercise 12.61}
\description{
  Muscular endurance as a function of maximal lactate level.
}
\usage{data(ex12.61)}
\format{
  A data frame with 14 observations on the following 2 variables.
  \describe{
    \item{x}{a numeric vector of maximal lactate level}
    \item{y}{a numeric vector of muscular endurance}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Objective Effects of a Six Months' Endurance and Strength Training
  Program in Outpatients with Congestive Heart Failure'', \emph{Medicine
    and Science in Sports and Exercise}, 1999: 1102--1107.
}
\examples{
data(ex12.61)
}
\keyword{datasets}
\eof
\name{ex12.62}
\alias{ex12.62}
\docType{data}
\title{data from exercise 12.62}
\description{
The \code{ex12.62} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.62)
}
\keyword{datasets}
\eof
\name{ex12.63}
\alias{ex12.63}
\docType{data}
\title{data from exercise 12.63}
\description{
The \code{ex12.63} data frame has 6 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{stiffnss}{
a numeric vector
}
\item{thicknss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.63)
}
\keyword{datasets}
\eof
\name{ex12.65}
\alias{ex12.65}
\docType{data}
\title{data from exercise 12.65}
\description{
The \code{ex12.65} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{blood}{
a numeric vector
}
\item{gasoline}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.65)
}
\keyword{datasets}
\eof
\name{ex12.68}
\alias{ex12.68}
\docType{data}
\title{data from exercise 12.68}
\description{
The \code{ex12.68} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{RDF}{
a numeric vector
}
\item{eff}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.68)
}
\keyword{datasets}
\eof
\name{ex12.69}
\alias{ex12.69}
\docType{data}
\title{data from exercise 12.69}
\description{
The \code{ex12.69} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{drain.wt}{
a numeric vector
}
\item{Cl.trace}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.69)
}
\keyword{datasets}
\eof
\name{ex12.71}
\alias{ex12.71}
\docType{data}
\title{data from exercise 12.71}
\description{
The \code{ex12.71} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{austenite}{
a numeric vector
}
\item{wearLoss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.71)
}
\keyword{datasets}
\eof
\name{ex12.72}
\alias{ex12.72}
\docType{data}
\title{data from exercise 12.72}
\description{
The \code{ex12.72} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{CO}{
a numeric vector
}
\item{Noy}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.72)
}
\keyword{datasets}
\eof
\name{ex12.73}
\alias{ex12.73}
\docType{data}
\title{data from exercise 12.73}
\description{
The \code{ex12.73} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{age}{
a numeric vector
}
\item{load}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.73)
}
\keyword{datasets}
\eof
\name{ex12.75}
\alias{ex12.75}
\docType{data}
\title{data from exercise 12.75}
\description{
The \code{ex12.75} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{absorb}{
a numeric vector
}
\item{peakVolt}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex12.75)
}
\keyword{datasets}
\eof
\name{ex12.82}
\alias{ex12.82}
\docType{data}
\title{data from exercise 12.82}
\description{
  Percentage removal of contaminants versus inlet temperature.
}
\usage{data(ex12.82)}
\format{
  A data frame with 33 observations on the following 2 variables.
  \describe{
    \item{temp}{a numeric vector of inlet temperatures}
    \item{removal}{a numeric vector of removal percentages}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Treatment of Mixed Hydrogen Sulfide and Organic Vapors in Rock
  Medium Biofilter'', \emph{Water Environment Research}, 2001: 426-435.
}
\examples{
data(ex12.82)
}
\keyword{datasets}
\eof
\name{ex12.83}
\alias{ex12.83}
\docType{data}
\title{data from exercise 12.83}
\description{
  Blood glucose level in fish versus time since stress applied.
}
\usage{data(ex12.83)}
\format{
  A data frame with 24 observations on the following 2 variables.
  \describe{
    \item{time}{a numeric vector of the time since stress was applied}
    \item{bloodgluc}{a numeric vector of blood glucose levels}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Evaluation of Simple Instruments for the Measurement of Blood
  Glucose and Lactate, and Plasma Protein as Stress Indicators in
  Fish'', \emph{J. of the World Aquaculture Society}, 1999: 276--284.
}
\examples{
data(ex12.83)
}
\keyword{datasets}
\eof
\name{ex12.84}
\alias{ex12.84}
\docType{data}
\title{data from exercise 12.84}
\description{
  Air displacement versus hydrostatic weighing for measuring body fat
}
\usage{data(ex12.84)}
\format{
  A data frame with 20 observations on the following 2 variables.
  \describe{
    \item{HW}{a numeric vector of results from hydrostatic weighing}
    \item{BOD}{a numeric vector of results from an air displacement device}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Evaluating the BOD POD for Assessing Body Fat in Collegiate Football
  Players'', \emph{Medicine and Science in Sports and Exercise}, 1999:
  1350--1356.
}
\examples{
data(ex12.84)
}
\keyword{datasets}
\eof
\name{ex13.02}
\alias{ex13.02}
\docType{data}
\title{data from exercise 13.2}
\description{
The \code{ex13.02} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{rate}{
a numeric vector
}
\item{stdResid}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.02)
}
\keyword{datasets}
\eof
\name{ex13.04}
\alias{ex13.04}
\docType{data}
\title{data from exercise 13.4}
\description{
The \code{ex13.04} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{thicknss}{
a numeric vector
}
\item{current}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.04)
}
\keyword{datasets}
\eof
\name{ex13.05}
\alias{ex13.05}
\docType{data}
\title{data from exercise 13.5}
\description{
  Ice thickness versus elapsed time
}
\usage{data(ex13.05)}
\format{
  A data frame with 33 observations on the following 2 variables.
  \describe{
    \item{time}{a numeric vector of elapsed time (hr)}
    \item{icethick}{a numeric vector of ice thickness (mm)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury} 
\references{
  ``Laborator Study of Anchor Ice Growth'', \emph{J. of Cold Regions
    Engr.}, 2001: 60-66.
}
\examples{
data(ex13.05)
}
\keyword{datasets}
\eof
\name{ex13.06}
\alias{ex13.06}
\docType{data}
\title{data from exercise 13.6}
\description{
The \code{ex13.06} data frame has 6 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{density}{
a numeric vector
}
\item{moisture}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.06)
}
\keyword{datasets}
\eof
\name{ex13.07}
\alias{ex13.07}
\docType{data}
\title{data from exercise 13.7}
\description{
The \code{ex13.07} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{exposure}{
a numeric vector
}
\item{weight}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.07)
}
\keyword{datasets}
\eof
\name{ex13.08}
\alias{ex13.08}
\docType{data}
\title{data from exercise 13.8}
\description{
  Relationship between heart rate and oxygen uptake during exercise
}
\usage{data(ex13.08)}
\format{
  A data frame with 15 observations on the following 2 variables.
  \describe{
    \item{HR}{a numeric vector of heart rates (as a percentage of maximum
    rate)}
    \item{VO2}{a numeric vector of oxygen uptake (as a percentage of
      maximum uptake)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``The Relationship between Heart Rate and Oxygen Uptake During
  Non-Steady State Exercise'', \emph{Ergonomics}, 2000: 1578-1592.
}
\examples{
data(ex13.08)
}
\keyword{datasets}
\eof
\name{ex13.09}
\alias{ex13.09}
\docType{data}
\title{data from exercise 13.9}
\description{
The \code{ex13.09} data frame has 44 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
\item{set}{
a factor with levels
\code{a} 
\code{b} 
\code{c} 
\code{d} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.09)
}
\keyword{datasets}
\eof
\name{ex13.14}
\alias{ex13.14}
\docType{data}
\title{data from exercise 13.14}
\description{
The \code{ex13.14} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{weight}{
a numeric vector
}
\item{clearnce}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.14)
}
\keyword{datasets}
\eof
\name{ex13.15}
\alias{ex13.15}
\docType{data}
\title{data from exercise 13.15}
\description{
The \code{ex13.15} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.15)
}
\keyword{datasets}
\eof
\name{ex13.16}
\alias{ex13.16}
\docType{data}
\title{data from exercise 13.16}
\description{
The \code{ex13.16} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Spectral}{
a numeric vector
}
\item{ln.L178.}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.16)
}
\keyword{datasets}
\eof
\name{ex13.17}
\alias{ex13.17}
\docType{data}
\title{data from exercise 13.17}
\description{
The \code{ex13.17} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{MassRate}{
a numeric vector
}
\item{FlameLen}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.17)
}
\keyword{datasets}
\eof
\name{ex13.18}
\alias{ex13.18}
\docType{data}
\title{data from exercise 13.18}
\description{
The \code{ex13.18} data frame has 4 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Conc.}{
a numeric vector
}
\item{pH}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.18)
}
\keyword{datasets}
\eof
\name{ex13.19}
\alias{ex13.19}
\docType{data}
\title{data from exercise 13.19}
\description{
The \code{ex13.19} data frame has 18 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Temp}{
a numeric vector
}
\item{Lifetime}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.19)
}
\keyword{datasets}
\eof
\name{ex13.21}
\alias{ex13.21}
\docType{data}
\title{data from exercise 13.21}
\description{
The \code{ex13.21} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{thicknss}{
a numeric vector
}
\item{conduct}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.21)
}
\keyword{datasets}
\eof
\name{ex13.24}
\alias{ex13.24}
\docType{data}
\title{data from exercise 13.24}
\description{
The \code{ex13.24} data frame has 40 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{age}{
a numeric vector
}
\item{Kyphosis}{
a factor with levels
\code{N} 
\code{Y} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.24)
}
\keyword{datasets}
\eof
\name{ex13.25}
\alias{ex13.25}
\docType{data}
\title{data from exercise 13.25}
\description{
The \code{ex13.25} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Success}{
a numeric vector
}
\item{Failure}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.25)
}
\keyword{datasets}
\eof
\name{ex13.27}
\alias{ex13.27}
\docType{data}
\title{data from exercise 13.27}
\description{
The \code{ex13.27} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{time}{
a numeric vector
}
\item{conc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.27)
}
\keyword{datasets}
\eof
\name{ex13.29}
\alias{ex13.29}
\docType{data}
\title{data from exercise 13.29}
\description{
The \code{ex13.29} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.29)
}
\keyword{datasets}
\eof
\name{ex13.30}
\alias{ex13.30}
\docType{data}
\title{data from exercise 13.30}
\description{
The \code{ex13.30} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{water}{
a numeric vector
}
\item{yield}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.30)
}
\keyword{datasets}
\eof
\name{ex13.31}
\alias{ex13.31}
\docType{data}
\title{data from exercise 13.31}
\description{
The \code{ex13.31} data frame has 7 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{velocity}{
a numeric vector
}
\item{conversn}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.31)
}
\keyword{datasets}
\eof
\name{ex13.32}
\alias{ex13.32}
\docType{data}
\title{data from exercise 13.32}
\description{
The \code{ex13.32} data frame has 16 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{soil.Ph}{
a numeric vector
}
\item{conc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.32)
}
\keyword{datasets}
\eof
\name{ex13.33}
\alias{ex13.33}
\docType{data}
\title{data from exercise 13.33}
\description{
The \code{ex13.33} data frame has 7 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{angle}{
a numeric vector
}
\item{efficncy}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.33)
}
\keyword{datasets}
\eof
\name{ex13.34}
\alias{ex13.34}
\docType{data}
\title{data from exercise 13.34}
\description{
The \code{ex13.34} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{cations}{
a numeric vector
}
\item{exchange}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.34)
}
\keyword{datasets}
\eof
\name{ex13.35}
\alias{ex13.35}
\docType{data}
\title{data from exercise 13.35}
\description{
The \code{ex13.35} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{tempture}{
a numeric vector
}
\item{rate}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.35)
}
\keyword{datasets}
\eof
\name{ex13.47}
\alias{ex13.47}
\docType{data}
\title{data from exercise 13.47}
\description{
The \code{ex13.47} data frame has 30 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Row}{
a numeric vector
}
\item{Plastics}{
a numeric vector
}
\item{Paper}{
a numeric vector
}
\item{Garbage}{
a numeric vector
}
\item{Water}{
a numeric vector
}
\item{Energy.content}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.47)
}
\keyword{datasets}
\eof
\name{ex13.48}
\alias{ex13.48}
\docType{data}
\title{data from exercise 13.48}
\description{
The \code{ex13.48} data frame has 15 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x1}{
a numeric vector
}
\item{x2}{
a numeric vector
}
\item{x3}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.48)
}
\keyword{datasets}
\eof
\name{ex13.49}
\alias{ex13.49}
\docType{data}
\title{data from exercise 13.49}
\description{
The \code{ex13.49} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{yield}{
a numeric vector
}
\item{temp}{
a numeric vector
}
\item{sunshine}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.49)
}
\keyword{datasets}
\eof
\name{ex13.51}
\alias{ex13.51}
\docType{data}
\title{data from exercise 13.51}
\description{
The \code{ex13.51} data frame has 14 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{shear}{
a numeric vector
}
\item{depth}{
a numeric vector
}
\item{water}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.51)
}
\keyword{datasets}
\eof
\name{ex13.52}
\alias{ex13.52}
\docType{data}
\title{data from exercise 13.52}
\description{
  Production of beta-carotene according to amounts of lineolic acid,
  kerosene, and antioxidant.
}
\usage{data(ex13.52)}
\format{
  A data frame with 20 observations on the following 4 variables.
  \describe{
    \item{Linoleic}{a numeric vector}
    \item{Kerosene}{a numeric vector}
    \item{Antiox}{a numeric vector}
    \item{Betacaro}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``Optimization of the Production of beta-Carotene from Molasses by
  Blakeslea Trispora'', \emph{J. of Chemical Technology and
    Biotechnology}, 2002: 933-943.
}
\examples{
data(ex13.52)
}
\keyword{datasets}
\eof
\name{ex13.53}
\alias{ex13.53}
\docType{data}
\title{data from exercise 13.53}
\description{
  Deposition of atmospheric pollutants in snowpacks.
}
\usage{data(ex13.53)}
\format{
  A data frame with 17 observations on the following 3 variables.
  \describe{
    \item{x1}{a numeric vector of a derived predictor variable}
    \item{x2}{a numeric vector of a second derived predictor variable}
    \item{filth}{a numeric vector of the amount of deposition over a
      specified time period}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
} 
\references{
  ``Atmospheric PAH Deposition: Deposition Velocities and Washout
  Ratios'', \emph{J. of Environmental Engineering}, 2002: 186-195.
}
\examples{
data(ex13.53)
}
\keyword{datasets}
\eof
\name{ex13.54}
\alias{ex13.54}
\docType{data}
\title{data from exercise 13.54}
\description{
The \code{ex13.54} data frame has 31 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Bright}{
a numeric vector
}
\item{H2O2}{
a numeric vector
}
\item{NaOH}{
a numeric vector
}
\item{Silicate}{
a numeric vector
}
\item{Tempture}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.54)
}
\keyword{datasets}
\eof
\name{ex13.55}
\alias{ex13.55}
\docType{data}
\title{data from exercise 13.55}
\description{
The \code{ex13.55} data frame has 10 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{q}{
a numeric vector
}
\item{a}{
a numeric vector
}
\item{b}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.55)
}
\keyword{datasets}
\eof
\name{ex13.68}
\alias{ex13.68}
\docType{data}
\title{data from exercise 13.68}
\description{
The \code{ex13.68} data frame has 16 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Log.edges.}{
a numeric vector
}
\item{Log.time.}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.68)
}
\keyword{datasets}
\eof
\name{ex13.69}
\alias{ex13.69}
\docType{data}
\title{data from exercise 13.69}
\description{
The \code{ex13.69} data frame has 18 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Pressure}{
a numeric vector
}
\item{Temperature}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.69)
}
\keyword{datasets}
\eof
\name{ex13.70}
\alias{ex13.70}
\docType{data}
\title{data from exercise 13.70}
\description{
The \code{ex13.70} data frame has 9 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x1}{
a numeric vector
}
\item{x2}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.70)
}
\keyword{datasets}
\eof
\name{ex13.71}
\alias{ex13.71}
\docType{data}
\title{data from exercise 13.71}
\description{
The \code{ex13.71} data frame has 32 rows and 7 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Obs}{
a numeric vector
}
\item{pdconc}{
a numeric vector
}
\item{niconc}{
a numeric vector
}
\item{pH}{
a numeric vector
}
\item{temp}{
a numeric vector
}
\item{currdens}{
a numeric vector
}
\item{pallcont}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.71)
}
\keyword{datasets}
\eof
\name{ex13.73}
\alias{ex13.73}
\docType{data}
\title{data from exercise 13.73}
\description{
The \code{ex13.73} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{power}{
a numeric vector
}
\item{freq}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.73)
}
\keyword{datasets}
\eof
\name{ex13.74}
\alias{ex13.74}
\docType{data}
\title{data from exercise 13.74}
\description{
The \code{ex13.74} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{log.con.}{
a numeric vector
}
\item{Li2O}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.74)
}
\keyword{datasets}
\eof
\name{ex13.75}
\alias{ex13.75}
\docType{data}
\title{data from exercise 13.75}
\description{
The \code{ex13.75} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{height}{
a numeric vector
}
\item{log.Mn.}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.75)
}
\keyword{datasets}
\eof
\name{ex13.76}
\alias{ex13.76}
\docType{data}
\title{data from exercise 13.76}
\description{
The \code{ex13.76} data frame has 9 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x1}{
a numeric vector
}
\item{x2}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex13.76)
}
\keyword{datasets}
\eof
\name{ex14.09}
\alias{ex14.09}
\docType{data}
\title{data from exercise 14.9}
\description{
The \code{ex14.09} data frame has 40 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.09)
}
\keyword{datasets}
\eof
\name{ex14.11}
\alias{ex14.11}
\docType{data}
\title{data from exercise 14.11}
\description{
The \code{ex14.11} data frame has 45 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{diam}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.11)
}
\keyword{datasets}
\eof
\name{ex14.12}
\alias{ex14.12}
\docType{data}
\title{data from exercise 14.12}
\description{
The \code{ex14.12} data frame has 4 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{male.children}{
a numeric vector
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.12)
}
\keyword{datasets}
\eof
\name{ex14.13}
\alias{ex14.13}
\docType{data}
\title{data from exercise 14.13}
\description{
The \code{ex14.13} data frame has 3 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{ovaries.developed}{
a numeric vector
}
\item{Observed.count}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.13)
}
\keyword{datasets}
\eof
\name{ex14.14}
\alias{ex14.14}
\docType{data}
\title{data from exercise 14.14}
\description{
The \code{ex14.14} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{observed}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.14)
}
\keyword{datasets}
\eof
\name{ex14.15}
\alias{ex14.15}
\docType{data}
\title{data from exercise 14.15}
\description{
The \code{ex14.15} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number.defective}{
a numeric vector
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.15)
}
\keyword{datasets}
\eof
\name{ex14.16}
\alias{ex14.16}
\docType{data}
\title{data from exercise 14.16}
\description{
The \code{ex14.16} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Number.exchanges}{
a numeric vector
}
\item{Observed.counts}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.16)
}
\keyword{datasets}
\eof
\name{ex14.17}
\alias{ex14.17}
\docType{data}
\title{data from exercise 14.17}
\description{
The \code{ex14.17} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{borers}{
a numeric vector
}
\item{freq}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.17)
}
\keyword{datasets}
\eof
\name{ex14.18}
\alias{ex14.18}
\docType{data}
\title{data from exercise 14.18}
\description{
The \code{ex14.18} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Rate}{
a factor with levels
\code{.100-below .150} 
\code{.150-below .200} 
\code{.200-below .250} 
\code{.250 or more} 
\code{Below .100} 
}
\item{Frequency}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.18)
}
\keyword{datasets}
\eof
\name{ex14.20}
\alias{ex14.20}
\docType{data}
\title{data from exercise 14.20}
\description{
The \code{ex14.20} data frame has 23 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.20)
}
\keyword{datasets}
\eof
\name{ex14.21}
\alias{ex14.21}
\docType{data}
\title{data from exercise 14.21}
\description{
The \code{ex14.21} data frame has 24 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.21)
}
\keyword{datasets}
\eof
\name{ex14.22}
\alias{ex14.22}
\docType{data}
\title{data from exercise 14.22}
\description{
The \code{ex14.22} data frame has 25 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{toughnss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.22)
}
\keyword{datasets}
\eof
\name{ex14.23}
\alias{ex14.23}
\docType{data}
\title{data from exercise 14.23}
\description{
The \code{ex14.23} data frame has 30 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Strength}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.23)
}
\keyword{datasets}
\eof
\name{ex14.26}
\alias{ex14.26}
\docType{data}
\title{data from exercise 14.26}
\description{
The \code{ex14.26} data frame has 5 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Treatment}{
a factor with levels
\code{Control} 
\code{Eight leaves removed} 
\code{Four leaves removed} 
\code{Six leaves removed} 
\code{Two leaves removed} 
}
\item{Matured}{
a numeric vector
}
\item{Aborted}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.26)
}
\keyword{datasets}
\eof
\name{ex14.27}
\alias{ex14.27}
\docType{data}
\title{data from exercise 14.27}
\description{
The \code{ex14.27} data frame has 2 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a factor with levels
\code{Men} 
\code{Women} 
}
\item{L.R}{
a numeric vector
}
\item{L.R.1}{
a numeric vector
}
\item{L.R.2}{
a numeric vector
}
\item{Sample.size}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.27)
}
\keyword{datasets}
\eof
\name{ex14.28}
\alias{ex14.28}
\docType{data}
\title{data from exercise 14.28}
\description{
The \code{ex14.28} data frame has 4 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Thienyla}{
a numeric vector
}
\item{Solvent}{
a numeric vector
}
\item{Sham}{
a numeric vector
}
\item{Unhandle}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.28)
}
\keyword{datasets}
\eof
\name{ex14.29}
\alias{ex14.29}
\docType{data}
\title{data from exercise 14.29}
\description{
The \code{ex14.29} data frame has 6 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{M.M}{
a numeric vector
}
\item{M.F}{
a numeric vector
}
\item{F.F}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.29)
}
\keyword{datasets}
\eof
\name{ex14.30}
\alias{ex14.30}
\docType{data}
\title{data from exercise 14.30}
\description{
The \code{ex14.30} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{count}{
a numeric vector
}
\item{Config}{
a numeric vector
}
\item{Mode}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.30)
}
\keyword{datasets}
\eof
\name{ex14.31}
\alias{ex14.31}
\docType{data}
\title{data from exercise 14.31}
\description{
The \code{ex14.31} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{count}{
a numeric vector
}
\item{Size}{
a factor with levels
\code{Compact} 
\code{Fullsize} 
\code{Midsize} 
\code{Subcompact} 
}
\item{dist}{
a factor with levels
\code{0-<10} 
\code{10-<20} 
\code{>=20} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.31)
}
\keyword{datasets}
\eof
\name{ex14.32}
\alias{ex14.32}
\docType{data}
\title{data from exercise 14.32}
\description{
The \code{ex14.32} data frame has 3 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Liberal}{
a numeric vector
}
\item{Consrvtv}{
a numeric vector
}
\item{Other}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.32)
}
\keyword{datasets}
\eof
\name{ex14.38}
\alias{ex14.38}
\docType{data}
\title{data from exercise 14.38}
\description{
The \code{ex14.38} data frame has 3 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Parsitiz}{
a numeric vector
}
\item{Nonparas}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.38)
}
\keyword{datasets}
\eof
\name{ex14.40}
\alias{ex14.40}
\docType{data}
\title{data from exercise 14.40}
\description{
The \code{ex14.40} data frame has 4 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sport}{
a factor with levels
\code{Baseball} 
\code{Basketball} 
\code{Football} 
\code{Hockey} 
}
\item{Leader.Wins}{
a numeric vector
}
\item{Leader.Loses}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.40)
}
\keyword{datasets}
\eof
\name{ex14.41}
\alias{ex14.41}
\docType{data}
\title{data from exercise 14.41}
\description{
The \code{ex14.41} data frame has 3 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Never}{
a numeric vector
}
\item{Occasion}{
a numeric vector
}
\item{Regular}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.41)
}
\keyword{datasets}
\eof
\name{ex14.42}
\alias{ex14.42}
\docType{data}
\title{data from exercise 14.42}
\description{
The \code{ex14.42} data frame has 4 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Home}{
a numeric vector
}
\item{Acute}{
a numeric vector
}
\item{Chronic}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.42)
}
\keyword{datasets}
\eof
\name{ex14.44}
\alias{ex14.44}
\docType{data}
\title{data from exercise 14.44}
\description{
The \code{ex14.44} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{sample}{
a numeric vector
}
\item{item.prc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex14.44)
}
\keyword{datasets}
\eof
\name{ex15.01}
\alias{ex15.01}
\docType{data}
\title{data from exercise 15.1}
\description{
The \code{ex15.01} data frame has 12 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.01)
}
\keyword{datasets}
\eof
\name{ex15.03}
\alias{ex15.03}
\docType{data}
\title{data from exercise 15.3}
\description{
The \code{ex15.03} data frame has 14 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{pH}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.03)
}
\keyword{datasets}
\eof
\name{ex15.04}
\alias{ex15.04}
\docType{data}
\title{data from exercise 15.4}
\description{
The \code{ex15.04} data frame has 15 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.04)
}
\keyword{datasets}
\eof
\name{ex15.05}
\alias{ex15.05}
\docType{data}
\title{data from exercise 15.5}
\description{
The \code{ex15.05} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sample}{
a numeric vector
}
\item{Gravimetric}{
a numeric vector
}
\item{Spectrophotometric}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.05)
}
\keyword{datasets}
\eof
\name{ex15.08}
\alias{ex15.08}
\docType{data}
\title{data from exercise 15.8}
\description{
The \code{ex15.08} data frame has 25 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{toughnss}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.08)
}
\keyword{datasets}
\eof
\name{ex15.10}
\alias{ex15.10}
\docType{data}
\title{data from exercise 15.10}
\description{
The \code{ex15.10} data frame has 5 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{adhesv.1}{
a numeric vector
}
\item{adhesv.2}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.10)
}
\keyword{datasets}
\eof
\name{ex15.11}
\alias{ex15.11}
\docType{data}
\title{data from exercise 15.11}
\description{
The \code{ex15.11} data frame has 14 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Time}{
a numeric vector
}
\item{wood}{
a factor with levels
\code{Oak} 
\code{Pine} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.11)
}
\keyword{datasets}
\eof
\name{ex15.12}
\alias{ex15.12}
\docType{data}
\title{data from exercise 15.12}
\description{
The \code{ex15.12} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Original}{
a numeric vector
}
\item{Modified}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.12)
}
\keyword{datasets}
\eof
\name{ex15.13}
\alias{ex15.13}
\docType{data}
\title{data from exercise 15.13}
\description{
The \code{ex15.13} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Orange.J}{
a numeric vector
}
\item{Ascorbic}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.13)
}
\keyword{datasets}
\eof
\name{ex15.14}
\alias{ex15.14}
\docType{data}
\title{data from exercise 15.14}
\description{
The \code{ex15.14} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Orange.J}{
a numeric vector
}
\item{Ascorbic}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.14)
}
\keyword{datasets}
\eof
\name{ex15.15}
\alias{ex15.15}
\docType{data}
\title{data from exercise 15.15}
\description{
The \code{ex15.15} data frame has 15 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{conc}{
a numeric vector
}
\item{exposed}{
a factor with levels
\code{N} 
\code{Y} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.15)
}
\keyword{datasets}
\eof
\name{ex15.23}
\alias{ex15.23}
\docType{data}
\title{data from exercise 15.23}
\description{
The \code{ex15.23} data frame has 5 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Region.1}{
a numeric vector
}
\item{Region.2}{
a numeric vector
}
\item{Region.3}{
a numeric vector
}
\item{Region.4}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.23)
}
\keyword{datasets}
\eof
\name{ex15.24}
\alias{ex15.24}
\docType{data}
\title{data from exercise 15.24}
\description{
The \code{ex15.24} data frame has 9 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{fasting}{
a numeric vector
}
\item{pct23}{
a numeric vector
}
\item{pct32}{
a numeric vector
}
\item{pct67}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.24)
}
\keyword{datasets}
\eof
\name{ex15.25}
\alias{ex15.25}
\docType{data}
\title{data from exercise 15.25}
\description{
The \code{ex15.25} data frame has 22 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{cortisol}{
a numeric vector
}
\item{Group}{
a factor with levels
\code{A} 
\code{B} 
\code{C} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.25)
}
\keyword{datasets}
\eof
\name{ex15.26}
\alias{ex15.26}
\docType{data}
\title{data from exercise 15.26}
\description{
The \code{ex15.26} data frame has 10 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Blocks}{
a numeric vector
}
\item{A}{
a numeric vector
}
\item{B}{
a numeric vector
}
\item{C}{
a numeric vector
}
\item{D}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.26)
}
\keyword{datasets}
\eof
\name{ex15.27}
\alias{ex15.27}
\docType{data}
\title{data from exercise 15.27}
\description{
The \code{ex15.27} data frame has 10 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Dog}{
a numeric vector
}
\item{Isoflurane}{
a numeric vector
}
\item{Halothane}{
a numeric vector
}
\item{Cyclopropane}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.27)
}
\keyword{datasets}
\eof
\name{ex15.28}
\alias{ex15.28}
\docType{data}
\title{data from exercise 15.28}
\description{
The \code{ex15.28} data frame has 8 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Subject}{
a numeric vector
}
\item{Potato}{
a numeric vector
}
\item{Rice}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.28)
}
\keyword{datasets}
\eof
\name{ex15.29}
\alias{ex15.29}
\docType{data}
\title{data from exercise 15.29}
\description{
The \code{ex15.29} data frame has 9 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{X1973}{
a numeric vector
}
\item{X1974}{
a numeric vector
}
\item{X1975}{
a numeric vector
}
\item{X1976}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.29)
}
\keyword{datasets}
\eof
\name{ex15.30}
\alias{ex15.30}
\docType{data}
\title{data from exercise 15.30}
\description{
The \code{ex15.30} data frame has 5 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Treatment.I}{
a numeric vector
}
\item{Treatment.II}{
a numeric vector
}
\item{Treatment.III}{
a numeric vector
}
\item{Treatment.IV}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.30)
}
\keyword{datasets}
\eof
\name{ex15.32}
\alias{ex15.32}
\docType{data}
\title{data from exercise 15.32}
\description{
The \code{ex15.32} data frame has 13 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Time}{
a numeric vector
}
\item{Gait}{
a factor with levels
\code{Diagonal} 
\code{Lateral} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.32)
}
\keyword{datasets}
\eof
\name{ex15.33}
\alias{ex15.33}
\docType{data}
\title{data from exercise 15.33}
\description{
The \code{ex15.33} data frame has 20 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.33)
}
\keyword{datasets}
\eof
\name{ex15.35}
\alias{ex15.35}
\docType{data}
\title{data from exercise 15.35}
\description{
The \code{ex15.35} data frame has 9 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{thickness}{
a numeric vector
}
\item{condition}{
a factor with levels
\code{Control} 
\code{SIDS} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex15.35)
}
\keyword{datasets}
\eof
\name{ex16.06}
\alias{ex16.06}
\docType{data}
\title{data from exercise 16.6}
\description{
The \code{ex16.06} data frame has 22 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Obs.1}{
a numeric vector
}
\item{Obs.2}{
a numeric vector
}
\item{Obs.3}{
a numeric vector
}
\item{Obs.4}{
a numeric vector
}
\item{Obs.5}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.06)
}
\keyword{datasets}
\eof
\name{ex16.09}
\alias{ex16.09}
\docType{data}
\title{data from exercise 16.9}
\description{
The \code{ex16.09} data frame has 24 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{xbar}{
a numeric vector
}
\item{stderr}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.09)
}
\keyword{datasets}
\eof
\name{ex16.14}
\alias{ex16.14}
\docType{data}
\title{data from exercise 16.14}
\description{
The \code{ex16.14} data frame has 24 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.14)
}
\keyword{datasets}
\eof
\name{ex16.25}
\alias{ex16.25}
\docType{data}
\title{data from exercise 16.25}
\description{
The \code{ex16.25} data frame has 21 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a factor with levels
\code{1} 
\code{10} 
\code{11} 
\code{12} 
\code{13} 
\code{14} 
\code{15} 
\code{16} 
\code{17} 
\code{18} 
\code{19} 
\code{2} 
\code{20} 
\code{3} 
\code{4} 
\code{5} 
\code{6} 
\code{7} 
\code{8} 
\code{9} 
\code{Panel} 
}
\item{C2}{
a factor with levels
\code{0.6} 
\code{0.8} 
\code{1} 
\code{Area Examined} 
}
\item{C3}{
a factor with levels
\code{# Blemishes} 
\code{1} 
\code{10} 
\code{12} 
\code{2} 
\code{3} 
\code{4} 
\code{5} 
\code{6} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.25)
}
\keyword{datasets}
\eof
\name{ex16.41}
\alias{ex16.41}
\docType{data}
\title{data from exercise 16.41}
\description{
The \code{ex16.41} data frame has 22 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{tensile1}{
a numeric vector
}
\item{tensile2}{
a numeric vector
}
\item{tensile3}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.41)
}
\keyword{datasets}
\eof
\name{ex16.43}
\alias{ex16.43}
\docType{data}
\title{data from exercise 16.43}
\description{
The \code{ex16.43} data frame has 20 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{n}{
a numeric vector
}
\item{xbar}{
a numeric vector
}
\item{stderr}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(ex16.43)
}
\keyword{datasets}
\eof
\name{xmp01.01}
\alias{xmp01.01}
\docType{data}
\title{data from Example 1.1}
\description{
    The \code{xmp01.01} data frame has 36 rows and 1 column of O-ring
    temperatures for space shuttle test firings or launches.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{temp}{
	    a numeric vector of temperatures (degrees F)
	}
    }
}
\details{
    The O-ring temperatures for each test firing of the engines or
    actual launch of the space shuttle prior to the 1986 explosion of
    the \emph{Challenger}.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
      and the Sciences (6th ed)}, Duxbury

  \emph{Presidential Commission on the Space Shuttle Challenger
      Accident}, Vol. \bold{1}, 1986: 129--131
}
\examples{
data(xmp01.01)
attach(xmp01.01)
summary(temp)             # summary statistics
stem(temp)
hist(temp, xlab = "Temperature (deg. F)")
rug(temp)
hist(temp, xlab = "Temperature (deg. F)",
     prob = TRUE, col = "lightgray")
lines(density(temp), col = "blue")
rug(temp)
detach()
}
\keyword{datasets}
\eof
\name{xmp01.02}
\alias{xmp01.02}
\docType{data}
\title{data from Example 1.2}
\description{
    The \code{xmp01.02} data frame has 27 rows and 1 column of flexural
    strengths of concrete.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{strength}{
	    a numeric vector of flexural strengths (MegaPascals)
	}
    }
}
\details{
    Data on the flexural strength (MPa) of high-performance concrete
    beams obtained by using superplasticizers and certain binders.
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury

    (1997) "Effects of aggregates and microfillers on the flexural
    properties of concrete", \emph{Magazine of Concrete Research}, 81--98.
}
\examples{
data(xmp01.02)
attach(xmp01.02)
hist(strength, xlab = "Flexural strength (MPa)",
     col = "lightgray")
rug(strength)
summary(strength)
boxplot(strength, col = "lightgray", notch = TRUE,
        ylab = "Flexural strength (MPa)",
        main = "Boxplot of strength",
        sub =
"Notches show a 95\% confidence interval on the median strength")
detach()
}
\keyword{datasets}
\eof
\name{xmp01.05}
\alias{xmp01.05}
\docType{data}
\title{data from Example 1.5}
\description{
  Percentage of binge drinkers in undergraduates at 140 campuses
}
\usage{data(xmp01.05)}
\format{
  A data frame with 140 observations on the following variable.
  \describe{
    \item{bingePct}{a numeric vector of percentage of binge drinkers}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
      and the Sciences (6th ed)}, Duxbury
}
\references{
  Based on data displayed in
  ``Health and Behavioral Consequences of Binge Drinking in College'',
  \emph{J. of the Amer. Med. Assoc.}, 1994: 1672-1677.
}
\examples{
data(xmp01.05)
str(xmp01.05)
stem(xmp01.05$bingePct)
stem(xmp01.05$bingePct, scale = 0.5)  # compare to Figure 1.4, p. 12
}
\keyword{datasets}

\eof
\name{xmp01.06}
\alias{xmp01.06}
\docType{data}
\title{data from Example 1.6}
\description{
    The \code{xmp01.06} data frame has 40 rows and 1 columns.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{yardage}{
	    a numeric vector
	}
    }
}
\details{
    Described in Devore (1995) as `` A random sample of the yardages of
    golf courses that have been designated by \emph{Golf Digest} as
    among the most challenging in the United States.''
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.06)
attach(xmp01.06)
summary(yardage)
stem(yardage)
hist(yardage, col = "lightgray",
     xlab = "Golf course yardages")
rug(yardage)
qqnorm(yardage, las = 1, ylab = "Golf course yardages")
detach()
}
\keyword{datasets}
\eof
\name{xmp01.10}
\alias{xmp01.10}
\docType{data}
\title{data from Example 1.10}
\description{
  The \code{xmp01.10} data frame has 90 rows and 1 column of adjusted
  power consumption for a sample of gas-heated homes.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{consump}{
      a numeric vector of adjusted power consumption (BTU) for
      gas-heated homes.
    }
  }
}
\details{
  Data obtained by Wisconsin Power and Light on the adjusted energy
  consumption during a particular period for a sample of gas-heated
  homes.  The energy consumption in BTU's is adjusted for the size
  (area) of the house and the weather (number of degree days of
  heating).

  These data are part of the FURNACE.MTW worksheet available with Minitab.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.10)
attach(xmp01.10)
hist(consump, col = "lightgray",
     xlab = "Adjusted energy consumption")
rug(consump)
hist(consump, col = "lightgray",
     xlab = "Adjusted energy consumption",
     prob = TRUE)
lines(density(consump), col = "blue")
rug(consump)
summary(consump)
# Make a histogram like Fig 1.9, p. 19
hist(consump, breaks = 1 + 2*(0:9),
     xlab = "BTUN", prob = TRUE, col = "lightgray")
rug(consump)
detach()
}
\keyword{datasets}
\eof
\name{xmp01.11}
\alias{xmp01.11}
\docType{data}
\title{data from Example 1.11}
\description{
  The \code{xmp01.11} data frame has 48 rows and 1 column of 
  measured bond strengths of glass-fiber-reinforced rebars and
  concrete.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{strength}{
      a numeric vector of bond strengths
    }
  }
}
\details{
  Data from a study to develop guidelines for bonding
  glass-fiber-reinforced rebars to concrete.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1996) "Design recommendations for bond of GFRP rebars to concrete",
  \emph{Journal of Structural Engineering}, 247-254.
}
\examples{
data(xmp01.11)
attach(xmp01.11)
hist(strength, xlab = "Bond strength", col = "lightgray")
rug(strength)
hist(log(strength), xlab = "log(bond strength)", col = "lightgray")
rug(log(strength))
## Create a histogram like Fig 1.11, page 20
hist(strength, breaks = c(2,4,6,8,12,20,30), prob = TRUE,
     col = "lightgray", xlab = "Bond strength")
rug(strength)
detach()
}
\keyword{datasets}
\eof
\name{xmp01.13}
\alias{xmp01.13}
\docType{data}
\title{data from Example 1.13}
\description{
  Crack lengths in corrosion tests
}
\usage{data(xmp01.13)}
\format{
  A data frame with 21 observations on the following variable.
  \describe{
    \item{crackLength}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
      and the Sciences (6th ed)}, Duxbury
}
\references{
  Based on data shown in ``On the Role of Phosphorus in the Caustic
  Stress Corrosion Cracking of Low Alloy Steels'', \emph{Corrosion
    Science}, 1989: 53--68.
}
\examples{
data(xmp01.13)
str(xmp01.13)
}
\keyword{datasets}
\eof
\name{xmp01.14}
\alias{xmp01.14}
\docType{data}
\title{data from Example 1.14}
\description{
  Concentrations of transferrin receptor in a sample of pregnant women.
}
\usage{data(xmp01.14)}
\format{
  A data frame with 12 observations on the following variable.
  \describe{
    \item{concentration}{a numeric vector}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
      and the Sciences (6th ed)}, Duxbury
}
\references{
  Based on data shown in ``Serum Transferrin Receptor for the Detection
  of Iron Deficiency in Pregnancy'', \emph{Amer. J. of Clinical
    Nutrition}, 1991: 1077--1081.
}
\examples{
data(xmp01.14)
str(xmp01.14)
}
\keyword{datasets}
\eof
\name{xmp01.15}
\alias{xmp01.15}
\docType{data}
\title{data from Example 1.15}
\description{
  The \code{xmp01.15} data frame has 20 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{lifetime}{
      a numeric vector of lifetimes (hr) of a certain type of
      incandescent light bulb.
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.15)
attach(xmp01.15)
summary(lifetime)              # produces mean, median, etc.
mean(lifetime, trim = 0.1)     # 10\% trimmed mean
mean(lifetime, trim = 0.2)     # 20\% trimmed mean
dotchart(lifetime)
hist(lifetime)                 # display a histogram
rug(lifetime)                  # add the data
abline(v = median(lifetime), col = 2, lty = 2)
abline(v = mean(lifetime), col = 3, lty = 2)
abline(v = mean(lifetime, trim = 0.1), col = 4, lty = 2)
abline(v = mean(lifetime, trim = 0.2), col = 5, lty = 2)
legend(600, 6,
  c("median", "mean", "10\% trimmed mean", "20\% trimmed mean"),
  col = 2:5, lty = 2)
}
\keyword{datasets}
\eof
\name{xmp01.16}
\alias{xmp01.16}
\docType{data}
\title{data from Example 1.16}
\description{
The \code{xmp01.16} data frame has 11 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Strength}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.16)
}
\keyword{datasets}
\eof
\name{xmp01.18}
\alias{xmp01.18}
\docType{data}
\title{data from Example 1.18}
\description{
    The \code{xmp01.18} data frame has 19 rows and 1 columns.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{depth}{
	    a numeric vector
	}
    }
}
\details{
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.18)
}
\keyword{datasets}
\eof
\name{xmp01.19}
\alias{xmp01.19}
\docType{data}
\title{data from Example 1.19}
\description{
The \code{xmp01.19} data frame has 25 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp01.19)
}
\keyword{datasets}
\eof
\name{xmp04.28}
\alias{xmp04.28}
\docType{data}
\title{data from Example 4.28}
\description{
    The \code{xmp04.28} data frame has 10 rows and 1 columns of
    constructed data representing measurement errors.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{meas.err}{
	    a numeric vector of measurement errors (no units given)
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp04.28)
attach(xmp04.28)
qqnorm(meas.err)   # compare to Figure 4.31, p. 188
qqline(meas.err)
detach()
}
\keyword{datasets}
\eof
\name{xmp04.29}
\alias{xmp04.29}
\docType{data}
\title{data from Example 4.29}
\description{
    The \code{xmp04.29} data frame has 19 rows and 2 columns of
    dielectric breakdown voltages and their corresponding standard
    normal quantiles used in a normal probability plot.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{Voltage}{
	    a sorted numeric vector of the dielectric breakdown voltages
	    measured on a piece of epoxy resin.
	}
	\item{z.percentile}{
	    a numeric vector of standard normal quantiles
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury 

    (1996) "Maximum likelihood estimation in the 3-parameter Weibull
    Distribution", \emph{IEEE Transactions on Dielectrics and Electrical
    Insulation}, 43--55.
}
\examples{
data(xmp04.29)
attach(xmp04.29)
## compare to Figure 4.33, page 190
qqp <- qqnorm(Voltage)
qqline(Voltage)
detach()
## compare quantiles with those given in book
cbind(qqp, xmp04.29)
}
\keyword{datasets}
\eof
\name{xmp04.30}
\alias{xmp04.30}
\docType{data}
\title{data from Example 4.30}
\description{
    The \code{xmp04.30} data frame has 10 rows and 1 columns of
    lifetimes of power apparatus insulation.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{lifetime}{
	    a numeric vector of lifetimes (hr) of power apparatus
	    insulation under thermal and electrical stress.
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury

    (1985) "On the estimation of life of power apparatus under combined
    electrical and thermal stress", \emph{IEEE Transactions on
    Electrical Insulation}, 70--78.
}
\examples{
data(xmp04.30)
attach(xmp04.30)
## Try normal probability plot first
qqnorm(lifetime, ylab = "Lifetime (hr)")
qqline(lifetime)
## Weibull probability plot, compare Figure 4.36, p. 194
plot(log(-log(1 - seq(0.05, 0.95, 0.1))),
     log(sort(lifetime)), xlab = "Theoretical Quantiles",
     ylab = "log(Lifetime) (log(hr))",
     main = "Weibull Q-Q Plot", las = 1)
detach()
}
\keyword{datasets}
\eof
\name{xmp06.02}
\alias{xmp06.02}
\docType{data}
\title{data from Example 6.2}
\description{
  The \code{xmp06.02} data frame has 20 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Voltage}{
      the dielectric breakdown voltage for pieces of expoxy resin
    }
  }
}
\details{
  This is the same data set as \code{xmp04.29}.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp06.02)
summary(xmp06.02)                # gives mean, median, etc.
attach(xmp06.02)
mean(range(Voltage))             # average of the extremes
mean(Voltage, trim = 0.1)        # trimmed mean
}
\keyword{datasets}
\eof
\name{xmp06.03}
\alias{xmp06.03}
\docType{data}
\title{data from Example 6.3}
\description{
  The \code{xmp06.03} data frame has 8 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Strength}{
      elastic modulus (GPa) of AZ91D alloy specimens from a die-casting
      process
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1998), On the development of a new approach for the determination of
  yield strength in Mg-based alloys, \emph{Light Metal Age}, Oct.,
  50-53.
}
\examples{
data(xmp06.03)
attach(xmp06.03)
stem(Strength)
var(Strength)  # usual (unbiased) estimate of sigma^2
## alternative estimate of sigma^2 with n in denominator
sum((Strength - mean(Strength))^2)/length(Strength)
}
\keyword{datasets}
\eof
\name{xmp06.12}
\alias{xmp06.12}
\docType{data}
\title{data from Example 6.12}
\description{
    The \code{xmp06.12} data frame has 20 rows and 1 columns of data on
    the survival times of mice subjected to radiation.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{Survival}{
	    a numeric vector of survival times (weeks) of mice subjected
	    to 240 rads of gamma radiation.
	}
    }
}
\details{
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury.
    
    Gross, A. J. and Clark, V. (1976) \emph{Survival Distributions:
	Reliability Applications in the Biomedical Sciences}, Wiley.
}
\examples{
data(xmp06.12)
attach(xmp06.12)
gamma.MoM <- function(x) {
   ## calculate method of moments estimates for gamma distribution
   xbar <- mean(x)
   mnSqDev <- mean((x - xbar)^2)
   c(alpha = xbar^2/mnSqDev, beta = mnSqDev/xbar)
}
## method of moments estimates
print(surv.MoM <- gamma.MoM(Survival))
## evaluating the negative log-likelihood
gammaLlik <- function(x) {
   ## argument x is a vector of shape (alpha) and scale (beta)
   -sum(dgamma(Survival, shape = x[1], scale = x[2], log = TRUE))
}
## maximum likelihood estimates - use MoM estimates as starting value
MLE <- optim(par = surv.MoM, gammaLlik)
print(MLE)
detach()
}
\keyword{datasets}
\eof
\name{xmp06.13}
\alias{xmp06.13}
\docType{data}
\title{data from Example 6.13}
\description{
    The \code{xmp06.13} data frame has 420 rows and 1 columns of the
    number of goals pre game scored by National Hockey League teams
    during the 1966-1967 season.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{goals}{
	    a numeric vector
	}
    }
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for
	Engineering and the Sciences (6th ed)}, Duxbury
    
    Reep, C. and Pollard, R. and Benjamin, B. (1971), ``Skill and chance
    in ball games'', \emph{Journal of the Royal Statistical Society,
	Series A, General}, \bold{134}, 623--629
}
\examples{
data(xmp06.13)
attach(xmp06.13)
table(goals)      # compare to frequency table on p. 267
hist(goals, breaks = 0:12 - 0.5, las = 1, col = "lightgray")
negBinom.MoM <- function(x) {
   ## method of moments estimates for negative binomial distribution
   xbar <- mean(x)
   mnSqDev <- mean((x - xbar)^2)
   c(p = xbar/mnSqDev, r = xbar^2/(mnSqDev - xbar))
}
print(goals.MoM <- negBinom.MoM(goals))
## MLE's
optim(goals.MoM, function(x)
  -sum(dnbinom(goals, p = x[1], size = x[2], log = TRUE)))
## would have been better to use a transformation of p
detach()
}
\keyword{datasets}
\eof
\name{xmp07.06}
\alias{xmp07.06}
\docType{data}
\title{data from Example 7.6}
\description{
  The \code{xmp07.06} data frame has 48 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Voltage}{
      the AC breakdown voltage (kV) of a circuit
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1995), Testing practices for the AC breakdown voltage testing of
  insulation liquids, \emph{IEEE Electrical Insulation Magazine},
  21-26.
}
\examples{
data(xmp07.06)
boxplot(xmp07.06,
  main = "AC Breakdown Voltage (kV)")
# t.test gives a 95\% confidence interval on the mean
t.test(xmp07.06)   
}
\keyword{datasets}
\eof
\name{xmp07.11}
\alias{xmp07.11}
\docType{data}
\title{data from Example 7.11}
\description{
  The \code{xmp07.11} data frame has 16 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Elasticity}{
      modulus of elasticity (MPa) obtained 1 minute after loading on
      Scotch pine lumber specimens.
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1996), Time-dependent bending properties of lumber, \emph{J. of
    Testing and Evaluation}, 187-193.
}
\examples{
data(xmp07.11)
boxplot(xmp07.11)
with(xmp07.11, qqnorm(Elasticity))
with(xmp07.11, qqline(Elasticity))
with(xmp07.11, t.test(Elasticity))
}
\seealso{\code{\link{xmp09.10}}}
\keyword{datasets}
\eof
\name{xmp07.15}
\alias{xmp07.15}
\docType{data}
\title{data from Example 7.15}
\description{
  The \code{xmp07.15} data frame has 17 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{voltage}{
      breakdown voltage of electrically stressed circuits
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp07.15)
boxplot(xmp07.15, main = "Breakdown voltage")
with(xmp07.15, qqnorm(voltage, main = "Breakdown voltage"))
with(xmp07.15, qqline(voltage))
attach(xmp07.15)
var(voltage) * (length(voltage) - 1)/
  qchisq(c(0.975, 0.025), df = length(voltage) - 1)
detach()
}
\keyword{datasets}
\eof
\name{xmp08.08}
\alias{xmp08.08}
\docType{data}
\title{data from Example 8.8}
\description{
  The \code{xmp08.08} data frame has 52 rows and 1 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{DCP}{
      dynamic cone penetrometer readings (mm/blow) for a certain type
      of pavement.
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1999), Probabilistic model for the analysis of dynamic cone
  penetrometer test values in pavement structure evaluation,
  \emph{J. Testing and Evaluation}, 7-14.
}
\examples{
data(xmp08.08)
boxplot(xmp08.08, main = "DCP readings")
attach(xmp08.08)
hist(DCP, breaks = 8, prob = TRUE)
rug(DCP)
lines(density(DCP), col = "blue")
t.test(DCP, alt = "less", mu = 30)
}
\keyword{datasets}
\eof
\name{xmp08.09}
\alias{xmp08.09}
\docType{data}
\title{data from Example 8.9}
\description{
  Five observations of the maximum weight of lift.
}
\usage{data(xmp08.09)}
\format{
  A data frame with 5 observations on the following variable.
  \describe{
    \item{MAWL}{maximum weight of lift (kg) for a frequency of four lifts/min.}
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``The Effects of Speed, Frequency, and Load on Measured Hand Forces
  for a Floor-to-Knuckle Lifting Task'', \emph{Ergonomics}, 1992: 833--843.
}
\examples{
data(xmp08.09)
str(xmp08.09)
with(xmp08.09, t.test(MAWL, mu = 25, alt = "greater"))
}
\keyword{datasets}
\eof
\name{xmp09.04}
\alias{xmp09.04}
\docType{data}
\title{data from Example 9.4}
\description{
  The \code{xmp09.04} data frame has 2 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Type}{
      a factor with levels
      \code{Graded} 
      \code{No-fines} 
    }
    \item{Sample.Size}{
      a numeric vector
    }
    \item{Sample.Average.Conductivity}{
      a numeric vector
    }
    \item{Sample.Standard.Deviation}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp09.04)
}
\keyword{datasets}
\eof
\name{xmp09.06}
\alias{xmp09.06}
\docType{data}
\title{data from Example 9.6}
\description{
  The \code{xmp09.06} data frame has 2 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Fabric.Type}{
      a factor with levels
      \code{Cotton} 
      \code{Triacetate} 
    }
    \item{Sample.Size}{
      a numeric vector
    }
    \item{Sample.Mean}{
      a numeric vector
    }
    \item{Sample.Standard.Deviation}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp09.06)
}
\keyword{datasets}
\eof
\name{xmp09.08}
\alias{xmp09.08}
\docType{data}
\title{data from Example 9.8}
\description{
  The \code{xmp09.08} data frame has 6 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{bottom}{
      a numeric vector
    }
    \item{surface}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp09.08)
boxplot(xmp09.08, main = "Boxplot of data from Example 9.8")
attach(xmp09.08)
boxplot(bottom-surface, main = "Boxplot of differences from Example 9.8")
t.test(bottom, surface, alt = "greater", paired = TRUE)
detach()
}
\keyword{datasets}
\eof
\name{xmp09.09}
\alias{xmp09.09}
\docType{data}
\title{data from Example 9.9}
\description{
  The \code{xmp09.09} data frame has 16 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Subject}{
      a numeric vector
    }
    \item{Before}{
      a numeric vector
    }
    \item{After}{
      a numeric vector
    }
    \item{Difference}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp09.09)
boxplot(xmp09.09[, c("Before", "After")],
   main = "Data from Example 9.9")
attach(xmp09.09)
boxplot(Difference, main = "Differences in Example 9.9")
qqnorm(Difference,
   main = "Normal probability plot (compare Figure 9.5, p. 377)")
t.test(Difference)
t.test(Before, After, paired = TRUE)   # same test
detach()
}
\keyword{datasets}
\eof
\name{xmp09.10}
\alias{xmp09.10}
\docType{data}
\title{data from Example 9.10}
\description{
  The \code{xmp09.10} data frame has 16 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{t1.min}{
      modulus of elasticity (MPa) obtained 1 minute after loading on
      Scotch pine lumber specimens.
    }
    \item{t4.wks}{
      modulus of elasticity (MPa) obtained 4 weeks after loading on
      Scotch pine lumber specimens.
    }
    \item{Difference}{
      a numeric vector of the differences in the modulus of elasticity (MPa)
    }
  }
}
\details{
  This is an extended version of the data from Example 7.11.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1996), Time-dependent bending properties of lumber, \emph{J. of
    Testing and Evaluation}, 187-193.
}
\examples{
data(xmp09.10)
boxplot(xmp09.10[, c("t1.min", "t4.wks")],
     main = "Data from Example 9.10")
attach(xmp09.10)
## compare to Figure 9.7, page 379
qqnorm(Difference, main = "Differences from Example 9.10",
       ylab = "Difference in modulus of elasticity")
qqline(Difference)
t.test(Difference, conf = 0.99)
t.test(t1.min, t4.wks, paired = TRUE, conf = 0.99) # same thing
detach()
}
\seealso{\code{\link{xmp07.11}}}
\keyword{datasets}
\eof
\name{xmp10.01}
\alias{xmp10.01}
\docType{data}
\title{data from Example 10.1}
\description{
  The \code{xmp10.01} data frame has 24 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{strength}{
      a numeric vector
    }
    \item{type}{
      a factor with levels
      \code{A} 
      \code{B} 
      \code{C} 
      \code{D} 
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp10.01)
boxplot(strength ~ type, data = xmp10.01, 
    main = "Data from Example (compare Figure 10.1, p. 405)")
fm1 <- lm( strength ~ type, data = xmp10.01 )  # fit anova model
qqnorm(resid(fm1), main = "Compare to Figure 10.2, p. 407")
anova(fm1)     # compare results in Example 10.2, p. 409
}
\keyword{datasets}
\eof
\name{xmp10.03}
\alias{xmp10.03}
\docType{data}
\title{data from Example 10.3}
\description{
  The \code{xmp10.03} data frame has 15 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Soiling}{
      a numeric vector
    }
    \item{Mixture}{
      a numeric vector
    }
  }
}
\details{
  Data from an experiment comparing the degree of soiling for fabric
  copolymerized with three different mixtures of methacrylic acid.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1983), ``Chemical factors affecting soiling and soil release from
  cotton DP fabric'', \emph{American Dyestuff Reporter}, 25-30.
}
\examples{
data(xmp10.03)
xmp10.03$Mixture <- factor(xmp10.03$Mixture)
plot(Soiling ~ Mixture, data = xmp10.03, col = "lightgray",
     main = "Data from Example 10.3")
summary(xmp10.03)          # check ranges and balance
fm1 <- lm(Soiling ~ Mixture, data = xmp10.03)
anova(fm1)                 # compare to table shown on p. 412
}
\keyword{datasets}
\eof
\name{xmp10.05}
\alias{xmp10.05}
\docType{data}
\title{data from Example 10.5}
\description{
  The \code{xmp10.05} data frame has 20 rows and 2 columns of data from
  an experiment on the effect of alcohol on REM sleep time
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{REMtime}{
      a numeric vector giving the rapid eye movement (REM) sleep time
      for each rat during a 24-hour period
    }
    \item{ethanol}{
      a numeric vector giving the concentration of ethanol (alcohol) per
      body weight administered to the rat (g/kg)
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1978), ``Relationship of ethanol blood level to REM and non-REM sleep
  time and distribution in the rat'', \emph{Life Sciences}, 839-846.
}
\examples{
data(xmp10.05)
plot(REMtime ~ ethanol, data = xmp10.05,
     xlab = "Ethanol concentration administered (g/kg)",
     ylab = "Amount of REM sleep during a 24 hour period")
fm1 <- lm(REMtime ~ factor(ethanol), data = xmp10.05)
anova(fm1)      # compare with Table 10.4, p. 417
summary(fm1)    # differences with baseline (0 g/kg)
##  more appropriate to use an ordered factor
fm2 <- lm(REMtime ~ ordered(ethanol), data = xmp10.05)
anova(fm2)      # same as above
summary(fm2)    # polynomial contrasts
##  best model uses square root of ethanol concentration
plot(REMtime ~ sqrt(ethanol), data = xmp10.05,
     xlab = expression(sqrt(
        plain("Ethanol concentration administered (g/kg)"))),
     ylab = "Amount of REM sleep during a 24 hour period")
fm3 <- lm(REMtime ~ sqrt(ethanol), data = xmp10.05)
summary(fm3)
abline(fm3)
anova(fm3, fm1)   # lack of fit test
opar <- par(mfrow = c(2,2))
plot(fm3, main = "Continuous fit to data in Example 10.5")
par(opar)
}
\keyword{datasets}
\eof
\name{xmp10.08}
\alias{xmp10.08}
\docType{data}
\title{data from Example 10.8}
\usage{data(xmp10.08)}
\description{
  The \code{xmp10.08} data frame has 22 rows and 2 columns of data on
  the elastic modulus of Mg-based alloys obtained by a new ultrasonic
  process for specimens produced using three different casting
  processes.}
\format{
  This data frame contains the following columns:
  \describe{
    \item{elastic}{a numeric vector of the elastic modulus (GPa)}
    \item{type}{a factor indicating the casting process with levels
      \code{Die}, \code{Permanent}, and \code{Plaster}}
  }
}
\details{
}
\source{
    Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  (1998), ``On the development of a new approach for the deterimination
  of yield strength in Mg-based alloys'', \emph{Light Metal Age}, Oct. 51--53.
}
\examples{
data(xmp10.08)
str(xmp10.08)
fm1 <- aov(elastic ~ type, data = xmp10.08)
anova(fm1)
}
\keyword{datasets}
\eof
\name{xmp10.10}
\alias{xmp10.10}
\docType{data}
\title{data from Example 10.10}
\description{
  The \code{xmp10.10} data frame has 18 rows and 2 columns.
}
\format{
    This data frame contains the following columns:
    \describe{
	\item{travel}{
	  a numeric vector giving the travel time for ultrasonic
	  head-waves in the rail (nanoseconds).  The value given is the
	  original travel time minus 36,100 nanoseconds.
	}
	\item{Rail}{
	    an ordered factor identifying the rail on which the
	    measurement was made.
	}
    }
}
\details{
  Data from a study of travel time for a certain type of wave that
  results from longitudinal stress of rails used for railroad track.
}
\source{
    Devore, J. L. (2003), \emph{Probability and Statistics for
      Engineering and the Sciences (6th ed)}, Duxbury, Boston, MA.
    
    Pinheiro, J. C. and Bates, D. M. (2003), \emph{Mixed-Effects Models in S
	and S-PLUS}, Springer, New York.  (Appendix A.26)

    (1985), ``Zero-force travel-time parameters for ultrasonic
    head-waves in railroad rail'', \emph{Materials Evaluation},
    854-858.
}
\examples{
data(xmp10.10)
xmp10.10$Rail <- factor(xmp10.10$Rail)
boxplot(travel ~ Rail, xmp10.10, col = "lightgray",
  xlab = "Rail", ylab = "Zero-force travel time (microsec)",
  main = "Travel times in rails, from example 10.10")
fm1 <- lm(travel ~ Rail, data = xmp10.10)
anova(fm1)
}
\keyword{datasets}
\eof
\name{xmp11.01}
\alias{xmp11.01}
\docType{data}
\title{data from Example 11.1}
\description{
  The \code{xmp11.01} data frame has 12 rows and 3 columns from an
  experiment on the effect of different washing treatments in removing
  marks from an erasable pen.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{strength}{
      a quantitative indicator of the overall specimen color change; the
      lower this value, the more marks were removed.
    }
    \item{brand}{
      a numeric vector identifying the brand of erasable pen used.
    }
    \item{treatment}{
      a numeric vector identifying the washing treatment.
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1991), ``An assessment of the effects of treatment, time, and heat on
  the removal of erasable pen marks from cotton and cotton/polyester
  blend fabrics'', \emph{J. of Testing and Evaluation}, 394-397.
}
\examples{
data(xmp11.01)
xmp11.01$brand <- factor(xmp11.01$brand)
xmp11.01$treatment <- factor(xmp11.01$treatment)
plot(strength ~ treatment, data = xmp11.01, col = "lightgray",
     main = "Interaction plot for Example 11.01",
     xlab = "Washing treatment")
lines(strength ~ as.integer(treatment), data = xmp11.01,
      subset = brand == 1, col = 4, type = "b")
lines(strength ~ as.integer(treatment), data = xmp11.01,
      subset = brand == 2, col = 2, type = "b")
lines(strength ~ as.integer(treatment), data = xmp11.01,
      subset = brand == 3, col = 3, type = "b")
legend(3, 0.9, paste("Brand", 1:3), col = c(4, 2, 3), lty = 1)
fm1 <- lm(strength ~ brand + treatment, data = xmp11.01)
anova(fm1)      # compare to table 11.1, page 439
}
\keyword{datasets}
\eof
\name{xmp11.05}
\alias{xmp11.05}
\docType{data}
\title{data from Example 11.5}
\description{
  The \code{xmp11.05} data frame has 20 rows and 3 columns of data from
  and experiment on energy consumption of dehumidifiers.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{power}{
      the estimated annual power consumption (kwh) of the dehumidifier
    }
    \item{humid}{
      the level of humidity at which the dehumidifier is tested.  Larger
      numbers correspond to more humid conditions.
    }
    \item{brand}{
      the brand of dehumidifier.
    }
  }
}
\details{
  This is a randomized blocked experiment.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp11.05)
plot(power ~ humid, data = xmp11.05, col = "lightgray",
     xlab = "Level of humidity",
     ylab = "Estimated annual power consumption (kwh)",
     main = "Data from Example 11.5")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 1, col = 2, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 2, col = 3, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 3, col = 4, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 4, col = 5, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 5, col = 6, type = "b")
legend(0.6, 1010, paste("Brand", 1:5), col = 1 + (1:5),
       lty = 1)
fm1 <- lm(power ~ humid + brand, data = xmp11.05)
anova(fm1)    # compare with Table 11.3, page 442
summary(fm1)
}
\keyword{datasets}
\eof
\name{xmp11.06}
\alias{xmp11.06}
\docType{data}
\title{data from Example 11.6}
\description{
  The \code{xmp11.06} data frame has 24 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Resp}{
      a numeric vector of the mean number of responses emitted by each
      subject during single and compound stimuli presentations over a
      4-day period.
    }
    \item{Stimulus}{
      a numeric vector of stimulus levels.  These levels correspond to
      L1 (moderate intensity light), L2 (low intensity light), T (tone),
      L1+L2, L1+T, and L2+T.
    }
    \item{Subject}{
      a numeric vector identifying the subject (rat).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1971), ``Compounding of discriminative stimuli from the same and
  different sensory modalities'', \emph{J. Experimental Analysis and
    Behavior}, 337-342
}
\examples{
data(xmp11.06)
plot(Resp ~ Stimulus, data = xmp11.06, col = "lightgray",
     main = "Data from Example 11.6",
     ylab = "Mean number of responses")
for (i in seq(along = levels(xmp11.06$Subject))) {
    attach(xmp11.06[ xmp11.06$Subject == i, ])
    lines(Resp ~ as.integer(Stimulus), col = i+1, type = "b")
}
legend(0.8, 95, paste("Subject", levels(xmp11.06$Subject)),
       col = 1 + seq(along = levels(xmp11.06$Subject)),
       lty = 1)
fm1 <- lm(Resp ~ Stimulus + Subject, data = xmp11.06)
anova(fm1)     # compare to Table 11.5, page 443
attach(xmp11.06)
means <- sort(tapply(Resp, Stimulus, mean))
means
diff(means)    # successive differences
qtukey(0.95, nmeans = 6, df = 15)  #for Tukey comparisons
detach()
}
\keyword{datasets}
\eof
\name{xmp11.07}
\alias{xmp11.07}
\docType{data}
\title{data from Example 11.7}
\description{
  The \code{xmp11.07} data frame has 36 rows and 3 columns from an
  experiment on the growth of different varieties of tomato plants at
  different planting densities.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Yield}{
      a numeric vector giving the yields for each plot
    }
    \item{Variety}{
      a numeric vector coding the variety.
    }
    \item{Density}{
      a numeric vector giving the planting density (thousands of plants
      per hectare).
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1976), ``Effects of plant density on tomato yields in western
  Nigeria'', \emph{Experimental Agriculture}, 43-47.
}
\examples{
data(xmp11.07)
plot(Yield ~ Density, data = xmp11.07, col = "lightgray",
  main = "Data from Example 11.7, page 450",
  xlab = "Density (plants/hectare)")
means <- sapply(split(xmp11.07, xmp11.07$Density),
  function(x) tapply(x$Yield, x$Variety, mean))
round(means, 2)
lines(1:4, means[1, ], col = 4, type = "b")
lines(1:4, means[2, ], col = 2, type = "b")
lines(1:4, means[3, ], col = 3, type = "b")
legend(0.4, 21.2, levels(xmp11.07$Variety), lty = 2,
  col = c(4, 2, 3))
fm1 <- lm(Yield ~ Variety * Density, data = xmp11.07)
anova(fm1)    # compare with Table 11.7, page 452
fm2 <- update(fm1, . ~ Variety + Density)  # additive model
anova(fm2)
sort(tapply(xmp11.07$Yield, xmp11.07$Variety, mean))
}
\keyword{datasets}
\eof
\name{xmp11.11}
\alias{xmp11.11}
\docType{data}
\title{data from Example 11.11}
\description{
  The \code{xmp11.11} data frame has 96 rows and 4 columns giving data
  on the heat tolerance of cattle under different conditions.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Tempr}{
      observed body temperature of the cattle (degrees Fahrenheit - 100)
    }
    \item{Period}{
      a numeric vector indicating the period of the year
    }
    \item{Strain}{
      a numeric vector indicating the strain of cattle
    }
    \item{Coat}{
      a numeric vector indicating the coat type
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1959), ``The significance of the coat in hear tolerance of cattle'',
  \emph{Australian J. Agricultural Research}, 744-748.
}
\examples{
data(xmp11.11)
coplot(Tempr ~ as.integer(Period) | Strain * Coat,
       data = xmp11.11, show.given = FALSE)
coplot(Tempr ~ as.integer(Strain) | Period * Coat,
       data = xmp11.11, show.given = FALSE)
coplot(Tempr ~ as.integer(Coat) | Period * Strain,
       data = xmp11.11, show.given = FALSE)
fm1 <- lm(Tempr ~ Period * Strain * Coat, xmp11.11)
anova(fm1)  # compare with Table 11.8, page 461
}
\keyword{datasets}
\eof
\name{xmp11.12}
\alias{xmp11.12}
\docType{data}
\title{data from Example 11.12}
\description{
  The \code{xmp11.12} data frame has 36 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{abrasion}{
      a numeric vector
    }
    \item{row}{
      a numeric vector
    }
    \item{column}{
      a numeric vector
    }
    \item{humidity}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1946), ``The abrasion of leather'', \emph{J. Inter. Soc. Leather
    Trades' Chemists}, 287.
}
\examples{
data(xmp11.12)
xmp11.12$row <- ordered(xmp11.12$row)
xmp11.12$column <- ordered(xmp11.12$column)
xmp11.12$humidity <- ordered(xmp11.12$humidity)
attach(xmp11.12)  # to check the design
table(row, column)
table(row, humidity)
table(humidity, column)
detach()
fm1 <- lm(abrasion ~ row + column + humidity, xmp11.12)
anova(fm1)    # compare with Table 11.9, page 464
}
\keyword{datasets}
\eof
\name{xmp11.13}
\alias{xmp11.13}
\docType{data}
\title{data from Example 11.13}
\description{
  The \code{xmp11.13} data frame has 16 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Strength}{
      a numeric vector
    }
    \item{age}{
      a numeric vector
    }
    \item{tempture}{
      a numeric vector
    }
    \item{soil}{
      a numeric vector
    }
  }
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp11.13)
fm1 <- lm(Strength ~ age * tempture * soil, xmp11.13)
anova(fm1)   # compare with Table 11.12, page 471
}
\keyword{datasets}
\eof
\name{xmp11.16}
\alias{xmp11.16}
\docType{data}
\title{data from Example 11.16}
\description{
  The \code{xmp11.16} data frame has 16 rows and 6 columns of data from
  a blocked, \eqn{2^3} replicated factorial design.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{strength}{
      strength of the product solution (arbitrary units).
    }
    \item{tempture}{
      reactor temperature - coded as \eqn{\pm 1}{+/-1}.
    }
    \item{gas}{
      gas throughput - coded as \eqn{\pm 1}{+/-1}.
    }
    \item{conc}{
      concentration of active constituent - coded as \eqn{\pm 1}{+/-1}.
    }
    \item{block}{
      block in which the experiment was run.
    }
  }
}
\source{
  (1951), Factorial experiments in pilot plant studies, \emph{Industrial
    and Engineering Chemistry}, 1300--1306.
  
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp11.16)
## leave -1/+1 encoding for experimental factors, convert block
fm1 <- aov(strength ~ tempture * gas * conc + block,
           data = xmp11.16)
summary(fm1)     # anova table
}
\keyword{datasets}
\eof
\name{xmp12.01}
\alias{xmp12.01}
\docType{data}
\title{data from Example 12.1}
\description{
  The \code{xmp12.01} data frame has 30 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{palprebal}{
      width of the palprebal fissure (cm).
    }
    \item{OSA}{
      Ocular Surface Area, a measure of vertical gaze direction (cm\eqn{^2}).
    }
  }
}
\details{
  These are data from an experiment relating the vertical gaze
  direction, as measured by the ocular surface area, to the width of the
  palprebal fissure (horizontal width of the eye opening).
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1996), ``Analysis of ocular surface area for comfortable VDT
  workstation layout'', \emph{Ergometrics}, 877-884.
}
\examples{
data(xmp12.01)
plot(OSA ~ palprebal, data = xmp12.01,
     xlab = "Palprebal fissure width (cm)",
     ylab = expression(paste(plain("Occular surface area (cm")^2,
               plain(")"))),
     main = "Data from Example 12.1, page 490", las = 1)
summary(xmp12.01)
fm1 <- lm(OSA ~ palprebal, data = xmp12.01)
summary(fm1)
abline(fm1)
opar <- par(mfrow = c(2,2))
plot(fm1)
par(opar)
}
\keyword{datasets}
\eof
\name{xmp12.02}
\alias{xmp12.02}
\docType{data}
\title{data from Example 12.2}
\description{
  The \code{xmp12.02} data frame has 19 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{soil.pH}{
      pH of the soil at the test site.
    }
    \item{dieback}{
      mean crown dieback at the test site (\%).
    }
  }
}
\details{
  These data are from an observational study of the mean crown dieback,
  a measure of the growth retardation in sugar maples, and the soil pH.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1995) ``Relationships among crown condition, growth, and stand
  nutrition in seven northern Vermont sugarbushes'', \emph{Canadian
    Journal of Forest Research}, 386--397
}
\examples{
data(xmp12.02)
plot(dieback ~ soil.pH, data = xmp12.02,
     xlab = "soil pH", ylab = "mean crown dieback (\%)",
     main = "Data from Example 12.2, page 491")
fm1 <- lm(dieback ~ soil.pH, data = xmp12.02)
abline(fm1)
summary(fm1)
opar <- par(mfrow = c(2,2))
plot(fm1)
par(opar)
}
\keyword{datasets}
\eof
\name{xmp12.04}
\alias{xmp12.04}
\docType{data}
\title{data from Example 12.4}
\description{
  The \code{xmp12.04} data frame has 15 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{weight}{
      unit weight of the concrete specimen (pcf).
    }
    \item{porosity}{
      porosity (\%) of the concrete specimen.
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1995) ``Pavement thickness design for no-fines concrete parking
  lots'' \emph{J. of Transportation Engineering}, 476-484.
}
\examples{
data(xmp12.04)
plot(porosity ~ weight, data = xmp12.04,
     xlab = "Unit weight (pcf) of concrete specimen",
     ylab = "Porosity (\%)",
     main = "Data from Example 12.4, page 500")
fm1 <- lm(porosity ~ weight, data = xmp12.04)
abline(fm1)
summary(fm1)
opar <- par(mfrow = c(2,2))
plot(fm1)
par(opar)
}
\keyword{datasets}
\eof
\name{xmp12.06}
\alias{xmp12.06}
\docType{data}
\title{data from Example 12.6}
\description{
  The \code{xmp12.06} data frame has 11 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{traffic}{
      traffic flow (1000's of cars per 24 hours)
    }
    \item{lead}{
      lead content of bark of trees near the highway (\eqn{\mu}{u}g/g
      dry wt).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.06)
plot(lead ~ traffic, data = xmp12.06,
     xlab = "Traffic flow (1000's of cars per 24 hours)",
     ylab = expression(paste(plain("Lead content of tree bark ("),
       mu,plain("g/g dry wt)"))),
     main = "Data from Example 12.6, page 503", las = 1)
fm1 <- lm(lead ~ traffic, data = xmp12.06)
abline(fm1)
summary(fm1)
opar <- par(mfrow = c(2, 2))
plot(fm1)
par(opar)
## compare to table on page 503
cbind(xmp12.06, yhat = fitted(fm1), resid = resid(fm1))
anova(fm1)
}
\keyword{datasets}
\eof
\name{xmp12.08}
\alias{xmp12.08}
\docType{data}
\title{data from Example 12.8}
\description{
  The \code{xmp12.08} data frame has 14 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{strength}{
      fracture strength, as a percentage of the ultimate tensile strength.
    }
    \item{attenuat}{
      attenuation or decrease in the amplitude of the stress wave (neper/cm).
    }
  }
}
\details{
  Data from a study to investigate how the propagation of an ultrasonic
  stress wave through a substance depends on the properties of the
  substance.  The test substance was fiberglass-reinforced polyester
  composites.
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1985), ``Promising quantitative nondestructive evaluation techniques
  for composite materials'', \emph{Materials Evaluation}, 561-565.
}
\examples{
data(xmp12.08)
plot(attenuat ~ strength, data = xmp12.08,
     xlab = "Fracture strength (\% of ultimate tensile strength)",
     ylab = "Attenuation (neper/cm)",
     main = "Data from Example 12.8, page 504")
fm1 <- lm(attenuat ~ strength, data = xmp12.08)
abline(fm1)
summary(fm1)
opar <- par(mfrow = c(2, 2))
plot(fm1)
par(opar)
anova(fm1)
}
\keyword{datasets}
\eof
\name{xmp12.10}
\alias{xmp12.10}
\docType{data}
\title{data from Example 12.10}
\description{
The \code{xmp12.10} data frame has 15 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.10)
}
\keyword{datasets}
\eof
\name{xmp12.11}
\alias{xmp12.11}
\docType{data}
\title{data from Example 12.11}
\description{
The \code{xmp12.11} data frame has 20 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.11)
}
\keyword{datasets}
\eof
\name{xmp12.12}
\alias{xmp12.12}
\docType{data}
\title{data from Example 12.12}
\description{
The \code{xmp12.12} data frame has 18 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.12)
}
\keyword{datasets}
\eof
\name{xmp12.13}
\alias{xmp12.13}
\docType{data}
\title{data from Example 12.13}
\description{
  Corrosion of steel reinforcing bars
}
\usage{data(xmp12.13)}
\format{
  A data frame with 18 observations on the following 2 variables.
  \describe{
    \item{x}{a numeric vector of carbonation depths (mm)}
    \item{y}{a numeric vector of strengths (MPa) for a sample of core
      specimens}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``The Carbonation of Concrete Structures in the Tropical Environment
  of Singapore'', \emph{Magazine of Concrete Research}, 1996: 293--300
}
\examples{
data(xmp12.13)
}
\keyword{datasets}
\eof
\name{xmp12.14}
\alias{xmp12.14}
\docType{data}
\title{data from Example 12.14}
\description{
The \code{xmp12.14} data frame has 8 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector
}
\item{y}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.14)
}
\keyword{datasets}
\eof
\name{xmp12.15}
\alias{xmp12.15}
\docType{data}
\title{data from Example 12.15}
\description{
The \code{xmp12.15} data frame has 16 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{ozone}{
a numeric vector
}
\item{carbon}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp12.15)
}
\keyword{datasets}
\eof
\name{xmp12.16}
\alias{xmp12.16}
\docType{data}
\title{data from Example 12.16}
\description{
  Correlation of concentrations of two pollutants
}
\usage{data(xmp12.16)}
\format{
  A data frame with 16 observations on the following 2 variables.
  \describe{
    \item{x}{a numeric vector of ozone concentrations (ppm)}
    \item{y}{a numeric vector of secondary carbon concentrations
      (microgram/m-cub)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``The Carbon Component of the Los Angeles Aerosol: Source
  Apportionment and Contributions to the Visibility Budget'',
  \emph{J. Air Polution Control Fed.}, 1984: 643-650.
}
\examples{
data(xmp12.16)
plot(y ~ x, data = xmp12.16, xlab = "Ozone concentration (ppm)",
     ylab = "Secondary carbon concentration")
cor(xmp12.16$x, xmp12.16$y)
cor.test(~ x + y, data = xmp12.16)
}
\keyword{datasets}
\eof
\name{xmp13.01}
\alias{xmp13.01}
\docType{data}
\title{data from Example 13.1}
\description{
  The \code{xmp13.01} data frame has 14 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{rate}{
      a numeric vector
    }
    \item{emission}{
      a numeric vector
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury 
}
\examples{
data(xmp13.01)
plot(emission ~ rate, data = xmp13.01,
     xlab = "Burner area liberation rate",
     ylab = expression(plain("NO")["x"]*
                 plain("emissions")), las = 1,
     main = "Data from Example 13.1, page 545")
fm1 <- lm(emission ~ rate, data = xmp13.01)
abline(fm1)                   # plot 1, Figure 13.1
if (require(MASS)) {
   sres <- stdres(fm1)
   plot(sres ~ fitted(fm1), ylab = "Standardized residuals",
       xlab = "Fitted values")  # plot 2, Figure 13.1
   abline(h = 0, lty = 2, lwd = 0)   # horizontal reference
}
plot(resid(fm1) ~ fitted(fm1), ylab = "Residuals",
     xlab = "Fitted values")  # alternative plot 2
abline(h = 0, lty = 2, lwd = 0)   # horizontal reference
plot(fitted(fm1) ~ emission, data = xmp13.01)
abline(0, 1)                  # plot 3, Figure 13.1
if (require(MASS)) {
   plot(sres ~ rate, data = xmp13.01) # plot 4
   abline(h = 0, lty = 2, lwd = 0)
   qqnorm(sres)               # plot 5
} else {
   plot(resid(fm1) ~ rate, data = xmp13.01) # plot 4
   qqnorm(resid(fm1))         # plot 5
}
## The residuals versus fitted plot and the normal
## probability plot of the standardized residuals 
plot(fm1, which = 1:2)
}
\keyword{datasets}
\eof
\name{xmp13.03}
\alias{xmp13.03}
\docType{data}
\title{data from Example 13.3}
\description{
  The \code{xmp13.03} data frame has 12 rows and 2 columns of data on tool
  lifetime versus cutting time.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      the cutting time (unknown units).
    }
    \item{ToolLife}{
      tool lifetime (unknown units).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1967) ``The effect of experimental error on the determination of
  optimum metal cutting conditions'', \emph{J. Eng. for Industry}, 315--322. 
}
\examples{
data(xmp13.03)
plot(ToolLife ~ time, data = xmp13.03)
plot(ToolLife ~ time, data = xmp13.03, log = "xy")
fm1 <- lm(log(ToolLife) ~ I(log(time)), data = xmp13.03)
summary(fm1)
plot(fm1, which = 1)     # plot of residuals versus fitted values
plot(exp(fitted(fm1)) ~ xmp13.03$ToolLife,
   xlab = "y", ylab = expression(hat("y")),
   main = "Compare to Figure 13.4, page 555")
abline(0, 1)       # reference line
}
\keyword{datasets}
\eof
\name{xmp13.04}
\alias{xmp13.04}
\docType{data}
\title{data from Example 13.4}
\description{
  The \code{xmp13.04} data frame has 11 rows and 2 columns on the
  ethylene content of lettuce seeds as a function of exposure time to an
  ethylene absorbent.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      exposure to an ethylene absorbent (min).
    }
    \item{Ethylene}{
      ethylene content of the seeds (nL/g dry wt).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1972), ``Ethylene synthesis in lettuce seeds: Its physiological
  significance'', \emph{Plant Physiology}, 719-722.
}
\examples{
data(xmp13.04)
plot(Ethylene ~ time, data = xmp13.04,
     xlab = "Exposure time (min)",
     ylab = "Ethylene content (nL/g dry wt)",
     main = "Compare to Figure 13.5 (a), page 556")
fm1 <- lm(Ethylene ~ time, data = xmp13.04)
abline(fm1)
plot(resid(fm1) ~ xmp13.04$time)
abline(h = 0, lty = 2)
title(main = "Compare to Figure 13.5 (b), page 556")
title(sub = "Using raw residuals instead of standardized")
fm2 <- lm(log(Ethylene) ~ time, data = xmp13.04)
plot(resid(fm2) ~ xmp13.04$time)
abline(h = 0, lty = 2)
title(main = "Compare to Figure 13.6 (a), page 557")
title(sub = "Using raw residuals instead of standardized")
summary(fm2)
plot(exp(fitted(fm2)) ~ xmp13.04$Ethylene)
}
\keyword{datasets}
\eof
\name{xmp13.06}
\alias{xmp13.06}
\docType{data}
\title{data from Example 13.6}
\description{
  The \code{xmp13.06} data frame has 24 rows and 2 columns of data on
  space shuttle launches.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Temperature}{
      launch temperature (degrees Fahrenheit).
    }
    \item{Failure}{
      a factor with levels
      \code{N} and
      \code{Y} indicating the incidence of failure of O-rings.
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.06)
fm1 <- glm(Failure ~ Temperature, 
    data = xmp13.06, family = "binomial")
## results are different from JMP results in Figure 13.9
summary(fm1)
temp <- seq(55, 85, len = 101)   # for doing the prediction
plot(
  predict(fm1, new = list(Temperature = temp), type = "resp") ~ temp,
  main = "Compare with Figure 13.8, page 560", type = "l",
  ylab = "P(F)")
}
\keyword{datasets}
\eof
\name{xmp13.07}
\alias{xmp13.07}
\docType{data}
\title{data from Example 13.6}
\description{
  The \code{xmp13.07} data frame has 16 rows and 2 columns on the yield
  of paddy (a grain farmed in India) versus the time of harvest.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{days}{
      date of harvesting (number of days after flowering.
    }
    \item{yield}{
      yield (kg/ha) of paddy
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  (1975), ``Determination of biological maturity and effect of harvesting
  and drying conditions on milling quality of paddy'',
  \emph{J. Agricultural Eng. Research}, 353-361
}
\examples{
data(xmp13.07)
plot(yield ~ days, data = xmp13.07,
   main = "Compare to Figure 13.11(a), page 579")
fm1 <- lm(yield ~ days + I(days^2), data = xmp13.07)
summary(fm1)
anova(fm1)
predict(fm1, list(days = 25), interval = "conf")
predict(fm1, list(days = 25), interval = "pred")
}
\keyword{datasets}
\eof
\name{xmp13.09}
\alias{xmp13.09}
\docType{data}
\title{data from Example 13.9}
\description{
  The \code{xmp13.09} data frame has 8 rows and 2 columns of data on
  cure temperature and ultimate sheer strength of rubber compounds.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{tempture}{
      cure temperature (degrees Fahrenheit).
    }
    \item{strength}{
      ultimate sheer strength (psi)
    }
  }
}

  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury 

  (1971), "A method for improving the accuracy of polynomial regression
  analysis",  \emph{J. Quality Technology}, 149--155.
}
\examples{
data(xmp13.09)
plot(strength ~ tempture, data = xmp13.09)
fm1 <- lm(strength ~ tempture + I(tempture^2), data = xmp13.09)
summary(fm1)
xmp13.09$Tcentered <- scale(xmp13.09$tempture, scale = FALSE)
fm2 <- lm(strength ~ Tcentered + I(Tcentered^2), data = xmp13.09)
summary(fm2)
## another approach using orthogonal polynomials
fm3 <- lm(strength ~ poly(tempture, 2), data = xmp13.09)
summary(fm3)
}
\keyword{datasets}
\eof
\name{xmp13.10}
\alias{xmp13.10}
\docType{data}
\title{data from Example 13.10}
\description{
  Ultimate shear strength of a rubber compound versus cure temperature.
}
\usage{data(xmp13.10)}
\format{
  A data frame with 8 observations on the following 3 variables.
  \describe{
    \item{x}{a numeric vector of cure temperatures (degrees Fahrenheit)}
    \item{x.}{a numeric vector of centered x values}
    \item{y}{a numeric vector of ultimate shear strength (psi)}
  }
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\references{
  ``A Method of Improving the Accuracy of Polynomial Regression
  Analysis'', \emph{J. Quality Technology}, 1971: 149-155.
}
\examples{
data(xmp13.10)
}
\keyword{datasets}
\eof
\name{xmp13.11}
\alias{xmp13.11}
\docType{data}
\title{data from Example 13.11}
\description{
  The \code{xmp13.11} data frame has 30 rows and 6 columns giving the
  ball bond shear strength from a wire bonding process and several
  covariates. 
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Observation}{
      observation number (not used).
    }
    \item{Force}{
      force (gm).
    }
    \item{Power}{
      power (mw).
    }
    \item{Temperature}{
      temperature (degrees Celsius).
    }
    \item{Time}{
      time (ms).
    }
    \item{Strength}{
      ball bond strength (gm).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury

  Vardeman, S. (1994) \emph{Statistics Engineering Problem Solving}, 
}
\examples{
data(xmp13.11)
fm1 <- lm(Strength ~ Force + Power + Temperature + Time,
     data = xmp13.11)
summary(fm1)
anova(fm1)
}
\keyword{datasets}
\eof
\name{xmp13.13}
\alias{xmp13.13}
\docType{data}
\title{data from Example 13.13}
\description{
  The \code{xmp13.13} data frame has 9 rows and 5 columns of data on
  characteristics of concrete.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{
      the \% limestone powder.
    }
    \item{x2}{
      the water-cement ratio.
    }
    \item{x1x2}{
      the interaction of limestone powder and water-cement ratio.
    }
    \item{strength}{
      the 28-day compressive strength (MPa).
    }
    \item{absorbability}{
      the absorbability (\%).
    }
  }
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.13)
fm1 <- lm(strength ~ x1 * x2, data = xmp13.13)
summary(fm1)
}
\keyword{datasets}
\eof
\name{xmp13.15}
\alias{xmp13.15}
\docType{data}
\title{data from Example 13.15}
\description{
The \code{xmp13.15} data frame has 13 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{index}{
a numeric vector
}
\item{iron}{
a numeric vector
}
\item{aluminum}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.15)
}
\keyword{datasets}
\eof
\name{xmp13.16}
\alias{xmp13.16}
\docType{data}
\title{data from Example 13.16}
\description{
The \code{xmp13.16} data frame has 30 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{press}{
a numeric vector
}
\item{HCHO}{
a numeric vector
}
\item{catalyst}{
a numeric vector
}
\item{temp}{
a numeric vector
}
\item{time}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.16)
}
\keyword{datasets}
\eof
\name{xmp13.18}
\alias{xmp13.18}
\docType{data}
\title{data from Example 13.18}
\description{
The \code{xmp13.18} data frame has 27 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{life}{
a numeric vector
}
\item{speed}{
a numeric vector
}
\item{load}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.18)
}
\keyword{datasets}
\eof
\name{xmp13.19}
\alias{xmp13.19}
\docType{data}
\title{data from Example 13.19}
\description{
The \code{xmp13.19} data frame has 31 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{tar}{
a numeric vector
}
\item{speed}{
a numeric vector
}
\item{tempture}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.19)
}
\keyword{datasets}
\eof
\name{xmp13.22}
\alias{xmp13.22}
\docType{data}
\title{data from Example 13.22}
\description{
The \code{xmp13.22} data frame has 10 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Strength}{
a numeric vector
}
\item{Sp.grav.}{
a numeric vector
}
\item{Moisture}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp13.22)
}
\keyword{datasets}
\eof
\name{xmp14.03}
\alias{xmp14.03}
\docType{data}
\title{data from Example 14.3}
\description{
The \code{xmp14.03} data frame has 24 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{onset}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp14.03)
}
\keyword{datasets}
\eof
\name{xmp14.10}
\alias{xmp14.10}
\docType{data}
\title{data from Example 14.10}
\description{
The \code{xmp14.10} data frame has 49 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Cholstrl}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp14.10)
}
\keyword{datasets}
\eof
\name{xmp14.13}
\alias{xmp14.13}
\docType{data}
\title{data from Example 14.13}
\description{
The \code{xmp14.13} data frame has 3 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Production.Line}{
a numeric vector
}
\item{Blemish}{
a numeric vector
}
\item{Crack}{
a numeric vector
}
\item{Location}{
a numeric vector
}
\item{Missing}{
a numeric vector
}
\item{Other}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp14.13)
}
\keyword{datasets}
\eof
\name{xmp14.14}
\alias{xmp14.14}
\docType{data}
\title{data from Example 14.14}
\description{
The \code{xmp14.14} data frame has 3 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Substand}{
a numeric vector
}
\item{Standard}{
a numeric vector
}
\item{Modern}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp14.14)
}
\keyword{datasets}
\eof
\name{xmp15.01}
\alias{xmp15.01}
\docType{data}
\title{data from Example 15.1}
\description{
The \code{xmp15.01} data frame has 15 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C1}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.01)
}
\keyword{datasets}
\eof
\name{xmp15.02}
\alias{xmp15.02}
\docType{data}
\title{data from Example 15.2}
\description{
The \code{xmp15.02} data frame has 8 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Log}{
a numeric vector
}
\item{Solvent.1}{
a numeric vector
}
\item{Solvent.2}{
a numeric vector
}
\item{Difference}{
a numeric vector
}
\item{Signed.rank}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.02)
}
\keyword{datasets}
\eof
\name{xmp15.03}
\alias{xmp15.03}
\docType{data}
\title{data from Example 15.3}
\description{
The \code{xmp15.03} data frame has 25 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{xi}{
a numeric vector
}
\item{Signed.Rank}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.03)
}
\keyword{datasets}
\eof
\name{xmp15.04}
\alias{xmp15.04}
\docType{data}
\title{data from Example 15.4}
\description{
The \code{xmp15.04} data frame has 12 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{conc}{
a numeric vector
}
\item{Area}{
a factor with levels
\code{Polluted} 
\code{Unpolluted} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.04)
}
\keyword{datasets}
\eof
\name{xmp15.06}
\alias{xmp15.06}
\docType{data}
\title{data from Example 15.6}
\description{
The \code{xmp15.06} data frame has 28 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{metabolc}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.06)
}
\keyword{datasets}
\eof
\name{xmp15.08}
\alias{xmp15.08}
\docType{data}
\title{data from Example 15.8}
\description{
The \code{xmp15.08} data frame has 11 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{strength}{
a numeric vector
}
\item{type}{
a factor with levels
\code{Epoxy} 
\code{Other} 
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.08)
}
\keyword{datasets}
\eof
\name{xmp15.09}
\alias{xmp15.09}
\docType{data}
\title{data from Example 15.9}
\description{
The \code{xmp15.09} data frame has 7 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{X4.inch}{
a numeric vector
}
\item{X6.inch}{
a numeric vector
}
\item{X8.inch}{
a numeric vector
}
\item{X10.inch}{
a numeric vector
}
\item{X12.inch}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.09)
}
\keyword{datasets}
\eof
\name{xmp15.10}
\alias{xmp15.10}
\docType{data}
\title{data from Example 15.10}
\description{
The \code{xmp15.10} data frame has 32 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{potental}{
a numeric vector
}
\item{emotion}{
a numeric vector
}
\item{subject}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp15.10)
}
\keyword{datasets}
\eof
\name{xmp16.01}
\alias{xmp16.01}
\docType{data}
\title{data from Example 16.1}
\description{
The \code{xmp16.01} data frame has 25 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{visc1}{
a numeric vector
}
\item{visc2}{
a numeric vector
}
\item{visc3}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.01)
}
\keyword{datasets}
\eof
\name{xmp16.04}
\alias{xmp16.04}
\docType{data}
\title{data from Example 16.4}
\description{
The \code{xmp16.04} data frame has 22 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{resist1}{
a numeric vector
}
\item{resist2}{
a numeric vector
}
\item{resist3}{
a numeric vector
}
\item{resist4}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.04)
}
\keyword{datasets}
\eof
\name{xmp16.06}
\alias{xmp16.06}
\docType{data}
\title{data from Example 16.6}
\description{
The \code{xmp16.06} data frame has 25 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{defects}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.06)
}
\keyword{datasets}
\eof
\name{xmp16.07}
\alias{xmp16.07}
\docType{data}
\title{data from Example 16.7}
\description{
The \code{xmp16.07} data frame has 24 rows and 1 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{flaws}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.07)
}
\keyword{datasets}
\eof
\name{xmp16.08}
\alias{xmp16.08}
\docType{data}
\title{data from Example 16.8}
\description{
The \code{xmp16.08} data frame has 16 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{obs1}{
a numeric vector
}
\item{obs2}{
a numeric vector
}
\item{obs3}{
a numeric vector
}
\item{obs4}{
a numeric vector
}
}
}
\details{
}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.08)
}
\keyword{datasets}
\eof
\name{xmp16.09}
\alias{xmp16.09}
\docType{data}
\title{data from Example 16.9}
\description{
The \code{xmp16.09} data frame has 16 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sample}{
a numeric vector
}
\item{xwl}{
a numeric vector
}
\item{xwl...40.15}{
a numeric vector
}
\item{dl}{
a numeric vector
}
\item{xwl...39.85}{
a numeric vector
}
\item{el}{
a numeric vector
}
}
}
%\details{}
\source{
  Devore, J. L. (2003) \emph{Probability and Statistics for Engineering
    and the Sciences (6th ed)}, Duxbury
}
\examples{
data(xmp16.09)
}
\keyword{datasets}
\eof
