### Name: KernSur
### Title: Bivariate kernel density estimation
### Aliases: KernSur
### Keywords: distribution smooth

### ** Examples

x <- c(2,4,6,8)                         # make up some x-y data
y <- x 

# calculate and plot a surface with zero correlation based on above data
op <- KernSur(x,y, xgridsize=50, ygridsize=50, correlation=0, 
        xbandwidth=1, ybandwidth=1, range.x=c(0,10), range.y=c(0,10))
image(op$xvals, op$yvals, op$zden, col=terrain.colors(100), axes=TRUE)
contour(op$xvals, op$yvals, op$zden, add=TRUE)
box()

# re-calculate and re-plot the above using a 0.8 correlation
op <- KernSur(x,y, xgridsize=50, ygridsize=50, correlation=0.8,
         xbandwidth=1, ybandwidth=1, range.x=c(0,10), range.y=c(0,10))
image(op$xvals, op$yvals, op$zden, col=terrain.colors(100), axes=TRUE)
contour(op$xvals, op$yvals, op$zden, add=TRUE)
box()

# calculate and plot a surface of the above data with an ascending
# correlation and bandwidths and a vector of equally spaced ordinates
bands <- c(1,1.1,1.2,1.3)
cors <- c(0,-0.2,-0.4,-0.6)
rnge.x <- seq(from=0, to=10, length=100)

op <- KernSur(x,y, xgridsize=50, ygridsize=50, correlation=cors, 
        xbandwidth=bands, ybandwidth=bands, range.x=rnge.x, range.y=c(0,10))
image(op$xvals, op$yvals, op$zden, col=terrain.colors(100), axes=TRUE)
contour(op$xvals, op$yvals, op$zden, add=TRUE)
box()




