### Name: cor.fit.mixture
### Title: Graphical Gaussian Models: Fit Mixture Distribution to Sample
###   Correlation Coefficients
### Aliases: cor.fit.mixture cor.prob.nonzero
### Keywords: htest

### ** Examples

# load GeneTS library
library(GeneTS)

# simulate mixture distribution
r <- rcor0(700, kappa=10)
u <- runif(200, min=-1, max=1)
rc <- c(r,u)

# estimate kappa and eta0 (=7/9)
cor.fit.mixture(r)
cor.fit.mixture(rc) 

# for comparison
cor0.estimate.kappa(r)
cor0.estimate.kappa(rc)

# posterior probabilities
r <- seq(-1,1, .01)
post.prob <- cor.prob.nonzero(r,kappa=10,eta0=7/9)
plot(r, post.prob, type="l")



