### Name: fdr.control
### Title: Controlling the False Discovery Rate in Multiple Testing
### Aliases: fdr.control
### Keywords: htest

### ** Examples

# load GeneTS library
library(GeneTS)

# load data set
data(caulobacter)

# how many genes and how many samples?
dim(caulobacter)

# p-values from Fisher's g test
pval.caulobacter <- fisher.g.test(caulobacter)

# FDR test on the level 0.05
fdr.control(pval.caulobacter, Q = 0.05)



