### Name: ggm.plot.graph
### Title: Graphical Gaussian Models: Plotting the Network
### Aliases: ggm.plot.graph ggm.make.graph show.edge.weights
### Keywords: hplot

### ** Examples

# load GeneTS library
library(GeneTS)
 
# generate random network with 20 nodes and 10 percent edges (=19 edges)
true.pcor <- ggm.simulate.pcor(20, 0.1)

# convert to edge list 
test.results <- ggm.test.edges(true.pcor, eta0=0.9, kappa=1000)[1:19,]

# generate graph object 
# NOTE: this requires the installation of the "graph" package
# (in the following "try" is used to avoid an error if the library is not installed)
try( gr <- ggm.make.graph( test.results, 20) )
try( gr )
try( show.edge.weights(gr) )

# plot network
# NOTE: this requires the installation of the "Rgraphviz" library
try ( ggm.plot.graph(gr))
nlab <- c("A","B","C","D","E","F","G","H","I","J","K",
            "L","M","N","O","P","Q","R","S", "T")
try( ggm.plot.graph(gr, nlab) )



