\name{IgM}
\alias{IgM}
\non_function{}
\title{Immunoglobulin G}
\description{
  Serum IgM
  in 298 children aged 6 months to 6 years.
}
\format{A single numeric vector (g/l).}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  3.2, Chapman & Hall.
}
\examples{
data(IgM)
stripchart(IgM,method="stack")
}
\keyword{datasets}
\eof
\name{ashina}
\alias{ashina}
\non_function{}
\title{Ashina's crossover trial}
\description{
  The \code{ashina} data frame has 16 rows and 3 columns.
  It contains data from a crossover trial for the effect of an NO
  synthase inhibitor on
  headaches. Visual analog scale recordings of pain level were made at
  baseline and at five time points after infusion of the drug or
  placebo. A score
  was calculated as the sum of the differences from baseline. All
  patients received both treatment and placebo in randomized order.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{vas.active}{ 
      a numeric vector. Summary score when given active substance.
    }
    \item{vas.plac}{
      a numeric vector. Summary score when given placebo treatment.
    }
    \item{grp}{
      a numeric vector code. 1: placebo first, 2: active first.
    }
  }
}
\source{
  Original data
}
\references{
  M.Ashina et al. (1999), \emph{Lancet} 353, pp. 287--289 
}
\examples{
data(ashina)
plot(vas.active~vas.plac,pch=grp,data=ashina)
abline(0,1)
}
\keyword{datasets}
\eof
\name{bp.obese}
\alias{bp.obese}
\non_function{}
\title{Obesity and blood pressure}
\description{
  The \code{bp.obese} data frame has 102 rows and 3 columns.
  It contains data from a random sample of Mexican-American adults in a
  small California town.
}
\format{
This data frame contains the following columns:
\describe{
\item{sex}{
a numeric vector code. 0: male, 1: female.
}
\item{obese}{
  a numeric vector. Ratio of actual weight to ideal weight from New York
  Metropolitan Life Tables.
}
\item{bp}{
  a numeric vector. Systolic blood pressure (mm Hg).
}
}
}
\source{
  B.W. Brown \& M. Hollander (1977), Statistics. A Biomedical Introduction,
  Wiley. 
}
\examples{
data(bp.obese)
plot(bp~obese,pch = ifelse(sex==1, "F", "M"), data = bp.obese)
}
\keyword{datasets}
\eof
\name{caesarean}
\non_function{}
\alias{caesarean}
\alias{caesar.shoe}
\title{Caesarean section and maternal shoe size}
\description{
  The table \code{caesar.shoe} contains the relation between caesarean
  section and maternal shoe sizes (UK sizes!)
}
\format{
  A matrix with two rows and six columns
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  10.1, Chapman & Hall.
}
\examples{
data(caesarean)
require(ctest)
prop.trend.test(caesar.shoe["Yes",],margin.table(caesar.shoe,2))
}
\keyword{datasets}
\eof
\name{coking}
\alias{coking}
\non_function{}
\title{Coking data}
\description{
  The \code{coking} data frame has 18 rows and 3 columns.
  It contains the time to coking in an experiment where the oven width
  and temperature were varied.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{width}{a factor with levels \code{4}, \code{8}, and
      \code{12}, giving the oven width in inches.}
    \item{temp}{a factor with levels \code{1600} and \code{1900},
      giving the temperature in Fahrenheit.}
    \item{time}{a numeric vector, time to coking.}
  }
}
\source{
  R.A. Johnson (1994), \emph{Miller and Freund's Probability and Statistics for
  Engineers}, 5th ed., Prentice-Hall. 
}
\examples{
data(coking)
attach(coking)
matplot(tapply(time,list(width,temp),mean))
detach(coking)
}
\keyword{datasets}
\eof
\name{cystfibr}
\alias{cystfibr}
\non_function{}
\title{Cystic fibrosis lung function data}
\description{
  The \code{cystfibr} data frame has 25 rows and 10 columns.
  It contains lung function data for cystic fibrosis patients (7--23 years
  old)
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{age}{a numeric vector. Age in years.}
    \item{sex}{a numeric vector code. 0: male, 1:female.}
    \item{height}{a numeric vector. Height (cm).}
    \item{weight}{a numeric vector. Weight (kg).}
    \item{bmp}{a numeric vector. Body mass (\% of normal).}
    \item{fev1}{a numeric vector. Forced expiratory volume.}
    \item{rv}{a numeric vector. Residual volume.}
    \item{frc}{a numeric vector. Functional residual capacity.}
    \item{tlc}{a numeric vector. Total lung capacity.}
    \item{pemax}{a numeric vector. Maximum expiratory pressure.}
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  12.11, Chapman & Hall.
}
\references{
  O'Neill et al. (1983) (full reference in Altman).
}
\keyword{datasets}
\eof
\name{energy}
\alias{energy}
\non_function{}
\title{Energy expenditure}
\description{
  The \code{energy} data frame has 22 rows and 2 columns.
  It contains data on the energy expenditure in groups of lean and obese women.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{expend}{
      a numeric vector. 24 hour energy expenditure (MJ).
    }
    \item{stature}{
      a factor with levels
      \code{lean} and 
      \code{obese}.
    }
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  9.4, Chapman & Hall.
}
\examples{
data(energy)
plot(expend~stature,data=energy)
}
\keyword{datasets}
\eof
\name{fake.trypsin}
\alias{fake.trypsin}
\non_function{}
\title{ Trypsin by age groups }
\description{
  The \code{trypsin} data frame has 271 rows and 3 columns.
  Serum levels of immunoreactive trypsin in healthy volunteers (faked!).
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{trypsin}{
      a numeric vector. Serum-trypsin in ng/ml.
    }
    \item{grp}{
      a numeric vector. Age coding. See below.
    }
    \item{grpf}{
      a factor with levels 
      \code{1}: age 10--19, 
      \code{2}: age 20--29,
      \code{3}: age 30--39,
      \code{4}: age 40--49,
      \code{5}: age 50--59, and
      \code{6}: age 60--69.
    }
  }
}
\details{
  Data have been simulated to match given group means and SD.
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  9.12, Chapman & Hall.
}
\examples{
data(fake.trypsin)
plot(trypsin~grp, data=fake.trypsin)
}
\keyword{datasets}
\eof
\name{graft.vs.host}
\alias{graft.vs.host}
\non_function{}
\title{Graft versus host disease}
\description{
  The \code{gvhd} data frame has 37 rows and 7 columns.
  It contains data from patients receiving a nondepleted allogenic bone
  marrow transplant, with the purpose of finding variables associated with
  the development of acute graft-versus-host disease.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{pnr}{
      a numeric vector. Patient number.
    }
    \item{rcpage}{
      a numeric vector. Age of recipient (years).
    }
    \item{donage}{
      a numeric vector. Age of donor (years).
    }
    \item{type}{
      a numeric vector, type of leukaemia coded 1: AML, 2: ALL, 3: CML
      for acute myeloid, acute lymphatic, and chronic myeloid leukaemia. 
    }
    \item{preg}{
      a numeric vector code, indicating whether donor has been pregnant. 0: no, 1: yes.
    }
    \item{index}{
      a numeric vector  giving an index of mixed epidermal cell-lymphocyte
      reactions. 
    }
    \item{gvhd}{
      a numeric vector code, graft versus host disease. 0: no, 1: yes.
    }
    \item{time}{a numeric vector. Follow-up time}
    \item{dead}{a numeric vector code 0: no (censored), 1: yes}
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research},
  Exercise 12.3, Chapman & Hall.
}
\examples{
data(graft.vs.host)
plot(jitter(gvhd,0.2)~index,data=graft.vs.host)
}
\keyword{datasets}
\eof
\name{heart.rate}
\alias{heart.rate}
\non_function{}
\title{Heart rates after enalaprilat}
\description{
 The \code{heart.rate} data frame has 36 rows and 3 columns.
 It contains data for nine patients with congestive heart failure before
 and shortly after administration of enalaprilat, in a balanced two-way
 layout.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{hr}{
      a numeric vector. Heart rate in beats per minute.
    }
    \item{subj}{
      a factor with levels
      \code{1} to \code{9}. 
    }
    \item{time}{
      a factor with levels
      \code{0} (before),
      \code{30}, 
      \code{60}, and 
      \code{120} (minutes after administration).
    }
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  12.2, Chapman & Hall.
}
\examples{
data(heart.rate)
evalq(interaction.plot(time,subj,hr), heart.rate)
}
\keyword{datasets}

\eof
\name{hellung}
\alias{hellung}
\non_function{}
\title{Growth of Tetrahymena cells}
\description{
  The \code{hellung} data frame has 51 rows and 3 columns.
  diameter and concentration of \emph{Tetrahymena} cells, with and without
  glucose added to growth medium.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{glucose}{
      a numeric vector code 1: yes, 2: no. 
    }
    \item{conc}{
      a numeric vector. Cell condentration (counts/ml)
    }
    \item{diameter}{
      a numeric vector. Cell diameter ($\mu$m)
    }
  }
}
\source{
  D. Kronborg and L.T. Skovgaard (1990), \emph{Regressionsanalyse},
  Table~1.1, FADLs Forlag (in Danish).
}
\examples{
data(hellung)
plot(diameter~conc,pch=glucose,log="xy",data=hellung)
}
\keyword{datasets}
\eof
\name{intake}
\alias{intake}
\non_function{}
\title{Energy intake}
\description{
The \code{intake} data frame has 11 rows and 2 columns.
It contains paired values of energy intake for 11 women.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{pre}{a numeric vector. Premenstrual intake (kJ).}
    \item{post}{a numeric vector. Postmenstrual intake (kJ).}
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  9.3, Chapman & Hall.
}

\examples{
data(intake)
plot(intake$pre, intake$post)
}
\keyword{datasets}
\eof
\name{juul}
\alias{juul}
\non_function{}
\title{Juul's IGF data}
\description{
  The \code{juul} data frame has 1339 rows and 6 columns.
  It contains a reference sample of the distribution of insulin-like
  growth factor (IGF-I), one observation per subject in various ages with the
  bulk of the data collected in connection with school physical
  examinations. 
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{age}{
      a numeric vector (years).
    }
    \item{menarche}{
      a numeric vector. Has menarche occurred (code 1: no, 2: yes)?
    }
    \item{sex}{
      a numeric vector (1: boy, 2: girl).
    }
    \item{igf1}{
      a numeric vector. Insulin-like growth factor ($\mu$g/l).
    }
    \item{tanner}{
      a numeric vector. Codes 1--5: Stages of puberty a.m. Tanner.
    }
    \item{testvol}{
      a numeric vector. Testicular volume (ml).
    }
  }
}
\source{
 Original data.
}
\examples{
data(juul)
plot(igf1~age, data=juul)
}
\keyword{datasets}
\eof
\name{juul2}
\alias{juul2}
\non_function{}
\title{Juul's IGF data, extended version}
\description{
  The \code{juul2} data frame has 1339 rows and 8 columns.
  Extended version of |juul|.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{age}{
      a numeric vector (years).
    }
    \item{height}{
      a numeric vector (cm).
    }
    \item{menarche}{
      a numeric vector. Has menarche occurred (code 1: no, 2: yes)?
    }
    \item{sex}{
      a numeric vector (1: boy, 2: girl).
    }
    \item{igf1}{
      a numeric vector. Insulin-like growth factor ($\mu$g/l).
    }
    \item{tanner}{
      a numeric vector. Codes 1--5: Stages of puberty a.m. Tanner.
    }
    \item{testvol}{
      a numeric vector. Testicular volume (ml).
    }
    \item{weight}{
      a numeric vector. Weight (kg).
    }
  }
}
\source{
 Original data.
}
\examples{
data(juul2)
plot(igf1~age, data=juul2)
}
\keyword{datasets}
\eof
\name{kfm}
\alias{kfm}
\non_function{}
\title{Breast-feeding data}
\description{
  The \code{kfm} data frame has 50 rows and 7 columns.
  It was collected by Kim Fleischer Michaelsen and contains data for 50
  infants of age approximately 2~months. They were weighed immediately
  before and
  after each breast feeding and the measured intake of breast milk was
  registered along with various other data.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{no}{
      a numeric vector. Identification number.
    }
    \item{dl.milk}{
      a numeric vector. Breast-milk intake (dl/24h).
    }
    \item{sex}{
      a factor with levels
      \code{boy} and
      \code{girl} 
    }
    \item{weight}{
      a numeric vector. Weight of child (kg).
    }
    \item{ml.suppl}{
      a numeric vector. Supplementary milk substitute (ml/24h).
    }
    \item{mat.weight}{
      a numeric vector. Weight of mother (kg).
    }
    \item{mat.height}{
      a numeric vector. Height of mother (cm).
    }
  }
}
\note{
  The amount of supplementary milk substitute refers to a period before
  the data collection.
}
\source{
 Original data.
}
\examples{
data(kfm)
plot(dl.milk~mat.height,pch=c(1,2)[sex],data=kfm)
}
\keyword{datasets}
\eof
\name{lung}
\alias{lung}
\non_function{}
\title{Methods for determining lung volume}
\usage{data(lung)}
\description{
The \code{lung} data frame has 18 rows and 3 columns. It contains data
on three different  methods  of determining human
  lung volume.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{volume}{a numeric vector. Measured lung volume.}
    \item{method}{a factor with levels \code{A}, \code{B}, and \code{C}. }
    \item{subject}{a factor with levels \code{1}--\code{6}.}
  }
}
\source{
 \emph{Exercises in Applied statistics} (1977), Exercise~4.15, Dept.\ of
 Theoretical Statistics,  
 Aarhus University.
}
\examples{
data(lung)
}
\keyword{datasets}
\eof
\name{malaria}
\alias{malaria}
\non_function{}
\title{Malaria antibody data}
\usage{data(malaria)}
\description{
The \code{malaria} data frame has 100 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{subject}{subject code.}
    \item{age}{age in years.}
    \item{ab}{antibody level.}
    \item{mal}{a numeric vector code: Malaria, 0/1 is no/yes, respectively. }
  }
}
\details{
  A random sample of 100
  children from a village in Ghana, aged 3--15 years. The children were
  followed for a period of 8 months. At the beginning of the study,
  values of a particular antibody were assessed. Based on observations
  during the study
  period, the children were categorized into two groups:
  individuals with and without symptoms of malaria.
}
\source{
 Unpublished data.
}
\examples{
data(malaria)
summary(malaria)
}
\keyword{datasets}
\eof
\name{melanom}
\alias{melanom}
\non_function{}
\title{Survival after malignant melanoma}
\description{
  The \code{melanom} data frame has 205 rows and 7 columns.
  It contains data relating to survival of patients after operation for
  malignant melanoma collected at Odense University Hospital by K.T.
  Drzewiecki. 
}
\format{
This data frame contains the following columns:
\describe{
\item{no}{
a numeric vector. Patient code.
}
\item{status}{
a numeric vector code. Survival status. 1: dead from melanoma, 2: alive,
3: dead from other cause.
}
\item{days}{
a numeric vector. Observation time.
}
\item{ulc}{
a numeric vector code. Ulceration, 1: present, 2: absent.
}
\item{thick}{
a numeric vector. Tumor thickness (1/100 mm).
}
\item{sex}{
a numeric vector code. 1: female, 2: male.
}
}
}
\source{
  P.K. Andersen, {\O}. Borgan, R.D. Gill, N. Keiding (1991),
  \emph{Statistical Models Based on 
  Counting Processes}, Appendix 1, Springer-Verlag. 
}
\examples{
data(melanom)
require(survival)
plot(survfit(Surv(days,status==1),data=melanom))
}
\keyword{datasets}
\eof
\name{react}
\alias{react}
\non_function{}
\title{Tuberculin reactions}
\format{
  A single vector. Reaction sizes in mm.
}
\description{
  The numeric vector \code{react} contains differences between two
  nurses' determination of 334 tuberculin reaction sizes.
}
 \emph{Exercises in Applied statistics} (1977), Exercise~2.9, Dept.\ of
 Theoretical Statistics,  
 Aarhus University.
}
\examples{
data(react)
hist(react) # not good because of discretization effects...
plot(density(react))
}
\keyword{datasets}
\eof
\name{red.cell.folate}
\alias{red.cell.folate}
\non_function{}
\title{Red cell folate data}
\description{
  The \code{folate} data frame has 22 rows and 2 columns.
  It contains data on red cell folate levels in patients receiving three
  different methods of ventilation during  anesthesia.
}
\format{
This data frame contains the following columns:
\describe{
  \item{folate}{
    a numeric vector. Folate concentration ($\mu$g/l).
  }
  \item{ventilation}{
    a factor with levels
    \code{N2O+O2,24h}: 50\% nitrous oxide and 50\% oxygen, continuously for
    24~hours; 
    \code{N2O+O2,op}:  50\% nitrous oxide and 50\% oxygen, only during operation;
    \code{O2,24h}: no nitrous oxide, but 35--50\% oxygen for 24~hours.
}
}
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  9.10, Chapman & Hall.
}
\examples{
data(red.cell.folate)
plot(folate~ventilation,data=red.cell.folate)
}
\keyword{datasets}
\eof
\name{rmr}
\alias{rmr}
\non_function{}
\title{Resting metabolic rate}
\description{
The \code{rmr} data frame has 44 rows and 2 columns.
It contains resting metabolic rate and body weight for 44 women.
}
\format{
This data frame contains the following columns:
\describe{
\item{body.weight}{
a numeric vector. Body weight (kg).
}
\item{metabolic.rate}{
a numeric vector. Metabolic rate (kcal/24~hr).
}
}
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research},
  Exercise~11.2, Chapman & Hall. 
}

\examples{
data(rmr)
plot(metabolic.rate~body.weight,data=rmr)
}
\keyword{datasets}
\eof
\name{secher}
\alias{secher}
\non_function{}
\title{Birth weight and ultrasonography}
\description{
The \code{secher} data frame has 107 rows and 4 columns. It contains
ultrasonographic measurements of fetuses immediately before birth and
subsequent 
birth weight.
}
\format{
This data frame contains the following columns:
\describe{
\item{bwt}{
a numeric vector. Birth weight (g).
}
\item{bpd}{
a numeric vector. Biparietal diameter (mm).
}
\item{ad}{
a numeric vector. Abdominal diameter (mm).
}
\item{no}{
a numeric vector. Observation number.
}
}
}
\source{
  D. Kronborg and L.T. Skovgaard (1990), \emph{Regressionsanalyse},
  Table~3.1, FADLs Forlag (in Danish).

  Secher et al. (1987), Eur.j.obs.gyn.repr.biol., 24, 1--11.
}
\examples{
data(secher)
plot(bwt~ad, data=secher, log="xy")
}
\keyword{datasets}
\eof
\name{secretin}
\alias{secretin}
\non_function{}
\title{Secretin-induced blood glucose changes}
\usage{data(secretin)}
\description{
The \code{secretin} data frame has 50 rows and 6 columns. It contains
data from a glucose response experiment.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{gluc}{a numeric vector. Blood glucose level.}
    \item{person}{a factor with levels \code{A}--\code{E}.}
    \item{time}{a factor with levels \code{20}, \code{30}, \code{60}, \code{90} 
      (minutes since injection), and \code{pre} (before injection).}
    \item{repl}{a factor with levels
      {\code{a}: 1st sample} and
      {\code{b}: 2nd sample}.}
    \item{time20plus}{a factor with levels
      {\code{20+}: 20 minutes or longer since injection} and
      {\code{pre}: before injection.}}
    \item{time.comb}{a factor with levels
      {\code{20}:  20 minutes since injection},
      {\code{30+}: 30 minutes or longer since injection}, and
      {\code{pre}: before injection.  }}
  }
}
\details{
 Secretin is a hormone of the duodenal mucous membrane. An extract was
 administered to five patients with arterial hypertension. Primary
 registrations (double determination) of blood glucose were on graph
 paper, later quantified with the smallest of the two measurements
 recorded first.}
 
\source{
 \emph{Exercises in Applied statistics} (1977), Exercise~5.8, Dept.\ of
 Theoretical Statistics,  
 Aarhus University.
}
\examples{
data(secretin)
}
\keyword{datasets}
\eof
\name{tb.dilute}
\alias{tb.dilute}
\non_function{}
\title{Tuberculin dilution assay}
\usage{data(tb.dilute)}
\description{
The \code{tb.dilute} data frame has 18 rows and 3 columns. It contains
data from a drug test involving dilutions of tuberculin.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{reaction}{a numeric vector. Reaction sizes (average of diameters) for tuberculin skin pricks.}
    \item{animal}{a factor with levels \code{1}--\code{6}.}
    \item{logdose}{a factor with levels \code{0.5}, \code{0}, and \code{-0.5}.}
  }
}
\details{The actual dilutions were 1:100, 1:100$\sqrt{10}$, 1:1000. 
  Setting the middle one to 1 and using base-10 logarithms gives 
  the \code{logdose} values.}
\source{
 \emph{Exercises in Applied statistics} (1977), part of Exercise~4.15,
 Dept.\ of 
 Theoretical Statistics,  
 Aarhus University.
}
\examples{
data(tb.dilute)
}
\keyword{datasets}
\eof
\name{thuesen}
\alias{thuesen}
\non_function{}
\title{Ventricular shortening velocity}
\description{
The \code{thuesen} data frame has 24 rows and 2 columns.
It contains ventricular shortening velocity and blood glucose for type 1
diabetic patients.  
}
\format{
This data frame contains the following columns:
\describe{
\item{blood.glucose}{
a numeric vector. Fasting blood glucose (mmol/l).
}
\item{short.velocity}{ 
a numeric vector. Mean circumferential shortening velocity (\%/s).
}
}
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  11.6, Chapman & Hall.
}
\examples{
data(thuesen)
plot(short.velocity~blood.glucose, data=thuesen)
}
\keyword{datasets}
\eof
\name{tlc}
\alias{tlc}
\non_function{}
\title{Total lung capacity}
\description{
The \code{tlc} data frame has 32 rows and 4 columns. It contains data on
pretransplant total lung capacity (TLC) for recipients of heart-lung
transplants, by whole-body plethysmography.
}
\format{
This data frame contains the following columns:
\describe{
\item{age}{
a numeric vector. Age of recipient (years).
}
\item{sex}{
a numeric vector code. Female:~1, male:~2.
}
\item{height}{
a numeric vector. Height of recipient (cm).
}
\item{tlc}{
a numeric vector. Total lung capacity (l).
}
}
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research},
  Exercise 12.5,  10.1, Chapman & Hall.
}
\examples{
data(tlc)
plot(tlc~height,data=tlc)
}
\keyword{datasets}
\eof
\name{vitcap}
\alias{vitcap}
\non_function{}
\title{Vital capacity}
\description{
The \code{vitcap} data frame has 24 rows and 3 columns.
It contains data on vital capacity for workers in the cadmium industry.
It is a subset of the \code{vitcap2} data set.
}
\format{
This data frame contains the following columns:
\describe{
\item{group}{
a numeric vector. Group codes are 1: Exposed > 10~years, 3: Not exposed.
}
\item{age}{
a numeric vector. Age in years.
}
\item{vital.capacity}{
a numeric vector. Vital capacity (a measure of lung volume) in liters.
}
}
}
\source{
  P. Armitage and G. Berry (1987), \emph{Statistical Methods in Medical Research}, 2nd ed., Blackwell, p.~286.
}
\examples{
data(vitcap)
plot(vital.capacity~age, pch=group, data=vitcap)
}
\keyword{datasets}
\eof
\name{vitcap2}
\alias{vitcap2}
\non_function{}
\title{Vital capacity, full data set}
\description{
The \code{vitcap2} data frame has 84 rows and 3 columns,
age and vital capacity for workers in the cadmium industry.
}
\format{
This data frame contains the following columns:
\describe{
\item{group}{
  a numeric vector. Group codes are 1: Exposed > 10~years,
  2: Exposed < 10~years, 3: Not exposed.
}
\item{age}{
a numeric vector. Age in years.
}
\item{vital.capacity}{
a numeric vector. Vital capacity (a measure of lung volume) (l).
}
}
}
\source{
  P. Armitage and G. Berry (1987), \emph{Statistical Methods in Medical Research}, 2nd ed., Blackwell, p.~286.
}
\examples{
data(vitcap2)
plot(vital.capacity~age, pch=group, data=vitcap2)
}
\keyword{datasets}
\eof
\name{wright}
\alias{wright}
\non_function{}
\title{Comparison of Wright peak-flow meters}
\description{
The \code{wright} data frame has 17 rows and 2 columns.
It contains data on peak expiratory flow rate with two different flow
meters on each of 17 subjects. 
}
\format{
This data frame contains the following columns:
\describe{
\item{std.wright}{
a numeric vector. Data from large flow meter (l/min).
}
\item{mini.wright}{
a numeric vector. Data from mini flow meter (l/min).
}
}
}
\source{
J.M. Bland and D.G. Altman (1986), \emph{Lancet}, pp. 307--310.
}
\examples{
data(wright)
plot(wright)
abline(0,1)
}
\keyword{datasets}
\eof
\name{zelazo}
\alias{zelazo}
\non_function{}
\title{Age at walking}
\usage{data(zelazo)}
\description{The \code{zelazo} object is a list with four components.} 
\format{
  This is a list containing data on age at
  walking (in months) for four groups of infants: 
\describe{
\item{active}{test group receiving active training. These children had
  their walking and placing reflexes
  trained during four three-minute sessions that took place every day
  from their second to their eighth week of life.}
\item{passive}{passive training group. Received the same types of
  social and gross motor stimulation, 
  but did not have their specific walking and placing reflexes
  trained. }
\item{none}{no training.  Had no special training, but
  were tested along with the children who underwent active or passive
  training.}
\item{ctr.8w}{eigth-week controls. Had no training and were only
  tested at the age of 8 weeks. }
}
}
\source{P.R.~Zelazo, N.A.~Zelazo, and S.~Kolb (1972),
  ``Walking'' in the newborn, \emph{Science}, 176, 314--315.
}
\note{When asked to enter these data from a text source, many
students will use one vector per group and will need to reformat data
into a data frame for some uses. The rather unusual format of this data set
mimics that situation. 
}
\examples{
data(zelazo)
}
\keyword{datasets}



\eof
