\name{aids}
\alias{aids}
\non_function{}
\title{data from Section 1.19}
\description{
  The \code{aids} data frame has 295 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{infect}{
      Infection time for AIDS, years
    }
    \item{induct}{
      Induction time for AIDS, years
    }
    \item{adult}{
      Indicator of adult (1=adult, 0=child)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Lagakos et al. Biometrika 68 (1981): 515-523. 
}
\examples{
data(aids)
}
\keyword{datasets}

\eof
\name{alloauto}
\alias{alloauto}
\non_function{}
\title{data from Section 1.9}
\description{
  The \code{alloauto} data frame has 90 rows and 5 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      Time to death or relapse, months
    }
    \item{type}{
      Type of transplant (1=allogeneic, 2=autologous)
    }
    \item{delta}{
      Leukemia-free survival indicator (0=alive without relapse, 1=dead
      or relapse)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Kardaun Stat. Nederlandica 37 (1983), 103-126.
}
\examples{
data(alloauto)
}
\keyword{datasets}

\eof
\name{allograft}
\alias{allograft}
\non_function{}
\title{data from Exercise 13.1, p418}
\description{
  The \code{allograft} data frame has 34 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{patient}{
      Patient
    }
    \item{time}{
      Time to graft rejection, days
    }
    \item{rejection}{
      Indicator of graft rejection (1=yes, 0=no)
    }
    \item{match}{
      Good HLA skin match (1=yes, 0=no)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Batchelor and Hackett Lancet 2 (1970): 581-583.
}
\examples{
data(allograft)
}
\keyword{datasets}

\eof
\name{azt}
\alias{azt}
\non_function{}
\title{data from Exercise 4.7, p122}
\description{
  The \code{azt} data frame has 45 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{patient}{
      Patient number
    }
    \item{ageentry}{
      Age at entry into AZT study, months
    }
    \item{age}{
      Age at death or censoring time, months
    }
    \item{death}{
      Death indicator (1=dead, 0=alive) 
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(azt)
}
\keyword{datasets}

\eof
\name{baboon}
\alias{baboon}
\non_function{}
\title{data from Exercise 5.8, p147}
\description{
  The \code{baboon} data frame has 25 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{date}{
      Date (day/month/year)
    }
    \item{time}{
      Descent time (military time)
    }
    \item{observed}{
      Indicator of observed or not (1=observed, 0=not observed)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(baboon)
}
\keyword{datasets}

\eof
\name{bcdeter}
\alias{bcdeter}
\non_function{}
\title{data from Section 1.18}
\description{
  The \code{bcdeter} data frame has 92 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{lower}{
      Lower limit of interval, months
    }
    \item{upper}{
      Upper limit of interval, months
    }
    \item{treat}{
      Treatment regimen (1=radiotherapy only, 2=radiotherapy + chemotherapy) 
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Beadle et al Cancer 54 (1984):2911-2918.
}
\examples{
data(bcdeter)
}
\keyword{datasets}

\eof
\name{bfeed}
\alias{bfeed}
\non_function{}
\title{data from Section 1.14}
\description{
  The \code{bfeed} data frame has 927 rows and 10 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{duration}{
      Duration of breast feeding, weeks
    }
    \item{delta}{
      Indicator of completed breast feeding (1=yes, 0=no)
    }
    \item{race}{
      Race of mother (1=white, 2=black, 3=other)
    }
    \item{poverty}{
      Mother in poverty (1=yes, 0=no)
    }
    \item{smoke}{
      Mother smoked at birth of child (1=yes, 0=no)
    }
    \item{alcohol}{
      Mother used alcohol at birth of child (1=yes, 0=no)
    }
    \item{agemth}{
      Age of mother at birth of child
    }
    \item{ybirth}{
      Year of birth
    }
    \item{yschool}{
      Education level of mother (years of school)
    }
    \item{pc3mth}{
      Prenatal care after 3rd month (1=yes, 0=no)       
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  \emph{National Longitudinal Survey of Youth Handbook} The Ohio State University, 1995.
}
\examples{
data(bfeed)
}
\keyword{datasets}

\eof
\name{bmt}
\alias{bmt}
\non_function{}
\title{data from Section 1.3}
\description{
  The \code{bmt} data frame has 137 rows and 22 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{group}{
      Disease Group 1-ALL, 2-AML Low Risk, 3-AML High Risk
    }
    \item{t1}{
      Time To Death Or On Study Time
    }
    \item{t2}{
      Disease Free Survival Time (Time To Relapse, Death Or End Of Study)
    }
    \item{d1}{
      Death Indicator 1-Dead 0-Alive
    }
    \item{d2}{
      Relapse Indicator 1-Relapsed, 0-Disease Free
    }
    \item{d3}{
      Disease Free Survival Indicator 1-Dead Or Relapsed, 0-Alive Disease Free)
    }
    \item{ta}{
      Time To Acute Graft-Versus-Host Disease
    }
    \item{da}{
      Acute GVHD Indicator 1-Developed Acute GVHD 0-Never Developed Acute GVHD)
    }
    \item{tc}{
      Time To Chronic Graft-Versus-Host Disease
    }
    \item{dc}{
      Chronic GVHD Indicator 1-Developed Chronic GVHD 0-Never Developed Chronic GVHD 
    }
    \item{tp}{
      Time To Chronic Graft-Versus-Host Disease
    }
    \item{dp}{
      Platelet Recovery Indicator 1-Platelets Returned To Normal, 0-Platelets Never Returned to Normal
    }
    \item{z1}{
      Patient Age In Years
    }
    \item{z2}{
      Donor Age In Years
    }
    \item{z3}{
      Patient Sex: 1-Male, 0-Female
    }
    \item{z4}{
      Donor Sex: 1-Male, 0-Female
    }
    \item{z5}{
      Patient CMV Status: 1-CMV Positive, 0-CMV Negative
    }
    \item{z6}{
      Donor CMV Status: 1-CMV Positive, 0-CMV Negative
    }
    \item{z7}{
      Waiting Time to Transplant In Days
    }
    \item{z8}{
      FAB: 1-FAB Grade 4 Or 5 and AML, 0-Otherwise
    }
    \item{z9}{
      Hospital: 1-The Ohio State University, 2-Alferd , 3-St. Vincent, 4-Hahnemann
    }
    \item{z10}{
      MTX Used as a Graft-Versus-Host- Prophylactic: 1-Yes 0-No
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(bmt)
}
\keyword{datasets}

\eof
\name{bnct}
\alias{bnct}
\non_function{}
\title{data from Exercise 7.7, p223}
\description{
  The \code{bnct} data frame has 34 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{trt}{
      Treatment (1=untreated, 2=radiated, 3=radiated + BPA)
    }
    \item{time}{
      Death time or on-study time, days
    }
    \item{death}{
      Death indicator (1=dead, 0=alive)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(bnct)
}
\keyword{datasets}

\eof
\name{btrial}
\alias{btrial}
\non_function{}
\title{data from Section 1.5}
\description{
  The \code{btrial} data frame has 45 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      Time to death or on-study time, months
    }
    \item{death}{
      Death indicator (0=alive, 1=dead) 
    }
    \item{im}{
      Immunohistochemical response (1=negative, 2=positive)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Sedmak el al. Modern Pathology 2 (1989): 516-520.
}
\examples{
data(btrial)
}
\keyword{datasets}

\eof
\name{burn}
\alias{burn}
\non_function{}
\title{data from Section 1.6}
\description{
  The \code{burn} data frame has 154 rows and 17 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Obs}{
      Observation number
    }
    \item{Z1}{
      Treatment: 0-routine bathing 1-Body cleansing
    }
    \item{Z2}{
      Gender (0=male 1=female)
    }
    \item{Z3}{
      Race: 0=nonwhite 1=white
    }
    \item{Z4}{
      Percentage of total surface area burned
    }
    \item{Z5}{
      Burn site indicator: head 1=yes, 0=no
    }
    \item{Z6}{
      Burn site indicator: buttock 1=yes, 0=no
    }
    \item{Z7}{
      Burn site indicator: trunk 1=yes, 0=no
    }
    \item{Z8}{
      Burn site indicator: upper leg 1=yes, 0=no
    }
    \item{Z9}{
      Burn site indicator: lower leg 1=yes, 0=no
    }
    \item{Z10}{
      Burn site indicator: respiratory tract 1=yes, 0=no
    }
    \item{Z11}{
      Type of burn: 1=chemical, 2=scald, 3=electric, 4=flame
    }
    \item{T1}{
      Time to excision or on study time
    }
    \item{D1}{
      Excision indicator: 1=yes 0=no
    }
    \item{T2}{
      Time to prophylactic antibiotic treatment or on study time
    }
    \item{D2}{
      Prophylactic antibiotic treatment: 1=yes 0=no
    }
    \item{T3}{
      Time to straphylocous aureaus infection or on study time
    }
    \item{D3}{
      Straphylocous aureaus infection: 1=yes 0=no
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Ichida et al. Stat. Med. 12 (1993): 301-310.
}
\examples{
data(burn)
}
\keyword{datasets}

\eof
\name{channing}
\alias{channing}
\non_function{}
\title{data from Section 1.16}
\description{
  The \code{channing} data frame has 462 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{obs}{
      Observation number
    }
    \item{death}{
      Death status (1=dead, 0=alive)
    }
    \item{ageentry}{
      Age of entry into retirement home, months
    }
    \item{age}{
      Age of death or left retirement home, months
    }
    \item{time}{
      Difference between the above two ages, months
    }
    \item{gender}{
      Gender (1=male, 2=female)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Hyde Biometrika (1977), 225-230.
}
\examples{
data(channing)
}
\keyword{datasets}

\eof
\name{drug6mp}
\alias{drug6mp}
\non_function{}
\title{data from Section 1.2}
\description{
  The \code{drug6mp} data frame has 21 rows and 5 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{pair}{
      pair number
    }
    \item{remstat}{
      Remission status at randomization (1=partial, 2=complete)
    }
    \item{t1}{
      Time to relapse for placebo patients, months 
    }
    \item{t2}{
      Time to relapse for 6-MP patients, months 
    }
    \item{relapse}{
      Relapse indicator (0=censored, 1=relapse) for 6-MP patients
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Freireich et al. (1963) \emph{Blood} 21: 699-716.
}
\examples{
data(drug6mp)
}
\keyword{datasets}

\eof
\name{drughiv}
\alias{drughiv}
\non_function{}
\title{data from Exercise 7.6, p222}
\description{
  The \code{drughiv} data frame has 34 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{drug}{
      Drug combination (1=AZT + zalcitabine, 2=AZT + zalcitabine +
      saquinavir)
    }
    \item{time}{
      Time after drug administration to CD4 count at a specified level,
      days
    }
    \item{delta}{
      Indicator of CD4 count reaching specified level (1=yes, 0=no) 
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(drughiv)
}
\keyword{datasets}

\eof
\name{hodg}
\alias{hodg}
\non_function{}
\title{data from Section 1.10}
\description{
  The \code{hodg} data frame has 43 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{gtype}{
      Graft type (1=allogenic, 2=autologous)
    }
    \item{dtype}{
      Disease type (1=Non Hodgkin lymphoma, 2=Hodgkins disease)
    }
    \item{time}{
      Time to death or relapse, days
    }
    \item{delta}{
      Death/relapse indicator (0=alive, 1=dead)
    }
    \item{score}{
      Karnofsky score
    }
    \item{wtime}{
      Waiting time to transplant in months
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Avalos et al. Bone Marrow Transplantation 13(1993):133-138.
}
\examples{
data(hodg)
}
\keyword{datasets}

\eof
\name{kidney}
\alias{kidney}
\non_function{}
\title{data from Section 1.4}
\description{
  The \code{kidney} data frame has 119 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      Time to infection, months 
    }
    \item{delta}{
      Infection indicator (0=no, 1=yes)
    }
    \item{type}{
      Catheter placement (1=surgically, 2=percutaneously)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Nahman el at. J. Am Soc. Nephrology 3 (1992): 103-107.
}
\examples{
data(kidney)
}
\keyword{datasets}

\eof
\name{kidrecurr}
\alias{kidrecurr}
\docType{data}
\title{Data on 38 individuals using a kidney dialysis machine}
\description{
  Data on 38 individuals using a kidney dialysis machine See Problem 13.5.2
}
\usage{data(kidrecurr)}
\format{
  A data frame with 38 observations on the following 10 variables.
  \describe{
    \item{patient}{Patient number}
    \item{time1}{Time one of recurrence of infection, days}
    \item{infect1}{Indicator infection one (1=yes, 0=no)}
    \item{time2}{Time two of recurrence of infection, days}
    \item{infect2}{Indicator infection two (1=yes, 0=no)}
    \item{age}{Patient's age}
    \item{gender}{Patient's gender}
    \item{gn}{Disease type GN (1=yes, 0=no)}
    \item{an}{Disease type AN (1=yes, 0=no)}
    \item{pkd}{Disease type PKD (1=yes, 0=no)}
  }
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  McGilchrist and Aisbett 47 (1991):461-466.
}
}
\examples{
data(kidrecurr)
}
\keyword{datasets}

\eof
\name{kidtran}
\alias{kidtran}
\non_function{}
\title{data from Section 1.7}
\description{
  The \code{kidtran} data frame has 863 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{obs}{
      Observation number
    }
    \item{time}{
      Time to death or on-study time
    }
    \item{delta}{
      Death indicator (0=alive, 1=dead)
    }
    \item{gender}{
      1=male, 2=female
    }
    \item{race}{
      1=white, 2=black
    }
    \item{age}{
      Age in years
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(kidtran)
}
\keyword{datasets}

\eof
\name{larynx}
\alias{larynx}
\non_function{}
\title{data from Section 1.8}
\description{
  The \code{larynx} data frame has 90 rows and 5 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{stage}{
      Stage of disease (1=stage 1, 2=stage2, 3=stage 3, 4=stage 4)
    }
    \item{time}{
      Time to death or on-study time, months
    }
    \item{age}{
      Age at diagnosis of larynx cancer
    }
    \item{diagyr}{
      Year of diagnosis of larynx cancer
    }
    \item{delta}{
      Death indicator (0=alive, 1=dead)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Kardaun Stat. Nederlandica 37 (1983), 103-126.
}
\examples{
data(larynx)
}
\keyword{datasets}

\eof
\name{lifetab}
\alias{lifetab}
\title{ Create cohort life table }
\description{
  Create cohort life table.
}
\usage{
lifetab(tis, ninit, nlost, nevent)
}
\arguments{
  \item{tis}{ a vector of end points of time intervals, whose length is
    1 greater than nlost and nevent. }
  \item{ninit}{ the number of subjects initially entering the study. }
  \item{nlost}{ a vector of the number of individuals lost follow or
    withdrawn alive for whatever reason. }
  \item{nevent}{ a vector of the number of individuals who experienced
    the event }
}
\value{
  A data.frame with the following columns:
  \item{nsubs}{ the number of subject entering the intervals
    who have not experienced the event.}
  \item{nlost}{ the number of individuals lost follow or
    withdrawn alive for whatever reason. }
  \item{nrisk}{ the estimated number of individuals at risk of
    experiencing the event. }
  \item{nevent}{ the number of individuals who experienced
    the event. }
  \item{surv}{ the estimated survival function at the start
    of the intervals. }
  \item{pdf}{ the estimated probability density function at
    the midpoint of the intervals. }
  \item{hazard}{ the estimated hazard rate at the midpoint
    of the intervals. }
  \item{se.surv}{ the estimated standard deviation of survival at the
    beginning of the intervals. }
  \item{se.pdf}{ the estimated standard deviation of the prbability
    density function at the midpoint of the intervals. }
  \item{se.hazard}{ the estimated standard deviation of the hazard
    function at the midpoint of the intervals}
  The row.names are the intervals.
}
\author{ Jun Yan \email{jyan@stat.uiowa.edu} }
\examples{
tis <- c(0, 2, 3, 5, 7, 11, 17, 25, 37, 53, NA)
nsubs <- c(927, 848, 774, 649, 565, 449, 296, 186, 112, 27)
nlost <- c(2, 3, 6, 9, 7, 5, 3, rep(0, 3))
nevent <- c(77, 71, 119, 75, 109, 148, 107, 74, 85, 27)

lifetab(tis, nsubs[1], nlost, nevent)
}
\keyword{ manip }

\eof
\name{lung}
\alias{lung}
\non_function{}
\title{data from Exercise 4.4, p120}
\description{
  The \code{lung} data frame has 25 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      Days to death
    }
    \item{death}{
      Death indicator (1=dead), complete follow-up on all patients
    }
    \item{time2}{
      Days to 3/31/80 or death (interim analysis)
    }
    \item{death2}{
      Death indicator as of 3/31/80 (1=dead, 0=alive)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(lung)
}
\keyword{datasets}

\eof
\name{pneumon}
\alias{pneumon}
\non_function{}
\title{data from Section 1.13}
\description{
  The \code{pneumon} data frame has 3470 rows and 15 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{chldage}{
      Age child had pneumonia, months
    }
    \item{hospital}{
      Indicator for hospitalization for pneumonia (1=yes, 0=no)
    }
    \item{mthage}{
      Age of the mother, years
    }
    \item{urban}{
      Urban environment for mother (1=yes, 0=no)
    }
    \item{alcohol}{
      Alcohol use by mother during pregnancy (1=yes, 0=no)
    }
    \item{smoke}{
      Cigarette use by mother during pregnancy (1=yes, 0=no)
    }
    \item{region}{
      Region of the coutry (1=northeast, 2=north central, 3=south,
      4=west)
    }
    \item{poverty}{
      Mother at poverty level (1=yes, 0=no)
    }
    \item{bweight}{
      Normal birthweight (>5.5 lbs.) (1=yes, 0=no)
    }
    \item{race}{
      Race of the mother (1=white, 2=black, 3=other)
    }
    \item{education}{
      Education of the mother, years of school
    }
    \item{nsibs}{
      Number of siblings of the child
    }
    \item{wmonth}{
      Month the child was weaned
    }
    \item{sfmonth}{
      Month the child on solid food
    }
    \item{agepn}{
      Age child in the hospital for pneumonia, months 
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  \emph{National Longitudinal Survey of Youth Handbook} The Ohio State University, 1995.
}
\examples{
data(pneumon)
}
\keyword{datasets}

\eof
\name{psych}
\alias{psych}
\non_function{}
\title{data from Section 1.15}
\description{
  The \code{psych} data frame has 927 rows and 10 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{sex}{
      Patient sex (1=male, 2=female)
    }
    \item{age}{
      Patient age
    }
    \item{time}{
      Time to death or on-study time
    }
    \item{death}{
      Death indicator (0=alive, 1=dead)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Woolsen Biometrics 37 (1981): 687-696.
}
\examples{
data(psych)
}
\keyword{datasets}

\eof
\name{bnct}
\alias{rats}
\non_function{}
\title{data from Exercise 7.13, p225}
\description{
  The \code{rats} data frame has 50 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{
      Time to tumor development
    }
    \item{tumor}{
      Indicator of tumor development (1=yes, 0=no)
    }
    \item{trt}{
      Treatment (1=treated with drug, 0=given placebo)
    }
    \item{litter}{
      Litter
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(rats)
}
\keyword{datasets}

\eof
\name{std}
\alias{std}
\non_function{}
\title{data from Section 1.12}
\description{
  The \code{std} data frame has 877 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{obs}{
      Observation number
    }
    \item{race}{
      Race (W=white, B=black)
    }
    \item{marital}{
      Marital status (D=divorced / separated, M=married, S=single)
    }
    \item{age}{
      AGE
    }
    \item{yschool}{
      Years of schooling
    }
    \item{iinfct}{
      Initial infection (1= gonorrhea, 2=chlamydia, 3=both)
    }
    \item{npartner}{
      Number of partners
    }
    \item{os12m}{
      Oral sex within 12 months (1=yes, 0=no)
    }
    \item{os30d}{
      Oral sex within 30 days (1=yes, 0=no)
    }
    \item{rs12m}{
      Rectal sex within 12 months (1=yes, 0=no)
    }
    \item{rs30d}{
      Rectal sex within 30 days (1=yes, 0=no)
    }
    \item{abdpain}{
      Presence of abdominal pain (1=yes, 0=no)
    }
    \item{discharge}{
      Sign of discharge (1=yes, 0=no)
    }
    \item{dysuria}{
      Sign of dysuria (1=yes, 0=no)
    }
    \item{condom}{
      Condom use (1=always, 2=sometime, 3=never)
    }
    \item{itch}{
      Sign of itch (1=yes, 0=no)
    }
    \item{lesion}{
      Sign of lesion (1=yes, 0=no)
    }
    \item{rash}{
      Sign of rash (1=yes, 0=no)
    }
    \item{lymph}{
      Sign of lymph (1=yes, 0=no)
    }
    \item{vagina}{
      Involvement vagina at exam (1=yes, 0=no)
    }
    \item{dchexam}{
      Discharge at exam (1=yes, 0=no)
    }
    \item{abnode}{
      Abnormal node at exam (1=yes, 0=no)
    }
    \item{rinfct}{
      Reinfection (1=yes, 0=no)
    }
    \item{time}{
      Time to reinfection
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(std)
}
\keyword{datasets}

\eof
\name{stddiag}
\alias{stddiag}
\non_function{}
\title{data from Exercise 5.6, p146}
\description{
  The \code{stddiag} data frame has 25 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{encounter}{
      Months from 1/93 to encounter
    }
    \item{diagnosed}{
      Months until STD diagnosed in the clinic
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(stddiag)
}
\keyword{datasets}

\eof
\name{tongue}
\alias{tongue}
\non_function{}
\title{data from Section 1.11}
\description{
  The \code{tongue} data frame has 80 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{type}{
      Tumor DNA profile (1=Aneuploid Tumor, 2=Diploid Tumor)
    }
    \item{time}{
      Time to death or on-study time, weeks
    }
    \item{delta}{
      Death indicator (0=alive, 1=dead)
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
  Sickle-Santanello et al. Cytometry 9 (1988): 594-599.
}
\examples{
data(tongue)
}
\keyword{datasets}

\eof
\name{twins}
\alias{twins}
\non_function{}
\title{data from Exercise 7.14, p225}
\description{
  The \code{twins} data frame has 24 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{id}{
      Twin number
    }
    \item{age}{
      Age of twin's death from CHD, months
    }
    \item{death}{
      Death (male twin) from CHD indicator (1=dead from CHD, 0=alive or other
      cause of death)
    }
    \item{gender}{
      1=male, 2=female
    }
  }
}
\details{
}
\source{
  Klein and Moeschberger (1997) \emph{Survival Analysis Techniques for Censored
    and truncated data}, Springer.
}
\examples{
data(twins)
}
\keyword{datasets}

\eof
