### Name: MCMCfactanal
### Title: Markov chain Monte Carlo for Normal Theory Factor Analysis Model
### Aliases: MCMCfactanal
### Keywords: models

### ** Examples

   ## Not run: 
##D    ### An example using the formula interface
##D    data(swiss)
##D    posterior <- MCMCfactanal(~Agriculture+Examination+Education+Catholic
##D                     +Infant.Mortality, factors=2,
##D                     lambda.constraints=list(Examination=list(1,"+"),
##D                        Examination=list(2,"-"), Education=c(2,0),
##D                        Infant.Mortality=c(1,0)),
##D                     verbose=FALSE, store.scores=FALSE, a0=1, b0=0.15,
##D                     data=swiss, burnin=5000, mcmc=50000, thin=20)
##D    plot(posterior)
##D    summary(posterior)
##D 
##D    ### An example using the matrix interface
##D    Lambda <- matrix(runif(45,-.5,.5), 15, 3)
##D    Psi <- diag(1 - apply(Lambda ^2, 1, sum))
##D    Sigma <- Lambda %*% t(Lambda) + Psi 
##D    Y <- t(t(chol(Sigma)) %*% matrix(rnorm(500*15), 15, 500))
##D 
##D    posterior <- MCMCfactanal(Y, factors=3,
##D                     lambda.constraints=list(V1=c(2,0),
##D                        V1=c(3,0), V2=c(3,0), V3=list(1,"+"),
##D                        V3=list(2,"+"), V3=list(3,"+")),
##D                     verbose=FALSE)
##D    plot(posterior)
##D    summary(posterior)        
##D    
## End(Not run)



