\name{cement}
\alias{cement}
\non_function{}
\title{ Cement Data }
\usage{data(cement)}
\description{
The \code{cement} data frame has 13 rows and 5 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
    \item{x3}{a numeric vector}
    \item{x4}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(cement)
pairs(cement)
}
\keyword{datasets}

\eof
\name{p11.12}
\alias{p11.12}
\non_function{}
\title{Data For Problem 11-12}
\usage{data(p11.12)}
\description{
The \code{p11.12} data frame has 19 observations on satellite cost.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{cost}{first-unit satellite cost}
    \item{x}{weight of the electronics suite}
  }
}
\source{
  Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Simpson and Montgomery (1998)
}
\examples{
data(p11.12)
attach(p11.12)
plot(cost~x)
detach(p11.12)
}
\keyword{datasets}

\eof
\name{p11.15}
\alias{p11.15}
\non_function{}
\title{Data set for Problem 11-15}
\usage{data(p11.15)}
\description{
The \code{p11.15} data frame has 9 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
    \item{y}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Ryan (1997), Stefanski (1991)
}
\examples{
data(p11.15)
plot(p11.15)
attach(p11.15)
lines(lowess(x,y))
detach(p11.15)
}
\keyword{datasets}

\eof
\name{p12.11}
\alias{p12.11}
\non_function{}
\title{Data Set for Problem 12-11}
\usage{data(p12.11)}
\description{
The \code{p12.11} data frame has 44 observations on the fraction
of active chlorine in a chemical product as a function of time
after manufacturing.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{xi}{time}
    \item{yi}{available chlorine}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p12.11)
plot(p12.11)
lines(lowess(p12.11))
}
\keyword{datasets}

\eof
\name{p12.12}
\alias{p12.12}
\non_function{}
\title{Data Set for Problem 12-12}
\usage{data(p12.12)}
\description{
The \code{p12.12} data frame has 18 observations on an
chemical experiment. A nonlinear model relating concentration to 
reaction time and temperature with an additive error is proposed to
fit these data.  
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{reaction time (in minutes)}
    \item{x2}{temperature (in degrees Celsius)}
    \item{y}{concentration (in grams/liter)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p12.12)
attach(p12.12)
# fitting the linearized model 
logy.lm <- lm(I(log(y))~I(log(x1))+I(log(x2)))
summary(logy.lm)
plot(logy.lm, which=1)  # checking the residuals
# fitting the nonlinear model
library(nls) # nonlinear regression library
 y.nls <- nls(y ~ theta1*I(x1^theta2)*I(x2^theta3), start=list(theta1=.95, 
theta2=.76, theta3=.21))
 summary(y.nls)
 plot(resid(y.nls)~fitted(y.nls)) # checking the residuals 
}
\keyword{datasets}

\eof
\name{p12.8}
\alias{p12.8}
\non_function{}
\title{Data Set for Problem 12-8}
\usage{data(p12.8)}
\description{
The \code{p12.8} data frame has 14 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
    \item{y}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p12.8)
}
\keyword{datasets}

\eof
\name{p13.1}
\alias{p13.1}
\non_function{}
\title{Data Set for Problem 13-1}
\usage{data(p13.1)}
\description{
The \code{p13.1} data frame has 25 observation on the
test-firing results for surface-to-air missiles.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{target speed (in Knots)}
    \item{y}{hit (=1) or miss (=0)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.1)
}
\keyword{datasets}

\eof
\name{p13.16}
\alias{p13.16}
\non_function{}
\title{Data Set for Problem 13-16}
\usage{data(p13.16)}
\description{
The \code{p13.16} data frame has 16 rows and 5 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{X1}{a numeric vector}
    \item{X2}{a numeric vector}
    \item{X3}{a numeric vector}
    \item{X4}{a numeric vector}
    \item{Y}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.16)
}
\keyword{datasets}

\eof
\name{p13.2}
\alias{p13.2}
\non_function{}
\title{Data Set for Problem 13-2}
\usage{data(p13.2)}
\description{
The \code{p13.2} data frame has 20 observations on home ownership.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{family income}
    \item{y}{home ownership (1 = yes, 0 = no)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.2)
}
\keyword{datasets}

\eof
\name{p13.20}
\alias{p13.20}
\non_function{}
\title{Data Set for Problem 13-20}
\usage{data(p13.20)}
\description{
The \code{p13.20} data frame has 30 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{yhat}{a numeric vector}
    \item{resdev}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.20)
}
\keyword{datasets}

\eof
\name{p13.3}
\alias{p13.3}
\non_function{}
\title{Data Set for Problem 13-3}
\usage{data(p13.3)}
\description{
The \code{p13.3} data frame has 10 observations on the
compressive strength of an alloy fastener used in
aircraft construction.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{load (in psi)}
    \item{n}{sample size}
    \item{r}{number failing}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.3)
}
\keyword{datasets}

\eof
\name{p13.4}
\alias{p13.4}
\non_function{}
\title{Data Set for Problem 13-4}
\usage{data(p13.4)}
\description{
The \code{p13.4} data frame has 11 observations on the
effectiveness of a price discount coupon on the
purchase of a two-litre beverage.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{discount}
    \item{n}{sample size}
    \item{r}{number redeemed}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.4)
}
\keyword{datasets}

\eof
\name{p13.5}
\alias{p13.5}
\non_function{}
\title{Data Set for Problem 13-5}
\usage{data(p13.5)}
\description{
The \code{p13.5} data frame has 20 observations on
new automobile purchases.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{income}
    \item{x2}{age of oldest vehicle}
    \item{y}{new purchase less than 6 months later (1=yes, 0=no)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.5)
}
\keyword{datasets}

\eof
\name{p13.6}
\alias{p13.6}
\non_function{}
\title{Data Set for Problem 13-6}
\usage{data(p13.6)}
\description{
The \code{p13.6} data frame has 15 observations
on the number of failures of a particular type of valve
in a processing unit.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{valve}{type of valve}
    \item{numfail}{number of failures}
    \item{months}{months}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p13.6)
}
\keyword{datasets}

\eof
\name{p13.7}
\alias{p13.7}
\non_function{}
\title{Data Set for Problem 13-7}
\usage{data(p13.7)}
\description{
The \code{p13.7} data frame has 44 observations on the coal
mines of the Appalachian region of western Virginia.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{number of fractures in upper seams of coal mines}
    \item{x1}{inner burden thickness (in feet), 
shortest distance between  seam floor and the lower
seam}
   \item{x2}{percent extraction of the lower previously
mined seam}
    \item{x3}{lower seam height (in feet)}
    \item{x4}{time that the mine has been in operation (in years)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Myers (1990)
}
\examples{
data(p13.7)
}
\keyword{datasets}

\eof
\name{p14.1}
\alias{p14.1}
\non_function{}
\title{Data Set for Problem 14-1}
\usage{data(p14.1)}
\description{
The \code{p14.1} data frame has 15 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
    \item{y}{a numeric vector}
    \item{time}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p14.1)
}
\keyword{datasets}

\eof
\name{p14.2}
\alias{p14.2}
\non_function{}
\title{Data Set for Problem 14-2}
\usage{data(p14.2)}
\description{
The \code{p14.2} data frame has 18 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{t}{a numeric vector}
    \item{xt}{a numeric vector}
    \item{yt}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p14.2)
}
\keyword{datasets}

\eof
\name{p15.4}
\alias{p15.4}
\non_function{}
\title{Data Set for Problem 15-4}
\usage{data(p15.4)}
\description{
The \code{p15.4} data frame has 40 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
    \item{y}{a numeric vector}
    \item{set}{a factor with levels \code{e} and \code{p}}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p15.4)
}
\keyword{datasets}

\eof
\name{p2.10}
\alias{p2.10}
\non_function{}
\title{Data Set for Problem 2-10}
\usage{data(p2.10)}
\description{
The \code{p2.10} data frame has 26 observations on weight and
systolic blood pressure for randomly selected males in the 25-30
age group.  
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{weight}{in pounds}
    \item{sysbp}{systolic blood pressure}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p2.10)
attach(p2.10)
cor.test(weight, sysbp, method="pearson")  # tests rho=0
                                           # and computes 95% CI for rho
                                           # using Fisher's Z-transform
}
\keyword{datasets}

\eof
\name{p2.12}
\alias{p2.12}
\non_function{}
\title{Data Set for Problem 2-12}
\usage{data(p2.12)}
\description{
The \code{p2.12} data frame has 12 observations on 
the number of pounds of steam used per month at a plant and
the average monthly ambient temperature.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{temp}{ambient temperature (in degrees F)}
    \item{usage}{usage (in thousands of pounds)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p2.12)
attach(p2.12)
usage.lm <- lm(usage ~ temp)
summary(usage.lm)
predict(usage.lm, newdata=data.frame(temp=58), interval="prediction")
detach(p2.12)
}
\keyword{datasets}

\eof
\name{p2.13}
\alias{p2.13}
\non_function{}
\title{Data Set for Problem 2-13}
\usage{data(p2.13)}
\description{
The \code{p2.13} data frame has 16 observations on the number
of days the ozone levels exceeded 0.2 ppm in the
South Coast Air Basin of California for the years 1976 through
1991.  It is believed that these levels are related to temperature.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{days}{number of days ozone levels exceeded 0.2 ppm}
    \item{index}{a seasonal
meteorological index giving the seasonal average 850 millibar
temperature.}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Davidson (1993) Update on Ozone Trends in California's South Coast Air 
Basin. Air and Waste, 43, 226.
}
\examples{
data(p2.13)
attach(p2.13)
plot(days~index, ylim=c(-20,130))
ozone.lm <- lm(days ~ index)
summary(ozone.lm)
# plots of confidence and prediction intervals:
ozone.conf <- predict(ozone.lm, interval="confidence")
lines(sort(index), ozone.conf[order(index),2], col="red")
lines(sort(index), ozone.conf[order(index),3], col="red")
ozone.pred <- predict(ozone.lm, interval="prediction")
lines(sort(index), ozone.pred[order(index),2], col="blue")
lines(sort(index), ozone.pred[order(index),3], col="blue")
detach(p2.13)
}
\keyword{datasets}

\eof
\name{p2.14}
\alias{p2.14}
\non_function{}
\title{Data Set for Problem 2-14}
\usage{data(p2.14)}
\description{
The \code{p2.14} data frame has 8 observations on the molar
ratio of sebacic acid and the intrinsic viscosity of copolyesters.
One is interested in predicting viscosity from the sebacic acid ratio.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{ratio}{molar ratio}
    \item{visc}{viscosity}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Hsuie, Ma, and Tsai (1995) Separation and Characterizations of 
Thermotropic Copolyesters of p-Hydroxybenzoic Acid, Sebacic Acid and
Hydroquinone. Journal of Applied Polymer Science, 56, 471-476.
}
\examples{
data(p2.14)
attach(p2.14)
plot(p2.14, pch=16, ylim=c(0,1))
visc.lm <- lm(visc ~ ratio)
summary(visc.lm)
visc.conf <- predict(visc.lm, interval="confidence")
lines(ratio, visc.conf[,2], col="red")
lines(ratio, visc.conf[,3], col="red")
visc.pred <- predict(visc.lm, interval="prediction")
lines(ratio, visc.pred[,2], col="blue")
lines(ratio, visc.pred[,3], col="blue")
detach(p2.14)
}
\keyword{datasets}

\eof
\name{p2.15}
\alias{p2.15}
\non_function{}
\title{Data Set for Problem 2-15}
\usage{data(p2.15)}
\description{
The \code{p2.15} data frame has 8 observations on the impact
of temperature on the viscosity of toluene-tetralin blends.
This particular data set deals with blends with a 0.4 molar
fraction of toluene.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{temp}{temperature (in degrees Celsius)}
    \item{visc}{viscosity (mPa s)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Byers and Williams (1987) Viscosities of Binary and Ternary Mixtures
of Polynomatic Hydrocarbons. Journal of Chemical and Engineering
Data, 32, 349-354.
}
\examples{
data(p2.15)
attach(p2.15)
plot(visc ~ temp, pch=16)
visc.lm <- lm(visc ~ temp)
plot(visc.lm, which=1)
detach(p2.15)
}
\keyword{datasets}

\eof
\name{p2.16}
\alias{p2.16}
\non_function{}
\title{Data Set for Problem 2-16}
\usage{data(p2.16)}
\description{
The \code{p2.16} data frame has 33 observations on the
pressure in a tank the volume of liquid.  
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{volume}{volume of liquid}
    \item{pressure}{pressure in the tank}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Carroll and Spiegelman (1986) The Effects of Ignoring Small Measurement
Errors in Precision Instrument Calibration. Journal of Quality Technology,
18, 170-173.  
}
\examples{
data(p2.16)
attach(p2.16)
plot(pressure ~ volume, pch=16)
pressure.lm <- lm(pressure ~ volume)
plot(pressure.lm, which=1)
summary(pressure.lm)
detach(p2.16)
}
\keyword{datasets}

\eof
\name{p2.7}
\alias{p2.7}
\non_function{}
\title{Data Set for Problem 2-7}
\usage{data(p2.7)}
\description{
The \code{p2.7} data frame has 20 observations on the
purity of oxygen produced by a fractionation process.  It
is thought that oxygen purity is related to the percentage
of hydrocarbons in the main condensor of the processing
unit.  
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{purity}{oxygen purity (percentage)}
    \item{hydro}{hydrocarbon (percentage)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}

\examples{
data(p2.7)
attach(p2.7)
purity.lm <- lm(purity ~ hydro)
summary(purity.lm)
# confidence interval for mean purity at 1% hydrocarbon:
predict(purity.lm,newdata=data.frame(hydro = 1.00),interval="confidence")
detach(p2.7)
}
\keyword{datasets}

\eof
\name{p2.9}
\alias{p2.9}
\non_function{}
\title{Data Set for Problem 2-9}
\usage{data(p2.9)}
\description{
The \code{p2.9} data frame has 25 rows and 2 columns.  See
help on \code{softdrink} for details.  
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x}{a numeric vector}
  }
}

\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p2.9)
}
\keyword{datasets}

\eof
\name{p4.18}
\alias{p4.18}
\non_function{}
\title{Data Set for Problem 4-18}
\usage{data(p4.18)}
\description{
The \code{p4.18} data frame has 13 observations on an
experiment to produce a synthetic analogue to jojoba oil.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{reaction temperature}
    \item{x2}{initial amount of catalyst}
    \item{x3}{pressure}
    \item{y}{yield}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Coteron, Sanchez, Matinez, and Aracil (1993) 
Optimization of the Synthesis of an Analogue of Jojoba Oil Using
a Fully Central Composite Design. Canadian Journal of Chemical
Engineering.
}

\examples{
data(p4.18)
y.lm <- lm(y ~ x1 + x2 + x3, data=p4.18)
summary(y.lm)
y.lm <- lm(y ~ x1, data=p4.18)
}
\keyword{datasets}

\eof
\name{p4.19}
\alias{p4.19}
\non_function{}
\title{Data Set for Problem 4-19}
\usage{data(p4.19)}
\description{
The \code{p4.19} data frame has 14 observations on
a designed experiment studying the relationship
between abrasion index for a tire tread compound
and three factors.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{hydrated silica level}
    \item{x2}{silane coupling agent level}
    \item{x3}{sulfur level}
    \item{y}{abrasion index for a tire tread compound}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Derringer and Suich (1980) Simultaneous Optimization of Several
Response Variables. Journal of Quality Technology.
}
\examples{
data(p4.19)
attach(p4.19)
y.lm <- lm(y ~ x1 + x2 + x3)
summary(y.lm)
plot(y.lm, which=1)
y.lm <- lm(y ~ x1)
detach(p4.19)
}
\keyword{datasets}

\eof
\name{p4.20}
\alias{p4.20}
\non_function{}
\title{Data Set for Problem 4-20
}
\usage{data(p4.20)}
\description{
The \code{p4.20} data frame has 26 observations
on a designed experiment to determine the influence
of five factors on the whiteness of rayon.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{acidtemp}{acid bath temperature}
    \item{acidconc}{cascade acid concentration}
    \item{watertemp}{water temperature}
    \item{sulfconc}{sulfide concentration}
    \item{amtbl}{amount of chlorine bleach}
    \item{y}{a measure of the whiteness of rayon}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Myers and Montgomery (1995) Response Surface Methodology, pp. 267-268.
}
\examples{
data(p4.20)
y.lm <- lm(y ~ acidtemp, data=p4.20)
summary(y.lm)
}
\keyword{datasets}

\eof
\name{p5.1}
\alias{p5.1}
\non_function{}
\title{Data Set for Problem 5-1}
\usage{data(p5.1)}
\description{
The \code{p5.1} data frame has 8 observations on the impact
of temperature on the viscosity of toluene-tetralin blends.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{temp}{temperature}
    \item{visc}{viscosity}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Byers and Williams (1987) Viscosities of Binary and Ternary Mixtures
of Polyaromatic Hydrocarbons. Journal of Chemical and Engineering
Data, 32, 349-354.
}
\examples{
data(p5.1)
plot(p5.1)
}
\keyword{datasets}

\eof
\name{p5.10}
\alias{p5.10}
\non_function{}
\title{Data Set for Problem 5-10}
\usage{data(p5.10)}
\description{
The \code{p5.10} data frame has 27 observations on the
effect of three factors on a printing machine's ability
to apply coloring inks on package labels.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{speed}
    \item{x2}{pressure}
    \item{x3}{distance}
    \item{yi1}{response 1}
    \item{yi2}{response 2}
    \item{yi3}{response 3}
    \item{ybar.i}{average response}
    \item{si}{standard deviation of the 3 responses}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.10)
attach(p5.10)
y.lm <- lm(ybar.i ~ x1 + x2 + x3)
plot(y.lm, which=1)
detach(p5.10)
}
\keyword{datasets}

\eof
\name{p5.11}
\alias{p5.11}
\non_function{}
\title{Data Set for Problem 5-11}
\usage{data(p5.11)}
\description{
The \code{p5.11} data frame has 8 observations on an 
experiment with a catapult.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{hook}
    \item{x2}{arm length}
    \item{x3}{start angle}
    \item{x4}{stop angle}
    \item{yi1}{response 1}
    \item{yi2}{response 2}
    \item{yi3}{response 3}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.11)
attach(p5.11)
ybar.i <- apply(p5.11[,5:7], 1, mean)
sd.i <- apply(p5.11[,5:7], 1, sd)
y.lm <- lm(ybar.i ~ x1 + x2 + x3 + x4)
plot(y.lm, which=1)
detach(p5.11)
}
\keyword{datasets}

\eof
\name{p5.2}
\alias{p5.2}
\non_function{}
\title{Data Set for Problem 5-2}
\usage{data(p5.2)}
\description{
The \code{p5.2} data frame has 11 observations on the vapor
pressure of water for various temperatures.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{temp}{temperature (K)}
    \item{vapor}{vapor pressure (mm Hg)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.2)
plot(p5.2)
}
\keyword{datasets}

\eof
\name{p5.3}
\alias{p5.3}
\non_function{}
\title{Data Set for Problem 5-3}
\usage{data(p5.3)}
\description{
The \code{p5.3} data frame has 12 observations on the
number of bacteria surviving in a canned food product and the
number of minutes of exposure to 300 degree Fahrenheit heat.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{bact}{number of surviving bacteria}
    \item{min}{number of minutes of exposure}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.3)
plot(bact~min, data=p5.3)
}
\keyword{datasets}

\eof
\name{p5.4}
\alias{p5.4}
\non_function{}
\title{Data Set for Problem 5-4}
\usage{data(p5.4)}
\description{
The \code{p5.4} data frame has 8 observations on 2 variables.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
    \item{y}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.4)
plot(y ~ x, data=p5.4)
}
\keyword{datasets}

\eof
\name{p5.5}
\alias{p5.5}
\non_function{}
\title{Data Set for Problem 5-5}
\usage{data(p5.5)}
\description{
The \code{p5.5} data frame has 14 observations on the average
number of defects per 10000 bottles due to stones in the bottle
wall and the number of weeks since the last furnace overhaul.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{defects}{a numeric vector}
    \item{weeks}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p5.5)
defects.lm <- lm(defects~weeks, data=p5.5)
plot(defects.lm, which=1)
}
\keyword{datasets}

\eof
\name{p7.1}
\alias{p7.1}
\non_function{}
\title{Data Set for Problem 7-1}
\usage{data(p7.1)}
\description{
The \code{p7.1} data frame has 10 observations on a predictor variable.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.1)
attach(p7.1)
x2 <- x^2
detach(p7.1)
}
\keyword{datasets}

\eof
\name{p7.11}
\alias{p7.11}
\non_function{}
\title{Data Set for Problem 7-11}
\usage{data(p7.11)}
\description{
The \code{p7.11} data frame has 11 observations on production cost
versus production lot size.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{production lot size}
    \item{y}{average production cost per unit}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.11)
plot(y ~ x, data=p7.11)
}
\keyword{datasets}

\eof
\name{p7.15}
\alias{p7.15}
\non_function{}
\title{Data Set for Problem 7-15}
\usage{data(p7.15)}
\description{
The \code{p7.15} data frame has 6 observations 
on vapor pressure of water at various temperatures.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{vapor pressure (mm Hg)}
    \item{x}{temperature (degrees Celsius)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.15)
y.lm <- lm(y ~ x, data=p7.15)
plot(y ~ x, data=p7.15)
abline(coef(y.lm))
plot(y.lm, which=1)
}
\keyword{datasets}

\eof
\name{p7.16}
\alias{p7.16}
\non_function{}
\title{Data Set for Problem 7-16}
\usage{data(p7.16)}
\description{
The \code{p7.16} data frame has 26 observations on the
observed mole fraction solubility of a solute at a
constant temperature.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{negative logarithm of the mole fraction solubility}
    \item{x1}{dispersion partial solubility}
    \item{x2}{dipolar partial solubility}
    \item{x3}{hydrogen bonding Hansen partial solubility}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
(1991) Journal of Pharmaceutical Sciences 80, 971-977.
}
\examples{
data(p7.16)
pairs(p7.16)
}
\keyword{datasets}

\eof
\name{p7.19}
\alias{p7.19}
\non_function{}
\title{Data Set for Problem 7-19}
\usage{data(p7.19)}
\description{
The \code{p7.19} data frame has 10 observations on the concentration
of green liquor and paper machine speed from a kraft paper
machine.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{green liquor (g/l)}
    \item{x}{paper machine speed (ft/min)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
(1986) Tappi Journal.
}
\examples{
data(p7.19)
y.lm <- lm(y ~ x + I(x^2), data=p7.19)
summary(y.lm)
}
\keyword{datasets}

\eof
\name{p7.2}
\alias{p7.2}
\non_function{}
\title{Data Set for Problem 7-2}
\usage{data(p7.2)}
\description{
The \code{p7.2} data frame has 10 observations on solid-fuel
rocket propellant weight loss.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{months since production}
    \item{y}{weight loss (kg)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.2)
y.lm <- lm(y ~ x + I(x^2), data=p7.2)
summary(y.lm)
plot(y ~ x, data=p7.2)
}
\keyword{datasets}

\eof
\name{p7.4}
\alias{p7.4}
\non_function{}
\title{Data Set for Problem 7-4}
\usage{data(p7.4)}
\description{
The \code{p7.4} data frame has 12 observations on two variables.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{a numeric vector}
    \item{y}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.4)
y.lm <- lm(y ~ x + I(x^2), data = p7.4)
summary(y.lm)
}
\keyword{datasets}

\eof
\name{p7.6}
\alias{p7.6}
\non_function{}
\title{Data Set for Problem 7-6}
\usage{data(p7.6)}
\description{
The \code{p7.6} data frame has 12 observations on softdrink
carbonation.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{carbonation}
    \item{x1}{temperature}
    \item{x2}{pressure}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p7.6)
y.lm <- lm(y ~ x1 + I(x1^2) + x2 + I(x2^2) + I(x1*x2), data=p7.6)
summary(y.lm)
}
\keyword{datasets}

\eof
\name{p8.11}
\alias{p8.11}
\non_function{}
\title{Data Set for Problem 8-11}
\usage{data(p8.11)}
\description{
The \code{p8.11} data frame has 25 observations on the tensile
strength of synthetic fibre used for men's shirts. 
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{tensile strength}
    \item{percent}{percentage of cotton}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Montgomery (2001) 
}
\examples{
data(p8.11)
y.lm <- lm(y ~ percent, data=p8.11)
model.matrix(y.lm)
}
\keyword{datasets}

\eof
\name{p8.3}
\alias{p8.3}
\non_function{}
\title{Data Set for Problem 8-3}
\usage{data(p8.3)}
\description{
The \code{p8.3} data frame has 25 observations on delivery
times taken by a vending machine route driver.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{delivery time (in minutes)}
    \item{x1}{number of cases of product stocked}
    \item{x2}{distance walked by route driver}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(p8.3)
pairs(p8.3)
}
\keyword{datasets}

\eof
\name{p9.10}
\alias{p9.10}
\non_function{}
\title{Data Set for Problem 9-10}
\usage{data(p9.10)}
\description{
The \code{p9.10} data frame has 31 observations
on the rut depth of asphalt pavements prepared under
different conditions.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{change in rut depth/million wheel passes (log scale)}
    \item{x1}{viscosity (log scale)}
    \item{x2}{percentage of asphalt in surface course}
    \item{x3}{percentage of asphalt in base course}
    \item{x4}{indicator}
    \item{x5}{percentage of fines in surface course}
    \item{x6}{percentage of voids in surface course}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\reference{
Gorman and Toman (1966) 
}
\examples{
data(p9.10)
pairs(p9.10)
}
\keyword{datasets}

\eof
\name{quadline}
\alias{quadline}
\title{Quadratic Overlay}
\description{
Overlays a quadratic curve to a fitted quadratic model.
}
\usage{
quadline(lm.obj, ...)
}
\arguments{
  \item{lm.obj}{A \code{lm} object (a quadratic fit) }
  \item{...}{Other arguments to the \code{lines} function; e.g. \code{col}}
  }
\value{
The function superimposes a quadratic curve onto an existing scatterplot.
}
\author{W.J. Braun}
\seealso{\code{lm}}

\examples{
data(p4.18)
attach(p4.18)
y.lm <- lm(y ~ x1 + I(x1^2))
plot(x1, y)
quadline(y.lm)
detach(p4.18)
}
\keyword{models}

\eof
\name{softdrink}
\alias{softdrink}
\non_function{}
\title{Softdrink Data}
\usage{data(softdrink)}
\description{
The \code{softdrink} data frame has 25 rows and 3 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(softdrink)
}
\keyword{datasets}

\eof
\name{solar}
\alias{solar}
\non_function{}
\title{Solar Data}
\usage{data(solar)}
\description{
The \code{solar} data frame has 29 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{total.heat.flux}{a numeric vector}
    \item{insolation}{a numeric vector}
    \item{focal.pt.east}{a numeric vector}
    \item{focal.pt.south}{a numeric vector}
    \item{focal.pt.north}{a numeric vector}
    \item{time.of.day}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(solar)
}
\keyword{datasets}

\eof
\name{stackloss}
\alias{stackloss}
\non_function{}
\title{Stackloss Data}
\usage{data(stackloss)}
\description{
The \code{stackloss} data frame has 21 rows and 4 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
    \item{x3}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}

\examples{
data(stackloss)
}
\keyword{datasets}

\eof
\name{table.b1}
\alias{table.b1}
\non_function{}
\title{Table B1}
\usage{data(table.b1)}
\description{
The \code{table.b1} data frame has 28 observations on National
Football League 1976 Team Performance.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{Games won in a 14 game season}
    \item{x1}{Rushing yards}
    \item{x2}{Passing yards}
    \item{x3}{Punting average (yards/punt)}
    \item{x4}{Field Goal Percentage (FGs made/FGs attempted)}
    \item{x5}{Turnover differential (turnovers acquired - turnovers lost)}
    \item{x6}{Penalty yards}
    \item{x7}{Percent rushing (rushing plays/total plays)}
    \item{x8}{Opponents' rushing yards}
    \item{x9}{Opponents' passing yards}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b1)
attach(table.b1)
y.lm <- lm(y ~ x2 + x7 + x8)
summary(y.lm)
# over-all F-test:
y.null <- lm(y ~ 1)
anova(y.null, y.lm)
# partial F-test for x7:
y7.lm <- lm(y ~ x2 + x8)
anova(y7.lm, y.lm)
detach(table.b1)
}
\keyword{datasets}

\eof
\name{table.b10}
\alias{table.b10}
\non_function{}
\title{Table B10}
\usage{data(table.b10)}
\description{
The \code{table.b10} data frame has 40 observations
on kinematic viscosity of a certain solvent system.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{Ratio of 2-methoxyethanol to 1,2-dimethoxyethane}
    \item{x2}{Temperature (in degrees Celsius)}
    \item{y}{Kinematic viscosity (.000001 m2/s}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Viscosimetric Studies on 2-Methoxyethanol + 1, 2-Dimethoxyethane
Binary Mixtures from -10 to 80C. Canadian Journal of Chemical
Engineering, 75, 494-501.
}
\examples{
data(table.b10)
attach(table.b10)
y.lm <- lm(y ~ x1 + x2)
summary(y.lm)
detach(table.b10)
}
\keyword{datasets}

\eof
\name{table.b11}
\alias{table.b11}
\non_function{}
\title{Table B11}
\usage{data(table.b11)}
\description{
The \code{table.b11} data frame has 38 observations on the
quality of Pinot Noir wine.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Clarity}{a numeric vector}
    \item{Aroma}{a numeric vector}
    \item{Body}{a numeric vector}
    \item{Flavor}{a numeric vector}
    \item{Oakiness}{a numeric vector}
    \item{Quality}{a numeric vector}
    \item{Region}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b11)
attach(table.b11)
Quality.lm <- lm(Quality ~ Clarity + Aroma + Body + Flavor + Oakiness + 
factor(Region))
summary(Quality.lm)
detach(table.b11)
}
\keyword{datasets}

\eof
\name{table.b12}
\alias{table.b12}
\non_function{}
\title{Table B12}
\usage{data(table.b12)}
\description{
The \code{table.b12} data frame has 32 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{temp}{a numeric vector}
    \item{soaktime}{a numeric vector}
    \item{soakpct}{a numeric vector}
    \item{difftime}{a numeric vector}
    \item{diffpct}{a numeric vector}
    \item{pitch}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b12)
}
\keyword{datasets}

\eof
\name{table.b13}
\alias{table.b13}
\non_function{}
\title{Table B13}
\usage{data(table.b13)}
\description{
The \code{table.b13} data frame has 40 rows and 7 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
    \item{x3}{a numeric vector}
    \item{x4}{a numeric vector}
    \item{x5}{a numeric vector}
    \item{x6}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b13)
}
\keyword{datasets}

\eof
\name{table.b14}
\alias{table.b14}
\non_function{}
\title{Table B14}
\usage{data(table.b14)}
\description{
The \code{table.b14} data frame has 25 observations on the transient
points of an electronic inverter.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{width of the NMOS Device}
    \item{x2}{length of the NMOS Device}
    \item{x3}{width of the PMOS Device}
    \item{x4}{length of the PMOS Device}
    \item{x5}{a numeric vector}
    \item{y}{transient point of PMOS-NMOS Inverters}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b14)
y.lm <- lm(y ~ x1 + x2 + x3 + x4, data=table.b14)
plot(y.lm, which=1)
}
\keyword{datasets}

\eof
\name{table.b2}
\alias{table.b2}
\non_function{}
\title{Table B2}
\usage{data(table.b2)}
\description{
The \code{table.b2} data frame has 29 rows and 6 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{a numeric vector}
    \item{x1}{a numeric vector}
    \item{x2}{a numeric vector}
    \item{x3}{a numeric vector}
    \item{x4}{a numeric vector}
    \item{x5}{a numeric vector}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\examples{
data(table.b2)
}
\keyword{datasets}

\eof
\name{table.b3}
\alias{table.b3}
\non_function{}
\title{Table B3}
\usage{data(table.b3)}
\description{
The \code{table.b3} data frame has observations on gasoline
mileage performance for 32 different automobiles.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{Miles/gallon}
    \item{x1}{Displacement (cubic in)}
    \item{x2}{Horsepower (ft-lb)}
    \item{x3}{Torque (ft-lb)}
    \item{x4}{Compression ratio}
    \item{x5}{Rear axle ratio}
    \item{x6}{Carburetor (barrels)}
    \item{x7}{No. of transmission speeds}
    \item{x8}{Overall length (in)}
    \item{x9}{Width (in)}
    \item{x10}{Weight (lb)}
    \item{x11}{Type of transmission (A=automatic, M=manual)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Motor Trend, 1975
}
\examples{
data(table.b3)
attach(table.b3)
y.lm <- lm(y ~ x1 + x6)
summary(y.lm)
# testing for the significance of the regression:
y.null <- lm(y ~ 1)
anova(y.null, y.lm)
# 95% CI for mean gas mileage:
predict(y.lm, newdata=data.frame(x1=275, x6=2), interval="confidence")
# 95% PI for gas mileage:
predict(y.lm, newdata=data.frame(x1=275, x6=2), interval="prediction")
detach(table.b3)
}
\keyword{datasets}

\eof
\name{table.b4}
\alias{table.b4}
\non_function{}
\title{Table B4}
\usage{data(table.b4)}
\description{
The \code{table.b4} data frame has 24 observations on property
valuation.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{sale price of the house (in thousands of dollars)}
    \item{x1}{taxes (in thousands of dollars)}
    \item{x2}{number of baths}
    \item{x3}{lot size (in thousands of square feet)}
    \item{x4}{living space (in thousands of square feet)}
    \item{x5}{number of garage stalls}
    \item{x6}{number of rooms}
    \item{x7}{number of bedrooms}
    \item{x8}{age of the home (in years)}
    \item{x9}{number of fireplaces}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Narula, S.C. and Wellington (1980) Prediction, Linear Regression
and Minimum Sum of Relative Errors. Technometrics, 19, 1977. 
}
\examples{
data(table.b4)
attach(table.b4)
y.lm <- lm(y ~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9)
summary(y.lm)
detach(table.b4)
}
\keyword{datasets}

\eof
\name{table.b5}
\alias{table.b5}
\non_function{}
\title{Data Set for Table B5}
\usage{data(table.b5)}
\description{
The \code{table.b5} data frame has 27 observations on liquefaction.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{CO2}
    \item{x1}{Space time (in min)}
    \item{x2}{Temperature (in degrees Celsius)}
    \item{x3}{Percent solvation}
    \item{x4}{Oil yield (g/100g MAF)}
    \item{x5}{Coal total}
    \item{x6}{Solvent total}
    \item{x7}{Hydrogen consumption}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
(1978) Belle Ayr Liquefaction Runs with Solvent. Industrial Chemical 
Process Design Development, 17, 3.
}
\examples{
data(table.b5)
attach(table.b5)
y.lm <- lm(y ~ x6 + x7)
summary(y.lm)
detach(table.b5)
}
\keyword{datasets}

\eof
\name{table.b6}
\alias{table.b6}
\non_function{}
\title{Data Set for Table B6}
\usage{data(table.b6)}
\description{
The \code{table.b6} data frame has 28 observations on 
a tube-flow reactor.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{Nb0Cl3 concentration (g-mol/l)}
    \item{x1}{COCl2 concentration (g-mol/l)}
    \item{x2}{Space time (s)}
    \item{x3}{Molar density (g-mol/l)}
    \item{x4}{Mole fraction CO2}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
(1972) Kinetics of Chlorination of Niobium oxychloride by
Phosgene in a Tube-Flow Reactor.  Industrial and Engineering
Chemistry, Process Design Development, 11(2).
}
\examples{
data(table.b6)
# Partial Solution to Problem 3.9
attach(table.b6)
y.lm <- lm(y ~ x1 + x4)
summary(y.lm)
detach(table.b6)
}
\keyword{datasets}

\eof
\name{table.b7}
\alias{table.b7}
\non_function{}
\title{Data Set for Table B7}
\usage{data(table.b7)}
\description{
The \code{table.b7} data frame has 16 observations on 
oil extraction from peanuts.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{CO2 pressure (bar)}
    \item{x2}{CO2 temperature (in degrees Celsius)}
    \item{x3}{peanut moisture (percent by weight)}
    \item{x4}{CO2 flow rate (L/min)}
    \item{x5}{peanut particle size (mm)}
    \item{y}{total oil yield}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Kilgo, M.B.  An Application of Fractional Experimental Designs. 
Quality Engineering, 1, 19-23.
}
\examples{
data(table.b7)
attach(table.b7)
# partial solution to Problem 3.11:
peanuts.lm <- lm(y ~ x1 + x2 + x3 + x4 + x5)
summary(peanuts.lm)
detach(table.b7)
}
\keyword{datasets}

\eof
\name{table.b8}
\alias{table.b8}
\non_function{}
\title{Table B8}
\usage{data(table.b8)}
\description{
The \code{table.b8} data frame has 36 observations on Clathrate
formation.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{Amount of surfactant (mass percentage)}
    \item{x2}{Time (min)}
    \item{y}{Clathrate formation (mass percentage)}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Tanii, T., Minemoto, M., Nakazawa, K., and Ando, Y. Study on
a Cool Storage System Using HCFC-14 lb Clathrate. Canadian
Journal of Chemical Engineering, 75, 353-360.
}
\examples{
data(table.b8)
attach(table.b8)
clathrate.lm <- lm(y ~ x1 + x2)
summary(clathrate.lm)
detach(table.b8)
}
\keyword{datasets}

\eof
\name{table.b9}
\alias{table.b9}
\non_function{}
\title{Data Set for Table B9}
\usage{data(table.b9)}
\description{
The \code{table.b9} data frame has 62 observations on an
experimental pressure drop.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{Superficial fluid velocity of the gas (cm/s)}
    \item{x2}{Kinematic viscosity}
    \item{x3}{Mesh opening (cm)}
    \item{x4}{Dimensionless number relating superficial fluid velocity
of the gas to the superficial fluid velocity of the liquid}
    \item{y}{Dimensionless factor for the pressure drop through a
bubble cap}
  }
}
\source{
 Montgomery, D.C., Peck, E.A., and Vining, C.G. (2001)
Introduction to Linear Regression Analysis. 3rd Edition, John Wiley and Sons.
}
\references{
Liu, C.H., Kan, M., and Chen, B.H. A Correlation of Two-Phase Pressure
Drops in Screen-Plate Bubble Column. Canadian Journal of Chemical 
Engineering, 71, 460-463.
}
\examples{
data(table.b9)
attach(table.b9)
# Partial Solution to Problem 3.13:
y.lm <- lm(y ~ x1 + x2 + x3 + x4)
summary(y.lm)
detach(table.b9)
}
\keyword{datasets}

\eof
