\name{APSOLU3}
\alias{APSOLU3}
\title{Associated 3-modes Principal Tensors of a 3-modes
Principal Tensor}
\description{ Computes all the 2-modes solutions associated to the given
Principal Tensor of the given tensor.  }
 \usage{
APSOLU3((X,solu,pt3=NULL,nbPT2=1,
                 smoothing=FALSE,smoo=list(NA),
                        verbose=getOption("verbose"),file=NULL )}

\arguments{
\item{X}{a tensor (as an array) of order \emph{3}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics }
\item{solu}{a \code{\link{PTAk}} object}
\item{pt3}{a number identifying in \code{solu} the Principal Tensor to use or the
last (if \code{NULL})}
\item{nbPT2}{integer, if 1 all solutions will be computed otherwise at maximum
nbPT2  solutions}
\item{smoothing}{see \code{\link{SVDgen}}}
\item{smoo}{see \code{\link{PTA3}}}
\item{verbose}{control printing}
 \item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
   }
 \details{ For each component of the identified Principal Tensor
given in \code{solu}, an SVD of the contracted product of \code{X} and the component is done.
This gives all the associated Principal Tensors which updates \code{solu} supposed to contain
Principal Tensors of \code{X}. }
\value{an updated \code{\link{PTAk}} object}
\references{ Leibovici D and Sabatier R (1998) \emph{A Singular Value Decomposition of a k-ways
array for a Principal Component Analysis of multi-way data, the PTA-k}. Linear Algebra and its
Applications, 269:307-329 }

 \note{ Usually (i.e. as in \code{PTA3} and \code{PTAk}) the principal
tensor used is the first Principal Tensor of X (and is the last updated in \code{solu}). If
it is another Principal Tensor, the obtained associated solutions do not \emph{stricto sensu}
refer to the SVD-\emph{k}modes decomposition (because the orthogonality is defined in the whole
tensor space not necessarily on each component space) but are still meaningful. }
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTA3}}, \code{\link{APSOLUk}} }
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{APSOLUk}
\alias{APSOLUk}
\title{Associated k-modes Principal Tensors of a k-modes Principal Tensor}
\description{
Computes all the (k-1)-modes associated solutions to the given
Principal Tensor of the given tensor. Calls recursively PTAk. }
\usage{
 APSOLUk(X,solu,nbPT,nbPT2=1,
                       smoothing=FALSE,smoo=list(NA),
                        minpct=0.1,ptk=NULL,
                         verbose=getOption("verbose"),file=NULL,
                          modesnam=NULL)}

\arguments{

\item{X}{
a tensor (as an array) of order \emph{k}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics}
\item{solu}{a \code{PTAk}  object }
\item{nbPT}{a number or a vector of dimension \emph{(k-2)}}
\item{nbPT2}{integer, if 0 no 2-modes solutions will be computed, 1 means all, >1 otherwise}
\item{smoothing}{see \code{\link{SVDgen}}}
\item{smoo}{see \code{\link{PTA3}}}
\item{minpct}{numerical 0-100 to control of computation of future solutions at this level and below}
\item{ptk}{a number identifying in solutions the Principal Tensor to use or the last (if \code{NULL})}
\item{verbose}{control printing}
 \item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
\item{modesnam}{character vector of the names of the modes, if \code{NULL} "\code{mo 1}" ..."\code{mo k}"}
}

\details{
For each component of the identified  Principal Tensor given in
\code{solutions}, a PTA-\emph{(k-1)}modes of the contracted product
of X and the component is done. This gives all the associated
Principal Tensors which updates  \code{solutions} supposed to contain
a Principal Tensors of X at the first place. For full description of
arguments see \code{\link{PTAk}}.}

\value{
an updated \code{PTAk} object }                                  

\references{
Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329. }

\note{
Usually (\emph{i.e.} as in \code{PTA3} and \code{PTAk}) the
principal tensor used is the first Principal Tensor of
\code{X} (and is the last updated in \code{solutions}). If
it is another Principal Tensor, the obtained associated
solutions do not \emph{stricto sensu} refer to the
SVD-\emph{k}modes decomposition (because the orthogonality
is defined in the whole tensor space not necessarily on
each component space) but are still meaningful. This
function is usually called by \code{PTAk} but can be used
on its own to carry on a \code{PTAk} analysis if \code{X}
is the projected (of the original data) on the orthogonal
of all the \emph{k}modes Principal Tensor. In other words
the \code{ptk} rank-one tensor in \code{solutions} should
be the first best rank-one tensor approximating \code{X}
for this decomposition analysis to be called
PTA-\emph{k}modes.}

\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTAk}} }
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{CANDPARA}
\alias{CANDPARA}
\title{CANonical DECOMPosition analysis and PARAllel FACtor analysis}
\description{Performs the identical models known as PARAFAC or CANDECOMP model.}
 \usage{
CANDPARA(X,dim=3,test=1E-8,Maxiter=1000,
                     smoothing=FALSE,smoo=list(NA),
                      verbose=getOption("verbose"),file=NULL,
                       modesnam=NULL,addedcomment="")}
\arguments{
\item{X}{a tensor (as an array) of order \emph{k}, if non-identity metrics are
used \code{X} is a list with \code{data} as the array and
\code{met} a list of metrics.}
\item{dim}{a number specifying the number of rank-one tensors }
\item{test}{control of convergence}
\item{Maxiter}{maximum number of iterations allowed for convergence}
\item{smoothing}{see \code{\link{SVDgen}}}
\item{smoo}{see \code{\link{PTA3}}}
\item{verbose}{control printing}
\item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
\item{modesnam}{character vector of the names of the modes, if \code{NULL}
  "\code{mo 1}" ..."\code{mo k}"}
\item{addedcomment}{character string printed after the title of the analysis}
}
\details{
Looking for the best rank-one tensor approximation (LS) the three
methods described in the package are equivalent. If the number of
tensors looked for is greater then one the methods differs:
PTA-\emph{k}modes will look for best approximation according to the
\emph{orthogonal rank} (\emph{i.e.} the rank-one tensors are
orthogonal), PCA-\emph{k}modes will look for best approximation
according to the \emph{space ranks} (\emph{i.e.} the ranks of all
(simple) bilinear forms , that is the number of components in each
space), PARAFAC/CANDECOMP will look for best approximation according
to the \emph{rank} (\emph{i.e.} the rank-one tensors are not
necessarily orthogonal). For sake of comparisons the
PARAFAC/CANDECOMP method and the PCA-\emph{n}modes are also in the
package but complete functionnality of the use these methods and more
complete packages may be checked at the www site quoted below.
 }
\value{a \code{CANDPARA} (inherits from \code{\link{PTAk}}) object}
 \references{
Caroll J.D and Chang J.J (1970) \emph{Analysis of individual
differences in multidimensional scaling via n-way generalization of
'Eckart-Young' decomposition}. Psychometrika 35,283-319.

Harshman R.A (1970) \emph{Foundations of the PARAFAC procedure:
models and conditions for 'an explanatory' multi-mode factor
analysis}. UCLA Working Papers in Phonetics, 16,1-84.

Kroonenberg P (1983) \emph{Three-mode Principal Component Analysis:
Theory and Applications}. DSWO press. Leiden.(related references in
\url{http://www.fsw.leidenuniv.nl/~kroonenb/})

Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329.
 }
\note{
The use of metrics (diagonal or not) and smoothing extends
flexibility of analysis. This program runs slow! A PARAFAC orthogonal
can be done with PTAk looking only for k-modes Principal Tensors
\emph{i.e.} with the options \code{nbPT=c(rep(0,k-2),dim), nbPT2=0}.
It is identical to look in any \code{PTAk} decomposition only for the
\emph{k}modes solution but obviously with unecessary computations.}

\author{Didier Leibovici \email{c3s2i@free.fr}}

\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{CONTRACTION}
\alias{CONTRACTION}
\alias{CONTRACTION.list}
 \title{Contraction of two tensors }
\description{Computes the contraction product of two tensors as a generalisation of matrix product.
 }
\usage{
 CONTRACTION(X,z, Xwiz=NULL,zwiX=NULL,rezwiX=FALSE,usetensor=TRUE)
 CONTRACTION.list((X,zlist,moins=1,zwiX=NULL,usetensor=TRUE,withapply=FALSE)
}
 \arguments{
   \item{X}{a tensor(as an array) of any order}
   \item{z}{another tensor  (with at least one space in common)}
   \item{zlist}{
a list of lists like a \code{solution.PTAk} at least with
\code{v} for every list(here \code{v} can be any array) }
   \item{Xwiz}{
\code{Xwiz} is to specify the entries of \code{X} to
contract with entries of \code{z} specified by \code{zwiX},
if \code{Xwiz} \code{NULL} \code{dim(z)[zwiX]} matching
\code{dim(X)} will do without ambiguity (taking all
\code{z} dimensions if \code{zwiX} is \code{NULL}). In
\code{CONTRACTION.list} it is not set as one supposes the
contractions in the list to operate follow the dimensions
of X}
   \item{zwiX}{
idem as \code{Xwiz}. If both \code{Xwiz} and \code{zwiX}
are \code{NULL} \code{zwiX}is replaced by full
possibilities (\code{1:length(dimz)}) then \code{Xwiz} is
looked for. In \code{CONTRACTION.list} it is the vector for
dimensions in the \code{v} to contract with X. Only 1-way
dimension for each \code{v}.}
   \item{moins}{
the elements in \code{zlist} to skip (see also
\code{\link{TENSELE}})}
   \item{rezwiX}{
logical if \code{TRUE} (and zwiX is \code{NULL}) rematches
the dimensions in for \code{zwiX}: useful only if the
dimensions of z were not following the Xwiz order and are
not equals.}
   \item{usetensor}{if \code{TRUE} uses \code{tensor} (add-on package)}
    \item{withapply}{if \code{TRUE} (only for vectors in \code{zlist} uses \code{apply}}
   }
\details{
Like two matrices \emph{contract} according to the
appropriate dimensions (columns matching rows) when one
performs a matrix product, this operation does pretty much
the same thing for tensors(array) and specified contraction
dimensions given by \code{Xwiz} and \code{zwiX} which
should match. The function is actually written like:
transforms both tensors as matrices with the ``matching
tensor product" of their contraction dimensions in columns
(for higher order tensor) and rows (the other one),
performs the matrix product and rebuild the result as a
tensor(array). Without using \code{tensor}, if \code{Xwiz}
and/or \code{zwiX} are not specified the functions tries to
match all \code{z} dimensions onto the dimensions of X
where X is the higher order tensor (if it is not the case
in the arguments the function swaps them). }
\value{
A tensor of dimension \code{c(dim(X)[-Xwiz],dim(z)[-zwiX])}
if \code{X} has got a bigger order than \code{z}.}
\references{
Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component
Analysis of multi-way data, the PTA-k}. Linear Algebra and
its Applications, 269:307-329.

Schwartz L (1975) \emph{Les Tenseurs}. Herman, Paris. }

\note{
This operation generalises the \emph{matrix} product to the
\emph{contracted} product of any two tensors(arrays), and
should theoretically perform the tensor product if no
matching (no contraction) but has not been implemented. I
recently put the option of using \code{tensor} which does
exactly the same thing faster as well as it is from
\code{C}. When using \code{tensor} if \code{Xwiz} or
\code{zwiX} are \code{NULL} they are replaced by the full
possibilities.}

\author{Didier Leibovici \email{c3s2i@free.fr}}

 \seealso{\code{\link{PTAk}},  \code{\link{APSOLUk}} }

 \examples{
 library(tensor)
   z <-  array(1:12,c(2,3,2))
   X <- array(1:48,c(3,4,2,2))
   Xcz <- CONTRACTION(X,z,Xwiz=c(1,3,4),zwiX=c(2,3,1))
   dim(Xcz)   # 4
   Xcz1 <- CONTRACTION(X,z,Xwiz=c(3,4),zwiX=c(1,3))
   dim(Xcz1) # 3,4,3
   Xcz2 <- CONTRACTION(X,z,Xwiz=c(3,4),zwiX=c(3,1))
   Xcz1[,,1]
   Xcz2[,,1]
   #######
   sval0 <- list(list(v=c(1,2,3,4)),list(v=rep(1,3)),list(v=c(1,3)))
   tew <- array(1:24,c(4,3,2))
    CONTRACTION.list(tew,sval0,moins=1)
       #this is equivalent to the following which may be too expensive for big datasets
    CONTRACTION(tew,TENSELE(sval0,moins=1),Xwiz=c(2,3))
   ##
     CONTRACTION.list(tew,sval0,moins=c(1,2)) #must be equal to
     CONTRACTION(tew,sval0[[3]]$v,Xwiz=3)
   }
\keyword{array} \keyword{algebra}

\eof
\name{CauRuimet}
\alias{CauRuimet}
\title{Robust estimation of within group covariance}
\description{ Gives a robust estimate of an unknown within group covariance, aiming either to look
for dense groups or to sparse groups (outliers) according to \emph{local variance and weighting
function} choice.
 }
\usage{
 CauRuimet(Z,ker=1,m0=1,withingroup=TRUE,
              loc=substitute(apply(Z,2,mean,trim=.1)),matrixmethod=TRUE)

        }
 \arguments{
   \item{Z}{matrix}
   \item{ker}{either numerical or a function:
if numerical the weighting function is \eqn{e^{(-ker \;t)}}, otherwise
\cr ker=function(t)\{return(expression)\} is a positive decreasing function. }
   \item{m0}{
is a graph of neighbourhood or another proximity matrix, the hadamard product of the proximities
will be operated}
   \item{withingroup}{
logical,if \code{TRUE} the aim is to give a robust estimate for dense groups, if \code{FALSE} the
aim is to give a robust estimate for outliers}
  \item{loc}{
a vector of locations or a function using mean, median, to give an estimate of it}
\item{matrixmethod}{if \code{TRUE} (only with \code{withingroup}) uses some matrix computation rather
  than double looping as suggests the formula below }
 }

 \details{
When withingroup is \code{TRUE}, local(defined by the weighting) variance formula is used, aiming
at finding dense groups: \deqn{W_g=\frac{\sum_{i=1}^{n-1}\sum_{j=i+1}^n
ker(d^2_{S^-}(Z_i,Z_j))(Z_i-Z_j)'(Z_i-Z_j)}{\sum_{i=1}^{n-1}\sum_{j=i+1}^n
ker(d^2_{S^-}(Z_i,Z_j))}} where \eqn{d^2_{S^-}( . , .)} is the squared euclidian distance with
\eqn{S^-} the inverse of a robust sample covariance (i.e. using \code{loc} instead of the mean) ;
if \code{FALSE} weighted global variance is used:
 \deqn{W_o=\frac{\sum_{i=1}^nker(d^2_{S^-}(Z_i,\tilde{Z}))(Z_i-\tilde{Z})'(Z_i-\tilde{Z})}
 {\sum_{i=1}^n  ker(d^2_{S^-}(Z_i,\tilde{Z}))}}
where \eqn{\tilde{Z}} is the vector \code{loc}.
\cr
If \code{m0} is a graph of neighbourhood and ker is the function returning 1 (no proximity due to
distance is used) the function will return (when \code{withingroup=TRUE}) the \emph{local
variance-covariance} matrix as define in Lebart(1969). }
 \value{a matrix}
 \references{
Caussinus, H and Ruiz, A (1990) \emph{Interesting Projections of Multidimensional Data by Means of
Generalized Principal Components Analysis}. COMPSTAT90, Physica-Verlag, Heidelberg,121-126.

Faraj, A (1994) \emph{Interpretation tools for Generalized Discriminant Analysis}.In: New
Approches in Classification and Data Analysis, Springer-Verlag, 286-291, Heidelberg.

Lebart, L (1969) \emph{Analyse statistique de la contiguite}.Publication de l'Institut de
Statistiques Universitaire de Paris, XVIII,81-112.

            }

\note{
As mentioned by Caussinus and Ruiz a good strategy to reveal dense groups with generalised PCA
would be to reveal outliers first using the metric \eqn{W_o^{-1}} and remove them before using the
metric \eqn{W_g^{-1}}. Based on theoretical considerations they recommand for  the choice of
\code{ker}, with the decreasing function \eqn{e^{(-ker \;t)}}: a lower bound of 1 if
\code{withingroup} and something fairly small say in the interval [0.05;0.3] otherwise.
  }
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{SVDgen}}}
\examples{

 data(iris)
  iris2 <- as.matrix(iris[,1:4])
  dimnames(iris2)[[1]] <- as.character(iris[,5])

 D2 <- CauRuimet(iris2,ker=1,withingroup=TRUE)
 D2 <- Powmat(D2,(-1))
 iris2 <- sweep(iris2,2,apply(iris2,2,mean))
 res <- SVDgen(iris2,D2=D2,D1=1)
 plot(res,nb1=1,nb2=2,cex=0.5)
 summary(res,testvar=0)

 # the same in a demo function

 # demo.CauRuimet(ker=4,withingroup=TRUE,openX11s=FALSE)
 # demo.Cauruimet(ker=0.15,withingroup=FALSE,openX11s=FALSE)
}

 \keyword{robust} \keyword{multivariate}

\eof
\name{FCAk}
\alias{FCAk}
\title{Generalisation of Correspondence Analysis for k-way tables}
\description{
Performs a particular \code{PTAk}  data as a ratio Observed/Expected
under complete independence with metrics as margins of the multiple
contingency table (in frequencies).
}
\usage{
 FCAk(X,nbPT=3,nbPT2=1,minpct=0.01,
               smoothing=FALSE,smoo=rep(list(
                       function(u)ksmooth(1:length(u),u,kernel="normal",
                       bandwidth=3,x.points=(1:length(u)))$y),length(dim(X))),
                     verbose=getOption("verbose"),file=NULL,
                       modesnam=NULL,addedcomment="",chi2=TRUE,E=NULL)}
\arguments{
   \item{X}{a multiple contingency table (array) of order \emph{k}}
   \item{nbPT}{a number or a vector of dimension \emph{(k-2)}}
   \item{nbPT2}{if 0 no 2-modes solutions will be computed, 1 =all, >1
     otherwise}
   \item{minpct}{numerical 0-100 to control of computation of future solutions at this level and below}

   \item{smoothing}{see \code{\link{SVDgen}}}
   \item{smoo}{see \code{\link{SVDgen}}}
   \item{verbose}{control printing}
   \item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
   \item{modesnam}{character vector of the names of the modes, if \code{NULL} "\code{mo 1}"
     ..."\code{mo k}"}
    \item{addedcomment}{character string printed if \code{printt} after the title of the analysis}
   \item{chi2}{print the chi2 information when computing margins in \code{\link{FCAmet}}}
    \item{E}{ if not \code{NULL} is an array with the same dimensions as X}
    }

\details{
Gives the SVD-\emph{k}modes decomposition of the \eqn{1+\chi^2/N} of
the multiple contingency table of full count \eqn{N=\sum X <- {ijk...}},
i.e. complete independence + lack of independence (including marginal
independences) as shown for example in Lancaster(1951)(see reference
in Leibovici(2000)). Noting \eqn{P=X/N},  a \code{PTAk} of the
\eqn{(k+1)}-uple is done, e.g. for a three way contingency table
\eqn{k=3} the \emph{4}-uple data and metrics is:
 \deqn{ ((D_I^{-1} \otimes D_J^{-1} \otimes D_K^{-1})P, \quad D_I, \quad D_J, \quad D_K)}
where the metrics are diagonals of the corresponding margins. For
full description of arguments see \code{\link{PTAk}}. If \code{E}
is not \code{NULL} an FCAk-modes relatively to a model is
done (see Escoufier(1985) and therin reference
Escofier(1984) for a 2-way derivation, e.g. for a three way contingency table
\eqn{k=3} the \emph{4}-tuple data and metrics is:
 \deqn{ ((D_I^{-1} \otimes D_J^{-1} \otimes D_K^{-1})(P-E), \quad D_I, \quad D_J, \quad D_K)}
  If \code{E} was the complete independence (product of the margins)
  then this would give an \code{AFCk} but without looking at the
  marginal  dependencies (i.e. for a three way table no two-ways lack of
  independence are looked for).
}
 \value{a \code{FCAk} (inherits \code{\link{PTAk}}) object }
\references{
Escoufier Y (1985) \emph{L'Analyse des correspondances : ses
proprits et ses extensions}. ISI 45th session Amsterdam.

Leibovici D (1993) \emph{Facteurs  Mesures Rptes et Analyses
Factorielles : applications  un suivi pidmiologique}. Universit
de Montpellier II PhD Thesis in Mathmatiques et Applications
(Biostatistiques).

Leibovici D (2000) \emph{Multiway Multidimensional Analysis for
Pharmaco-EEG Studies}. (submitted)
\url{http://c3s2i.free.fr/cv/recentpub.html}
}
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTAk}}, \code{\link{FCAmet}}, \code{\link{summary.FCAk}}  }

\examples{
 # try the demo
   # demo.FCAk()
}
\keyword{models}
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{FCAmet}
\alias{FCAmet}
\title{Tool used in Generalisation of Correspondence Analysis for k-way tables}
\description{
Computes the  ratio Observed/Expected under complete independence
with margins of the multiple contingency table (in frequencies) and
gives \code{chi2} statistic of lack of complete independence. }
\usage{ FCAmet(X,chi2=FALSE,E=NULL)}
\arguments{
   \item{X}{a multiple contingency table (array) of order \emph{k}}
   \item{chi2}{if \code{TRUE} prints the chi2 statistic information }
   \item{E}{if not \code{NULL} represent a model which
   would be used for an \code{\link{FCAk}} relatively to a model}
    }

\value{a list with
\item{data}{
an array \code{(X/count (-E))/Indepen} where \code{Indepen} is the array obtained
from he products of the margins}
\item{met}{
a list wherein each entry is the vector of the corresponding margins i.e.
\code{apply(X,i,sum)/count}}
\item{count}{is the total sum \code{sum(X).}}
 }
\note{The statistics and metrics do not depend on \code{E}. The statistic given measure only the lack of independence.}
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{ \code{\link{FCAk}} }
\keyword{ multivariate}
\keyword{models}

\eof
\name{INITIA}
\alias{INITIA}
\title{Initialisation used in SINGVA}
\description{Gives the first Tucker1 components of a given tensor.
}
\usage{
   INITIA(X,modesnam=NULL,method="Presvd",dim=1,...)}
\arguments{
    \item{X}{a tensor (as an array) of order \emph{k}}
    \item{modesnam}{a character vector of the names of the modes}
    \item{method}{
uses either the inbuilt SVD \code{method="svd"} or a power
algorithm giving only the first \code{method="Presvd"} or
any other function given applying to the column space of a
matrix and returning a list with \code{v} (in columns
vectors as in \code{svd}) and \code{d}. }
    \item{dim}{
default 1 in each space otherwise specify the number of dimensions
e.g. \code{c(2,3..,2)} (with \code{"Presvd"} dim is obviously 1)}
\item{...} {extra arguments of the method \code{method}: the first argument is fixed (see details). }}
 \details{
Computes the first (or \code{dim}) right singular vector  (or other
summaries) for every representation of the tensor as a matrix with
\code{dim(X)[i]} columns, \code{i=1...k}.}

\value{
a list (of length \emph{k}) of  lists  with arguments:
   \item{v}{the singular vectors in rows}
   \item{modesnam}{a character object naming the mode, \code{"m i"} otherwise}
   \item{n}{labels of mode \code{i} entries as given in \code{dimnames} of the data, can be \code{NULL}}
   \item{d}{the corresponding first singular values}
   }
\references{
Kroonenberg P.M (1983) \emph{Three-mode Principal Component Analysis:
Theory and Applications}.  DSWO Press, Leiden.

Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329. }
\note{
The collection these eigenvectors, is known as the Tucker1 solution
or initialisation related to PCA-3modes or PCA-\emph{n}modes models.
If a function is given  it may include \code{dim} as argument.}
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{ \code{\link{SINGVA}}, \code{\link{PTAk}} }
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{PCAn}
\alias{PCAn}
\title{Principal Component Analysis on n modes }
\description{Performs the Tucker\emph{n} model using a space version of RPVSCC (\code{SINGVA}).}
\usage{
 PCAn(X,dim=c(2,2,2,3),test=1E-12,Maxiter=400,
              smoothing=FALSE,smoo=list(NA),
                verbose=getOption("verbose"),file=NULL,
                  modesnam=NULL,addedcomment="")
}
\arguments{
   \item{X}{
a tensor (as an array) of order \emph{k}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics}
   \item{dim}{a vector of  numbers specifying the dimensions in each space }
\item{test}{control of convergence}
\item{Maxiter}{maximum number of iterations allowed for convergence}
\item{smoothing}{see \code{\link{SVDgen}}}
\item{smoo}{see \code{\link{PTA3}}}
\item{verbose}{control printing}
\item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
\item{modesnam}{character vector of the names of the modes, if \code{NULL}
  "\code{mo 1}" ..."\code{mo k}"}
\item{addedcomment}{character string printed after the title of the analysis}

   }
\details{
Looking for the best rank-one tensor approximation (LS) the three
methods described in the package are equivalent. If the number of
tensors looked for is greater then one the  methods differs:
PTA-\emph{k}modes will "look" for "best" approximation according to the
\emph{orthogonal rank} (\emph{i.e.} the rank-one tensors are
orthogonal), PCA-\emph{k}modes will look for best approximation
according to the \emph{space ranks} (\emph{i.e.} the rank of every
bilinear form, that is the number of components in each space),
PARAFAC/CANDECOMP will look for best approximation according to the
\emph{rank} (\emph{i.e.} the rank-one tensors are not necessarily
orthogonal). For the sake of comparisons the PARAFAC/CANDECOMP method
and the PCA-\emph{n}modes are also in the  package but complete
functionnality  of the use these methods  and more complete packages
may be fetched at the www site quoted below. \cr
Recent work from Tamara G Kolda showed on an example that \emph{orthogonal rank}
decompositions are not necesseraly nested. This makes PTA-\emph{k}modes a model with
nested decompositions not giving the exact \emph{orthogonal rank}.
 So PTA-\emph{k}modes will look for best approximation according to orthogonal tensors in a nested approximmation process. }
\value{a \code{PCAn} (inherits \code{\link{PTAk}}) object}
\references{
Caroll J.D  and Chang J.J (1970) \emph{Analysis of individual
differences in multidimensional   scaling via n-way generalization of
"Eckart-Young" decomposition}. Psychometrika 35,283-319.

Harshman R.A (1970) \emph{Foundations of the PARAFAC procedure:
models and conditions for "an explanatory" multi-mode factor
analysis}. UCLA Working Papers in Phonetics, 16,1-84.

Kroonenberg P (1983) \emph{Three-mode Principal Component Analysis:
Theory and Applications}. DSWO press. Leiden.(related references in
\url{http://www.fsw.leidenuniv.nl/~kroonenb/})

Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329.

Kolda T.G (2003)\emph{ A Counterexample to the Possibility of an Extension of the Eckart-Young Low-Rank Approximation Theorem for the Orthogonal Rank Tensor Decomposition}. SIAM J. Matrix Analysis, 24(2):763-767, Jan. 2003.
              }
\note{The use of metrics (diagonal or not) and smoothing extend flexibility of analysis. }
\author{Didier Leibovici \email{c3s2i@free.fr}}
\keyword{models}
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{PROJOT}
\alias{PROJOT}
\title{Orthogonal Tensor projection }
\description{
Orthogonal-tensoriel projection of a tensor according to a rank-1
tensor, or a to bigger structure defined by kronecker product of
matrices. }
\usage{
 PROJOT(X,solu,numo=1,bortho=TRUE,Ortho=TRUE,metrics=NULL)
}
\arguments{
   \item{X}{a tensor(as an array) of any order }
   \item{solu}{an object like a \code{solutions.PTAk} object with at least \code{v}}
   \item{numo}{
a vector of numbers  or a list of vectors  (length the order of the
tensor) identifying for each space the structure to project onto, if
NULL for a specific space then no projection is done for this space}
\item{bortho}{list of logicals saying if the structures are othogonal
or not.}
  \item{Ortho}{
list of logicals telling the projectors on each space to be  on the
structure  or on its orthogonal.}
  \item{metrics}{NULL or list of metrics (either diagonal or not) for each entry of \code{X}}
 }
\details{
This function computes the \emph{tensorial orthogonal projection} of
\code{X} onto the \emph{tensorial structure} defined by \code{solu}
and \code{numo}. For each space (involved in the tensorial product
where from  \code{X} belongs), one defined the projector onto
\code{solu[[i]][["v"]][numo,]} (or on its orthogonal if
\code{Ortho[[i]]==TRUE}), then the result is the image of \code{X} by
the tensorial product of the projectors, i.e.
 \deqn{(P_{S1} \otimes P_{S2} \otimes \ldots \otimes P_{Sk})(X)}.
 }
\value{A tensor with dimensions as \code{X}}
\references{
Leibovici D (1993) \emph{Facteurs  Mesures Rptes et Analyses
Factorielles : applications  un suivi pidmiologique}. Universit
de Montpellier II PhD Thesis in Mathmatiques et Applications
(Biostatistiques).

Leibovici D (2000) \emph{Multiway Multidimensional Analysis for
Pharmaco-EEG Studies}.(submitted) \url{http://c3s2i.free.fr/cv/recentpub.html}
                     }
\note{
For PTA-\emph{k}modes the projection used is only on rank-one tensors
(Principal Tensors), \emph{i.e.} \code{numo} is a number. The code
here can be used for any structure (on each spaces) and constitutes
the projector onto a tensorial structure, and can define the
PTAIV-\emph{k}modes (PTAk on Instrumental Variables Leibovici(1993).
(see other references  for tensorial product of linear operators in
Leibovici(2000) \emph{e.g.} Dauxois et al.(1994))}
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTAk}} }
\examples{

don <- array(1:360,c(5,4,6,3))
 don <- don + rnorm(360,10,2)

 ones <- list(list(v=rep(1,5)),list(v=rep(1,4)),list(v=rep(1,6)),list(v=rep(1,3)))
 donfc <- PROJOT(don,ones)

 apply(donfc,c(2,3,4),mean)
apply(donfc,c(1),mean)

  # implementation de PTAIVk with obvious settings
 PTAIVk <- function(X,STruct,...)
         {X <- PROJOT(X$data,STruct,numo=Struct[[1]]$numo,Ortho=Struct[[1]]$Ortho,metrics=X$met)
         PTAk(X,...)
         }

   }
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{PTA3}
\alias{PTA3}
\title{Principal Tensor Analysis on 3 modes}
\description{
Performs a truncated SVD-\emph{3}modes analysis with or
without specific metrics, penalised or not.
 }
 \usage{PTA3(X,nbPT=2,nbPT2=1,
                smoothing=FALSE,
                smoo=list(function(u)ksmooth(1:length(u),u,kernel="normal",
                          bandwidth=4,x.points=(1:length(u)))$y,
                          function(u)smooth.spline(u,df=3)$y,
                          NA),
                minpct=0.1,verbose=getOption("verbose"),file=NULL,
                modesnam=NULL,addedcomment="")}

\arguments{
   \item{X}{
a tensor (as an array) of order \emph{3}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics}
   \item{nbPT}{a number specifying the number of \emph{3}modes Principal Tensors requested}
   \item{nbPT2}{if 0 no \emph{2}-modes solutions will be computed, 1 =all, >1 otherwise}
   \item{smoothing}{logical to consider smoothing or not}
   \item{smoo}{a list of length 3 with lists of functions operating on
     vectors component for the appropriate dimension (see details) }
   \item{minpct}{
numerical 0-100 to control of computation of future solutions at this
level and below}
\item{verbose}{control printing}
 \item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
   \item{modesnam}{
character vector of the names of the modes, if \code{NULL} "\code{mo 1}"
..."\code{mo k}"}
 \item{addedcomment}{character string printed after the title of the analysis}

   }

 \details{
According to the decomposition described in Leibovici(1993) and
Leibovici and Sabatier(1998) the function gives a generalisation of
the SVD (2 modes) to \emph{3} modes. It is the same algorithm used
for \code{PTAk} but simpler as the recursivity implied by the
\emph{k} modes analysis is reduced only to one level \emph{i.e} for
every \emph{3}-modes  Principal Tensors, 3 SVD are performed for
every contracted product with one the three components of the
\emph{3}-modes  Principal Tensors (see \code{\link{APSOLU3}},
\code{\link{PTAk}}). \cr

Recent work from Tamara G Kolda showed on an example that \emph{orthogonal rank}
decompositions are not necesseraly nested. This makes PTA-\emph{3}modes a model with
nested decompositions not giving the exact \emph{orthogonal rank}.
 So PTA-\emph{3}modes will look for best approximation according to orthogonal tensors in a nested approximmation process. PTA3 decompositions is "a" generalisation of SVD but not the ...
 \cr
With the \code{smoothing} option \code{smoo} contain a list of (lists) of functions to
apply on vectors of component (within the algorithm, see
\code{\link{SVDgen}}). For a given dimension (1,2,or 3) a list of
functions is given. If this list consists only of one function (no list
needed) this
function will be used at any level all the time : if one want to smooth
only for the first Principal Tensor, put \code{list(function,NA)}. Now
you start to understand this list will have a maximum length of
\code{nbPT} and the corresponding function will be used for the
corresponding \emph{3}mode Principal Tensor. To smooth differently the
associated solutions one have to put another level of nested lists
otherwise the function given at the \emph{3}mode level will be used for
all. These rules are te same for \code{\link{PTAk}}.
}

\value{a \code{\link{PTAk}} object}
\references{
Leibovici D(1993) \emph{Facteurs  Mesures Rptes et Analyses
Factorielles : applications  un suivi pidmiologique}. Universit
de Montpellier II. PhD Thesis in Mathmatiques et Applications
(Biostatistiques).

Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329.

Kolda T.G (2003)\emph{ A Counterexample to the Possibility of an Extension of the Eckart-Young Low-Rank Approximation Theorem for the Orthogonal Rank Tensor Decomposition}. SIAM J. Matrix Analysis, 24(2):763-767, Jan. 2003.
 }

  \note{
The use of metrics (diagonal or not) allows flexibility of analysis like in \emph{2} modes
\emph{e.g.} correspondence analysis, discriminant analysis, robust analysis.  Smoothing option
extends the analysis towards functional data analysis, and or outliers ``protection" is
theoretically valid for tensors belonging to a tensor product of separable Hilbert spaces
(\emph{e.g.} Sobolev spaces) (see references in \code{PTAk}, \code{SVDgen}).}

 \author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{SVDgen}}, \code{\link{FCAk}}, \code{\link{PTAk}}, \code{\link{summary.PTAk}}}
 \examples{
 cat(" A little fun using iris3 and matching randomly 15 for each iris sample!","\n")
 cat("   then performing a PTA-3modes.  If many draws are done, plots")
 cat("   show the stability of the first and third Principal Tensors.","\n")
 cat("iris3 is centered and reduced beforehand for each original variables.","\n")
#  demo function
 # source(paste(R.home(),"/library/PTAk/demo/PTA3.R",sep=""))
 # demo.PTA3(bootn=10,show=5,openX11s=FALSE)
}
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{PTAk-internal}

\alias{Ginv}
\alias{PPMA}
\alias{Powmat}
\alias{RaoProd}
\alias{REBUILDPCAn}
\alias{RESUM}
\alias{svdsmooth}
\alias{toplist}

\title{Internal PTAk functions}
\description{
Internal PTAk functions }
\usage{
Ginv(A)
PPMA(X,test=1E-10,pena=list(function(u)ksmooth(1:length(u),u,kernel="normal",
                     bandwidth=3,x.points=(1:length(u)))$y
                     ,NA) ,ini=mean,vsmin=1E-20,Maxiter=2000)
Powmat(A,pw,eltw=FALSE)
RaoProd(A,B)
REBUILDPCAn(solu)
RESUM(solb,sola=NULL,numass=NULL,verbose=getOption("verbose"),file=NULL
                        ,summary=FALSE,testvar=0.1,with=TRUE)
svdsmooth(X,nomb=min(dim(X)),
                   smooth=list(function(u)ksmooth(1:length(u),u,kernel="normal",
                               bandwidth=3,x.points=(1:length(u)))$y),vsmin=1E-16)
toplist(li)
}
\arguments{
These functions are not supposed to be called directly.
        \item{X}{ a matrix}
         \item{test}{a zero limit number}
         \item{pena}{ list of functions to be used as smoother}
         \item{ini}{initialisation method over the dual dimension}
         \item{vsmin}{zero limit for singular value}
          \item{Maxiter}{limit number of iteration}
           \item{A}{a matrix}
         \item{pw}{ power value number}
          \item{eltw}{ boolean to perform power elementwise or matrix power }
            \item{B}{a matrix}
              \item{solb}{an object inheriting from class \code{PTAk} }
                \item{sola}{an object inheriting from class \code{PTAk} }
                 \item{solu}{an object inheriting from class \code{PTAk} }
                  \item{numass}{position number of the associated solution, NULL is equivalent to the last in \code{sola}}
                  \item{verbose}{boolean playing a verbose role}
                     \item{file}{string pointing a destination of  file output}
                  \item{summary}{boolean to show the summary or not }
                      \item{testvar}{threshold control for minimum percent of variability explained}
                       \item{with}{boolean expression to give a supplementary selection criterion}
                 \item{nomb}{integer giving the number of components to fit}
                 \item{smooth}{idem as pena}
                 \item{li}{any list}
                 }
 \author{Didier Leibovici \email{c3s2i@free.fr}}
  \seealso{\code{\link{PTAk}}}
\keyword{misc}

\eof
\name{PTAk}
\alias{PTAk}
\title{Principal Tensor Analysis on k modes}
\description{
Performs a truncated SVD-\emph{k}modes analysis with or without
specific metrics, penalised or not. }
\usage{
 PTAk(X,nbPT=2,nbPT2=1,minpct=0.1,
                smoothing=FALSE,
                   smoo=list(NA),
                    verbose=getOption("verbose"),file=NULL,
                     modesnam=NULL,addedcomment="")}

\arguments{
   \item{X}{
a tensor (as an array) of order \emph{k}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics}
   \item{nbPT}{
integer vector of length \emph{(k-2)}  specifying the  maximum number
of Principal Tensors requested for the \emph{(3,...,k-1, k)} modes
levels (see details), if it is not a vector every levels would have
the same given nbPT value }
   \item{nbPT2}{if 0 no 2-modes solutions
     will be computed, 1 =all, >1 otherwise}
   \item{minpct}{
numerical 0-100 to control of computation of future solutions at this
level and below}
   \item{smoothing}{see \code{\link{PTA3}}, \code{\link{SVDgen}}}
   \item{smoo}{see \code{\link{PTA3}}}
\item{verbose}{control printing}
 \item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
   \item{modesnam}{character vector of the names of the modes, if \code{NULL} \code{mo 1} ...\code{mo k}}
   \item{addedcomment}{character string printed if \code{printt} after the title of the analysis}
   }

 \details{
According to the decomposition described in Leibovici(1993) and
Leibovici and Sabatier(1998) the function gives a generalisation of
the SVD (2 modes) to \emph{k} modes. The algorithm is recursive,
calling \code{APSOLUk} which calls \code{PTAk} for \emph{(k-1)}.
\code{nbPT}, \code{nbPT2} and \code{minpct} control the number of
Principal Tensors desired. For example \code{nbPT=c(2,4,3)} means a
tensor of order \emph{5} is analysed, the maximum number of 5-modes
PT is set to \emph{3}, for \emph{each of them} one sets a maximum of
\emph{4} associated \emph{4-modes} (for each of the five components),
for \emph{each of these later} a maximum of \emph{2} associated
\emph{3-modes} PT is asked (for each of the four components). Then
\code{nbPT2} complete for \emph{2-modes} associated or not. Overall
\code{minpct} controls to carry on the algorithm at any level and
lower, \emph{i.e.} stops if \eqn{100(vs^2/ssx)<minpct} (where
\eqn{vs} is the singular value, and \emph{ssx} is the total sum of
squares of the tensor \eqn{X} or the "metric transformed" \eqn{X}).
Putting a \eqn{0} at a given level in \code{nbPT} obviously
automatically puts \eqn{0}  in \code{nbPT} at lower levels. Putting
high values in \code{nbPT} allows control only on \code{minpct}
helping to reach the full decomposition. All these controls allow to
truncate the full decomposition in a level-controlled fashion. Notice
the full decomposition always contains any possible choice of
truncation, \emph{i.e.} the solutions are not dependant on the
truncation scheme (Generalised Eckart-Young Theorem).
\cr
Recent work from Tamara G Kolda showed on an example that \emph{orthogonal rank}
decompositions are not necesseraly nested. This makes PTA-\emph{k}modes a model with
nested decompositions not giving the exact \emph{orthogonal rank}.
 So PTA-\emph{k}modes will look for best approximation according to orthogonal tensors in a nested approximmation process.}

  \value{a \code{\link{PTAk}} object }
\author{Didier Leibovici \email{c3s2i@free.fr}}
\references{
Leibovici D(1993) \emph{Facteurs  Mesures Rptes et Analyses Factorielles :
applications  un suivi pidmiologique}. Universit de Montpellier
II. PhD Thesis in Mathmatiques et Applications (Biostatistiques).

Leibovici D and El Maache H (1997) \emph{Une dcomposition en Valeurs Singulires d'un lment
d'un produit Tensoriel de k espaces de Hilbert Sparables}. Compte Rendus de l'Acadmie des
Sciences tome 325, srie I, Statistiques (Statistics) & Probabilits (Probability Theory):
779-782.

Leibovici D and Sabatier R (1998) \emph{A Singular Value Decomposition of a k-ways array for a
Principal Component Analysis of multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329.

Leibovici D (2001) \emph{A Penalised algorithm for SVD and Multiway functional methods}. (in
preparation)

Kolda T.G (2003)\emph{ A Counterexample to the Possibility of an Extension of the Eckart-Young Low-Rank Approximation Theorem for the Orthogonal Rank Tensor Decomposition}. SIAM J. Matrix Analysis, 24(2):763-767, Jan. 2003.
}
\note{
The use of metrics (diagonal or not) allows flexibility of analysis like in \emph{2} modes
\emph{e.g.} correspondence analysis, discriminant analysis, robust analysis.  Smoothing option
extending the analysis towards functional data analysis is theoretically
valid for Principal Tensors  belonging to a tensor product of separable
Hilbert spaces (\emph{e.g.} Sobolev spaces) see Leibovici and El Maach (1997).}
 \seealso{\code{\link{REBUILD}}, \code{\link{FCAk}}, \code{\link{PTA3}} \code{\link{summary.PTAk}}
      }
 \examples{

  # don <- array((1:3)%x%rnorm(6*4)%x%(1:10),c(10,4,6,3))

don <- array(1:360,c(5,4,6,3))
 don <- don + rnorm(360,1,2)

 dimnames(don) <- list(paste("s",1:5,sep=""),paste("T",1:4,sep=""),
          paste("t",1:6,sep=""),c("young","normal","old"))
   # hypothetic data on learning curve at different age and period of year

 ones <-list(list(v=rep(1,5)),list(v=rep(1,4)),list(v=rep(1,6)),list(v=rep(1,3)))

 don <- PROJOT(don,ones)
 don.sol <- PTAk(don,nbPT=1,nbPT2=2,minpct=0.01,
               verbose=TRUE,
                modesnam=c("Subjects","Trimester","Time","Age"),
                 addedcomment="centered on each mode")
 summary(don.sol,testvar=2)
  plot(don.sol,mod=c(1,2,3,4),nb1=1,nb2=NULL,
     xlab="Subjects/Trimester/Time/Age",main="Best rank-one approx" )
  plot(don.sol,mod=c(1,2,3,4),nb1=4,nb2=NULL,
      xlab="Subjects/Trimester/Time/Age",main="Associated to Subject vs1111")

#  demo function
 # demo.PTAk()

  }
 \keyword{array }  \keyword{algebra}
 \keyword{multivariate}

\eof
\name{REBUILD}
\alias{REBUILD}
\title{Build an approximation of the tensor of any order}
\description{
Gives the approximation of a previously analysed tensor using its
given decomposition. }
\usage{
 REBUILD(solutions,nTens=1:2,testvar=1 ,redundancy=FALSE)}
\arguments{
   \item{solutions}{a \code{PTAk} object}
   \item{nTens}{a vector of identifying positions (numbers given in \code{summary}) for  the choice of Principal Tensors to use}
   \item{testvar}{control within \code{nTens} used Principal Tensor with  minimum percent of variability explained}
   \item{redundancy}{
logical to take into account (within \code{nTens}) PT \emph{tested}
redundant during analysis (seealso \code{RESUM}) if \code{TRUE}.}
      }
\details{
The function rebuilds the Principal Tensors, \emph{i.e.} rank-one
tensors of order the order of the tensor analysed, and add them up to
build an approximation of the tensor analysed (according to the
method used see \code{method}). This constitutes a best Least Squares
(ordinary or "weighted"  if metrics are used) approximation of
  \code{datanam} for a given \emph{orthogonal-rank r} (number of
 principal tensors used), if and only if the singular values used are
 the \emph{r} highest.
   }
   \value{A tensor with dimensions as \code{solutions[[k]][["datanam"]]}. }
 \note{
 This function can be called for \code{PARAFAC/CANDECOMP} and
 \code{PCAn}. A specific rebuilt is implemented for this last one. }

 \author{Didier Leibovici \email{c3s2i@free.fr}}

  \seealso{\code{\link{PTAk}}}

\keyword{multivariate}
\keyword{models}

\eof
\name{SINGVA}
\alias{SINGVA}
\title{Optimisation algorithm RPVSCC}
\description{Computes the best rank-one approximation using the RPVSCC algorithm.}
\usage{
SINGVA(X,test=1E-12,PTnam="vs111",Maxiter=2000,
                  verbose=getOption("verbose"),file=NULL,
                    smoothing=FALSE,smoo=list(NA),
                     modesnam=NULL,
                      Ini="Presvd",sym=NULL)}
\arguments{
   \item{X}{
a tensor (as an array) of order \emph{k}, if non-identity metrics are
used \code{X} is a list with \code{data}  as the array and
\code{met} a list of metrics}
   \item{test}{numerical value to stop optimisation}
   \item{PTnam}{character giving the name of the \emph{k}-modes Principal Tensor}
   \item{Maxiter}{if \code{iter > Maxiter} prompts to carry on or not, then do it
     every other 200 iterations}
   \item{verbose}{control printing}
\item{file}{output printed at the prompt if \code{NULL}, or printed in the given  \file{file}}
   \item{smoothing}{logical to use smooth functiosns or not (see
     \code{\link{SVDgen}}) }
   \item{smoo}{list of functions returning smoothed vectors (see
     \code{\link{PTA3}}) }
   \item{modesnam}{character vector of the names of the modes, if \code{NULL} "\code{mo 1}" ..."\code{mo k}"}
   \item{Ini}{method used for initialisation of the algorithm (see \code{INITIA})}
   \item{sym}{description of the symmetry of the tensor \emph{e.g.} c(1,1,3,4,1) means the
     second mode and the fifth are identical to the first }
}

\details{
The algorithm termed \emph{RPVSCC}  in Leibovici(1993) is implemented
to compute the first Principal Tensor (rank-one tensor with its
singular value) of the given tensor \code{X}. According to the
decomposition described in Leibovici(1993) and Leibovici and
Sabatier(1998), the function gives a generalisation  to \emph{k}
modes of the \emph{best rank-one approximation} issued from SVD whith
2 modes. It is identical to  the PCA-\emph{k}modes if only 1
dimension is asked in each space, and to PARAFAC/CANDECOMP if the
rank of the approximation is fixed to 1. Then the methods differs,
PTA-\emph{k}modes will look for best approximation according to the
\emph{orthogonal rank} (\emph{i.e.} the rank-one tensors (of the
decomposition) are orthogonal), PCA-\emph{k}modes will look for best
approximation according to the \emph{space ranks} (\emph{i.e.}  ranks
of every bilinear form deducted from the original tensor, that is the
number of components in each space), PARAFAC/CANDECOMP will look for
best approximation according to the \emph{rank} (\emph{i.e.} the
rank-one tensors are not necessarily orthogonal).
\cr
Recent work from Tamara G Kolda showed on an example that \emph{orthogonal rank}
decompositions are not necesseraly nested. This makes PTA-\emph{k}modes a model with
nested decompositions not giving the exact \emph{orthogonal rank}.
 So PTA-\emph{k}modes will look for best approximation according to orthogonal tensors in a nested approximmation process.
 }
\value{a \code{\link{PTAk}} object (without \code{datanam method})}
\references{
Kroonenberg P (1983) \emph{Three-mode Principal Component Analysis:
Theory and Applications}. DSWO press. Leiden.(related references in
\url{http://www.fsw.leidenuniv.nl/~kroonenb/})
\
Leibovici D (1993) \emph{Facteurs  Mesures Rptes et Analyses
Factorielles : applications  un suivi pidmiologique}. Universit
de Montpellier II. PhD Thesis in Mathmatiques et Applications
(Biostatistiques).

Leibovici D and Sabatier R (1998) \emph{A Singular Value
Decomposition of a k-ways array for a Principal Component Analysis of
multi-way data, the PTA-k}. Linear Algebra and its Applications,
269:307-329.

De Lathauwer L, De Moor B and Vandewalle J (2000) \emph{On the best
rank-1 and rank-(R1,R2,...,Rn) approximation of higher-order
tensors}. SIAM J. Matrix Anal. Appl. 21,4:1324-1342.


Kolda T.G (2003)\emph{ A Counterexample to the Possibility of an Extension of the Eckart-Young Low-Rank Approximation Theorem for the Orthogonal Rank Tensor Decomposition}. SIAM J. Matrix Analysis, 24(2):763-767, Jan. 2003.
}
\note{
The algorithm was derived in generalising the \emph{transition
formulae} of SVD (Leibovici 1993), can also be understood as a
generalisation of the \emph{power method} (De Lathauwer et al.
2000). In this paper they also use a similar algorithm  to build
bases in each space, reminiscent of three-modes and \emph{n}-modes
PCA (Kroonenberg(1980)), \emph{i.e.} defining what they called a
rank-(R1,R2,...,Rn) approximation (called here \emph{space ranks},
see \code{PCAn}). \emph{RPVSCC} stands for  \emph{R}echerche de la \emph{P}remire
\emph{V}aleur \emph{S}ingulire par \emph{C}ontraction
\emph{C}omplte.
 }
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{INITIA}}, \code{\link{PTAk}}, \code{\link{PCAn}},
\code{\link{CANDPARA}} }

\keyword{smooth}
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{SVDgen}
\alias{SVDgen}
\title{SVD with metrics and smoothing approximation}
\description{
Computes the generalised Singular Value Decomposition, \emph{i.e.} with
non-identity metrics. A smooth approximation can be asked to constraint the
components (\code{u} and \code{v}) to be smooth.
 }

\usage{
  SVDgen(Y,D2=1,D1=1,smoothing=FALSE,nomb= min(dim(Y)),
                  smoo=list(function(u)ksmooth(1:length(u),u,kernel="normal",
                           bandwidth=3,x.points=(1:length(u)))$y)) }
 \arguments{
   \item{Y}{a matrix \eqn{n \times p}}
   \item{D2}{metric in \eqn{R^p} either a vector (\eqn{p \times 1}) or a matrix (\eqn{p \times p})}
   \item{D1}{metric in \eqn{R^n} either a vector (\eqn{n \times 1}) or a matrix (\eqn{n \times n})}
   \item{smoothing}{logical if \code{TRUE}  the smoothing methods in
     \code{smoo} are used}
   \item{nomb}{numeric number of components to extract (typically when
     smoothing is used less components are used as the screeplot becomes
     flatter faster)}
   \item{smoo}{
list of lists of smoothing functions on a vector of the approriate dimension; if on one dimension it is
\code{NA} no smoothing will be done for this one; if the length of a list is one the function is used
for all components. If only one list in the list it will be used for both dimensions. } }

 \details{
The function computes the decomposition \eqn{X=UL^{1/2}V'} where \eqn{U'D_1U=Id_p} and
\eqn{V'D_2V=Id_p} and the diagonal matrix \eqn{L} containing no zeros squared singular values. If
\code{smoothing} a \emph{constraint}  on Least Squares solution  is used, then the
above decomposition becomes an approximation (unless \code{X} belongs to the space defined by the constraints). A \emph{Power Method} algorithm to compute each
principal tensor is used wherein Alternated Least Squares are always followed by a \emph{smoothed
version} of the updated vectors. If a Spline smoothing was used the algorithm would be equivalent
to use the traditional \emph{penalised least squares} at each iteration and could be called
\emph{Penalised Power Method} or Splined Alternated Least Squares Algorithm (SALSA is already  an
acronym used by Besse and Ferraty (1995) in where  a similar idea is developped: but smoothing
operates only on variables, and is\emph{ model based} as the Alternating operates on the whole
approximation \emph{i.e.} given the choice of the dimension
reduction). }

\value{a \code{PTAk} object}

\note{
  \code{SVDgen} makes use of a non-identity version \code{svd} (inbuilt) or
\code{svdksmooth} which outputs like the inbuilt \code{svd}. The smoothing
option is also implemented in PTA-kmodes, FCA-kmodes, PCAn and
CANDECOMP/PARAFAC. The use of metrics (diagonal or not) allows flexibility of
analysis like \emph{e.g.} correspondence analysis, discriminant analysis,
robust analysis. Smoothing option extends the analysis towards functional data
analysis, and or outliers protection. 

This smoothing penalising approach is theoretically valid for Principal Tensors (here order 2) belonging
to a tensor product of separable Hilbert spaces (\emph{e.g.} Sobolev
spaces) see Leibovici and El Maach (1997), and in fact only valid for
projection onto this space : this includes polynomial fitting, spline
basis fitting ... As you are penalysing the alternating optimisation
criterion you also need the to get a \emph{robust fit} at each iteration to be
able to reach stationarity and declare optimisation done. If the smoother is not linear one looses orthogonality of
the corresponding components but they are usually not too much correlated
and preserving one mode to be unsmoothed insured orthogonality of the
whole decomposition. Alternatively \code{keepOrtho} insures (as a third
step optimisation for each iteration) orthogonality with the previous
component (but then the solution is approximatively in the space of constraints).

The flexibility of this function \code{smoothing} constraint should be carefully used. The
function offers also the choice to change of smoothing (method or parameters)
as the number of components grows as in Ramsay and Silverman (1997).}
 \references{
Leibovici D and  El Maache H (1997) \emph{Une dcomposition en Valeurs Singulires d'un lment
d'un produit  Tensoriel de k espaces de Hilbert Sparables.} Compte Rendus de l'Acadmie des
Sciences tome  325, srie I, Statistiques (Statistics) & Probabilits (Probability Theory):
779-782.

Besse P and Ferraty F (1995) \emph{Curvilinear fixed effect model}. Computational Statistics, 10:339-351.

Leibovici  D (2001) \emph{Metric choices for fMRI Multiway Data
Analysis}. (to be submitted)

Leibovici  D (2001) \emph{A Penalised algorithm for SVD and Multiway
   functional  methods}. (to be submitted)

Ramsay J.O. and Silverman B.W.  (1997) \emph{Functional Data
    Analysis}. Springer Series in Statistics.
}



\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTAk}},\code{\link{PCAn}}, \code{\link{CANDPARA}} }

\examples{
library(modreg)
 library(tensor)

 # on smoothing

 data(longley)
 long <- as.matrix(longley[,1:7])

 long.svd <- SVDgen(long,smoothing=FALSE)
  summary.PTAk(long.svd,testvar=0)
   # X11(width=4,height=4)
  plot.PTAk(long.svd,scree=TRUE,RiskJack=0,type="b",lty=3)

 long.svdo <- SVDgen(long,smoothing=TRUE,
  smoo=list(function(u)ksmooth(1:length(u),
      u,kernel="normal",bandwidth=3,x.points=(1:length(u)))$y,NA))

  summary.PTAk(long.svdo,testvar=0)
  #  X11(width=4,height=4)
  plot.PTAk(long.svdo,scree=TRUE,RiskJack=0,type="b",lty=3)
 ###using polynomial fitting
   polyfit <- function(u,deg=length(u)/5)
       {n <- length(u);time <- rep(1,n);
        for(e in 1:deg)time<-cbind(time,(1:n)^e);return(lm.fit(time,u)$fitted.values)}
bsfit<-function(u,deg=42)
       {n <- length(u);time <- rep(1,n);
        return(lm.fit(bs(time,df=deg),u)$fitted.values)}

###
 long.svdo2 <- SVDgen(long,nomb=4,smoothing=TRUE,smoo=list(polyfit,NA))
  long.svdo2[[1]]$v[1:3,]%*%t(long.svdo2[[1]]$v[1:3,])
long.svdo[[1]]$v[1:3,]%*%t(long.svdo[[1]]$v[1:3,])
# orthogonality may be lost with non-projective smoother

     ####
comtoplot <- function(com=1,solua=long.svd,solub=long.svdo,openX11s=FALSE,...)
         {
  if(openX11s)X11(width=4,height=4)
 yla <- c(round((100*(solua[[2]]$d[com])^2)/
     solua[[2]]$ssX[1],4),
     round((100*(solub[[2]]$d[com])^2)/solua[[2]]$ssX[1],4))

limi <- range(c(solua[[1]]$v[com,],solub[[1]]$v[com,]))
  plot(solua,nb1=com, mod=1,type="b",lty=3,lengthlabels=4,cex=0.4,
   ylimit=limi,ylab="",col=2,...)
mtext(paste("vs",com,":",yla[1],"\%"),2,col=2,line=2)
 par(new=TRUE)

  plot.PTAk(solub,nb1=com,mod=1,labels=FALSE,type="b",lty=1,
  lengthlabels=4,cex=0.6,ylimit=limi,ylab="",main=paste("smooth vs",com,":",yla[2],"\%"),...)
  par(new=FALSE)
}   ####
 comtoplot(com=1)



#  on using non-diagonal metrics

 data(crimerate)
  crimerate.mat <- sweep(crimerate,2,apply(crimerate,2,mean))
  crimerate.mat <- sweep(crimerate.mat,2,sqrt(apply(crimerate.mat,2,var)),FUN="/")
   metW <- Powmat(CauRuimet(crimerate.mat),(-1))
   # inverse of the within "group" (to play a bit more you could set m0 relating
   # the neighbourhood of states (see CauRuimet)

  cri.svd <- SVDgen(crimerate.mat,D2=1,D1=1)
  summary(cri.svd,testvar=0)
   plot(cri.svd,scree=TRUE,RiskJack=0,type="b",lty=3)
  cri.svdo <- SVDgen(crimerate.mat,D2=metW,D1=1)
   summary(cri.svdo,testvar=0)
   plot(cri.svdo,scree=TRUE,RiskJack=0,type="b",lty=3)
  # X11(width=8,height=4)
  par(mfrow=c(1,2))
   plot(cri.svd,nb1=1,nb2=2,mod=1,lengthlabels=3)
  plot(cri.svd,nb1=1,nb2=2,mod=2,lengthlabels=4,main="canonical")
  # X11(width=8,height=4)
  par(mfrow=c(1,2))
 plot(cri.svdo,nb1=1,nb2=2,mod=1,lengthlabels=3)
 plot(cri.svdo,nb1=1,nb2=2,mod=2,lengthlabels=4,
       main=expression(paste("metric ",Wg^{-1})))

###########
#  demo function
 # when ima is NULL it uses the dataset timage12 but you can put any array
 # demo.SVDgen(ima=NULL,snr=3,openX11s=TRUE)  

    }

\keyword{smooth}
\keyword{multivariate}

\eof
\name{TENSELE}
\alias{TENSELE}
\title{Elementary Tensor product}
\description{
Computes the Tensor Product of a list of vectors  (or matrices) according to
a given order.}
 }
 \usage{
 TENSELE(T,moins=NULL, asarray=TRUE,order=NULL,id=NULL)}
 \arguments{
   \item{T}{a list like a \code{PTAk} object and minimally  just contains \code{v} }
   \item{moins}{if not \code{NULL}, vector of indexes  (in the list T) to skip  }
   \item{asarray}{logical to specify the output form \code{TRUE} gives an array, \code{FALSE} gives a vector}
   \item{order}{
if not \code{NULL} vector of length \code{length(T)}, \code{NULL} is equivalent to
\code{length(T):1} as the function makes indexes in order run slowest to
fastest }
   \item{id}{
when \code{T} is a list of matrices, can be either a vector of
\code{length(T)} giving indexes of the vectors for each space (following
order) or a list of vectors of indexes.} }
\details{
The tensor product of the vectors (or matrices) in the list \code{T} is
computed, skipping or not the indexes in \code{moins}, the output tensor is
either in tensor form or in vector form. The way the tensor product is done
follows \code{order}.}
\value{
According to \code{asarray} the value is either an array, or a vector
representing the tensor product of the vectors (not in moins), the dimension
in \code{order[1]} running the slowest.}

\author{Didier Leibovici \email{c3s2i@free.fr}}
 \seealso{\code{\link{REBUILD}}}

\keyword{array }  \keyword{algebra}

\eof
\name{datasets}
\alias{timage12}
\alias{crimerate}
\title{data used for demo in SVDgen}
\description{The \code{crimerate} dataset provides crime rates per 100,000 people in
 seven categories for each of the fifty states in 1977.  The \code{timage12} dataset
  is an image from fMRI analysis, it is a \emph{t}-statistic image over 12 subjects of the activation (verbal) parameter. }
\usage{
data(crimerate)
data(timage12)
}
\format{
A matrix of \code{50 x 7} for the \code{crimerate} data.

A matrix \code{91 x 109} for \code{timage12} data.}
\source{\code{crimerate} comes from SAS. The image comes from FMRIB center, University of Oxford. }

\keyword{datasets}

\eof
\name{howtoPTAk}
\alias{howtoPTAk}
\title{howto for Principal Tensors Analysis of a k-modes Tensor}
\description{A mini guide to handle PTAk model decomposittion}
 \usage{
howtoPTAk()}

\arguments{}
 \details{The PTAk decomposition aims at building an approximation of a given multiway data, represented as a tensor, based on a variance criterion. This approximation is given by a set of rank one tensors, orthogonals to each other, in a nested algorithm process and so controlling the level of approximation by the amount of variability extracted and represented by the sum of squares of the singular values (associated to the rank one tensors). In that respect it offers a way of generalising PCA to tensors of order greater than 2. \cr
 \cr
 Full description of the licence is given in the file copyrights given in the distribution, or alternatively in the readme file  along with the history of changes. This function displays the copyright and licence information.}

\references{ Leibovici D and Sabatier R (1998) \emph{A Singular Value Decomposition of a k-ways
array for a Principal Component Analysis of multi-way data, the PTA-k}. Linear Algebra and its
Applications, 269:307-329 }

\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{\code{\link{PTA3}}, \code{\link{PTAk}} ,\code{\link{FCAk}}}
\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
\name{plot.PTAk}
\alias{plot.PTAk}
\alias{RiskJackplot}
\title{Plot a PTAk object}
\description{
Screeplot of singular values or plot of superposed
modes or not for one or two components.}
\usage{
 plot.PTAk(x,labels=TRUE,mod=1,nb1=1,nb2=NULL,coefi=list(NULL,NULL),
                xylab=TRUE,ppch=(1:length(solution)),lengthlabels=2,ylimit=NULL,
                scree=FALSE,ordered=TRUE,nbvs=40,RiskJack=NULL,method="",...)
RiskJackplot(x,nbvs=1:20,mod=NULL,max=NULL,rescaled=TRUE,...)
                              }
\arguments{
\item{x}{an object inheriting from class \code{PTAk}, representing a generalised  singular value decomposition}
\item{labels}{logical if \code{TRUE} plots the labels given in \code{solution[[mod]]["n"]}}
\item{mod}{vectors of the modes numbers to be plotted}
\item{nb1}{number identifying the Principal Tensor to display on the vertical
axe, can be checked using \code{\link{summary.PTAk}} }
\item{nb2}{as nb1 to be displayed on the horizontal axe, if \code{NULL} the horizontal
axe will be used  as \code{Index} (see \code{\link{plot.default}}) }
\item{coefi}{coefficients to multiply components for rescaling or changing signs
purposes; each element of the list correpond to \code{nb1} and \code{nb2}
and are vectors of dimentions the tensor order}
\item{xylab}{logical to display axes labels}
\item{ppch}{a vector of length at least \code{length(mod)} used for \code{pch=}}
\item{lengthlabels}{
a number or a vector of numbers of characters in labels to be used for display}
\item{ylimit}{
used in ylim as initialisation range (in order to compare different plots)}
\item{scree}{
logical to display s screeplot of squared singular values as percent of total variation}
\item{ordered}{logical used when displaying the screeplot  with sorted
values (TRUE) or the order is given by output listing from
\code{summary.PTAk}}
\item{nbvs}{a maximum number of singular values to display on the screeplot or a vector of ranks}
\item{max}{is the number of singular values to be considered as giving the perfect fit, NULL is the max possible in x}
\item{rescaled}{boolean to rescale the y axis to 0-100}
\item{RiskJack}{
if not \code{NULL} is a integer,  scree is \code{TRUE} and ordered is \code{TRUE}, plots
on top of the scree plot a Risk plot with maximum dimension: \cr
\code{min(RiskJack+length(nbvs),length(solution[[k]][["d"]]))}. It is
possible to use directly the function \code{RiskJackplot}: the default
maximum dimension (argument \code{max}) is  \code{length(solution[[k]][["d"]])}. }
\item{method}{default is \code{""}, a value \code{"FCA"} is to be used only
if \code{solution} is after an FCA with \code{SVDgen}}
\item{...}{plot arguments can be passed (except \code{xlim, ylim,ylab,pch,xaxt} for component plot,
and \code{xlab, ylab} for screeplot)}
    }
 \details{
Plot components of one or two Principal Tensors, modes are superposed if more
than one is asked, or gives a screeplot. As it is using \code{plot.default} at
some point some added features can be used in the ... part, especially
\code{xlab= } may be useful when \code{nb2=NULL}. Plots are superposed as they
correspond to the same Principal Tensor and so this gives insight to
interpretation of it, but careful is recommended as only overall
interpretation, once the Principal Tensor has been rebuilt mentally
(\emph{i.e.} product of signs ...) to work out oppositions or associations. The
risk plot on top of a screeplot is an approximation of the Jacknife estimate of
the MSE in the choice of number of dimensions (see Besse et al.(1997)). }
\references{
Besse, P Cardot, H and Ferraty, F (1997) \emph{Simultaneous
non-parametric regressions of unbalanced longitudinal
data}. Computational Statistics and Data Analysis, 24:255-270.

Leibovici D (2000) \emph{Multiway Multidimensional Analysis for Pharmaco-EEG
Studies}.(submitted) \url{http://c3s2i.free.fr/cv/recentpub.html}
             }
\note{This function is used all for \code{FCAk}, and
  \code{CANDPARA}, \code{PCAn} objjects notheless for this
  last object other interesting plots known as jointplots have not been implemented.}
\author{Didier Leibovici \email{c3s2i@free.fr}}
\seealso{ \code{\link{PTAk}}, \code{\link{PTA3}},
\code{\link{FCAk}},\code{\link{SVDgen}}}
\examples{
#  see the demo function   source(paste(R.home(),"/ library/PTAk/demo/PTA3.R",sep=""));
# or    source(paste(R.home(),"/ library/PTAk/demo/PTAk.R",sep=""));
 
 # demo.PTA3()
 }

\keyword{hplot}
\keyword{multivariate}

\eof
\name{preprocessings}
\alias{preprocessings}
\alias{Multcent}
\alias{IterMV}
\alias{Detren}
\alias{Susan1D}
\title{Few useful functions for preprocessing arrays }
\description{Choices of centering or detrending  and scaling are important preprocessings for multiway analysis.}
\usage{
Multcent(dat=X,bi=c(1,2),by=3,
          centre=mean,
           centrebyBA=c(TRUE,FALSE),scalebyBA=c(TRUE,FALSE))
IterMV(n=10,dat=X,Mm=c(1,3),Vm=c(2,3),
               fFUN=mean,usetren=FALSE,
                  tren=function(x)smooth.spline(as.vector(x),df=5)$y,
                   rsd=TRUE)
Detren(dat,Mm=c(1,3),rsd=TRUE,
         tren=function(x)smooth.spline(as.vector(x),df=5)$y )
Susan1D(y,x=NULL,sigmak=NULL,sigmat=NULL,
          ker=list(function(u)return(exp(-0.5*u**2))))
}
\arguments{
                 \emph{function} \code{Multcent}
  \item{dat}{array}
  \item{bi}{vector defining the "centering, bicentering or multi-centering" one wants
    to operate crossed with \code{by}}
  \item{by}{number or vector defining the entries used "with" in
    the other operations}
  \item{centre}{function used as \code{FUN} in applying
    "multi-centering"}
  \item{centrebyBA}{a bolean vector for "centering" with \code{centre} Before and After
    according to \code{by}}
  \item{scalebyBA}{idem as centrebyBA, for scaling operation}
                \cr \emph{function} \code{IterMV}
  \item{n}{number of iterations between "centering" and scaling}
  \item{Mm}{margins to performs \code{Detren} or \code{fFUN} on}
  \item{Vm}{margins to scale}
  \item{fFUN}{function to use as \code{FUN} if \code{usetren} is
    \code{FALSE}}
  \item{usetren}{logical, to use \code{Detren}}
  \item{tren}{function to use in \code{Detren}}
  \item{rsd}{logical passed into \code{Detren} (only) to detrend or not}

  \cr \emph{function} \code{Detren}
  

  \cr \emph{function} \code{Susan1D}
  \item{y}{vector (length \code{n})}
  \item{x}{vector of same length, if \code{NULL} it is \code{1:n} }
  \item{sigmak}{parameter related to kernel bandwidth with \code{y}
    values (default is \code{1/2*range}}
  \item{sigmat}{parameter related to kernel bandwidth with  \code{x}
    values (default value is \code{8*n^{-1/5}}, with a minimum number of
  neigbours set as one apart)}
  \item{ker}{a list of two kernels \code{list("t"=function "k"=function
      ) } for each weightings (if only one given it is used for
      both)}
  }
\details{\code{Multcent} performs in order "centering" by \code{by};
  "multicentering" for every \code{bi} with \code{by}; then scale
  (standard deviation) to one by \code{by}.

   \code{IterMV} performs an iterative "detrending" and scaling
   according to te margins defined (see Leibovici(2000) and references
   in it).

    \code{Detren} detrends (or smooths if \code{rsd} is \code{FALSE})
    the data accoding to th margins given.

    \code{Susan1D} performs a non-linear kernel smoothing  of \code{y}
    against \code{x} (both reordered in the function according to orders
     of \code{x}) with an usual kernel (\code{t}) as for kernel
     regression and a kernel (\code{t}) for the values of \code{y} (the
     product of the kernels constitutes the non-linear weightings. This
     function is adapted from SUSAN algorithm (see references).



}
  \author{Didier Leibovici \email{c3s2i@free.fr}}

\references{
 Smith S.M. and J.M. Brady (1997) \emph{SUSAN - a new approach to low level image processing}.
     International Journal of Computer Vision, 23(1):45-78, May 1997.
   }

\keyword{multivariate}
\keyword{smooth}

\eof
\name{summary.PTAk}
\alias{summary.PTAk}
\alias{summary.FCAk}
\title{Summary of a PTA-k modes analysis}
\description{Print a summary listing of the decomposition obtained.
}
\usage{
summary.PTAk(object,testvar=1,dontshow="*",...)
summary.FCAk(object,testvar=0.5,dontshow="*",...)
}
\arguments{
   \item{object}{an object inheriting from class \code{PTAk}, representing a generalised  singular value decomposition}
   \item{testvar}{control within \code{nTens} used Principal Tensor with  minimum percent of variability explained}
   \item{dontshow}{
boolean criterion to remove Principal Tensors from the summary, or
default is a character "*" equivalent to the criterion:
\cr
\code{!substr(solution[[length(solution)]][["vsnam"]],1,1)=="*"} }
\item{...}{summary generic additional arguments not used here }
}
\details{
The function prints a listing of the decomposition with historical
order (instead of traditional singular value order). It is useful
before any plots or reconstruction, a screeplot (using
\code{plot.PTAk}) will be also useful. It is useful before any plots
r reconstruction, a screeplot (using \code{plot.PTAk}) will be also
useful. \code{summary.FCAk} is alike
\code{summary.PTAk} but \code{testvar} operates on the variability of
the lack of complete independence. }

\value{prints on the prompt}
\references{
Leibovici D (2000) \emph{Multiway Multidimensional Analysis for
  Pharmaco-EEG Studies}.(submitted)
\url{http://c3s2i.free.fr/cv/recentpub.html}
}

\author{Didier Leibovici \email{c3s2i@free.fr}}

\note{At the moment can be used for \code{PCAn},
  \code{CANDPRA}, better summaries will be in the next release.}
 \seealso{ \code{\link{plot.PTAk}} }

 \examples{
 data(crimerate)
 crimerate.mat <- sweep(crimerate,2,apply(crimerate,2,mean))
 crimerate.mat <- sweep(crimerate.mat,2,sqrt(apply(crimerate,2,var)),FUN="/")
 cri.svd <- SVDgen(crimerate.mat)
 summary(cri.svd,testvar=0)
  plot(cri.svd,scree=TRUE)
  par(new=TRUE)
  RiskJackplot(cri.svd,nbvs=1:7,mod=NULL,max=NULL,rescaled=TRUE,
        axes=FALSE,ann=FALSE)
  par(new=FALSE)

  # or equivalently

  plot(cri.svd,scree=TRUE,type="b",lty=3,RiskJack=1) #set mod=NULL or c(1,2)
  ###
   data(crimerate)
   criafc <- FCAmet(crimerate,chi2=TRUE)
   cri.afc <- SVDgen(criafc$data,criafc$met[[2]],criafc$met[[1]])
    summary(cri.afc)
   plot(cri.afc,scree=TRUE)
   plot(cri.afc,scree=TRUE,type="b",lty=3,RiskJack=1,method="FCA")


   }

\keyword{array }  \keyword{algebra}
\keyword{multivariate}

\eof
