\name{RArcInfo}
\alias{RArcInfo}


\title{RArcInfo}
\description{
This package allows the user to import into R binary coverages in format
Arc/Info V 7.x. These coverages represent geographical data in several forms:
points, lines, polygons, point labels, etc. 

 RArcInfo uses the library AVCE00, written by Daniel Morissette, to whom I would
thank fo his marvelous work. But RArcInfo is much more than a wrapper of this library, because
it provides functions to plot the data and draw maps.

 Since the geographical data are separated into several files, RArcInfo provides a different 
function to read each file. These functions are called get.XXXdata, where XXX is the
file name to open (usually the extension is 'adf'):

\item get.arcdata

 ARC files contain arcs definition and their vertices.

\item get.bnddata

 BND files contain coordinates for the boundary of the data.

\item get.cntdata

 CNT files contain polygon centroid information.

\item get.labdata

 LAB files contain label point records.

\item get.paldata

 PAL files contain the polygon definitions.

\item get.toldata

 TOL files contain the tolerance values that were used when processing the polygon coverage.

\item get.txtdata

 TXT files contain annotations (or labels) about the data.


 Besides these files, binary coverage store several tables containing additional information
(like name of the city, population, etc.). To get this data, RArcInfo provides the
next functions:


\item get.tablenames 

 Gets all the table names and the coverage each table belongs to.

\item get.tablefields

 Gets the names of the fields for a given table.

\item get.tabledata

 Gets the data stored in the table.


In order to plot the data, RArcInfo has several functions:

\item plotarc

 Plots all the arcs.

\item plotpal

 Plots all the polygons.

\item plotpoly

 Like plotpal, but it allows to select the polygons we want to plot, colour and 
other stuff. This is useful to plot maps according the value of some covariate.
  

To get all the names of the coverages, the user can call 'get.namesofcoverages'.

Other two interesting functions are:

\item thinlines

 Useful to reduce the number of points in an arc according to a given
 tolerance.

\item get.nb

 Calculates the neighbouring polygons of a given set of polygons.
}


\seealso{get.arcdata, get.bnddata, get.cntdata, get.labdata, get.paldata,
get.toldata, get.txtdata, get.tablenames, get.tablefields, get.tabledata,
get.namesofcoverages, read.coverage, thinlines, get.nb }


\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\examples{
library(RArcInfo)

datadir<-system.file("exampleData",package="RArcInfo")
infodir<-system.file("exampleData","info",package="RArcInfo")
coveragedir<-system.file("exampleData","wetlands",package="RArcInfo")

#get.bnddata needs the last slash...
infodir<-paste(c(infodir,"/"), collapse="")

#List all the tables

covnames<-get.namesofcoverages(datadir)
tablenames<-get.tablenames(infodir)


#Display the name of the table and its filds
for(i in 1:length(tablenames[[1]]))
{
	print(c("Table: ",tablenames$TableName[i]))

	fields<-get.tablefields(infodir,tablenames$TableName[i])
	print("Fields")
	for(j in 1:length(fields))
		print(fields[[j]][1])

	#Get the data
	if(i==1)
		tabledata<-get.tabledata(infodir,tablenames$TableName[i])
	else
		tabledata<-c(tabledata, get.tabledata(infodir,tablenames$TableName[i]) )
}

#Import data fromsome tables
arc<-get.arcdata(datadir,"wetlands")
pal<-get.paldata(datadir,"wetlands")
lab<-get.labdata(datadir,"wetlands")
cnt<-get.cntdata(datadir,"wetlands")

bnd<-get.bnddata(infodir,"WETLANDS.BND")

print("Plotting all the arcs")
plotarc(arc)

print("Plotting the first ten polygons (in red) on the previous plot")
par(col="red")
plotpal(arc,pal,new=FALSE, index=1:10)
}

\keyword{file}

\eof
\name{avctoe00}
\alias{avctoe00}

\title{Converts a ARC/INFO binary coverage into an ESRI E00 file}
\description{
This function makes a convertion to an ESRI E00 file from a binary
coverage. 

}

\usage{avctoe00(avcdir, e00file)}

\arguments{
\item{avcdir}{The path to the binary coverage we want to convert from.}
\item{e00file}{The E00 file to be created.}
}

\value{
Returns 'NULL' on exit.
}

\seealso{e00toavc}

\references{
More information about this topic can be found at
\url{http://pages.infinit.net/danmo/e00/index-avce00.html}.
}

\keyword{file}




\eof
\name{e00toavc}
\alias{e00toavc}

\title{Converts an ESRI E00 file into an Arc/Info V 7.x binary coverage}
\description{
This function makes a convertion from an ESRI E00 file to a binary
coverage. Usually two new directories
are created. One with the name of the coverage and another called 'info',
where some information about the tables are created. If this directory
already exists (because there are already other binary coverages), 
then the new information is added and no file is replaced or deleted.

}

\usage{e00toavc(e00file, avcdir)}

\arguments{
\item{e00file}{The E00 file to be converted.}
\item{avcdir}{The path to the binary coverage directory we want to create.}
}

\value{
Returns 'NULL' on exit.
}

\seealso{avctoe00}

\references{
More information about this topic can be found at
\url{http://pages.infinit.net/danmo/e00/index-avce00.html}.
}

\keyword{file}


\eof
\name{get.arcdata}
\alias{get.arcdata}


\title{Function for importing the contents of an ARC file into R}
\description{
This function reads and imports into R the  contents of an arcs definition file.
}


\usage{get.arcdata(datadir, coverage, filename="arc.adf")}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with.}
\item{filename}{The name of the file in the coverage directory that
stores the data. By default, it is called 'arc.dat'.}
}

\value{
This function returns a list with two elements. The first one is a data
frame containing the next fields (by columns):

\item{ArcID}{A number that identifies this arc.}

\item{ArcUserID}{Identifier defined by the user.}

\item{FromNode}{The node where the arc begins.}

\item{ToNode}{The node where the arc finishes.}

\item{LeftPoly}{The number of the polygon that is to the left of the arc.}

\item{RightPoly}{The number of the polygon that is to the right of the arc.}

\item{NVertices}{The number of vertices the arc has.}

The second element is a list that stores the vertices of the arc. So, each element
in this list is also a list of two arrays: the first for the X coordinates
and the secod for the Y coordinates.
}


\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.bnddata}
\alias{get.bnddata}

\title{Function for importing the contents of a BND file into R}
\description{
This function reads and imports into R the  contents of a BND file. This kind
of files store the bounds of the given coverage (the one we are working
with). That is, the upper and lower bounds for the x and y coordinates.
}

\usage{get.bnddata(infodir, tablename)}

\arguments{
\item{infodir}{Directory where there is a file called arc.dat (usually, it is called 'info').}
\item{tablename}{The name of the table in the coverage that
stores the data (usually called 'COVERAGENAME.BND').}
}


\value{
A vector with the  x min, y min, x max and y max values.
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.cntdata}
\alias{get.cntdata}

\title{Function for importing the contents of a CNT file into R}
\description{
This function reads and imports into R the  contents of a polygon centroid information file.
}

\usage{get.cntdata(datadir, coverage, filename="cnt.adf")}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with.}
\item{filename}{The name of the file in the coverage directory that
stores the data (usually called 'cnt.adf').}
}

\value{
This functions returns a list with two elements. The first one is a data frame
with the next fields (columns):

\item{PolygonID}{The polygon itself.}

\item{CoordX}{An array with the X coordinates of the centroid.}

\item{CoordY}{An array with the Y coordinates of the centroid.}

\item{NLabels}{The number of labels this polygon has.}

The second element in the list is an array with the label identifiers related
to this polygon.
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.labdata}
\alias{get.labdata}

\title{Funtion for importing  the contents of a LAB file into R}
\description{
This function reads and imports into R the  contents of a polygon labels definition file.
}

\usage{get.labdata(datadir, coverage, filename="lab.adf")}

\arguments{
\item{datadir}{Directory under which iall the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with}
\item{filename}{The name of the file in the coverage directory that
stores the data. By default, called 'lab.adf'.}
}

\value{
This function returns a data frame with the next fields (by columns):

\item{LabelUserID}{The label of the polygon.}

\item{PolygonID}{The polygon related to the label.}

\item{Coord1X}{The X component of the first coordinate.}

\item{Coord2X}{The X component of the second coordinate.}

\item{Coord3X}{The X component of the third coordinate.}

\item{Coord1Y}{The Y component of the first coordinate.}

\item{Coord2Y}{The Y component of the second coordinate.}

\item{Coord3Y}{The Y component of the third coordinate.}
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}
\keyword{file}

\eof
\name{get.namesofcoverages}
\alias{get.namesofcoverages}

\title{Function for getting the names of the coverages}

\description{
This function returns the name of all the coverages under the given directory.
}

\usage{get.namesofcoverages(directory)}

\arguments{
\item{directory}{A character string with the name of the directory which 
contains the coverages.}
}

\values{
A list of character strings with the names of the files and directories
under the given one.
}

\keyword{file}

\eof
\name{get.nb}
\alias{get.nb}


\title{Function for calculating neighbouting polygons.}
\description{
This function allows the user to calculate, for every given polygon (in the
array 'index'), the list of its neighbouring polygons.  

}


\usage{get.nb(arc,pal, index=NULL)}

\arguments{
\item{arc}{The list of arc definitions, as returned by 'get.arcdata'.}
\item{pal}{The list of polygon definitions, as returned by 'get.paldata'.}
\item{index}{An array with the polygons we want to use to calculate their
neighbours. It must be an array. If 'index' is not set, then all the polygons
are used.}
}

\value{
A list in which the first element is a vector of the neighbouring polygons
of the fist element in 'index', and so on.
}


\keyword{file}

\eof
\name{get.paldata}
\alias{get.paldata}

\title{Function for importing the contents of a PAL file into R}
\description{
This function reads and imports into R the  contents of a polygon definitions file. 
}

\usage{get.paldata(datadir, coverage, filename="pal.adf")}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with}
\item{filename}{The name of the file in the coverage directory that
stores the data. By default, it is called 'pal.adf'}
}

\value{
This function returns a list with two elements. The first one is
a data frame with the next fields (columns):

\item{PolygonID}{A number that identifies this polygon.}
\item{MinX}{Minimum value for all the X component of the coordinates.}
\item{MinY}{Minimum value for all the Y component of the coordinates.}
\item{MaxX}{Maximum value for all the X component of the coordinates.}
\item{MaxY}{Maximum value for all the Y component of the coordinates.}
\item{NArcs}

The second element in the list is also a list in which each element is
composed by three arrays with information about the polygons that 
are in the polygon boundary:  'Arc ID', 'From Node' and 'Adjacent Polygon'.
}


\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.tabledata}
\alias{get.tabledata}

\title{Function for importing  the contents of a table file into R}
\description{
This function reads and imports into R the  contents of a table file.
}

\usage{get.tabledata(infodir, tablename)}

\arguments{
\item{infodir}{Info directory where there is a file called arc.dat}
\item{tablename}{The name of the table from which we want to import the data}
}

\value{
This function returns a data frame in which each column stores the
data of a field from the table. The columns are not assigned the names
of the fields, but this can be got with the get.tablefields function.
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.tablefields}
\alias{get.tablefields}

\title{Function for reading names of the table fields in the coverages}
\description{
This function returns the names of the fields (and its type) in the table whose names are 
provided by the user. 
}


\usage{get.tablefields(infodir,tablename)}

\arguments{
\item{infodir}{Info directory where there is a file called arc.dat}
\item{tablename}{The name of the table from which we want to get the fields}
}

\value{
This function returns a data frame with the next fields (columns):

\item{FieldName}{The name of the field.}

\item{FieldType}{
This is an integer from 1 to 6 that explain the kind of data:

	\itemize{
		
	\item{1}{Date}

	\item{2}{Character String}

	\item{3}{Integer (stored as a character string)}

	\item{4}{Numeric (stored as a character string)}

	\item{5}{Binary integer}

	\item{6}{Binary float}
		}
	}
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.tablenames}
\alias{get.tablenames}

\title{Function for reading the names of the tables in the coverages}
\description{
This function reads the arc.dat file in the info directory and it returns a list
with some data about the tables. Each element of this list is 
another list with data from a single table.
}


\usage{get.tablenames(infodir)}

\arguments{
\item{infodir}{info dir where there is a file called arc.dat}
}

\value{
A list with some information about the tables stored in all the coverages:

\itemize{

\item{Table Name}

\item{Info File}

\item{Number of fields}

\item{Record Size}

\item{Number of records}

\item{Internal/External Table (FALSE/TRUE)}
	}
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.toldata}
\alias{get.toldata}

\title{Function for importing the contents of a TOL file into R}
\description{
This function reads and imports into R the  contents of a tolerance definition file.
}

\usage{get.toldata(datadir, coverage, filename="tol.adf")}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with}
\item{filename}{The name of the file in the coverage directory that
stores the data. By default it is called 'tol.adf'. In some cases, when
the values are stored in double precission,
the tolerances are in a file whose name is 'par.adf'.} 
}

\value{
This function returns a data frame with the next fields (columns):

\item{Type}{A number from 1 to 10 showing the tolerance type.} 

\item{Status}{This field indicates whether the tolerance is active or not.}

\item{Value}{Tolerance value.}
}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{get.txtdata}
\alias{get.txtdata}


\title{Function for importing the contents of an TXT file into R}
\description{
This function reads and imports into R the  contents of a file of annotations (TXT).
}


\usage{get.txtdata(datadir, coverage, filename="txt.adf")}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with.}
\item{filename}{The name of the file in the coverage directory that
stores the data. By default, it is called 'txt.dat'.}
}

\value{
This function returns a list with two elements. The first one is a dataframe
with the next columns:

\item{TxtID}{This field identifies the anotation.}

\item{UserID}{Identifier defined by the user.}

\item{Level}{I don't know what this exactly means. Please, help me to fix this.}

\item{NVerticesLine}{Number of vertices pairs that are valid.}

\item{NVerticesArrow}{I don't know what this exactly means. Please, help me to fix this.}

\item{Text}{Some text related to the annotation.}


The second element in the list is another list containing the vertices
related the annotation. For each annotation there are two vectors, for
the X and Y coordinates.
}


\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{plotarc}
\alias{plotarc}

\title{Plots the data imported from an ARC file}
\description{

Taking as argument the list returned by the get.arcdata function,
this function plots all the arcs. With the argument new the user can decide
whether to plot on a new window/device or on the last window/device.

If the user provides the arguments 'xlim' and 'ylim' they will be used when 
calling the 'plot' function. Other way, the real boundary of the plotted
arcs will be used.
}

\usage{plotarc(arc, new=TRUE, index=NULL, ...)}

\arguments{
\item{arc}{The data returned by a call to get.arcdata}
\item{new}{Do you want to plot on the last window/device or on a new one?}
\item{index}{A vector containing the indexes of the arcs to be plotted. If it nos supplied all the arcs will be plotted.}
\item{...}{Options to be passed to a call to the function plot when
creating the display (i. e., window or file).}
}

\value{
This function returns nothing, but plots a nice map :-D.
}

\keyword{hplot}

\eof
\name{plotpal}
\alias{plotpal}

\title{Plots the data imported from an ARC file according to the contents
of a PAL file}

\description{
This function works like plotarc, but we can also decide what polygons to
plot. The arc definitions are stored in the arc variable, and the polygon 
definitions are in the pal variable.
}

\usage{plotpal(arc, pal, new=TRUE, index, ...)}

\arguments{
\item{arc}{The data returned by a call to get.arcdata}
\item{pal}{The data returned by a call to get.paldata}
\item{new}{Do you want to plot on the last window/device or on a new one?}
\item{index}{The indices of the polygons to be plotted.}
\item{...}{Options to be passed to a call to the function plot when
creating the display (i. e., window or file).}
}

\value{
This function returns nothing, but plots a nice map :-D.
}

\keyword{hplot}

\eof
\name{plotpoly}
\alias{plotpoly}

\title{Plots polygons defined by the coverages.}

\description{
This function is capable of plotting polygons, referenced by its id number.
These can be filled with colors acording to a given variate.
}

\usage{plotpoly(arc,bnd,pal,index=NULL,col, xratio=1, yratio=1,...)}

\arguments{
\item{arc}{The data returned by a call to get.arcdata}
\item{bnd}{The data returned by a call to get.bnddata}
\item{pal}{The data returned by a call to get.paldata}
\item{index}{IDs of the polygon to be plotted. If it is 'NULL' then all the polygons are plotted.}
\item{col}{Colors to be used when filling the polygons}
\item{xratio}{Controls x-axis ratio. It can take any value from 0 to 1.}
\item{yratio}{Controls x-axis ratio. It can take any value from 0 to 1.}
\item{...}{Options to be passed to a call to the function plot when
creating the display (i. e., window or file).}
}

\value{
Thins function returns nothing, but plots a nice map. :-D
}

\keyword{hplot}

\eof
\name{read.coverage}
\alias{read.coverage}

\title{Function for retrieving basic data from a given coverage}
\description{
This function allows the user to retrieve the main data stored in the chosen
coverage. This doesn't mean that all the data are retrieved, but only the
most important.

Tables are not imported, but a dataframe containig the information provided by
a call to get.tablenames of all the tables related to the coverage.

For a single coverage there can be more than one pal file, so just their names
are imported (into 'palfiles'). Then, the user can choose which one to import
by calling get.paldata.  But, if there is just one pal file, it is imported
into 'pal'.

The names of the different files are supposed to be the default names when
calling the proper get.XXXdata. If some of these names change then the
function will not import that feature properly. But this fact should never
happen.
}

\usage{read.coverage(datadir, coverage)}

\arguments{
\item{datadir}{Directory under which all the coverages and a directory called 'info' are.}
\item{coverage}{The name of the coverage we want to work with}
}

\value{
This function returns a list of all the data directory, coverage name
and all the data imported:
i
\item{datadir}{The directory where all the coverages are stored, the one used 
when this function was called.}

\item{coverage}{The name of the coverage used when calling this function.}

\item{arc}{The arc definitions, as returned by get.arcdata.}

\item{bnd}{The bounday definition, as returned by get.bnddata.}

\item{cnt}{The polygon centroids, as returned by get.cntdata.}

\item{lab}{The label point records of the coverage.}

\item{pal}{If there is just one file for the polygon definitions inside the 
coverage, it is imported here using get.paldata. Otherwise, it is filled 
with a 'NULL'.}

\item{palfiles}{The names of all the polygon definitions files.}

\item{tblnames}{The description of all the tables related to the coverage,
as returned by get.tablenames.}

\item{tol}{The tolerance values.}

}

\references{
More information about this kind of data can be found at
\url{http://pages.infinit.net/danmo/e00/docs/v7_bin_cover.html}.
}

\keyword{file}

\eof
\name{thinlines}
\alias{thinlines}
\alias{thinl}

\title{Function for deleting points in an arc definition object}
\description{
Usually the plotting device resolution allows us to plot only a few
points per arc with no difference.
}

\usage{thinlines(arc, tol)}

\arguments{
\item{arc}{The original arc definition object, as retuend by get.arcdata.}
\item{tol}{The theshold we used to define which polygons are 'too close'.}
}


\value{
A new arc definition object, usually with less points per arc than the original.
Notice that no modification is made to the topology but the number of
vertices is updated in the table related to the arc definition.
}

\keyword{file}

\eof
