### Name: SQLite
### Title: Instantiate the SQLite engine from the current R/S-Plus session.
### Aliases: SQLite SQLiteDriver
### Keywords: interface database

### ** Examples
## Don't run: 
##D    # create a SQLite instance and create one connection.
##D    m <- dbDriver("SQLite")
##D    
##D    # initialize a new database "base.dbms" in the current directory
##D    # and copy some data.frame from the base package into it
##D    
##D    con <- dbConnect(m, dbname = "base.dbms")
##D    data(USArrests)
##D    dbWriteTable(con, "USArrests", USArrests, overwrite = T)
##D    
##D    # query
##D    rs <- dbSendQuery(con, "select * from USArrests")
##D    d1 <- fetch(rs, n = 10)      # extract data in chunks of 10 rows
##D    dbHasCompleted(rs)
##D    d2 <- fetch(rs, n = -1)      # extract all remaining data
##D    dbHasCompleted(rs)
##D    dbClearResult(rs)
##D    dbListTables(con)    
##D    
## End Don't run



