### Name: skewt.axis
### Title: Draws a SKEW-T, log p axis.
### Aliases: skewt.axis
### Keywords: hplot

### ** Examples

# draw a background, then
#    draw the temperature (with a solid line) in color 6
#    draw the dewpoint in color 7
#    overlay the temperature observations in a different color
#    you get the point ...
#
filename <- system.file("exampleData", "ExampleSonde.txt", package = "RadioSonde")   
sample.sonde <- getsonde(filename)
skewt.axis( mar=c(5.1, 1.1, 2.1, 5.1) )
skewt.lines( sample.sonde$temp,  sample.sonde$press, col = 6)
skewt.lines( sample.sonde$dewpt, sample.sonde$press, col = 7)
skewt.points(sample.sonde$temp,  sample.sonde$press, col = 3)
skewt.points(sample.sonde$dewpt, sample.sonde$press, col = 4)
#
# Changing the moist adiabats: you must edit the this-is-escaped-code{ function
# directly and then capture the output in this-is-escaped-codenormal-bracket36bracket-normal to be used in 
# subsequent calls.
skewt.data <- skewt.axis(redo=TRUE)
skewt.axis() 
skewt.axis() 



