\name{ambition}
\alias{ambition}
\docType{data}
\title{Ambition and Attainment}
\description{
In a study of ambition and attainment 7 variables are measured on 767
twelth grade males.  The variables are:
  \tabular{lcl}{
    \eqn{X_1}{X1} \tab : \tab father's education,\cr
    \eqn{X_2}{X2} \tab : \tab father's occupation,\cr 
    \eqn{X_3}{X3} \tab : \tab number of siblings,\cr 
    \eqn{X_4}{X4} \tab : \tab intelligence,\cr 
    \eqn{X_5}{X5} \tab : \tab grades,\cr 
    \eqn{X_6}{X6} \tab : \tab educational expectation,\cr 
    \eqn{X_7}{X7} \tab : \tab occupational aspiration.
  }
}
\usage{data(ambition)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{ambition$means} \tab : \tab the mean vector,\cr 
    \code{ambition$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{ambition$corr} \tab : \tab the correlation matrix, and \cr
    \code{ambition$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See Ch. 10.4).
}
\examples{
data(ambition)
ambition$means
ambition$stddev
ambition$corr
ambition$n
}
\keyword{datasets}

\eof
\name{anxietyanger}
\alias{anxietyanger}
\docType{data}
\title{Anxiety and Anger}
\description{
Measurements on 684 students. The 4 variables are:
  \itemize{
    \item Anxiety state,
    \item Anger state,
    \item Anxiety trait,
    \item Anger trait.
  }
}
\usage{data(anxietyanger)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{anxietyanger$means} \tab : \tab the mean vector,\cr 
    \code{anxietyanger$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{anxietyanger$corr} \tab : \tab the correlation matrix, and \cr
    \code{anxietyanger$n}    \tab : \tab the sample size.
  }
}
\source{
  Cox, D.R. \& Wermuth, N.  (1993) Linear Dependencies Represented by
  Chain Graphs.  \emph{Statistical Science} 8(3): 204-283. (See Table 1).
}
\examples{
data(anxietyanger)
anxietyanger$means
anxietyanger$stddev
anxietyanger$corr
anxietyanger$n
}
\keyword{datasets}

\eof
\name{blauduncan}
\alias{blauduncan}
\docType{data}
\title{Blau and Duncan's data on the American occupational structure}
\description{
Sample of 20,700 subjects for which 5 variables are measured:
  \tabular{lcl}{
    \eqn{V} \tab : \tab   Father's educational attainment,\cr 
    \eqn{X} \tab : \tab   Father's occupational status,\cr 
    \eqn{U} \tab : \tab   educational attainment,\cr 
    \eqn{W} \tab : \tab   Status of first-job,\cr 
    \eqn{Y} \tab : \tab   Status of occupation in 1962.
  }
}
\usage{data(blauduncan)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{blauduncan$means} \tab : \tab the mean vector,\cr 
    \code{blauduncan$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{blauduncan$corr} \tab : \tab the correlation matrix, and \cr
    \code{blauduncan$n}    \tab : \tab the sample size.
  }
}
\source{
  Blau, P. \& Duncan, O. (1967) \emph{The American Occupational
    Structure}. New York: Wiley. (See p.13 and p.169).
}
\references{
  Spirtes, P., Glymour, C. \& Scheines, R.  (2000) \emph{Causation,
    Prediction, and Search}. Cambridge, Massachusetts: The MIT
  Press. (See pp.105-108).
}
\examples{
data(blauduncan)
blauduncan$means
blauduncan$stddev
blauduncan$corr
blauduncan$n
}
\keyword{datasets}


\eof
\name{bloodpressure}
\alias{bloodpressure}
\docType{data}
\title{Blood Pressure}
\description{
In a study on relating blood pressure to age, weight, and stress at
work, 6 measurements are taken on 98 subjects.  The variables are:
  \tabular{lcl}{
    \eqn{a} \tab : \tab age,\cr 
    \eqn{b} \tab : \tab weight,\cr
    \eqn{c} \tab : \tab anger at work,\cr
    \eqn{d} \tab : \tab anxiety at work,\cr
    \eqn{e} \tab : \tab diastolic blood pressure,\cr
    \eqn{f} \tab : \tab systolic blood pressure.
  }
}
\usage{data(bloodpressure)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{bloodpressure$means} \tab : \tab the mean vector,\cr 
    \code{bloodpressure$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{bloodpressure$corr} \tab : \tab the correlation matrix, and \cr
    \code{bloodpressure$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See p.343).
}
\examples{
data(bloodpressure)
bloodpressure$means
bloodpressure$stddev
bloodpressure$corr
bloodpressure$n
}
\keyword{datasets}

\eof
\name{bodyfat}
\alias{bodyfat}
\docType{data}
\title{Body Fat}
\description{
Data consists of estimates of the percentage of body fat determined by
underwater weighing and various body circumference measurements for 252 men.
The 15 variables are:
  \itemize{
    \item Density determined from underwater weighing,
    \item Percent body fat,
    \item Age (years),
    \item Weight (lbs),
    \item Height (inches),
    \item Neck circumference (cm),
    \item Chest circumference (cm),
    \item Abdomen 2 circumference (cm),
    \item Hip circumference (cm),
    \item Thigh circumference (cm),
    \item Knee circumference (cm),
    \item Ankle circumference (cm),
    \item Biceps (extended) circumference (cm),
    \item Forearm circumference (cm),
    \item Wrist circumference (cm).
  }
}
\usage{data(bodyfat)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{bodyfat$means} \tab : \tab the mean vector,\cr 
    \code{bodyfat$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{bodyfat$corr} \tab : \tab the correlation matrix, and \cr
    \code{bodyfat$n}    \tab : \tab the sample size.
  }
}
\source{
  The data set is available online at StatLib---Datasets Archive\cr 
  \url{http://lib.stat.cmu.edu/datasets/bodyfat} .
}
\examples{
data(bodyfat)
bodyfat$means
bodyfat$stddev
bodyfat$corr
bodyfat$n
}
\keyword{datasets}

\eof
\name{corkborings}
\alias{corkborings}
\docType{data}
\title{Cork Borings}
\description{
Data from cork borings on 28 trees.  The 4 variables are the weights of
cork deposits in the four directions
  \tabular{lcl}{
    \eqn{N} \tab : \tab North,\cr
    \eqn{E} \tab : \tab East,\cr
    \eqn{S} \tab : \tab South,\cr
    \eqn{W} \tab : \tab West.
  }
}
\usage{data(corkborings)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{corkborings$means} \tab : \tab the mean vector,\cr 
    \code{corkborings$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{corkborings$corr} \tab : \tab the correlation matrix, and \cr
    \code{corkborings$n}    \tab : \tab the sample size.
  }
}
\source{
  Mardia, K.V., Kent, J.T. \& Bibby, J.M. (1979) \emph{Multivariate
  analysis}. London: Academic Press.  (See pp.11-12).
}
\examples{
data(corkborings)
corkborings$means
corkborings$stddev
corkborings$corr
corkborings$n
}
\keyword{datasets}

\eof
\name{fisherz}
\alias{fisherz}
\title{Fisher's z-transform}
\description{
  This function implements Fisher's z-transform, which maps a
  correlation \eqn{\rho\in (-1,1)}{rho in (-1,1)} to
  \deqn{\frac{1}{2} \log \frac{1+\rho}{1-\rho}.}{0.5*log((1+rho)/(1-rho)).}
}
\usage{fisherz(corrs)}
\arguments{
  \item{corrs}{a vector of correlations in (-1,1).}
}
\value{
  The return value is a vector of z-transformed correlations.
}
\references{
  Anderson, T.W.  (2003) \emph{An Introduction to Multivariate
    Statistical Analysis}, third edition.  Hoboken, New Jersey: Wiley.
  (See p.133-134).
}
\examples{
corrs <- c(-0.5,0,0.5)
fisherz(corrs)
}
\keyword{multivariate}

\eof
\name{fowlbones}
\alias{fowlbones}
\docType{data}
\title{Fowl Bones}
\description{
  Bone measurements are taken on 276 white leghorn fowl. The 6 variables
  are:  
  \itemize{
    \item skull length,
    \item skull breadth,
    \item humerous (wings),
    \item ulna (wings),
    \item femur (legs),
    \item tibia (legs).
  }
}
\usage{data(fowlbones)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{fowlbones$means} \tab : \tab the mean vector,\cr 
    \code{fowlbones$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{fowlbones$corr} \tab : \tab the correlation matrix, and \cr
    \code{fowlbones$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See p.266).
}
\examples{
data(fowlbones)
fowlbones$means
fowlbones$stddev
fowlbones$corr
fowlbones$n
}
\keyword{datasets}

\eof
\name{fretsheads}
\alias{fretsheads}
\docType{data}
\title{Frets' Heads}
\description{
Head measurements on the first an the second adult son in a sample of 25
families. The 4 variables are:
  \itemize{
    \item head length (first son),
    \item head breadth (first son),
    \item head length (second son),
    \item head breadth (second son).
  }
}
\usage{data(fretsheads)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{fretsheads$means} \tab : \tab the mean vector,\cr 
    \code{fretsheads$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{fretsheads$corr} \tab : \tab the correlation matrix, and \cr
    \code{fretsheads$n}    \tab : \tab the sample size.
  }
}
\source{
  Mardia, K.V., Kent, J.T. \& Bibby, J.M.  (1979) \emph{Multivariate
    analysis}. London: Academic Press. (See p.121).
  \cr\cr
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See p.265).
}
\examples{
data(fretsheads)
fretsheads$means
fretsheads$stddev
fretsheads$corr
fretsheads$n
}
\keyword{datasets}

\eof
\name{getgraph}
\alias{getgraph}
\title{Obtain graph from simultaneous p-values}
\description{
  This function converts a matrix of simultaneous p-values into a graph
  by comparing the p-values to a user-provided significance level.
}
\usage{getgraph(pvals, alpha, type="UG", blocks=NULL)}
\arguments{
  \item{pvals}{a matrix of simultaneous p-values.}
  \item{alpha}{a significance level, i.e., alpha in (0,1).}
  \item{type}{a string specifying the type of graph that should be
  obtained from the p-value matrix. If type equals \code{"UG"} then an
  undirected graph is returned, if type equals \code{"DAG"} then an acyclic
  directed graph is returned, and if type equals \code{"BG"} then a bidirected
  graph is returned.  If type equals the fourth possible choice \code{"CG"}
  then a chain graph is returned, in which case a list of integer
  vectors has to be provided as the input \code{blocks}.}
  \item{blocks}{a list of integer
  vectors specifying a family of subsets of the variables.}
}
\value{
  The function returns an adjacency matrix \eqn{A}{A} with
  \eqn{A_{ij}=0}{A[i,j]=0}
  if there is no edge between vertices
  (variables) \eqn{i}{i} and \eqn{j}{j}. The convention for edges is
  that \eqn{i-j}{i-j} if and only if
  \eqn{A_{ij}=A_{ji}=1}{A[i,j]=A[j,i]=1}, \eqn{i\to j}{i->j} if and only
  if \eqn{A_{ij}=1}{A[i,j]=1} and \eqn{A_{ji}=0}{A[j,i]=0}, and
  \eqn{i\leftrightarrow j}{i<->j} 
  if and only if \eqn{A_{ij}=A_{ji}=2}{A[i,j]=A[j,i]=2}.
}
\examples{
data(fowlbones)
pvals <- sinUG(fowlbones$corr,fowlbones$n)
alpha <- 0.2
## get undirected graph
getgraph(pvals, alpha, type="UG") 
## forget that we used sinUG and get acyclic directed graph
getgraph(pvals, alpha, type="DAG")
## forget that we used sinUG and get bidirected graph
getgraph(pvals, alpha, type="BG")
## forget that we used sinUG and get chain graph
myblocks <- list(1:2,3:4,5:6)
getgraph(pvals, alpha, type="CG", blocks=myblocks)
}
\keyword{multivariate}

\eof
\name{glucose}
\alias{glucose}
\docType{data}
\title{Glucose}
\description{
From an investigation of determinants of blood glucose control.  Data on
39 diabetic patients.  The 4 variables are:
  \itemize{
    \item glycosylated hemoglobin GHb,
    \item knowledge about the illness,
    \item duration of the illness,
    \item fatalism (measure of patient's attitude to disease).
  }
}
\usage{data(glucose)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{glucose$means} \tab : \tab the mean vector,\cr 
    \code{glucose$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{glucose$corr} \tab : \tab the correlation matrix, and \cr
    \code{glucose$n}    \tab : \tab the sample size.
  }
}
\source{
  Cox, D.R. \& Wermuth, N.  (1993)  Linear Dependencies Represented by
  Chain Graphs.  \emph{Statistical Science} 8(3): 204-283. (See Table 7).
}
\examples{
data(glucose)
glucose$means
glucose$stddev
glucose$corr
glucose$n
}
\keyword{datasets}

\eof
\name{grades}
\alias{grades}
\docType{data}
\title{School Grades}
\description{
The data consists of the test results of 220 boys in the 6 school
subjects:  
  \itemize{
    \item Gaelic,
    \item English,
    \item history,
    \item arithmetic,
    \item algebra,
    \item geometry.
  }
}
\usage{data(grades)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{grades$means} \tab : \tab the mean vector,\cr 
    \code{grades$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{grades$corr} \tab : \tab the correlation matrix, and \cr
    \code{grades$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See p.266).
}
\examples{
data(grades)
grades$means
grades$stddev
grades$corr
grades$n
}
\keyword{datasets}

\eof
\name{hiv}
\alias{hiv}
\docType{data}
\title{HIV}
\description{
The data consists of 6 blood measurements taken on 107 babies:
  \itemize{
    \item immunoglobin G,
    \item immunoglobin A,
    \item lymphocyte B,
    \item platelet count,
    \item lymphocyte T4,
    \item T4/T8 lymphocyte ratio.
  }
}
\usage{data(hiv)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{hiv$means} \tab : \tab the mean vector,\cr 
    \code{hiv$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{hiv$corr} \tab : \tab the correlation matrix, and \cr
    \code{hiv$n}    \tab : \tab the sample size.
  }
}
\source{
  Roverato, A. \& Whittaker, J.  (1996) A hyper normal prior distribution
  for approximate Bayes factor calculations on non-decomposable
  graphical Gaussian models, unpublished manuscript.
}
\examples{
data(hiv)
hiv$means
hiv$stddev
hiv$corr
hiv$n
}
\keyword{datasets}

\eof
\name{holm}
\alias{holm}
\title{Holm's step-down p-values}
\description{
  This function takes a matrix of simultaneous p-values from Sidak's
  inequality and adjusts the p-values according to Holm's step-down procedure.
}
\usage{holm(pvals)}
\arguments{
  \item{pvals}{a matrix of simultaneous p-values from Sidak's inequality.}
}
\value{
  A matrix of simultaneous p-values from Holm's step-down procedure with
  \code{NA} on the diagonal. 
}
\references{
  Holm, S.  (1979)  A Simple Sequentially Rejective Multiple Test
  Procedure.  \emph{Scandinavian Journal of Statistics} 6: 65-70.
}
\examples{
data(mathmarks)
sinUG(mathmarks$corr,mathmarks$n)
holm(sinUG(mathmarks$corr,mathmarks$n))
}
\keyword{multivariate}



\eof
\name{is.blocks}
\alias{is.blocks}
\title{Check variable blocking}
\description{
  This function checks whether a list of vectors defines a valid
  decomposition of the set of variables into blocks.
}
\usage{is.blocks(blocks, p)}
\arguments{
  \item{blocks}{a list of integer vectors representing a family of
    subsets of the variable set.}
  \item{p}{the number of variables.}
}
\value{
  The function returns \code{TRUE} if the block structure is such that
  each variable is represented in exactly one of the blocks.  Otherwise,
  \code{FALSE} is returned.
}
\examples{
p <- 6
blocks <- list(1:3,6,5:4)
is.blocks(blocks, p)
blocks <- list(1:3,7,5:4)
is.blocks(blocks, p)
blocks <- list(1:2,6,5:4)
is.blocks(blocks, p)
}
\keyword{multivariate}

\eof
\name{mathmarks}
\alias{mathmarks}
\docType{data}
\title{Mathematics marks}
\description{
Examination marks of 88 students in the five subjects:
  \itemize{
    \item Mechanics,
    \item Vectors,
    \item Algebra,
    \item Analysis,
    \item Statistics.
  }
}
\usage{data(mathmarks)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{mathmarks$means} \tab : \tab the mean vector,\cr 
    \code{mathmarks$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{mathmarks$corr} \tab : \tab the correlation matrix, and \cr
    \code{mathmarks$n}    \tab : \tab the sample size.
  }
}
\details{
  Mechanics and Vectors were closed book examinations. Algebra, Analysis
  and Statistics were open book examinations.
}
\source{
  Mardia, K.V., Kent, J.T. \& Bibby, J.M. (1979) \emph{Multivariate
    analysis}. London: Academic Press. (See pp.3-4).
  \cr\cr
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See Ch. 1.1).
}
\examples{
data(mathmarks)
mathmarks$means
mathmarks$stddev
mathmarks$corr
mathmarks$n
}
\keyword{datasets}

\eof
\name{moth}
\alias{moth}
\docType{data}
\title{Noctuid Moth Trappings}
\description{
The data are of sample size 72 and contain 6 variables:
  \describe{
    \item{\emph{min}}{minimum night temperature},
    \item{\emph{max}}{previous day's maximum temperature},
    \item{\emph{wind}}{average wind speed during night},
    \item{\emph{rain}}{amount of rain during night},
    \item{\emph{cloud}}{percentage of starlight obscured by clouds},
    \item{\emph{moth}}{number of moths caught in a light trap in one 
night}.
  }
}
\usage{data(moth)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{moth$means} \tab : \tab the mean vector,\cr 
    \code{moth$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{moth$corr} \tab : \tab the correlation matrix, and \cr
    \code{moth$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See Ch. 10.3).
}
\examples{
data(moth)
moth$means
moth$stddev
moth$corr
moth$n
}
\keyword{datasets}

\eof
\name{plotBGpvalues}
\alias{plotBGpvalues}
\title{Plot simultaneous p-values for bidirected graphs}
\description{
  This function plots the simultaneous p-values for SIN
  model selection for bidirected graphs.
}
\usage{plotBGpvalues(pvals, legend=T, legendpos=NULL)}
\arguments{
  \item{pvals}{a matrix of p-values.}
  \item{legend}{a Boolean.}
  \item{legendpos}{a numerical vector of length 2.}
}
\value{
  A plot illustrating the simultaneous p-values.  If
  \code{legend==TRUE}, then a legend giving information on the variable
  labelling is drawn. Optionally, the position of the legend can be
  specified by \code{legendpos}.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{sinBG}}
}
\examples{
data(stressful)
pvals <- holm(sinBG(stressful$corr,stressful$n))
\dontrun{plotBGpvalues(pvals)}
\dontrun{plotBGpvalues(pvals, legend=F)}
\dontrun{plotBGpvalues(pvals, legendpos=c(5,0.5))}
\dontrun{plotBGpvalues(pvals, legend=T, legendpos=c(5,0.5))}
}
\keyword{multivariate}

\eof
\name{plotCGpvalues}
\alias{plotCGpvalues}
\title{Plot simultaneous p-values for chain graphs}
\description{
  This function plots the simultaneous p-values for SIN
  model selection for chain graphs.
}
\usage{plotCGpvalues(blocks, pvals, legend=T, legendpos=NULL)}
\arguments{
  \item{blocks}{a list of integer vectors with entries amongst
    \eqn{1,\ldots,p} where \eqn{p} is the number of variables.  Each one
    of the integer vectors specifies a set of variables that form a
    block in the chain graph. Furthermore, a partial ordering of the
    variables is specified by the convention that
    variables in one block are ordered smaller than variables in a block
    succeeding in the list \code{blocks}.}
  \item{pvals}{a matrix of p-values.}
  \item{legend}{a Boolean.}
  \item{legendpos}{a numerical vector of length 2.}
}
\value{
  A plot illustrating the simultaneous p-values.  If
  \code{legend==TRUE}, then a legend giving information on the variable
  labelling is drawn. Optionally, the position of the legend can be
  specified by \code{legendpos}.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{sinCG}}
}
\examples{
data(fowlbones)
blocks <- list(1:2,3:4,5:6)
pvals <- holm(sinCG(blocks,fowlbones$corr,fowlbones$n, type="AMP"))
\dontrun{plotCGpvalues(blocks, pvals)}
\dontrun{plotCGpvalues(blocks, pvals, legend=F)}
\dontrun{plotCGpvalues(blocks, pvals, legendpos=c(7,0.5))}
\dontrun{plotCGpvalues(blocks, pvals, legend=T, legendpos=c(7,0.5))}
}
\keyword{multivariate}

\eof
\name{plotDAGpvalues}
\alias{plotDAGpvalues}
\title{Plot simultaneous p-values for acyclic directed graphs}
\description{
  This function plots the simultaneous p-values for SIN
  model selection for acyclic directed graphs (DAGs).
}
\usage{plotDAGpvalues(pvals, legend=T, legendpos=NULL)}
\arguments{
  \item{pvals}{a matrix of p-values.}
  \item{legend}{a Boolean.}
  \item{legendpos}{a numerical vector of length 2.}
}
\value{
  A plot illustrating the simultaneous p-values.  If
  \code{legend==TRUE}, then a legend giving information on the variable
  labelling is drawn. Optionally, the position of the legend can be
  specified by \code{legendpos}.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{sinDAG}}
}
\examples{
data(fowlbones)
p <- dim(fowlbones$corr)[1]
pvals <- holm(sinDAG(list(1:p),fowlbones$corr,fowlbones$n))
\dontrun{plotDAGpvalues(pvals)}
\dontrun{plotDAGpvalues(pvals, legend=F)}
\dontrun{plotDAGpvalues(pvals, legendpos=c(7,0.5))}
\dontrun{plotDAGpvalues(pvals, legend=T, legendpos=c(7,0.5))}
}
\keyword{multivariate}

\eof
\name{plotUGpvalues}
\alias{plotUGpvalues}
\title{Plot simultaneous p-values for undirected graphs}
\description{
  This function plots the simultaneous p-values for SIN
  model selection for undirected graphs.
}
\usage{plotUGpvalues(pvals, legend=T, legendpos=NULL)}
\arguments{
  \item{pvals}{a matrix of p-values.}
  \item{legend}{a Boolean.}
  \item{legendpos}{a numerical vector of length 2.}
}
\value{
  A plot illustrating the simultaneous p-values.  If
  \code{legend==TRUE}, then a legend giving information on the variable
  labelling is drawn. Optionally, the position of the legend can be
  specified by \code{legendpos}.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{sinUG}}
}
\examples{
data(fowlbones)
pvals <- holm(sinUG(fowlbones$corr,fowlbones$n))
\dontrun{plotUGpvalues(pvals)}
\dontrun{plotUGpvalues(pvals, legend=F)}
\dontrun{plotUGpvalues(pvals, legendpos=c(7,0.5))}
\dontrun{plotUGpvalues(pvals, legend=T, legendpos=c(7,0.5))}
}
\keyword{multivariate}

\eof
\name{pubprod}
\alias{pubprod}
\docType{data}
\title{Publishing productivity}
\description{
Sample of 162 subjects for which 7 variables are measured:
  \tabular{lcl}{
    ability \tab : \tab   score of the subject's ability,\cr 
    GPQ     \tab : \tab  measure of the quality of the graduate program attended ,\cr 
    preprod \tab : \tab   preliminary measure of productivity,\cr 
    QFJ     \tab : \tab   quality of the first-job,\cr 
    sex     \tab : \tab   sex,\cr
    cites   \tab : \tab   citation rate,\cr
    pubs    \tab : \tab   publication rate.
  }
}
\usage{data(pubprod)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{pubprod$means} \tab : \tab the mean vector,\cr 
    \code{pubprod$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{pubprod$corr} \tab : \tab the correlation matrix, and \cr
    \code{pubprod$n}    \tab : \tab the sample size.
  }
}
\source{
  Spirtes, P., Glymour, C. \& Scheines, R.  (2000) \emph{Causation,
    Prediction, and Search}. Cambridge, Massachusetts: The MIT
  Press. (See Example 5.8.1).
}
\examples{
data(pubprod)
pubprod$means
pubprod$stddev
pubprod$corr
pubprod$n
}
\keyword{datasets}


\eof
\name{sdcor2cov}
\alias{sdcor2cov}
\title{Covariance matrix}
\description{
  This function takes a vector of standard deviations and a correlation
  matrix as input and computes the covariance matrix.
}
\usage{sdcor2cov(stddev, corr)}
\arguments{
  \item{stddev}{a vector of standard deviations.}
  \item{corr}{a correlation matrix.}
}
\value{
  The function returns the covariance matrix corresponding to the input
  information.
}
\examples{
data(sur)
sdcor2cov(sur$stddev, sur$corr)
}
\keyword{multivariate}

\eof
\name{simpvalueMx}
\alias{simpvalueMx}
\title{Simultaneous p-values}
\description{
  Simultaneous p-values are computed for a correlation matrix. Function
  only for internal use.
}
\usage{simpvalueMx(corr,n)}
\arguments{
  \item{corr}{a correlation matrix.}
  \item{n}{the sample size.}
}
\value{
  A matrix of simultaneous p-values with \code{NA} on the diagonal.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{simpvalueVec}}
}
\examples{
data(fowlbones)
temp <- -solve(fowlbones$corr)
diag(temp) <- abs(diag(temp))
temp <- cov2cor(temp)
round( simpvalueMx(temp,fowlbones$n), 2)
}
\keyword{internal}


\eof
\name{simpvalueVec}
\alias{simpvalueVec}
\title{Simultaneous p-values}
\description{
  Simultaneous p-values are computed for a vector of
  correlations. Function only for internal use.
}
\usage{simpvalueVec(corrs,n,p)}
\arguments{
  \item{corrs}{a vector of correlations in (-1,1).}
  \item{n}{the sample size.}
  \item{p}{the number of variables.}
}
\value{
  A vector of simultaneous p-values.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{simpvalueMx}}
}
\examples{
data(fowlbones)
temp <- -solve(fowlbones$corr)
diag(temp) <- abs(diag(temp))
temp <- cov2cor(temp)
p <- dim(temp)[1]
round( simpvalueVec(temp[1,2:p],fowlbones$n,p), 2)
}
\keyword{internal}


\eof
\name{sinBG}
\alias{sinBG}
\title{SIN for bidirected graphs}
\description{
  This function computes the matrix of simultaneous p-values for SIN
  model selection for bidirected (or covariance) graphs.
}
\usage{sinBG(S,n)}
\arguments{
  \item{S}{a covariance or correlation matrix.}
  \item{n}{the sample size.}
}
\value{
  A matrix of simultaneous p-values with \code{NA} on the diagonal.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{plotBGpvalues}}
}
\examples{
data(stressful)
sinBG(stressful$corr,stressful$n)
holm(sinBG(stressful$corr,stressful$n))
}
\keyword{multivariate}



\eof
\name{sinCG}
\alias{sinCG}
\title{SIN for chain graphs}
\description{
  This function computes the matrix of simultaneous p-values for SIN
  model selection for chain graphs.  SIN assumes that 
  a dependence chain or blocking of the variables is available.  
}
\usage{sinCG(blocks, S, n, type="AMP")}
\arguments{
  \item{blocks}{a list of integer vectors with entries amongst
    \eqn{1,\ldots,p} where \eqn{p} is the number of variables.  Each one
    of the integer vectors specifies a set of variables that form a
    block in the chain graph. Furthermore, a partial ordering of the
    variables is specified by the convention that
    variables in one block are ordered smaller than variables in a block
    succeeding in the list \code{blocks}.}
  \item{S}{a covariance or correlation matrix.}
  \item{n}{the sample size.}
  \item{type}{a string equal to either \code{"AMP"} or \code{"LWF"} that
    determines whether the chain graph is interpreted with respect to
    the Andersson, Madigan, Perlman Markov property or the Lauritzen,
    Wermuth, Frydenberg Markov property.}
}
\value{
  A matrix of simultaneous p-values with \code{NA} on the diagonal.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
  \cr\cr
  Andersson, S.A., Madigan, D. \& Perlman, M.D.  (2001) Alternative
  Markov Properties for Chain Graphs. \emph{Scandinavian Journal of
    Statistics} 28(1): 33-85.
  \cr\cr
  Lauritzen, S.  (1996) \emph{Graphical Models}.  Oxford University
  Press: Oxford.
}
\seealso{
  \code{\link{plotCGpvalues}}
}
\examples{
data(fowlbones)
p <- dim(fowlbones$corr)[1]
blocks <- list(1:2,3:4,5:6)
sinCG(blocks,fowlbones$corr,fowlbones$n, type="AMP")
sinCG(blocks,fowlbones$corr,fowlbones$n, type="LWF")
holm(sinCG(blocks,fowlbones$corr,fowlbones$n, type="AMP"))
holm(sinCG(blocks,fowlbones$corr,fowlbones$n, type="LWF"))
}
\keyword{multivariate}



\eof
\name{sinDAG}
\alias{sinDAG}
\title{SIN for acyclic directed graphs}
\description{
  This function computes the matrix of simultaneous p-values for SIN
  model selection for acyclic directed graphs (DAGs).  SIN assumes that
  a total ordering of the variables is available (e.g., as a
  time-order). 
}
\usage{sinDAG(order,S,n)}
\arguments{
  \item{order}{a list of pairwise different integers amongst
    \eqn{1,\ldots,p} where \eqn{p} is the number of variables.  This
    list specifies a total ordering of the variables by the convention that
    a list element is smaller than succeeding list elements.}
  \item{S}{a covariance or correlation matrix.}
  \item{n}{the sample size.}
}
\value{
  A matrix of simultaneous p-values with \code{NA} on the diagonal.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{plotDAGpvalues}}
}
\examples{
data(fowlbones)
p <- dim(fowlbones$corr)[1]
sinDAG(list(1:p),fowlbones$corr,fowlbones$n)
holm(sinDAG(list(1:p),fowlbones$corr,fowlbones$n))
sinDAG(list(3,2,1,4,5,6),fowlbones$corr,fowlbones$n)
}
\keyword{multivariate}



\eof
\name{sinUG}
\alias{sinUG}
\title{SIN for undirected graphs}
\description{
  This function computes the matrix of simultaneous p-values for SIN
  model selection for undirected (or concentration) graphs.
}
\usage{sinUG(S,n)}
\arguments{
  \item{S}{a covariance or correlation matrix.}
  \item{n}{the sample size.}
}
\value{
  A matrix of simultaneous p-values with \code{NA} on the diagonal.
}
\references{
  Drton, M. \& Perlman, M.D.  (2004)  Model Selection for Gaussian
  Concentration Graphs. \emph{Biometrika}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2004)  A SINful Approach to Gaussian
  Graphical Model Selection.  \emph{Statistical Science}, to appear.
  \cr\cr
  Drton, M. \& Perlman, M.D.  (2003)  A SINful Approach to Model
  Selection for Gaussian Concentration Graphs. Department of
  Statistics, University of Washington, Technical Report 429.\cr
  \url{http://www.stat.washington.edu/www/research/reports/2003/tr429.pdf}
}
\seealso{
  \code{\link{plotUGpvalues}}
}
\examples{
data(fowlbones)
sinUG(fowlbones$corr,fowlbones$n)
holm(sinUG(fowlbones$corr,fowlbones$n))
}
\keyword{multivariate}

\eof
\name{socstatus}
\alias{socstatus}
\docType{data}
\title{Social Status and Participation}
\description{
In a study on the relationship between social status and participation,
6 variables are measured for a sample of 530 women:
  \tabular{lcl}{
    \eqn{X_1}{X1} \tab : \tab income,\cr
    \eqn{X_2}{X2} \tab : \tab occupation,\cr
    \eqn{X_3}{X3} \tab : \tab education,\cr
    \eqn{Y_1}{Y1} \tab : \tab church attendance,\cr
    \eqn{Y_2}{Y2} \tab : \tab memberships,\cr
    \eqn{Y_3}{Y3} \tab : \tab friends' seen.
  }
}
\usage{data(socstatus)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{socstatus$means} \tab : \tab the mean vector,\cr 
    \code{socstatus$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{socstatus$corr} \tab : \tab the correlation matrix, and \cr
    \code{socstatus$n}    \tab : \tab the sample size.
  }
}
\source{
  Whittaker, J. (1990) \emph{Graphical models in applied
    multivariate statistics}. Chichester: Wiley. (See p.327).
}
\examples{
data(socstatus)
socstatus$means
socstatus$stddev
socstatus$corr
socstatus$n
}
\keyword{datasets}

\eof
\name{stressful}
\alias{stressful}
\docType{data}
\title{Stressful Events}
\description{
Results of questionnaires given to 72 students.  The 4 variables are:
  \itemize{
    \item cognitive avoidance,
    \item vigilance,
    \item blunting,
    \item monitoring.
  }
}
\usage{data(stressful)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{stressful$means} \tab : \tab the mean vector,\cr 
    \code{stressful$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{stressful$corr} \tab : \tab the correlation matrix, and \cr
    \code{stressful$n}    \tab : \tab the sample size.
  }
}
\source{
  Cox, D.R. \& Wermuth, N.  (1993)  Linear Dependencies Represented by
  Chain Graphs.  \emph{Statistical Science} 8(3): 204-283. (See Table 3).
}
\examples{
data(stressful)
stressful$means
stressful$stddev
stressful$corr
stressful$n
}
\keyword{datasets}

\eof
\name{sur}
\alias{sur}
\docType{data}
\title{Simulated Data from Seemingly Unrelated Regressions}
\description{
The data are simulated from a bivariate seemingly unrelated regressions
model with two response variables (\eqn{Y_1}, \eqn{Y_2}) and two
covariates (\eqn{X_1}, \eqn{X_2}). The sample is only of size 8. 
}
\usage{data(sur)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{sur$means} \tab : \tab the mean vector,\cr 
    \code{sur$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{sur$corr} \tab : \tab the correlation matrix, and \cr
    \code{sur$n}    \tab : \tab the sample size.
  }
}
\details{
  The data were used by Drton \& Richardson (2004) to illustrate the
  possibility of a multimodal likelihood in seemingly unrelated regressions.
}
\source{
  Drton, M. \& Richardson, T.S.  (2004) Multimodality of the likelihood
  in the bivariate seemingly unrelated regressions
  model. \emph{Biometrika}, to appear.
}
\examples{
data(sur)
sur$means
sur$stddev
sur$corr
sur$n
}
\keyword{datasets}

\eof
\name{university1992}
\alias{university1992}
\docType{data}
\title{Druzdzel and Glymour's University Data 1992}
\description{
Data from a study by the \emph{U.S. News and World Report} magazine with
the purpose of college ranking. Druzdzel and Glymour choose 8 variables
and after removing some universities give a correlation matrix for 170
universities. The 8 variables are:
  \describe{
    \item{\emph{apgra}}{average percentage of graduation, i.e., the
      fraction of the total number of entering students who make it
      through the graduation,}
    \item{\emph{rejr}}{rejection rate, i.e., the fraction of the
      applicants who are given an admission offer,}
    \item{\emph{tstsc}}{average standardized test scores of the incoming
      students,}
    \item{\emph{top10}}{class standing of the incoming freshman, which
      is a fraction of the incoming freshmen who were in top 10\% of
      their high school graduating class,}
    \item{\emph{pacc}}{percentage of those students who accept the
      university's offer from among those who are offered admission,}
    \item{\emph{spend}}{total educational and general expenses per
      student, which is the sum spent on the instruction, student
      services, and academic support, including libraries and computing
      services,} 
    \item{\emph{strat}}{student-faculty ratio,}
    \item{\emph{salar}}{average facutly salary.}
  }
}
\usage{data(university1992)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{university1992$means} \tab : \tab the mean vector,\cr 
    \code{university1992$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{university1992$corr} \tab : \tab the correlation matrix, and \cr
    \code{university1992$n}    \tab : \tab the sample size.
  }
}
\source{
  Druzdzel, M.J. \& Glymour, C.  (1999)  In \emph{Computation, Causation,
    and Discovery}. (Ed. Glymour, C. \& Cooper, G.F.). Cambridge,
  Massachusetts: The MIT Press. (See Ch. 19). 
}
\examples{
data(university1992)
university1992$means
university1992$stddev
university1992$corr
university1992$n
}
\keyword{datasets}

\eof
\name{university1993}
\alias{university1993}
\docType{data}
\title{Druzdzel and Glymour's University Data 1993}
\description{
Data from a study by the \emph{U.S. News and World Report} magazine with
the purpose of college ranking. Druzdzel and Glymour choose 8 variables
and after removing some universities give a correlation matrix for 170
universities. The 8 variables are:
  \describe{
    \item{\emph{apgra}}{average percentage of graduation, i.e., the
      fraction of the total number of entering students who make it
      through the graduation,}
    \item{\emph{rejr}}{rejection rate, i.e., the fraction of the
      applicants who are given an admission offer,}
    \item{\emph{tstsc}}{average standardized test scores of the incoming
      students,}
    \item{\emph{top10}}{class standing of the incoming freshman, which
      is a fraction of the incoming freshmen who were in top 10\% of
      their high school graduating class,}
    \item{\emph{pacc}}{percentage of those students who accept the
      university's offer from among those who are offered admission,}
    \item{\emph{spend}}{total educational and general expenses per
      student, which is the sum spent on the instruction, student
      services, and academic support, including libraries and computing
      services,} 
    \item{\emph{strat}}{student-faculty ratio,}
    \item{\emph{salar}}{average facutly salary.}
  }
}
\usage{data(university1993)}
\format{
  A list providing a summary of the data. The list contains:
  \tabular{lcl}{
    \code{university1993$means} \tab : \tab the mean vector,\cr 
    \code{university1993$stddev}   \tab : \tab the vector of standard deviations,\cr
    \code{university1993$corr} \tab : \tab the correlation matrix, and \cr
    \code{university1993$n}    \tab : \tab the sample size.
  }
}
\source{
  Druzdzel, M.J. \& Glymour, C.  (1999)  In \emph{Computation, Causation,
    and Discovery}. (Ed. Glymour, C. \& Cooper, G.F.). Cambridge,
  Massachusetts: The MIT Press. (See Ch. 19). 
}
\examples{
data(university1993)
university1993$means
university1993$stddev
university1993$corr
university1993$n
}
\keyword{datasets}

\eof
