\name{E1.1}
\alias{E1.1}
\non_function{}
\title{ Data on density of vehicles and average speed }
\usage{data(E1.1)}
\description{
The \code{E1.1} data frame has 24 rows and 2 columns.
   }
\format{
This data frame contains the following columns:
\describe{
\item{DENSITY}{
a numeric vector, vehicles per mile.
}
\item{SPEED}{
a numeric vector, miles per hour.
}
}
}
\details{
 Example 1.1 page 2 in Sen and Srivastava.
}
\source{
 Huber, M.J (1957) Effect of temporary bridge on Parkway performance.
 \emph{Highway Research Board Bulletin} \bold{167} 63--74.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(E1.1)
attach(E1.1)
plot(DENSITY, sqrt(SPEED))
E1.1.m1 <- lm(sqrt(SPEED) ~ DENSITY + I(DENSITY^2), data=E1.1)
summary(E1.1.m1)
}
\keyword{datasets}

\eof
\name{E1.11}
\alias{E1.11}
\non_function{}
\title{ Data on violent and property crimes in 22 metropolitan areas of the U.S. }
\usage{data(E1.11)}
\description{
The \code{E1.11} data frame has 23 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Metro.Area}{
a character vector, names and state of each metropolitan area.
}
\item{Violent.Crimes}{
a numeric vector, units of measurenment not given.
}
\item{Property.Crimes}{
a numeric vector, units of measurement not given.
}
\item{Population}{
a numeric vector, in thousands.
}
}
}
\source{
 Dacey, M.F.(1983) \emph{Social science Theories and Methods I: Models of data}, Evanston: 
               Northwestern University.
}
\examples{
data(E1.11)
attach(E1.11)
plot(Population, Violent.Crimes)
}
\keyword{datasets}

\eof
\name{E1.15}
\alias{E1.15}
\non_function{}
\title{ Stevens Experiment to compare notes against a standard (80 Db) }
\usage{data(E1.15)}
\description{
The \code{E1.15} data frame has 10 rows and 3 columns.
 Stevens (1956) asked a number of persons to compare notes of 
 various decibel levels against a standard (80 decibels) and to assign 
 them a loudness rating with the standard note being a 10. logy is 
the response variable and x the stimulus.
}
\format{
This data frame contains the following columns:
\describe{
\item{x}{
a numeric vector, the stimulus.
}
\item{y}{
a numeric vector, the median response at \code{x}
}
\item{logy}{
a numeric vector, the log of \code{y}.
}
}
}

\source{
 Dacey,M.F. (1983)  \emph{Social science Theories and Methods I: Models of Data}
 Evanston: Northwestern University, fromStevens (1956).    
}
\examples{
data(E1.15)
attach(E1.15)
plot(x, logy)
abline(lm( logy ~ x, data=E1.15))
}
\keyword{datasets}

\eof
\name{E1.16}
\alias{E1.16}
\non_function{}
\title{ Earnings and Prices of Selected Paper Company Stocks }
\usage{data(E1.16)}
\description{
The \code{E1.16} data frame has 10 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Company}{
a character vector, name of the company
}
\item{Earn.Share}{
a numeric vector, 1972 earnings per share, in dollars.
}
\item{Price.Share}{
a numeric vector, prive per share, in dollars, in may, 1973.
}
}
}
\source{
 Dacey (1983, ch 1) from Moodys's Stock Survey, June 4, 1973, p 610.
}
\examples{
}
\keyword{datasets}

\eof
\name{E1.17}
\alias{E1.17}
\non_function{}
\title{ Data on Population Density and Vehicle Thefts }
\usage{data(E1.17)}
\description{
The \code{E1.17} data frame has 18 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{D}{
a numeric vector, district of Chicago. 1 is downtown Chicago.
}
\item{pd}{
a numeric vector, population density of each district.
}
\item{vtt}{
a numeric vector, vehicle thefts per thousand residents.
}
}
}
\source{
 Mark Buslik, Chicago Police Department.
}
\examples{
data(E1.17)
attach(E1.17)
plot(pd, vtt)
cat("Use the mouse to identify the outlier in the plot (click on the outlier)\n")
\dontrun{identify(pd, vtt)}
}
\keyword{datasets}

\eof
\name{E1.18}
\alias{E1.18}
\non_function{}
\title{ Data on Simsbury Marriages }
\usage{data(E1.18)}
\description{
The \code{E1.18} data frame has 8 rows and 3 columns with 
 data on the number of marriages (\code{ma}) that occurred between residents of each of
8 annular zones and residents of Simsbury, Connecticut, for the period 1930--39.
The number of residents of each zone is given as \code{pop} and the midpoint 
of distance between Simsbury and the band is given as \code{d}.
}
\format{
This data frame contains the following columns:
\describe{
\item{d}{
a numeric vector, distance between Simsbury and midpoint of annular zone.
}
\item{pop}{
a numeric vector, population of annular zone.
}
\item{ma}{
a numeric vector, number of marriages.
}
}
}
\source{
 Dacey (1983, ch 4) from Ellsworth (1948).
}
\examples{
data(E1.18)
}
\keyword{datasets}

\eof
\name{E1.19}
\alias{E1.19}
\non_function{}
\title{ Data on Book Prices, Pages and Type of Binding }
\usage{data(E1.19)}
\description{
The \code{E1.19} data frame has 20 rows and 3 columns.
Compiled from the catalog of one publisher of American Government books.
}
\format{
This data frame contains the following columns:
\describe{
\item{Price}{
a numeric vector, price of book.
}
\item{P}{
a numeric vector, number of pages of book.
}
\item{B}{
a factor with levels
\code{c} 
\code{p}, \code{c} is cloth and \code{p} is paperback. 
}
}
}
\source{
 Compiled by one of the authors.
}
\examples{
data(E1.19)
}
\keyword{datasets}

\eof
\name{E1.20}
\alias{E1.20}
\non_function{}
\title{ Data on Physical Quality of life Index (PQLI) Scores and Infant Mortality Rates (IMR)
         for Selected Indian States }
\usage{data(E1.20)}
\description{
The \code{E1.20} data frame has 13 rows and 7 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{State}{
a character vector, name of state.
}
\item{PQLI}{
a numeric vector, Physical Quality of Life Index, a measure of 
average wealth.
}
\item{Comb.IMR}{
a numeric vector, combined infant mortality rate.
}
\item{Rur.M.IMR}{
a numeric vector, rural male infant mortality rate.
}
\item{Rur.F.IMR}{
a numeric vector, rural female infant mortality rate.
}
\item{Urb.M.IMR}{
a numeric vector, urban male infant mortality rate.
}
\item{Urb.F.IMR}{
a numeric vector, urban female infant mortality rate.
}
}
}
\source{
 Dr. T.N.K.Raju, Department of Neonatology, University of 
 Illinois at Chicago.
}
\examples{
data(E1.20)
## Some data reorganization before analysis:
## Maybe reshape could have been used here?
 e1.20 <- data.frame(rbind(as.matrix(E1.20[,c(2,4)]), 
                          as.matrix(E1.20[,c(2,5)]),
                          as.matrix(E1.20[,c(2,6)]),
                          as.matrix(E1.20[,c(2,7)])),row.names=1:52)
  attr(e1.20,"names")[[2]] <- "IMR"
 e1.20$Female <- c(rep(0,13), rep(1,13),rep(0,13),rep(1,13))
 e1.20$Urban  <- c(rep(0,26),rep(1,26))
## Now the analysis can start.
}
\keyword{datasets}

\eof
\name{E1.21}
\alias{E1.21}
\non_function{}
\title{ Data on Loads and Deformation of a Bar }
\usage{data(E1.21)}
\description{
The \code{E1.21} data frame has 24 rows and 2 columns. Data are on loads, 
in pounds, and corresponding deformation, in inches, of a mild steel bar, of length 8 inches 
and average diameter .564 inches.
}
\format{
This data frame contains the following columns:
\describe{
\item{L}{
a numeric vector, load, in pounds.
}
\item{D}{
a numeric vector, corresponding deformation, in inches.
}
}
}
\source{
 M.R. Khavanin, Department of Mechanical Engineering, University of 
 Illinois at Chicago.
}
\examples{
data(E1.21)
attach(E1.21)
plot(L, D)
}
\keyword{datasets}

\eof
\name{E1.7}
\alias{E1.7}
\non_function{}
\title{ Data on Population and Number of Telephones }
\usage{data(E1.7)}
\description{
The \code{E1.7} data frame has 6 rows and 2 columns. The relation between 
population and number of telephones have been used to estimate the
population in non-census years.
}
\format{
This data frame contains the following columns:
\describe{
\item{RES}{
a numeric vector, number of residents.
}
\item{MAINS}{
a numeric vector, number of telephones.
}
}
}
\source{
 Prof. Edwin Thomas, Department of Geography, 
 University of Illinois at Chicago.
}
\examples{
data(E1.7)
attach(E1.7)
plot(RES, MAINS)
plot(sqrt(RES), sqrt(MAINS))
}
\keyword{datasets}

\eof
\name{E10.1}
\alias{E10.1}
\non_function{}
\title{ Multicollinear Data }
\usage{data(E10.1)}
\description{
The \code{E10.1} data frame has 10 rows and 5 columns.
 The responses were obtained by adding a N(0, 0.01) pseudorandom
 variate to \code{x.1}+0.5\code{x.2}. The data were made up by the authors.
}
\format{
This data frame contains the following columns:
\describe{
\item{x.1}{
a numeric vector, predictor 1.
}
\item{x.2}{
a numeric vector, predictor 2.
}
\item{y.1}{
a numeric vector, response 1.
}
\item{y.2}{
a numeric vector, response 2.
}
\item{y.3}{
a numeric vector, response 3.
}
}
}
\source{
 The data were made up by the authors.
}
\examples{
data(E10.1)
attach(E10.1)
plot(x.1, x.2)
}
\keyword{datasets}

\eof
\name{E10.11}
\alias{E10.11}
\non_function{}
\title{ Longley's Data }
\usage{data(E10.11)}
\description{
The \code{E10.11} data frame has 16 rows and 7 columns.
 This is a selection of Longley's multicollinear data (1967).
}
\format{
This data frame contains the following columns:
\describe{
\item{Def}{
a numeric vector, a price index.
}
\item{GNP}{
a numeric vector, gross national product.
}
\item{Unemp}{
a numeric vector, unemployment rate.
}
\item{AF}{
a numeric vector, employment in the armed forces.
}
\item{Pop.}{
a numeric vector, noninstitutional population.
}
\item{Year}{
a numeric vector, the year.
}
\item{Total}{
a numeric vector, the response, total employment.
}
}
}
\source{
 Reproduced from the \emph{Journal of the American Statistical Association},
 \bold{62}.
}
\examples{
data(E10.11)
}
\keyword{datasets}

\eof
\name{E10.3}
\alias{E10.3}
\non_function{}
\title{ Supervisor Rating Data }
\usage{data(E10.3)}
\description{
The \code{E10.3} data frame has 30 rows and 6 columns.
 This is part of a larger data set gathered for other purposes.  The six variables
 are each composites obtained from responses to a questionare. The dependent 
 variable \code{y} is a composite of responses towards thr respondent's
 supervisor and on job satisfaction.  The highest possible score is 20. The
predictor variables are defined below.
}
\format{
This data frame contains the following columns:
\describe{
\item{x.1}{
a numeric vector, measures the level of social contact each respondent felt he or
 she had with the supervisor, was based on questions like "Do you see your supervisor 
 outside of your work place?"
}
\item{x.2}{
a numeric vector, measures the perceived level of interest from the supervisor
in the employees personal life. Based on questions like "Would you discuss
a personal problem with your supervisor?"
}
\item{x.3}{
a numeric vector, measures the level of support the employee feels from 
the supervisor. Based on questions like "Is your supervisor supportive of your work?"
}
\item{x.4}{
a numeric vector, together with  \code{x.5} measure the drive of the supervisor.
Based on the emplotees perception of this drive.
}
\item{x.5}{
a numeric vector, based on questions like "Does your supervisor encourage you to 
learn new skills?"
}
\item{y}{
a numeric vector, the response.
}
}
}
\source{
 Sen and Srivastava (1990) \emph{Regression Analysis, 
 Theory, Methods and Applications}. Springer-verlag.
}
\examples{
data(E10.3)
}
\keyword{datasets}

\eof
\name{E11.1}
\alias{E11.1}
\non_function{}
\title{ Artificially Created Data for an Example on Variable Search }
\usage{data(E11.1)}
\description{
The \code{E11.1} data frame has 20 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{x.1}{
a numeric vector, predictor 1.
}
\item{x.2}{
a numeric vector, predictor 2.
}
\item{x.3}{
a numeric vector, predictor 3.
}
\item{x.4}{
a numeric vector, predictor 4.
}
\item{y}{
a numeric vector, response.
}
}
}
\source{
 Data made up by the authors.
}
\examples{
data(E11.1)
exleaps <- require("leaps", quietly=TRUE)
if (exleaps) {
   E11.1.m1 <- regsubsets(y ~x.1+x.2+x.3+x.4, data=E11.1)
   summary(E11.1.m1)
   plot(E11.1.m1)
}
}
\keyword{datasets}

\eof
\name{E2.1}
\alias{E2.1}
\non_function{}
\title{ Data on Grade Point Average and SAT Scores }
\usage{data(E2.1)}
\description{
The \code{E2.1} data frame has 9 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{GPA}{
a numeric vector, grade point average (maximum=4)
}
\item{SATV}{
a numeric vector, SAT verbal score.
}
\item{SATM}{
a numeric vector, SAT mathematical score.
}
}
}
\source{
 Dacey (1983).
}
\examples{
data(E2.1)
}
\keyword{datasets}

\eof
\name{E2.11}
\alias{E2.11}
\non_function{}
\title{ Demographic Data for the 50 States of the U.S. }
\usage{data(E2.11)}
\description{
The \code{E2.11} data frame has 50 rows and 27 columns, this 
 combines exhibits E2.10 and E2.11 in the book. The data are for 1980 except as 
noted.
}
\format{
This data frame contains the following columns:
\describe{
\item{State}{
a character vector, two-letter state code.
}
\item{POP}{
a numeric vector, total population (1000's).
}
\item{UR}{
a numeric vector, per mil of population living in urban areas.
}
\item{MV}{
a numeric vector, per mil who moved between 1965 and 1970.
}
\item{BL}{
a numeric vector, number of blacks (1000's).
}
\item{SP}{
a numeric vector, number of spanish speaking (1000's)
}
\item{AI}{
a numeric vector, number of native americans (100's).
}
\item{IN}{
a numeric vector, number of inmates of all institutions (correctional, 
   mental, TB, etc) in 1970, (1000's).
}
\item{PR}{
a numeric vector, number of inmates of correctional 
institutions in 1970 (100's)
}
\item{MH}{
a numeric vector, Homes and schools for the mentally handicapped (100's)
}
\item{B}{
a numeric vector, births per thousand.
}
\item{HT}{
a numeric vector, death rate from hearth disease per 100000 residents.
}
\item{S}{
a numeric vector, suicide rate, 1978, per 100000.
}
\item{DI}{
a numeric vector, death rate from diabetes, 1978, per 100000.
}
\item{MA}{
a numeric vector, marriage rate, per 10000.
}
\item{D}{
a numeric vector, divorce rate, per 10000.
}
\item{DR}{
a numeric vector, physicians per 100000.
}
\item{DN}{
a numeric vector, dentists per 100000.
}
\item{HS}{
a numeric vector, per mil high school grads.
}
\item{CR}{
a numeric vector, crime rate per 100000 population.
}
\item{M}{
a numeric vector, murder rate oer 100000 population.
}
\item{PI}{
a numeric vector, prison rate (federal and state) per 100000 residents.
}
\item{RP}{
a numeric vector, % voting for Republican candidate in presidential elections.
}
\item{VT}{
a numeric vector, % voting for presidential candidate among voting age population.
}
\item{PH}{
a numeric vector, telephjones per 100 (1979).
}
\item{INC}{
a numeric vector, per capita income in 1972 dollars.
}
\item{PL}{
a numeric vector, per mil of population below poverty label.
}
}
}
\source{
 Compiled by Prof. Siim Soot, Department of Geography, University of 
 Illinois at Chicago, from \emph{Statistical Abstract of the United States}, 
1981, \emph{U.S. Bureau of the Census}, Washington, D.C.
}
\examples{
data(E2.11)
}
\keyword{datasets}

\eof
\name{E2.2}
\alias{E2.2}
\non_function{}
\title{ Data on House Prices }
\usage{data(E2.2)}
\description{
The \code{E2.2} data frame has 26 rows and 14 columns, data on 
house prices in different zones of Chicago.
}
\format{
This data frame contains the following columns:
\describe{
\item{Price}{
a numeric vector, selling price of house in thousands of dollars.
}
\item{BDR}{
a numeric vector, number of bedrooms.
}
\item{FLR}{
a numeric vector, floor space in sq. feet.
}
\item{FP}{
a numeric vector, number of fireplaces.
}
\item{RMS}{
a numeric vector, number of rooms.
}
\item{ST}{
a numeric vector, storm windows (1 present, 0 absent).
}
\item{LOT}{
a numeric vector, front footage of lot in feet.
}
\item{TAX}{
a numeric vector, annual taxes.
}
\item{BTH}{
a numeric vector, number of bathrooms.
}
\item{CON}{
a numeric vector, construction (0 if frame, 1 if brick).
}
\item{GAR}{
a numeric vector, garage size (0=no garage, 10 1 auto garage, etc.).
}
\item{CDN}{
a numeric vector, condition (1=needs work, 0 otherwise).
}
\item{L1}{
a numeric vector, indicator for zone A.
}
\item{L2}{
a numeric vector, indicator for zone B.
}
}
}
\source{
 Ms. Terry Tasch of Long-Kogan Realty, Chicago.
}
\examples{
data(E2.2)
}
\keyword{datasets}

\eof
\name{E2.4}
\alias{E2.4}
\non_function{}
\title{ International Car Ownership Data }
\usage{data(E2.4)}
\description{
The \code{E2.4} data frame has 24 rows and 8 columns, all data
are for 1978.
}
\format{
This data frame contains the following columns:
\describe{
\item{Country}{
a character vector, name of each country.
}
\item{AO}{
a numeric vector, cars per person.
}
\item{POP}{
a numeric vector, population of country in millions.
}
\item{DEN}{
a numeric vector, population density.
}
\item{GDP}{
a numeric vector, per capita income in U.S. dollars.
}
\item{PR}{
a numeric vector, gasoline price in U.S. cents per liter.
}
\item{CON}{
a numeric vector, Tonnes of gasoline consumed per car per year.
}
\item{TR}{
a numeric vector, thousands of passenger-kilometers per person of bus and rail use.
}
}
}
\details{
 Develop a model with \code{AO} as the response variable.
}
\source{
 OECD (1982)
}
\examples{
data(E2.4)
}
\keyword{datasets}

\eof
\name{E2.6}
\alias{E2.6}
\non_function{}
\title{ Voltage Data }
\usage{data(E2.6)}
\description{
The \code{E2.6} data frame has 10 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{V.a}{
a numeric vector, actual voltage.
}
\item{V.c}{
a numeric vector, voltage computed from the measured power outout (using light 
     output from electronic flash).
}
}
}
\details{
 A definition of efficiency is the ratio \code{V.c}/\code{V.a}. Obtain 
 a model for efficiency E as a regresion in \code{V.a}. Use a quadratic polynomial.
 Examine the fit.
}
\source{
 Armin Lehning, Speedotron Corporation.
}
\examples{
data(E2.6)
E2.6.m1 <- lm(V.c/V.a ~ V.a + I(V.a^2), data=E2.6)
plot(E2.6.m1)
}
\keyword{datasets}

\eof
\name{E2.7}
\alias{E2.7}
\non_function{}
\title{ Korean Auto Ownership Data }
\usage{data(E2.7)}
\description{
The \code{E2.7} data frame has 10 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Year}{
a numeric vector, year.
}
\item{AO}{
a numeric vector, number of cars per person.
}
\item{GNP}{
a numeric vector, per capita GNP in 1000 korean Wons.
}
\item{CP}{
a numeric vector, average car price in 1000 korean Wons.
}
\item{OP}{
a numeric vector, gasoline price after taxes, in wons per liter.
}
}
}
\source{
 KRIHS, (1985) \emph{Study of Road User Charges}. Seoul: Korea Research Institute
 for Human Settlements.
}
\examples{
data(E2.7)
}
\keyword{datasets}

\eof
\name{E2.8}
\alias{E2.8}
\non_function{}
\title{ Data on per Capita Output of Workers in Shanghai }
\usage{data(E2.8)}
\description{
The \code{E2.8} data frame has 17 rows and 4 columns, data
 for 17 factories in Shanghai.
}
\format{
This data frame contains the following columns:
\describe{
\item{Output}{
a numeric vector, per capita output in Chinese Yuan.
}
\item{SI}{
a numeric vector, number of workers in the factory.
}
\item{SP}{
a numeric vector, land area of the factory in sq. meters per worker.
}
\item{I}{
a numeric vector, investments in Yuan per worker.
}
}
}
\source{
 Prof. Zhang Tingwei of Tongji University, Shanghai.
}
\examples{
data(E2.8)
}
\keyword{datasets}

\eof
\name{E2.9}
\alias{E2.9}
\non_function{}
\title{ Data on capital, Labour and Value Added for Three Sectors }
\usage{data(E2.9)}
\description{
The \code{E2.9} data frame has 15 rows and 10 columns.
The three sectors are "20": Food and kindred products, "36": Equipment and supplies and
"37": Transportation equipment.
}
\format{
This data frame contains the following columns:
\describe{
\item{YEAR}{
a numeric vector, year without first two digits "19".
}
\item{Cap.20}{
a numeric vector, capital of sector 20.
}
\item{Cap.36}{
a numeric vector, capital of sector 36.
}
\item{Cap.37}{
a numeric vector, capital of sector 37.
}
\item{Lab.20}{
a numeric vector, labour of sector 20.
}
\item{Lab.36}{
a numeric vector, labour of sector 36.
}
\item{Lab.37}{
a numeric vector, labour of sector 37.
}
\item{Val.20}{
a numeric vector, real value added of sector 20.
}
\item{Val.36}{
a numeric vector, real value added of sector 36.
}
\item{Val.37}{
a numeric vector, real value added of sector 37.
}
}
}
\source{
 Dr. Phillip Israelovich of the Federal Reserve Bank.
}
\examples{
data(E2.9)
}
\keyword{datasets}

\eof
\name{E3.4}
\alias{E3.4}
\non_function{}
\title{ Men's Worlds Record Times for Running and Corresponding Distances }
\usage{data(E3.4)}
\description{
The \code{E3.4} data frame has 13 rows and 2 columns.
 World record times as of 1974.
}
\format{
This data frame contains the following columns:
\describe{
\item{Dist.}{
a numeric vector, distance in meters.
}
\item{Time}{
a numeric vector, time in seconds.
}
}
}
\seealso{ \code{\link{E3.5}}, the records for women. }
\source{
 Encyclopaedia Britannica, 15th Edition, 1974, Micropaedia, IX, 
 page 485. 
}
\examples{
data(E3.4)
}
\keyword{datasets}

\eof
\name{E3.5}
\alias{E3.5}
\non_function{}
\title{ Women's World Record Times for Running and Corresponding Distances }
\usage{data(E3.5)}
\description{
The \code{E3.5} data frame has 6 rows and 2 columns.
 Records are for 1974.
}
\format{
This data frame contains the following columns:
\describe{
\item{Dist.}{
a numeric vector, distance run, in meters.
}
\item{Time}{
a numeric vector, time used, in seconds.
}
}
}
\seealso{ \code{\link{E3.4}}, for the men's records. }
\source{
 Encyclopdia Britannica, 15th Edition, 1974, Micropdia, IX, 
 page 487. 
}
\examples{
data(E3.5)
data(E3.4)
summary(E3.5)
summary(E3.4)
records <- rbind(E3.5,E3.4)
sex <- factor(c(rep("F", 6), rep("M", 13)))
records$sex <- sex
}
\keyword{datasets}

\eof
\name{E3.6}
\alias{E3.6}
\non_function{}
\title{ Data on Corporations and Corporation Chairmen }
\usage{data(E3.6)}
\description{
The \code{E3.6} data frame has 50 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Y84}{
a numeric vector, salary 1984, in dollars.
}
\item{Y83}{
a numeric vector, salary 1983, in dollars.
}
\item{SHARES}{
a numeric vector, number of shares the chairman holds.
}
\item{REV}{
a numeric vector, total revenue of the company.
}
\item{INC}{
a numeric vector, total income of the company.
}
\item{AGE}{
a numeric vector, age of chairman, in years.
}
}
}
\source{
 Reprinted with permission from the May 13, 1985, issue of  Crain's
 Chicago Business. Copyright 1985 by Crain's Communications, Inc. The
 data given are a portion of the original table.  
}
\examples{
data(E3.6)
}
\keyword{datasets}

\eof
\name{E3.7}
\alias{E3.7}
\non_function{}
\title{ Data on Oxygen Demand in Dairy Wastes }
\usage{data(E3.7)}
\description{
The \code{E3.7} data frame has 20 rows and 7 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Day}{
a numeric vector, day of measurement, all measurements are on 
the same sample.
}
\item{x.1}{
a numeric vector, biological oxygen demand, mg/liter.
}
\item{x.2}{
a numeric vector, total Kjeldahl nitrogen, mg/liter.
}
\item{x.3}{
a numeric vector, total solids, mg/liter.
}
\item{x.4}{
a numeric vector, total volatile solids, a component of \code{x.3}, 
 in mg/liter.
}
\item{x.5}{
a numeric vector, chemical oxygen demand, mg/liter.
}
\item{y}{
a numeric vector, the response, log of oxygen demand, mg oxygen per minute.
}
}
}
\details{
 This is data from an experiment to construct a model for total oxygen 
 demand in dairy wastes as a dunction of five laboratory measurements. Data
  were collected on samples kept in suspension in water in a laboratory for 220
 days. All observations given here were taken on the same sample over time, 
 so are probably dependent.
}
\source{
 Moore (1975) \emph{Total Biochemical Oxygen Demand of Animal Manures}.
 Ph. D. thesis, University of Minnesota, Dept. of Agricultural
 Engineering. 
}
\examples{
data(E3.7)
}
\keyword{datasets}

\eof
\name{E3.8}
\alias{E3.8}
\non_function{}
\title{ Map reading Test scores and Route Finding Scores }
\usage{data(E3.8)}
\description{
The \code{E3.8} data frame has 20 rows and 3 columns. 20 student volunteers
where given a map reading test and a test of route finding on transit maps.
}
\format{
This data frame contains the following columns:
\describe{
\item{y}{
a numeric vector, ability to find routes to a given destination on a transit route
map where scored \code{y}.
}
\item{sc}{
a numeric vector, scores on a map reading ability test.
}
\item{Use}{
a factor with levels
\code{Non.users} 
\code{Users}, users and non-users of transit. 
}
}
}
\source{
 Preof. Siim Soot, Department of Geography, University of 
Illinois at Chicago. 
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(E3.8)
}
\keyword{datasets}

\eof
\name{E3.9}
\alias{E3.9}
\non_function{}
\title{ Blood Velocity Data }
\usage{data(E3.9)}
\description{
The \code{E3.9} data frame has 18 rows and 4 columns.
All the observations are for the same person.
}
\format{
This data frame contains the following columns:
\describe{
\item{x.1}{
a numeric vector, cardiac output.
}
\item{x.2}{
a numeric vector, carbon dioxide level in the blood.
}
\item{y}{
a numeric vector, blood flow velocity in the brain.
}
\item{Aminophylline}{
a factor with levels
\code{no} 
\code{with}, Aminophylline used or not. The hypothesis is that 
 aminophylline retards blood flow. 
}
}
}
\source{
 Tonse Raju, M.D., Department of Neonatology, University of Illinois
 at Chicago.
}
\examples{
data(E3.9)
}
\keyword{datasets}

\eof
\name{E4.1}
\alias{E4.1}
\non_function{}
\title{ Traffic Fatality Data for Illinois }
\usage{data(E4.1)}
\description{
The \code{E4.1} data frame has 10 rows and 3 columns.
 Deaths are in deaths per 100 million vehicle miles.
}
\format{
This data frame contains the following columns:
\describe{
\item{Year}{
a numeric vector, the year.
}
\item{Deaths}{
a numeric vector, number of deaths.
}
\item{DFR}{
a numeric vector, deaths.t - deaths.(t-1).
}
}
}
\details{
 The interest are in possible changes after new safety regulations where
 in effect after 1966.
}
\source{
 Illinois Department of Transportation (1972).
}
\examples{
data(E4.1)
}
\keyword{datasets}

\eof
\name{E4.10}
\alias{E4.10}
\non_function{}
\title{ Votes from Chicago's Twenty-second Ward by Precinct }
\usage{data(E4.10)}
\description{
The \code{E4.10} data frame has 27 rows and 7 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Pr.}{
a numeric vector, precinct number.
}
\item{LATV}{
a numeric vector, number of latin voters.
}
\item{NONLV}{
a numeric vector,  number of non-latin voters.
}
\item{TURNOUT}{
a numeric vector, total number of votes cast.
}
\item{GARCIA}{
a numeric vector, number of votes for Garcia.
}
\item{MARTINEZ}{
a numeric vector, number of votes for Martinez.
}
\item{YANEZ}{
a numeric vector, number of votes for Yanez.
}
}
}
\details{
 Note that the votes for the three candidates may not add to the total 
 turnout because of write-in votes, spoilt ballots, etc. 
}
\source{
 Ray Flores, The Latino Institute, Chicago. 
}
\examples{
data(E4.10)
}
\keyword{datasets}

\eof
\name{E4.11}
\alias{E4.11}
\non_function{}
\title{ Data on Cost of Repairing Starters, Ring Gears or Both in Diesel Engines }
\usage{data(E4.11)}
\description{
The \code{E4.11} data frame has 133 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Cost}{
a numeric vector, the repair cost in dollars.
}
\item{Part}{
a factor with levels
\code{Both} 
\code{Ring gear} 
\code{Starter}, the type of part being repaired.
}
}
}
\source{
 M.R.Khavanin, Department of Mechanical Engineering, University of Illinois
 at Chicago.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(E4.11)
E4.11.m1 <- lm(Cost ~ Part - 1, data=E4.11)
summary(E4.11.m1)
}
\keyword{datasets}

\eof
\name{E4.12}
\alias{E4.12}
\non_function{}
\title{ Time taken by Professional Dieticians and Interns for Four Patient 
         Contact Activities }
\usage{data(E4.12)}
\description{
   The \code{E4.12} data frame has 24 rows and 6 columns. Each row is the 
   activities and time taken by one dietician.
}
\format{
   This data frame contains the following columns:
\describe{
\item{Time}{
    a numeric vector, sum of time taken for all activities.
}
\item{SC}{
    a numeric vector, number of patient contacts for screening.
}
\item{DC}{
    a numeric vector, number of patient contacts for diet class.
}
\item{MR}{
    a numeric vector, number of patient contacts for meal rounds.
}
\item{TR}{
    a numeric vector, number of patient contacts for team rounds.
}
\item{Dietician}{
    a factor with levels
    \code{Intern} 
    \code{Prof}, dietician is professional or intern.
  }
}% end describe
} %end format
\source{
 The data where made available to one of the authors by a student.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(E4.12)
m1 <- lm(Time ~ SC+DC+MR+TR-1, data=E4.12, subset=Dietician=="Prof")
summary(m1)
}
\keyword{datasets}

\eof
\name{E4.13}
\alias{E4.13}
\non_function{}
\title{ Data on Hospital Charges }
\usage{data(E4.13)}
\description{
The \code{E4.13} data frame has 49 rows and 5 columns. Data on hospital
 charges for patients with an identical diagnosis.
}
\format{
This data frame contains the following columns:
\describe{
\item{Sex}{
a factor with levels
\code{F} 
\code{M} , male and female.
}
\item{MD}{
a factor with levels
\code{499} 
\code{730} 
\code{1021}, three different medical doctors.
}
\item{Svty}{
a factor with levels
\code{1} 
\code{2} 
\code{3} 
\code{4}, severity of illness. 
}
\item{Chrg}{
a numeric vector, total hospital charge in dollars.
}
\item{Age}{
a numeric vector, age of patient in years.
}
}
}

\source{
 Dr. Joseph Feinglass, Northwestern Memorial Hospital, Chicago.
}
\examples{
data(E4.13)
summary(E4.13)
}
\keyword{datasets}

\eof
\name{E4.4}
\alias{E4.4}
\non_function{}
\title{ Measures of Quality for Agencies Delivering Transportation for 
        the Elderly and the Handicapped }
\usage{data(E4.4)}
\description{
The \code{E4.4} data frame has 40 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{QUAL}{
a numeric vector, a quality measure made using psychometric methods from results 
      of questionares.
}
\item{X.1}{
a numeric vector, an indicator variable for private ownership.
}
\item{X.2}{
a numeric vector, an indicator variable for private for profit ownership.
}
}
}
\details{
 The quality data, \code{QUAL}, is constructed from questionares given
 to users of such services in the state of Illinois.  Multiple services 
 in the state of Illinois was scored using this method. The indicator variables
 was constructed to give first (\code{X.1}) a comparison between private
 and public services, then (\code{X.2}) a comparison between private
 not-for-profit and private for profit services. 
}
\source{
 Slightly modified version of data supplied by Ms. Claire McKnight of
 the Department of Civil Engineering, City University of New York.
}
\examples{
data(E4.4)
}
\keyword{datasets}

\eof
\name{E4.7}
\alias{E4.7}
\non_function{}
\title{ Data on Per-Capita Income and Life Expectancy }
\usage{data(E4.7)}
\description{
The \code{E4.7} data frame has 101 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Country}{
a character vector, containing names of the countries.
}
\item{LIFE}{
a numeric vector, life expectancy, years. Early 1970's.
}
\item{INC}{
a numeric vector, per capita income in 1974 dollars. Early 1970's.
}
}
}
\source{
 From the \emph{New York Times} (September, 28, 1975, p E-3).
}
\examples{
data(E4.7)
attach(E4.7)
plot(INC, LIFE)
plot(log(INC), LIFE)
}
\keyword{datasets}

\eof
\name{E6.1}
\alias{E6.1}
\non_function{}
\title{ Data on Automobile Speed and Distance Covered to Come to a Standstill 
         after Breaking }
\usage{data(E6.1)}
\description{
The \code{E6.1} data frame has 62 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{d.}{
a numeric vector, distance covered to come to a standstill after breaking.
}
\item{sp.}{
a numeric vector, speed before breaking.
}
}
}
\source{
 From Ezekiel,M. and F. A. Fox, \emph{Methods of Correlation and Regression Analysis}. 
 Copyright 1959 John Wiley and Sons, Inc. 
}
\examples{
data(E6.1)
attach(E6.1)
plot(sp., d.)
}
\keyword{datasets}

\eof
\name{E6.10}
\alias{E6.10}
\non_function{}
\title{ Data on Perceived and Computed Travel Times by Bus }
\usage{data(E6.10)}
\description{
The \code{E6.10} data frame has 32 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{n}{
a numeric vector, number of respondents, weights for the linear regression.
}
\item{x}{
a numeric vector, computed travel times between a pair of zones in Chicago.
}
\item{y}{
a numeric vector, perceived travel times, as reported to the U.S. Census 
        Bureau. 
}
}
}
\details{
 \code{x} where computed from bus timetables, adding an average waiting time at the stop, 
     and an average walking time from zone center to bus stop. \code{y}
     is the average reported by \code{n} travelers, to the US census bureau. The variable
     \code{t} introduced in the example below is the one for multiple bus transfers, used
     in example 8.1 page 161.
}
\source{
 The data where selected by one of the authors from a larger data set compiled
 by Csar Singh from census tapes, timetables and maps. 
}
\examples{
data(E6.10)
## Manipulations of the data for example 8.1, page 161:
t <- c(0,1,rep(0,20),1,rep(0,5),1,rep(0,3))
e6.10 <- data.frame(E6.10, t=t)
rm(t)
}
\keyword{datasets}

\eof
\name{E6.11}
\alias{E6.11}
\non_function{}
\title{ Heights of Fathers and Sons }
\usage{data(E6.11)}
\description{
The \code{E6.11} data frame has 12 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Height.Father}{
a numeric vector, height of father to the nearest inch.
}
\item{Aver.Height.Son}{
a numeric vector, average heights of sons.
}
\item{No.Fathers}{
a numeric vector, number of fathers in each group.
}
}
}

\source{
 dacey (1983, Ch. 1) from McNemar (1969, p. 130), \emph{Psycological Statistics}.
}
\examples{
data(E6.11)
}
\keyword{datasets}

\eof
\name{E6.8}
\alias{E6.8}
\non_function{}
\title{ Dial-a-ride Data }
\usage{data(E6.8)}
\description{
The \code{E6.8} data frame has 54 rows and 7 columns. It has 7 variables 
 describing 54 dial-a-ride services in U.S. and Canada.  It needs 
 weighted regression.
}
\format{
This data frame contains the following columns:
\describe{
\item{POP}{
a numeric vector, population of area where service where operating.
}
\item{AR}{
a numeric vector, area of the place where service where provided.
}
\item{RDR}{
a numeric vector, number of riders using the system.
}
\item{HR}{
a numeric vector, hours of operation.
}
\item{VH}{
a numeric vector, number of vehicles in operation.
}
\item{F}{
a numeric vector, the fare used.
}
\item{IND}{
a numeric vector, a composite index, 1 when several ridership enhancing features 
                   where present, and 0 elsewhere. 
}
}
}
\source{
 Collected by Louise Stanton-Maston, from 54 services in U.S. and Canada.
}
\examples{
data(E6.8)
}
\keyword{datasets}

\eof
\name{E7.1}
\alias{E7.1}
\non_function{}
\title{ Data on Dental Measurements }
\usage{data(E7.1)}
\description{
The \code{E7.1} data frame has 4 rows and 12 columns.
Dental measurements for girls from 8 to 14 years old. Each measurement is the
distance, in mm, from the center of the pituary to the ptery-maxilliary fissure.
}
\format{
This data frame contains the following columns:
\describe{
\item{Age}{
a numeric vector, age of girl when measurement was taken.
}
\item{S.1}{
a numeric vector, measurements for girl 1.
}
\item{S.2}{
a numeric vector, measurements for girl 2.
}
\item{S.3}{
a numeric vector, measurements for girl 3.
}
\item{S.4}{
a numeric vector, measurements for girl 4.
}
\item{S.5}{
a numeric vector, measurements for girl 5.
}
\item{S.6}{
a numeric vector, measurements for girl 6.
}
\item{S.7}{
a numeric vector, measurements for girl 7.
}
\item{S.8}{
a numeric vector, measurements for girl 8.
}
\item{S.9}{
a numeric vector, measurements for girl 9.
}
\item{S.10}{
a numeric vector, measurements for girl 10.
}
\item{S.11}{
a numeric vector, measurements for girl 11.
}
}
}
\source{
 Pothoff and Roy (1964).
}
\examples{
data(E7.1)
}
\keyword{datasets}

\eof
\name{E7.2}
\alias{E7.2}
\non_function{}
\title{ Prices of Crude Oil, Natural Gas, Bituminous Coal and Lignite, 
           and Anthracite by Year. }
\usage{data(E7.2)}
\description{
The \code{E7.2} data frame has 32 rows and 5 columns.
 Prices are in 1972 cents (U.S) by 1000 BTU.}
\format{
This data frame contains the following columns:
\describe{
\item{year}{
a numeric vector, year of observation.
}
\item{Oil}{
a numeric vector, price of oil.
}
\item{Gas}{
a numeric vector, price of Gas.
}
\item{Bit.}{
a numeric vector, price of Bituminous Coal and Lignite.
}
\item{Anth.}{
a numeric vector, price of Anthracite.
}
}
}

\source{
 Darrel Sala, Institute of Gas Technology, Chicago.
}
\examples{
data(E7.2)
}
\keyword{datasets}

\eof
\name{E7.3}
\alias{E7.3}
\non_function{}
\title{ Data on Intake/Output Ratio }
\usage{data(E7.3)}
\description{
The \code{E7.3} data frame has 19 rows and 6 columns.
 It gives the ratios \code{u} of fluid intake to urine output over five 
 consecutive 8-hour periods for 19 babies divided in a control and 
 treatment group.  
}
\format{
This data frame contains the following columns:
\describe{
\item{G}{
a factor with levels
\code{surfactant} 
\code{placebo} 
}
\item{u.1}{
a numeric vector, \code{u} for time period 1.
}
\item{u.2}{
a numeric vector, \code{u} for time period 2.
}
\item{u.3}{
a numeric vector, \code{u} for time period 3.
}
\item{u.4}{
a numeric vector, \code{u} for time period 4.
}
\item{u.5}{
a numeric vector, \code{u} for time period 5.
}
}
}

\source{
 Rama Bhat, M.D., Department of Pediatrics, University of
 Illinoi at Chicago. This data is part of a larger data set.
}
\examples{
data(E7.3)
}
\keyword{datasets}

\eof
\name{E7.4}
\alias{E7.4}
\non_function{}
\title{ Data on PCO2 and Cerebral Blood Flow for Five Regions of the 
                Brain of five Chimpanzees }
\usage{data(E7.4)}
\description{
The \code{E7.4} data frame has 5 rows and 11 columns.
Five baby chimpanzees were injected with a heavy dose of HIV
infection. After six months, the radio-active microsphere technique
was used to measure brain blood flow in ml per 100 grams of brain tissue, 
from five regions of the brain. 
The partial pressure of carbon dioxide in millimeters of mercury was
also obtained. 
}
\format{
This data frame contains the following columns:
\describe{
\item{Ch.}{
a numeric vector, id number of chimpanzee.
}
\item{Fron.x}{
a numeric vector, Frontal partial pressure of carbon dioxide.
}
\item{Fron.y}{
a numeric vector,  Frontal blood flow.
}
\item{Pari.x}{
a numeric vector, Parietal partial pressure of carbon dioxide.
}
\item{Pari.y}{
a numeric vector, Parietal blood flow.
}
\item{Occi.x}{
a numeric vector, Occipital partial pressure of carbon dioxide.
}
\item{Occi.y}{
a numeric vector, Occipital blood flow.
}
\item{Temp.x}{
a numeric vector, Temporal partial pressure of carbon dioxide.
}
\item{Temp.y}{
a numeric vector, Temporal blood flow.
}
\item{Cere.x}{
a numeric vector, Cerebellum partial pressure of carbon dioxide.
}
\item{Cere.y}{
a numeric vector, Cerebellum blood flow.
}
}
}
\source{
 Tonse Raju, M.D. Department of pediatrics, 
 University of Illinois at Chicago.
}
\examples{
data(E7.4)
}
\keyword{datasets}

\eof
\name{E7.5}
\alias{E7.5}
\non_function{}
\title{ Data on Static Weights and Weight in Motion of Trucks }
\usage{data(E7.5)}
\description{
The \code{E7.5} data frame has 26 rows and 6 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{sw.1}{
a numeric vector, static weight of axle 1.
}
\item{wim.1}{
a numeric vector, weight in motion of axle 1.
}
\item{sw.23}{
a numeric vector, static weight of axles 2--3.
}
\item{wim.23}{
a numeric vector, weight in motion of axles 2--3.
}
\item{sw.45}{
a numeric vector, static weight of axles 4--5.
}
\item{wim.45}{
a numeric vector, weight in motion of axles 4--5.
}
}
}
\details{
 Trucks can be weighted by two methods. In one, a truck needs to go into a 
 weighting station and each axle is weighted by conventional means.  The
 other is newer and a somewhat experimental method where a thin pad is placed 
 on the highway and axles are weighted as trucks pass over it. Former weight 
are called static weights (\code{sw}) while later are called weights in 
motion (\code{wim}). 
}
\source{
 Saleh Mumayiz, Urban Transportation Center, University of Illinois at Chicago, 
 who compiled the data from a data set provided by the Illinois Department of
Transportation.
}
\examples{
data(E7.5)
}
\keyword{datasets}

\eof
\name{E7.6}
\alias{E7.6}
\non_function{}
\title{ Community Area Data for the North Part of the City of Chicago }
\usage{data(E7.6)}
\description{
The \code{E7.6} data frame has 34 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Area.Name}{
a character vector, name of area.
}
\item{PB}{
a numeric vector, percentage of population which are black.
}
\item{PS}{
a numeric vector, percentage of population which are spanish speaking.
}
\item{PA}{
a numeric vector, percentage of population over 65.
}
\item{Income}{
a numeric vector, median family income for each area.
}
}
}
\seealso{ \code{\link{E7.7}}, which is the adjacency 
 matrix for the 34 areas. }
\source{
 Data set were constructed by Prof. Siim Soot, Dept. of Geography, 
 University of Illinois at Chicago. 
}
\examples{
data(E7.6)
}
\keyword{datasets}

\eof
\name{E7.7}
\alias{E7.7}
\non_function{}
\title{ The Contiguity Matrix for the 34 Areas in Northern Chicago  }
\usage{data(E7.7)}
\description{
 This is the contiguity matrix for the 34 areas in northern Chicago, 
 given in \code{\link{E7.6}}.  Contains only 0's and 1's with the 
obvious interpretation.
}
\keyword{datasets}

\eof
\name{E8.12}
\alias{E8.12}
\non_function{}
\title{ Data on Lung Cancer Deaths and Cigarette Smoking }
\usage{data(E8.12)}
\description{
The \code{E8.12} data frame has 11 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Country}{
a character vector, the country.
}
\item{y}{
a numeric vector, male deaths in 1950 for lung cancer, per million.
}
\item{x}{
a numeric vector, per capita cigarette consumption in 1930.
}
}
}

\source{
 Tufte, (1974) \emph{Data Analysis for Politics and Policy}. Englewood Cliffs, 
               N.J.: Prentice-Hall. Data are adapted. 
}
\examples{
data(E8.12)
}
\keyword{datasets}

\eof
\name{E8.13}
\alias{E8.13}
\non_function{}
\title{ Florida Cumulus Experiment Data }
\usage{data(E8.13)}
\description{
The \code{E8.13} data frame has 20 rows and 7 columns, giving 
  data on the effects of cloud seeding by silver iodide 
crystals on precipitation. Each data point is one day.
}
\format{
This data frame contains the following columns:
\describe{
\item{A}{
a factor with levels
\code{NoSeed} 
\code{Seed} 
}
\item{T}{
a numeric vector, number of days after the first day of the experiment.
}
\item{S}{
a numeric vector, relates to heights of clouds.
}
\item{C}{
a numeric vector, percentage of clode cover in the experimental area.
}
\item{P}{
a numeric vector, total rainfall in the study area one hour before seeding
(in $10^7$ cubic meters).
}
\item{E}{
a factor with levels
\code{Moving} 
\code{Stationary} , indicating if the radar echo was mowing or not. 
}
\item{y}{
a numeric vector, the response, natural logarithm of precipitation in the 
target area in a 6-hour period (in $10^7$ cubic meters).
}
}
}

\source{
 Woodley, et.al (1977) \emph{Rainfall Results 1970--1975: Florida Area Cumulus Experiment.
         }. Science \bold{95} 735--742.  Copyright 1977 by the AAAS. 
}
\examples{
data(E8.13)
}
\keyword{datasets}

\eof
\name{E9.11}
\alias{E9.11}
\non_function{}
\title{ Data on transit Privatization }
\usage{data(E9.11)}
\description{
The \code{E9.11} data frame has 17 rows and 10 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{V1}{
a numeric vector, average capacity of buses in service.
}
\item{V2}{
a numeric vector, ratio of buses in use during non-peak periods to those in use in 
 peak periods.
}
\item{V3}{
a numeric vector, average speed.
}
\item{V4}{
a numeric vector, vehicle-miles contracted.
}
\item{V5}{
a numeric vector, distance of center from metroploitan area.
}
\item{V6}{
a numeric vector, population of metropolitan area.
}
\item{V7}{
a numeric vector, percentage of work trips in the metropolitan area
       that are made by transit.
}
\item{V8}{
a numeric vector, Buses owned by sponsor / buses owned by contractor
}
\item{V9}{
a numeric vector, per capita income for metropolitan area.
}
\item{PCS}{
a numeric vector, per cent savings that occurred when some transit lines
     was given to private companies.
}
}
}
\source{
 Prof E.K.Morlok, Dept. of Systems Engineering, University of Pennsylvania.
}
\examples{
data(E9.11)
}
\keyword{datasets}

\eof
\name{E9.18}
\alias{E9.18}
\non_function{}
\title{ Data Travel Times and Usage for Automobiles and Public Transportation }
\usage{data(E9.18)}
\description{
The \code{E9.18} data frame has 51 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{t.a}{
a numeric vector, travel time by car, in tenth of minutes.
}
\item{t.r}{
a numeric vector, travel time by public transportation, in tenth of minutes.
}
\item{m.a}{
a numeric vector, number of those who used a car or van either as driver
            or passenger.
}
\item{m.r}{
a numeric vector, number of people using any kind of public transportation.
}
}
}
\details{
 Travel times modified by one of the authors to reflect the cost of parking.
 For downtown zones  (Chicago) this amounted to about 60 minutes.
}
\source{
 Selected by Robert Drozd from Census (US) Urban Transportation Planning 
 Package, for the Chicago area.
}
\examples{
data(E9.18)
}
\keyword{datasets}

\eof
\name{E9.19}
\alias{E9.19}
\non_function{}
\title{ Acceleration data }
\usage{data(E9.19)}
\description{
The \code{E9.19} data frame has 50 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{ACC}{
a numeric vector, Acceleration of different vehicles.
}
\item{WHP}{
a numeric vector, weight-to-horsepower ratio.
}
\item{SP}{
a numeric vector, speed at which they were travelling.
}
\item{G}{
a numeric vector, Grade of road, G=0 implies road was horizontal.
}
}
}

\source{
 Raj Tejwaney, Department of civil Engineering, University
  of Illinoi at Chicago.
}
\examples{
data(E9.19)
}
\keyword{datasets}

\eof
\name{E9.20}
\alias{E9.20}
\non_function{}
\title{ Stadium Cleanup Data }
\usage{data(E9.20)}
\description{
The \code{E9.20} data frame has 16 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{C}{
a numeric vector, cost of cleanup. Units forgotten.
}
\item{R.HD}{
a numeric vector, sales at hot-dog stands. Units forgotten.
}
\item{R.B}{
a numeric vector, sales at beer stands. Units forgotten.
}
}
}
\source{
 The authors of the book.
}
\examples{
data(E9.20)
}
\keyword{datasets}

\eof
\name{E9.21}
\alias{E9.21}
\non_function{}
\title{ Depreciation in Market Value of Large Factories }
\usage{data(E9.21)}
\description{
The \code{E9.21} data frame has 11 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Age}{
a numeric vector, units not given, probably years.
}
\item{Depr}{
a numeric vector, units not given.
}
}
}
\source{
 Diamond-stars Motors, Normal, Il. Gary Shultz, general Counsel, made this 
       data available.
}
\examples{
data(E9.21)
}
\keyword{datasets}

\eof
\name{E9.3}
\alias{E9.3}
\non_function{}
\title{ "Areas", lengths and widths of rectangles }
\usage{data(E9.3)}
\description{
The \code{E9.3} data frame has 50 rows and 3 columns.
  Made by random sampling numbers.
}
\format{
This data frame contains the following columns:
\describe{
\item{y}{
a numeric vector, area of the rectangle.
}
\item{x1}{
a numeric vector, length of the rectangle.
}
\item{x2}{
a numeric vector, width of the ractangle.
}
}
}

\examples{
data(E9.3)
E9.3.m1 <- lm(y ~ x1 + x2, data=E9.3)
attach(E9.3)
plot(x1, resid(E9.3.m1))
plot(x2, resid(E9.3.m1))
}
\keyword{datasets}

\eof
\name{E9.8}
\alias{E9.8}
\non_function{}
\title{ Data on monthly rent, annual income and househould size }
\usage{data(E9.8)}
\description{
The \code{E9.8} data frame has 27 rows and 3 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{R}{
a numeric vector, Monthly rent in dollars.
}
\item{I}{
a numeric vector, annual income in \eqn{1000\$}{1000$}.
}
\item{S}{
a numeric vector, household size.
}
}
}
\details{
 Example 9.8 in Sen and Srivastava, page 201.
}
\source{
 Selected by one of the authors from a much larger data set, collected from
 several sources about 20 years ago.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(E9.8)
attach(E9.8)
E9.8.m1 <- lm(R ~ I + S, data=E9.8)
summary(E9.8.m1)
plot(I, resid(E9.8.m1, type="partial")[,"I"])
plot(S, resid(E9.8.m1, type="partial")[,"S"])
}
\keyword{datasets}

\eof
\name{Ec.8}
\alias{Ec.8}
\non_function{}
\title{ Data on asylum requests to the U.S. by country of origen of applicant }
\usage{data(Ec.8)}
\description{
The \code{Ec.8} data frame has 112 rows and 5 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{Country}{
a character vector, containing country of origen of applicant.
}
\item{APR}{
a numeric vector, number of successful applications.
}
\item{DEN}{
a numeric vector, number of denied applications.
}
\item{H}{
a numeric vector, 1 if country is considered hostile to the U.S., 0 en other case.
}
\item{E}{
a numeric vector, 1 if country is European or mainly inhabited by people
                of european descent.
}
}
}

\source{
 Prof. Barbara Yarnold, Dept. of political science, Saginaw Valley 
        State University, Saginaw, Michigan.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(Ec.8)
summary(Ec.8)
attach(Ec.8)
Ec.8.m1 <- glm(cbind(APR, DEN) ~ E + H, data=Ec.8, family=binomial)
summary(Ec.8.m1)
}
\keyword{datasets}

\eof
\name{Ex.7.7}
\alias{Ex.7.7}
\non_function{}
\title{ U.S. Population in thousands, for exercise 7.7 }
\usage{data(Ex.7.7)}
\description{
The \code{Ex.7.7} data frame has 19 rows and 2 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{y}{
a numeric vector, U.S. population in thousands.
}
\item{t}{
a numeric vector, year.
}
}
}

\source{
 Sen and Srivastava.
}
\examples{
##---- Should be DIRECTLY executable !! ----
data(Ex.7.7)
}
\keyword{datasets}

\eof
\name{Ex4.4}
\alias{Ex4.4}
\non_function{}
\title{ Data on Effects of Air Pollution on Interpersonal Attraction }
\usage{data(Ex4.4)}
\description{
The \code{Ex4.4} data frame has 24 rows and 3 columns.
 An experiment was conducted to examine the effects of air pollution 
 on interpersonal attraction.  Twenty-four subjects were each placed 
 with a stranger for a 15-minute period in a room which was either 
 odor free or contaminated with ammonium sulfide. The stranger came
 from a culture which was similar or dissimilar to that of the subject.
 At the end of the encounter, each subject was asked to assess his degree
 of attraction towards the stranger on a likert scale of 1--10 with
 10 indicating strong attraction.
}
\format{
This data frame contains the following columns:
\describe{
\item{Likert}{
a numeric vector, attraction on a likert scale.
}
\item{Odor}{
a factor with levels
\code{Free} 
\code{Odor}, room was contaminated or not.
}
\item{Culture}{
a factor with levels
\code{Dissimilar} 
\code{Similar}, similar or dissimilar culture.
}
}
}
\source{
 The full data set is given in Srivastava and Carter (1983).
}
\examples{
data(Ex4.4)
}
\keyword{datasets}

\eof
