\name{DJIA}
\alias{DJIA}
\docType{data}
\title{Daily Closing Prices of Stocks in The Dow Jones 30 Industrial Index}
\description{
 This data frame contains daily closing prices of stocks in Dow Jones 30
 Industrial index. Data covers a time period from 30-08-1993 till 29-08-2003.
 The composition of DJIA 30 corresponds to September 1st, 2003.
}
\usage{data(DJIA)}
\format{
  A data frame with 2521 observations on the following 31 variables.
  \describe{
    \item{Date}{POSIXt object containing dates.}
    \item{AA}{Quotes for ALCOA INC.}
    \item{AXP}{Quotes for AMERICAN EXPRESS CO.} 
    \item{BA}{Quotes for BOEING CO.}
    \item{C}{Quotes for CITIGROUP INC.}
    \item{CAT}{Quotes for CATERPILLAR INC.}
    \item{DD}{Quotes for DUPONT E I DE NEMOURS CO.}
    \item{DIS}{Quotes for DISNEY CO WALT HLDG CO.}
    \item{EK}{Quotes for EASTMAN KODAK CO.}
    \item{GE}{Quotes for GENERAL ELECTRIC CO.}
    \item{GM}{Quotes for GENERAL MOTORS CORP.}
    \item{HD}{Quotes for HOME DEPOT INC.}
    \item{HON}{ Quotes for HONEYWELL INTERNATIONAL.}
    \item{HPQ}{ Quotes for HEWLETT-PACKARD CO.}
    \item{IBM}{Quotes for INTERNATIONAL BUSINESS MACHINES CO.}
    \item{INTC}{Quotes for INTEL CO.}
    \item{IP}{ Quotes for INTERNATIONAL PAPER CO.}
    \item{JNJ}{ Quotes for JOHNSON & JOHNSON.}
    \item{JPM}{ Quotes for JP MORGAN CHASE AND CO.}
    \item{KO}{ Quotes for COCA COLA CO.}
    \item{MCD}{ Quotes for MCDONALDS CORP.}
    \item{MMM}{ Quotes for 3M COMPANY.}
    \item{MO}{Quotes for ALTRIA GROUP INC.}
    \item{MRK}{ Quotes for MERCK & CO INC.}
    \item{MSFT}{Quotes for MiCROSOFT CORPORATION.}
    \item{PG}{ Quotes for PROCTER & GAMBLE CO.}
    \item{SBC}{ Quotes for SBC COMMUNICATIONS INC.}
    \item{T}{ Quotes for AT & T CORP.}  
    \item{UTX}{ Quotes for UNITED TECHNOLOGIES CORP.}
    \item{WMT}{ Quotes for WAL-MART STORES INC.}
    \item{XOM}{ Quotes for EXXON MOBIL CORP.}
  }
}

\details{ 
The Dow Jones 30 Industrial Index (DJIA) is prepared and published by Dow Jones & Co. It
is one of the oldest and most widely quoted of all the market indicators. 
The Dow Jones Industrial Average is comprised of 30 stocks that are major factors in their industries, 
and widely held by individuals and institutional investors. 
These 30 stocks represent about a fifth of the \$ 8 trillion-plus market value of all U.S. stocks 
and about a fourth of the value of stocks listed on the New York Stock Exchange. Please refer
for further information, for example, \url{www.nasdaq.com} or \url{www.dowjones.com}.
}

\source{
  	\url{www.nasdaq.com}
}
\examples{
 data(DJIA)
 attach(DJIA)
 plot(Date,IBM, xlab = "Time", ylab = "Close Price", main = "Stock Close Prices vs. Day", type = "l")
 axis.POSIXct(1, Date)
 detach(DJIA)
}
\keyword{datasets}
\eof
\name{VaR-internal}

\alias{gpdf}
\alias{gpd}
\alias{gpdq}
\alias{pdfVaReps}
\alias{pdfESeps}
\alias{gpd.lik}

\title{Internal Functions}

\description{
  Not to be called by the user.
}

\keyword{internal}
\eof
\name{VaR.backtest}
\alias{VaR.backtest}

\title{Backtest of VaR Estimation}

\description{ 
Test for given proportions on input data respective a given VaR. 
}

\usage{
VaR.backtest(x, VaR, p)
}

\arguments{
  \item{x}{ Numerical vector of observation.}
  \item{VaR}{ Number or numerical vector of the same length as \code{x}.}
  \item{p}{Confidence level of VaR estimation.}
}

\details{
This function performs the test for equal or given proportion (prop.test) on
input data. It calculates a part of observation exceeding a VaR and compares it
with a confidence level of VaR estimation.
}

\value{
Return value is a p.value of prop.test and can be interpretated in a usual
manner.
}

\author{T. Daniyarov}

\seealso{\code{\link{prop.test}}}

\examples{
data(exchange.rates)
attach(exchange.rates)
y <- USDJPY[!is.na(USDJPY)]
z <- VaR.norm(y)
VaR.backtest(z$cdata, z$VaR, p = 0.01)
detach(exchange.rates)
}

\keyword{htest}
\eof
\name{VaR.gpd}
\alias{VaR.gpd}

\title{Value at Risk Calculation from Log-Likelihood Fit of General Pareto Distribution (GPD)}

\description{
Estimation of Value at Risk from log-likelihood fit of GPD.
}

\usage{
VaR.gpd(ydat, p = 0.01, p.tr = 0.97, drift.appx = FALSE, init = c(1, 0.3), cflevel = 0.95)
}

\arguments{
  \item{ydat}{Numeric vector of data for which VaR is to be calculated.}
  \item{p}{Confidence level for VaR calculation.}
  \item{p.tr}{Threshold for GPD fit.}
  \item{drift.appx}{ Logical; if \code{TRUE} VaR is calculated in non-zero drift approximation.}
  \item{init}{ Initial values for log-likelihood fit of GPD.}
  \item{cflevel}{Confidence level for estimation of VaR and ES intervals.}
}

\details{
This function estimates Value at Risk and Expected Shortfall of a single risk factor with a given confidence by using a fit of Generalized
Pareto Distribution to the part of data exceeding a given threshold (Peak over Threshold (POT) Method). The input data transformed
to procentual daily return. Then, transformed data is sorted and only part exceeding a given threshold is hold. Threshold is calculated
according an expression \code{p.tr*std}. Log-likelihood fit is then applied to get values of VaR and ES. After that, confidence
intervals for this values are calculated (see reference for details).
}

\value{    
 A list containing following components:
  \item{VaR}{Value at Risk for input data.}
  \item{VaR.interval}{Lower and higher bounds of VaR estimation with confidence given by parameter \code{cflevel}.}
  \item{ES}{Expected shortfall.}
  \item{ES.interval}{Lower and higher bounds of ES estimation with confidence given by parameter \code{cflevel}.}
  \item{data}{Same as \code{ydat}.}
  \item{cdata}{Vector of data used for GPD fit.}  
  \item{conf.level}{Same as \code{p}.}
  \item{tr}{Same as \code{p.tr}.}
  \item{mean}{Mean value of \code{cdata}.}  
  \item{std}{Standard deviation of \code{cdata}.}
  \item{gfit}{Best fit values of GPD.}
  \item{int.conf.level}{Same as \code{cflevel}.}
}

\references{Embrechts, P., Kluepelberg, C., and Mikosch, T. (1999) Modelling
Extremal Events for Insurance and Finance. Application of Mathematics. Springer.
2nd ed. (1st ed., 1997)}

\author{T. Daniyarov}

\seealso{\code{\link{VaR.gpd.plots}}}

\examples{
data(exchange.rates)
attach(exchange.rates)
y <- USDJPY[!is.na(USDJPY)]
z <- VaR.gpd(y)
z$VaR
z$VaR.interval
z$ES
z$ES.interval
detach(exchange.rates)
}

\keyword{ts}% at least one, from doc/KEYWORDS
\eof
\name{VaR.gpd.plots}

\alias{VaR.gpd.plots}

\title{Diagnostic Plots for VaR Calculation from GPD Approximation}

\description{
This function produces some diagnostic plots for VaR estimation using 
output of \code{VaR.gpd} function.
}
\usage{
VaR.gpd.plots(z)
}

\arguments{
  \item{z}{Output of \code{VaR.gpd} function}
}

\details{
Returns plots of daily return (\%), fit of sample distribution, quantile plot, 
loglikelihood functions for VaR and ES.
}

\author{T. Daniyarov}

\seealso{\code{\link{VaR.gpd}}}

\examples{
data(exchange.rates)
attach(exchange.rates)
y <- USDJPY[!is.na(USDJPY)]
z <- VaR.gpd(y)
VaR.gpd.plots(z)
detach(exchange.rates)
}
\keyword{aplot}
\eof
\name{VaR.norm}

\alias{VaR.norm}

\title{Value at Risk Calculation in Lognormal Approximation}

\description{This function estimates Value of Risk (VaR) value in lognormal approximation.}

\usage{
VaR.norm(ydat, p = 0.99, dt = 1, type = "long", drift.appx = FALSE, lin.appx = TRUE)
}

\arguments{
  \item{ydat}{Numeric vector of data for which VaR is to be calculated}
  \item{p}{Confidence level for VaR calculation}
  \item{dt}{Liquidation period}
  \item{type}{String describing type of VaR calculated: "long" or "short"}
  \item{drift.appx}{Logical; if \code{TRUE} VaR is calculated in non-zero drift approximation }
  \item{lin.appx}{Logical; if \code{TRUE} VaR is calculated in linear approximation }
}

\details{
This function estimates VaR for a single risk factor \eqn{S(t)} in lognormal approximation. 
The final expression for VaR of {\bf long} and {\bf short} position is 
\deqn{VaR_{long}(c)=S(t)[1-exp(\mu \delta t + Q^{N(0,1)}_{1-c} \sigma \sqrt{\delta t})]}
\deqn{VaR_{short}(c)=-S(t)[1-exp(\mu \delta t - Q^{N(0,1)}_{1-c} \sigma \sqrt{\delta t})]}
Here, \eqn{c} is a desired confidence, \eqn{Q^{N(0,1)}_{1-c}} is a \eqn{1-c} percentile of normal
distribution, \eqn{\delta t} is liquidation period, and parameters \eqn{\mu} and \eqn{\sigma} are
mean value (or drift) and standard deviation of \eqn{\delta S(t)}.
If \code{drift.appx}=\code{FALSE}, \eqn{\mu = 0}. If \code{lin.appx}=\code{TRUE}, the above functions are expanded 
according \eqn{exp(x) = 1+x}.
}

\value{
  Return value is a list containing following components:
  \item{VaR}{Value at Risk for input data}
  \item{data}{Input data}
  \item{cdata}{Log-transformed data}
  \item{liq.period}{Same as \code{dt}}
  \item{type}{Same as \code{type}}
  \item{conf.level}{Same as \code{p}}
  \item{mean}{Mean value of \code{cdata}}
  \item{std}{Standard deviation of \code{cdata}}
}

\references{ Deutsch, H.P., Derivatives and Internal Models, 2nd Edition, Palgrave, London 2001}

\author{T. Daniyarov}

\seealso{ \code{\link{VaR.norm.plots}}, \code{\link{VaR.backtest}}}

\examples{
data(exchange.rates)
attach(exchange.rates)
y <- USDJPY[!is.na(USDJPY)]
z <- VaR.norm(y)
z$VaR
detach(exchange.rates)
}

\keyword{ts}
\eof
\name{VaR.norm.plots}
\alias{VaR.norm.plots}

\title{Diagnostic Plots for VaR Calculation in Lognormal Approximation}

\description{
This function produces some diagnostic plots for VaR calculation in lognormal 
approximation.
}

\usage{
VaR.norm.plots(z)
}

\arguments{
  \item{z}{ An object returned by \code{VaR.norm()} function }
}

\details{
Returns plots of daily log return and of daily log return histogram with
the best fit provided by \code{VaR.norm()}.	 
}

\author{T. Daniyarov}


\seealso{\code{\link{VaR.norm}}}

\examples{
data(exchange.rates)
attach(exchange.rates)
y <- USDJPY[!is.na(USDJPY)]
z <- VaR.norm(y)
VaR.norm.plots(z)
detach(exchange.rates)
}
\keyword{ aplot}
\eof
\name{exchange.rates}
\alias{exchange.rates}
\docType{data}
\title{EUR/USD, USD/JPY, USD/CHF and GPD/USD Exchange Rates}
\description{
Data on the currencies exchange rates for USD, EUR, CHF, GPD. Data covers a
period from 03-01-2000 till 22-08-2003.
}
\usage{data(exchange.rates)}
\format{
  A data frame with 950 observations on the following 5 variables.
  \describe{
    \item{date}{a POSIXt object containing dates.}
    \item{EURUSD}{a numeric vector. EUR against USD exchange rate.}
    \item{USDJPY}{a numeric vector. USD against JPY exchange rate.}
    \item{USDCHF}{a numeric vector. USD against CHF exchange rate.}
    \item{GPDUSD}{a numeric vector. GPD against USD exchange rate.}
  }
}
\source{
\url{http://www.federalreserve.gov/releases/}
}
\examples{
data(exchange.rates)
attach(exchange.rates)
plot(date, USDJPY, xlab = "Time", ylab = "Exchange Rate", main = "USD/JPY Exchange Rate", type = "l")
axis.POSIXct(1, date)
detach(exchange.rates)
}
\keyword{datasets}
\eof
