\name{abind}
\alias{abind}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Combine multi-dimensional arrays}
\description{
Combine multi-dimensional arrays.  This is a
 generalization of cbind and rbind.  Takes a sequence of
 vectors, matrices, or arrays and produces a single array of
 the same or higher dimension.
}
\usage{
abind(..., along=N, rev.along=NULL, new.names=NULL, force.array=TRUE, make.names=use.anon.names, use.anon.names=FALSE, use.first.dimnames=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{\dots}{ Any number of vectors, matrices, arrays, or data frames.
The dimensions of all the arrays must match, except on one dimension
(specified by \code{along=}).  If these arguments are named, the name
will be used for the name of the dimension along which the arrays are
joined.  Vectors are treated as having a dim attribute of length one.

Alternatively, there can be one (and only one) list argument supplied,
whose compenents are the objects to be bound together.  Names of the
list components are treated in the same way as argument names.
}

\item{along}{ (optional) The dimension along which to bind the arrays.
The default is the last dimension, i.e., the maximum length of the dim
attribute of the supplied arrays.  \code{along=} can take any
non-negative value up to the minimum length of the dim attribute of
supplied arrays plus one.  When \code{along=} has a fractional value, a
value less than 1, or a value greater than N (N is the maximum of the
lengths of the dim attribute of the objects to be bound together), a new
dimension is created in the result.  In these cases, the dimensions of
all arguments must be identical.  }

\item{rev.along}{ (optional)
Alternate way to specify the dimension along which to bind the arrays:
\code{along = N + 1 - rev.along}.  This is provided mainly to allow easy
specification of \code{along = N + 1} (by supplying
\code{rev.along=0}).  If both \code{along} and \code{rev.along} are
supplied, the supplied value of \code{along} is ignored.
}

\item{new.names}{ (optional)
If new.names is a list, it is the first choice for the
dimnames attribute of the result.  It should have the same
structure as a dimnames attribute.  If the names for a
particular dimension are \code{NULL}, names for this dimension are
constructed in other ways.

If \code{new.names} is a character vector, it is used for dimension
names in the same way as argument names are used.  Zero
length ("") names are ignored.
}
  \item{force.array}{ (optional) If \code{FALSE}, rbind or cbind are
called when possible, i.e., when the arguments are all vectors, and
along is not 1, or when the arguments are vectors or matrices or data
frames and along is 1 or 2.  If rbind or cbind are used, they will
preserve the data.frame classes (or any other class that r/cbind
preserve).  Otherwise, abind will convert objects to class array.  Thus,
to guarantee that an array object is returned, supply the argument
\code{force.array=TRUE}.  Note that the use of rbind or cbind introduces
some subtle changes in the way default dimension names are constructed:
see the examples below.  }

\item{make.names}{ (optional)
If \code{TRUE}, the last resort for dimnames for the along
dimension will be the deparsed versions of anonymous
arguments.  This can result in cumbersome names when
arguments are expressions.

    <p>The default is \code{FALSE}.
}


\item{use.anon.names}{ (optional)
  \code{use.anon.names}
is a deprecated synonym for \code{make.names}.
}
  \item{use.first.dimnames}{ (optional)
    When dimension names are present on more than one
argument, should dimension names for the result be take from
the first available (the default is to take them from the
last available, which is the same behavior as
\code{rbind} and \code{cbind}.)
}
}
\details{
The dimensions of the supplied vectors or arrays do not need
to be identical, e.g., arguments can be a mixture of vectors
and matrices.  \code{abind} coerces arguments by the addition
of one dimension in order to make them consistent with other
arguments and \code{along=}.  The extra dimension is
added in the place specified by \code{along=}.

The default action of abind is to concatenate on the last
dimension, rather than increase the number of dimensions.
For example, the result of calling abind with vectors is a
longer vector (see first example below).  This differs from
the action of \code{rbind} and cbind which is to return a matrix when
called with vectors.  abind can be made to behave like cbind
on vectors by specifying \code{along=2}, and like rbind by
specifying \code{along=0}.

The dimnames of the returned object are pieced together
from the dimnames of the arguments, and the names of the
arguments.  Names for each dimension are searched for in the
following order: new.names, argument name, dimnames (or
names) attribute of last argument, dimnames (or names)
attribute of second last argument, etc.  (Supplying the
argument \code{use.first.dimnames=TRUE} changes this to
cause \code{abind} to use dimnames or names from the
first argument first.  The default behavior is the same as
for \code{rbind} and \code{cbind}: use dimnames
from later arguments.)  If some names are supplied for the
along dimension (either as argument names or dimnames in
arguments), names are constructed for anonymous arguments
unless \code{use.anon.names=FALSE}.

}
\value{

  An array with a dim attribute calculated as follows.

  Let \code{rMin=min(sapply(list(...), function(x) length(dim(x))))} and
  \code{rMax=max(sapply(list(...), function(x) length(dim(x))))} (where
  the length of the dimensions of a vector are taken to be 1).  Then \code{rMax} should be
  equal to or one greater than \code{rMin}.

  If \code{along} refers to an existing dimension, then the length of
  the dim attribute of the result is \code{rMax}.  If \code{along} does
  not refer to an existing dimension, then \code{rMax} should equal
  \code{rMin} and the length of the dim attribute of the result will be \code{rMax+1}.

\code{rbind} or \code{cbind} are
called to compute the result if (a)
\code{force.array=FALSE}; and (b) the result will be a
two-dimensional object.

}
% \references{ ~put references to the literature/web site here ~ }
\author{Tony Plate \email{tplate@acm.org} and Richard Heiberger }
% \note{ ~~further notes~~ }

%  ~Make other sections like WARNING with \section{WARNING }{....} ~

% \seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
# Five different ways of binding together two matrices
x <- matrix(1:12,3,4)
y <- x+100
dim(abind(x,y,along=0))     # binds on new dimension before first
dim(abind(x,y,along=1))     # binds on first dimension
dim(abind(x,y,along=1.5))
dim(abind(x,y,along=2))
dim(abind(x,y,along=3))
dim(abind(x,y,rev.along=1)) # binds on last dimension
dim(abind(x,y,rev.along=0)) # binds on new dimension after last

# Unlike cbind or rbind in that the default is to bind
# along the last dimension of the inputs, which for vectors
# means the result is a vector (because a vector is
# treated as an array with length(dim(x))==1).
abind(x=1:4,y=5:8)
# Like cbind
abind(x=1:4,y=5:8,along=2)                   
abind(x=1:4,matrix(5:20,nrow=4),along=2)
abind(1:4,matrix(5:20,nrow=4),along=2)
# Like rbind
abind(x=1:4,matrix(5:20,nrow=4),along=1)
abind(1:4,matrix(5:20,nrow=4),along=1)
# Create a 3-d array out of two matrices
abind(x=matrix(1:16,nrow=4),y=matrix(17:32,nrow=4),along=3)
}
\keyword{ manip }% at least one, from doc/KEYWORDS
\keyword{ array }% __ONLY ONE__ keyword per line

\eof
\name{adrop}
\alias{adrop}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Drop dimensions of an array object }
\description{
  Drop degenerate dimensions of an array object.  Offers more control
  than the \code{drop()} function.
}
\usage{
adrop(x, drop = TRUE, named.vector = TRUE, one.d.array = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ An array (including a matrix) }
  \item{drop}{ A logical or numeric vector describing the dimensions to
    be dropped. }
  \item{named.vector}{ (Optional, defaults to \code{TRUE}.  Controls
    whether a vector result has names derived from the \code{dimnames}
    of \code{x}.}
  \item{one.d.array}{ (Optional, defaults to \code{FALSE}.  If
    \code{TRUE}, a one-dimensional array result will be an object with a
    \code{dim} attribute of
    length 1, and possibly a \code{dimnames} attribute.  If
    \code{FALSE}, a one-dimensional result will be a vector object
    (named if \code{named.vector==TRUE}).}
}
\details{
  Dimensions can only be dropped if their extent is one, i.e., dimension
  \code{i} of array \code{x} can be dropped only if \code{dim(x)[i]==1}.
  It is an error to request \code{adrop} to drop a dimension whose
  extent is not 1.
}
\value{
If \code{x} is an object with a \code{dim} attribute (e.g., a matrix or
     \code{array}), then \code{adrop} returns an object like \code{x},
     but with the requested
     extents of length one removed.  Any accompanying \code{dimnames}
     attribute is adjusted and returned with \code{x}.
}
% \references{ ~put references to the literature/web site here ~ }
\author{Tony Plate \email{tplate@acm.org}}
% \note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~ 
\seealso{ \code{\link{abind}} }
\examples{
x <- array(1:24,dim=c(2,3,4),dimnames=list(letters[1:2],LETTERS[1:3],letters[23:26]))
adrop(x[1,,,drop=FALSE],drop=1)
adrop(x[,1,,drop=FALSE],drop=2)
adrop(x[,,1,drop=FALSE],drop=3)
adrop(x[1,1,1,drop=FALSE],drop=1)
adrop(x[1,1,1,drop=FALSE],drop=2)
adrop(x[1,1,1,drop=FALSE],drop=3)
adrop(x[1,1,1,drop=FALSE],drop=1:2)
adrop(x[1,1,1,drop=FALSE],drop=1:2,one.d=TRUE)
adrop(x[1,1,1,drop=FALSE],drop=1:2,named=FALSE)
dim(adrop(x[1,1,1,drop=FALSE],drop=1:2,one.d=TRUE))
dimnames(adrop(x[1,1,1,drop=FALSE],drop=1:2,one.d=TRUE))
names(adrop(x[1,1,1,drop=FALSE],drop=1:2,one.d=TRUE))
dim(adrop(x[1,1,1,drop=FALSE],drop=1:2))
dimnames(adrop(x[1,1,1,drop=FALSE],drop=1:2))
names(adrop(x[1,1,1,drop=FALSE],drop=1:2))
}
\keyword{ manip }% at least one, from doc/KEYWORDS
\keyword{ array }% __ONLY ONE__ keyword per line

\eof
