### Name: hotelling.trace
### Title: Compute the hotteling trace statistics.
### Aliases: hotelling.trace
### Keywords: multivariate

### ** Examples

data(Bt20)
### Remove the missing values (if any)
Bt20<-remove.NA(Bt20)
###Create the design matrix
X<-design.matrix(Bt20[,1])
###Convert as numeric the measurement
Y<-as.matrix(Bt20[,3:dim(Bt20)[2]])
### Number of groups
p<-dim(X)[2]
### Default contrast matrices
C<-cbind(rep(1,p-1),-diag(p-1))
U<-rbind(rep(1,p),-diag(p))
### Compute the Lawley Hotteling trace statistics
tr<-hotelling.trace(X,Y,C,U)
 


