### Name: interp
### Title: Gridded Bivariate Interpolation for Irregular Data
### Aliases: interp interp.new interp.old
### Keywords: dplot

### ** Examples

data(akima)
# linear interpolation
akima.li <- interp(akima$x, akima$y, akima$z)
image(akima.li$x,akima.li$y,akima.li$z)
contour(akima.li$x,akima.li$y,akima.li$z,add=TRUE)
points(akima$x,akima$y)

# increase smoothness
akima.smooth <- interp(akima$x, akima$y, akima$z,
      xo=seq(0,25, length=100),  yo=seq(0,20, length=100))
image(akima.smooth$x,akima.smooth$y,akima.smooth$z)
contour(akima.smooth$x,akima.smooth$y,akima.smooth$z,add=TRUE)
points(akima$x,akima$y)
# use triangulation library to
# show underlying triangulation:
if(library(tripack, logical.return=TRUE))
  plot(tri.mesh(akima),add=TRUE,lty="dashed")

# use only 15 points (interpolation only within convex hull!)
akima.part <- interp(akima$x[1:15],akima$y[1:15],akima$z[1:15])
image(akima.part$x,akima.part$y,akima.part$z)
contour(akima.part$x,akima.part$y,akima.part$z,add=TRUE)
points(akima$x[1:15],akima$y[1:15])

# spline interpolation, use 5 points to calculate derivatives
# interp gives `linear interpolation not yet implemented with interp.new()'
akima.spl <- interp.old(akima$x, akima$y, akima$z,
      xo=seq(0,25, length=100),  yo=seq(0,20, length=100),ncp=5)
image(akima.spl$x,akima.spl$y,akima.spl$z)
contour(akima.spl$x,akima.spl$y,akima.spl$z,add=TRUE)
points(akima$x,akima$y)

# example with duplicate points
data(airquality)
air <- airquality[(!is.na(airquality$Temp) & 
                   !is.na(airquality$Ozone) & 
                   !is.na(airquality$Solar.R)),]
# gives an error:
## Don't run: air.ip <- interp(air$Temp,air$Solar.R,air$Ozone)
# use mean of duplicate points:
air.ip <- interp(air$Temp,air$Solar.R,air$Ozone,duplicate="mean")



