\name{ash-internal}
\alias{center}
\alias{nicerange}
\title{Internal ash functions}
\description{
 Internal ash functions
}
\details{
  These functions are not intended to be called by the user.
 
}
\keyword{nonparametric}

\eof
\name{ash1}
\alias{ash1}
\title{univariate ASH}
\description{
Computes univariate averaged shifted histogram (polynomial kernel)
}
\usage{
ash1(bins, m, kopt)
}
\arguments{
\item{bins}{
(input list) \code{$nc}=integer vector of bin counts and \code{$ab}=bin interval
}
\item{m}{
(input) optional integer smoothing parameter;  default=5.
}
\item{kopt}{
(input) vector of length 2 specifying the kernel, which
is proportional to \eqn{( 1 - abs(i/m)^kopt(1) )i^kopt(2)};
(2,2)=biweight (default);  (0,0)=uniform;  (1,0)=triangle;
(2,1)=Epanechnikov;  (2,3)=triweight.
}}
\value{
returns structure suitable for input to \code{plot}
dd
\item{x=t}{
vector of bin center locations
}
\item{y=f}{
vector of ash estimates
}
\item{ier}{
0=normal exit; 1=estimate nonzero outside interval ab
}}
\seealso{\code{\link{bin1}}}
\examples{
x <- rnorm(100)         # data
f <- ash1(bin1(x,nbin=50),5) # compute ash estimate
plot( f , type="l" )    # line plot of estimate
}
\keyword{nonparametric}
% Converted by Sd2Rd version 0.2-a3.

\eof
\name{ash2}
\alias{ash2}
\title{bivariate ASH}
\description{
Compute bivariate ASH estimate (product polynomial kernel)
}
\usage{
ash2(bins, m, kopt)
}
\arguments{
\item{bins}{
(input list) bin count matrix nc and interval matrix  ab from \code{bin2}
}
\item{m}{
(input integer vector of length 2) x and y direction smoothing
parameters. Default is 5 by 5. 
}
\item{kopt}{see \code{\link{ash1}}}
}
\value{
Matrix of ASH estimates returned.
Components x,y,z can be given to the contour function directly.
Other input variables returned in list for record keeping.
}
\seealso{\code{\link{bin2}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="bins"))==0){example(bin2)}
}

# Continuing example from help(bin2)
m <- c(5,5)
f <- ash2(bins,m)
image(f$x,f$y,f$z)
contour(f$x,f$y,f$z,add=TRUE)
}
\keyword{nonparametric}
% Converted by Sd2Rd version 0.2-a3.

\eof
\name{bin1}
\alias{bin1}
\title{univariate binning}
\description{
Function to compute array of bin counts for a data vector
}
\usage{
bin1(x, ab, nbin=50)
}
\arguments{
\item{x}{
(input) data vector
}
\item{ab}{
(input vector of length 2):  half-open interval for bins \eqn{[a,b)}.  If no
value is specified, the range of x is stretched by 5\% at each end and
used the interval.
}
\item{nbin}{
(input integer):  number of bins desired. Default 50.
}
}
\value{
\code{bin1} returns a list including the vector of integer bin counts and
the ab vector and the number of points outside the ab interval.
}
\seealso{\code{\link{ash1}}}
\examples{
x <- rnorm(100)         # data vector
ab <- c(-5,5)           # bin interval
bins <- bin1(x,ab,10)     # bin x into 10 bins over ab
}
\keyword{nonparametric}
% Converted by Sd2Rd version 0.2-a3.

\eof
\name{bin2}
\alias{bin2}
\title{2D binning}
\description{
Bin bivariate data x
}
\usage{
bin2(x, ab, nbin)
}
\arguments{
\item{x}{
(input matrix with 2 columns) data sample
}
\item{ab}{
(input 2 x 2 matrix) rows 1 and 2 contain x and y axis bin intervals,
respectively.  If not specified, the ranges are stretched by 5\%
at each end for each dimension.
}
\item{nbin}{
(input vector of length 2) number of bins along x and y axes. Default
is 20 by 20. 
}}
\value{
\code{bin2} returns a list including the bivariate bin matrix 
and the number of points outside the ab rectangle.
}
\seealso{\code{\link{ash2}}}
\examples{
x <- matrix( rnorm(200), 100 , 2)       # bivariate normal n=100
ab <- matrix( c(-5,-5,5,5), 2, 2)       # interval [-5,5) x [-5,5)
nbin <- c( 20, 20)                      # 400 bins
bins <- bin2(x, ab, nbin)               # bin counts,ab,nskip
}
\keyword{nonparametric}
% Converted by Sd2Rd version 0.2-a3.

\eof
