\name{Arosa}
\docType{data}
\alias{Arosa}
\title{Monthly Mean Ozone Thickness in Arosa of Switzerland}
\description{ The \code{Arosa} data frame has 518 rows and 3 columns of data for monthly mean ozone thickness.}
\usage{
data{Arosa}
}
\format{
The data frame contains the following columns:

year a vector of integers from 1 to 46 indicating the years when the measures were taken from 1926. 

month a vector of integers from 1 to 12 represeting the months in a year.

thick a numeric vetor of mean ozone thickness (Dobson units).
}

\details{ Monthly mean ozone thickness in Arosa, Switzerland was recorded from 1926-1971.
}

\source{
Andrew,D. F. and Herzberg, A. M. (1985). Data: a collection of problems from many fields for the  
students and research workers. Springer: Berlin: New York.
}
\keyword{datasets}

\eof
\name{Polynomial}
\alias{linear}
\alias{cubic}
\alias{quintic}
\alias{septic}
\title{
Calculate Reproducing Kernels for Polynomial Splines on [0, 1]
}
\description{
Return a matrix evaluating reproducing kernels for polynomial splines at observed points.
}
\usage{
linear(s, t=s)
cubic(s, t=s)
quintic(s, t=s)
septic(s, t=s)
}
\arguments{
 \item{s}{
   a vector of values in [0, 1], at which the kernels are evaluated.
 }
 \item{t}{
   an optional vector in [0, 1]. Default is the same as s.
 }
}

\details{
The reproducing kernels implemented in these functions are based on Bernoulli functions 
with domain [0, 1].
}
\value{
a matrix with the numbers of row and column equal to the lengths of s and t respectively.
The [i, j] element is the reproducing kernel of linear, cubic, quintic, or septic spline 
evaluated at (s[i], t[j]). 
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}, \code{\link{linear2}}, \code{\link{cubic2}}, 
\code{\link{quintic2}}, \code{\link{septic2}}
}
\examples{
x<-seq(0, 1, len=10)
cubic(x)
}
\keyword{file}

\eof
\name{Polynomial2}
\alias{linear2}
\alias{cubic2}
\alias{quintic2}
\alias{septic2}
\title{
Calculate Reproducing Kernels for Polynomial Splines on [0, T]
}
\description{
Return a matrix evaluating reproducing kernels for polynomial splines at observed points.
}
\usage{
linear2(s, t=s)
cubic2(s, t=s)
quintic2(s, t=s)
septic2(s, t=s)
}
\arguments{
   \item{s}{
   a vector of non-negative values, at which the kernels are evaluated.
   }
   \item{t}{
   an optional non-negative vector. Default is the same as s.
   }
}
\details{
The reproducing kernels implemented in these functions are based on Green functions. The domain is
[0, T], where T is a given positive number.
}
\value{
a matrix with the numbers of row and column equal to the length of s and t respectively.
The [i, j] element is the reproducing kernel of linear, cubic, quintic, or septic spline 
evaluated at (s[i], t[j]). 
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}, \code{\link{linear}}, \code{\link{cubic}}, 
\code{\link{quintic}}, \code{\link{septic}}
}
\examples{
x<- seq(0, 5, len=10)
linear2(x)
}
\keyword{file}


\eof
\name{Shrinkage}
\alias{shrink0}
\alias{shrink1}
\title{Calculate reproducing kernels for Stein shrinkage estimate}
\description{Return a matrix evaluating reproducing kernels for the discrete shrinkage towards zero or the mean estimate}
}
\usage{
shrink0(x, y=x)
shrink1(x, y=x)
}
\arguments{
\item{x}{a vector of numerical values or factor indicating different levels.}
\item{y}{a vector of numerical values or factor indicating different levels. Default is x.}
}
\value{
a matrix with the numbers of row and column equal to the length of x and y respectively. 
The \eqn{[i, j]} element is the reproducing kernel evaluated at the ith element of x and jth element of y.

\code{shink0} shrinks towards zero, and \code{shrink1} shinks towards the mean. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{shrink0}},\code{\link{ssr}}
}
\examples{
x<-rep(1:10,2)
shrink1(x)
}
\keyword{file}

\eof
\name{TXtemp}
\docType{data}
\alias{TXtemp}
\title{Texas Historical Climate Data}
\description{The data frame \code{TXtemp}, obtained from the Carbon Dioxide Information and Analysis Center at Oak Ridge National Laboratory, has 17280 rows and 6 columns of data representing monthly temperature records for stations in Texas.}

\usage{
data(TXtemp)
}
\format{
The data frame contains the following columns:

stacode a numeric vector of the unique station code formed by combining the two-digit state number 
[state numbers range from 1 to 48] and the four-digit station number (values range from 0008 to 9933);                   

lat, long numeric vectors identifying the lattitudes and longitudes of the stations in decimal degree.

year a numeric vector comprising the year for the records

month a numeric vector of values 1 to 12, represeting the month for the data

mmtemp a numeric vector of monthly average temperature in Fahrenheit scale.
}

\details{The data set was extracted from a large national historical climate data, containing data for 48 stations in Texas from 1961 to 1990. Monthly temperature records as well as the latitude and longitude for each station were available.

Of note, the missing values were coded as -99.99.
}

\source{
Data are downloadable from \url{http://cdiac.ornl.gov/ftp/ndp019/}
}
\keyword{datasets}

\eof
\name{Thin}
\alias{tp.pseudo}
\alias{tp}
\title{
Calculate Reproducing Kernels for Thin Plate Splines
}
\description{
Return a matrix evaluating reproducing kernels for thin plate splines at observed points.
}
\usage{
tp.pseudo(s, u=s, order=2)
tp(s, u=s, order=2)
}
\arguments{
\item{s}{
a list or matrix of observations. One component, if a list, and one column, if a matrix,
contains observations on one variable. If a list, all components must be of the same length. 
}
\item{u}{
a list or matrix of observations. If a list, all components must be of the same length. The number
of componets of the list, or the number of column of the matrix must be the same as that for s. 
Default is s.
}
\item{order}{
an optional integer specifying the order of the thin plate spline. Default is 2. Let d be the
dimension of s (and u). Then order must satisfy \eqn{2*order-d>0}.
}}
\value{
a matrix with the numbers of row and column equal to the common length of componets or 
the number of row of s and t respectively. The [i, j] element is the pseudo or true reproducing kernel
evaluated at the ith element of s and jth element of u.
}
\details{
The pseudo kernel, which is conditional definite positive instead of definite positive, is easy to
calculate, while the true reproducing kernel is complicated. Pseudo Kernels are enough to compute 
spline estimates, but to calcualte Bayesian confidnece intervals, the true kernel is required.
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Gu, C. and Wahba, G (1993). Smoothing Spline ANOVA with component-wise Bayesian confidence intervals.
Journal of Computational and Graphical Statistics 55, 353--368.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}, \code{\link{cubic}}
}
\examples{
data(acid)
\dontrun{tp.pseudo(list(acid$x1, acid$x2))}
\dontrun{tp.pseud0(list(acid$x1, acid$x2), order=3)}
}
\keyword{file}

\eof
\name{acid}
\docType{data}
\alias{acid}
\title{Lake Acidity Study}
\description{The \code{acid} data frame has 112 rows and 4 columns of data derived based on the Eastern Lakes Survey of 1984 implemented by the Environmental Protection Agency of the USA.}

\usage{
data(acid)
}
\format{
The data frame contains the following columns:

ph a numeric vector of surface pH values.

t1 a numeric vector of calcium concentrations in log10 milligrams per liter.

x1, x2 numeric vectors of the lakes' geographic locations.
}

\details{112 lakes are extracted in the southern Blue Ridge mountains area. The surface pH values were recorded together with the calcium concentration and geographic locations.}

\source{
Douglas, A. and Delampady, M. (1990), Eastern Lake Survey Phase I: Documentation for the Data Base and the Derived Data sets. Tech Report 160 (SIMS), Dept. Statistics, University of British Columbia. 
}
\references{
Gu, C. and Wahba, G. (1993) Smoothing Spline ANOVA with component-wise Bayesian confidence intervals. Journal of Computational and Graphic Statistics 55, 353-368.
}
\keyword{datasets}

\eof
\name{alogit}
\alias{alogit}
\title{ Calculate the Inverse Logit Transformation}
\description{
 Perform an inverse logit calculation
}
\usage{
alogit(x)
}
\arguments{
  \item{x}{a numeric value}
}

\value{
 Returned is \eqn{e^x/(1+e^x)}.
}
\author{Chunlei ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\keyword{file}



\eof
\name{anova.ssr}
\alias{anova.ssr}
\title{
Testing a Non-parametric Function Fitted via Smoothing Splines
}
\description{
For smoothing spline models with a single smoothing parameter, test
the hypothesis that the unknown funciton 
lies in the null space using the local most powerful (LMP) test and 
a GCV or GML test.
}
\usage{
anova.ssr(object, simu.size=100, ...)
}
\arguments{
\item{object}{
an object of class "ssr" fitted with a single smooting parameter.
}
\item{ simu.size}{
   an optional integer giving the number of simulations to calcualte 
p-values based on simulation. Default is 100.
  }
\item{\dots}{other available arguments, currently unused.}
}

\details{
For Gaussian data with one smoothing parameter, test the hypothesis that the function is in the 
null space \eqn{H_0}, i.e. the parametric part of the fitted model is sufficient. 
Available are the LMP and GCV or GML methods. However, the p-values cannot be calculated analytically 
since the null distributions for these testing statistics under \eqn{H_0} are unknown. 
Monte Carlo simulation is used to approximate the p-values
for the LMP, and GCV (if spar="v") or GML (if spar="m") methods. Due to computation burden, 
the smoothing parameters are fixed at their estimate in the currect calculation. 

When spar="m", an approximate p-value based on a mixture of two Chi-square distributions is also provided for the GML test, 
which tends to be conservationve (Pinherio and Bates, 2002). 

Methods further developed in  Liu and Wang (2004) and Liu, Meiring and Wang (2004) will be implemented in the future.

}
\value{
   a list including test values.
}
\author{ Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\references{
Cox, D. and Koh, E. (1989). A smoothing spline based test of model adequency
in polynomial regression. Ann. Ins. Stat. Math. 41, 383-400.

Cox, D., Koh, E., Wahba, G. and Yandell, B.S. (1988). Testing the parameteric null
model hypothesis in semi-parametric partial and generalized spline models. 
Ann. Statist. 16, 113-119.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Pinherio, J. C. and Bates, D. M. (2000) Mixed-effects Models in S and S-Plus. Springer.

Liu, A. and Wang, Y. (2004) Hypothesis Testing in Smoothing Spline Models. 
Journal of Statistical Computation and Simulation, to appear. 

Liu, A., Meiring, W. and Wang, Y. (2004), Testing Generalized Linear Models Using Smoothing Spline Methods. Statistica Sinica, to appear,
}
\seealso{
\code{\link{ssr}}, \code{\link{print.anova.ssr}}
}
\examples{
data(acid)

# fit a partial thin-plate spline
temp <- ssr(ph~t1+x1+x2, rk=tp(t1), data=acid, spar="m")
anova(temp, 500)
}
\keyword{file}

\eof
\name{bdiag}
\alias{bdiag}
\title{Construct a Block Diagonal Matrix}
\description{
  Return a block diagonal matrix formed from the input list of matrices
}
\usage{
bdiag(x)
}
\arguments{
  \item{x}{a list of matrices}
}
\value{
 Returned is a matrix of the form diag(x1, \dots, xn) where n is the length of the list.
}
\keyword{file}

\eof
\name{canadaTemp}
\docType{data}
\alias{canadaTemp}
\title{Monthly Mean Temperatures}
\description{ The \code{canadaTemp} data frame has 420 rows and 3 columns of data for monthly mean temperatures in Canada}
\usage{
data{canadaTemp}
}
\format{
The data frame contains the following columns:

temp a numeric vector of mean temperatures at some stations in Canada. 

month a vector of integers from 1 to 12 represeting the months in a year.

station a vetor of integers from 1 to 35 indicating the sations where the temperatures were recorded.
}

\source{
The data set was downloaded from \url{http://www.psych.mcgill.ca/faculty/ramsay/datasets.html}.
}
\references{
Ramsay, J. O and Silverman, B. W. (1997). Functional Data Analysis. New York:Springer.

Ke, C. and Wang, Y. (2001). Semi-parametric Nonlinear Mixed Effects Models and
Their Applications. JASA 96:1272-1298.
}
\keyword{datasets}


\eof
\name{chickenpox}
\docType{data}
\alias{chickenpox}
\title{ Chickenpox in New York City}
\description{The \code{chickenpox} data frame has 498 rows and 3 columns of data 
recording the number of Chickenpox occurrences in New York City.}

\usage{
data(chickenpox)
}
\format{
The data frame contains the following columns:

count the number of monthly reported Chickenpox cases.

month a vector of integers from 1 to 12 representing the month for the reported cases.
year a numeric vector representing the year when the cases were reported.
}

\details{ This data frame contains monthly number of reported cases of chickenpox in New York City from 1931 to the first six months of 1972.}

\section{Source}{
The data were downloaded from \url{http://www-personal.buseco.monash.edu.au/~hyndman/TSDL}.
}
\keyword{datasets}

\eof
\name{chol.new}
\alias{chol.new}
\title{A Modified Cholesky Decomposition}
\description{
 Returned a matrix forming Cholesky Decomposition
}
\usage{
chol.new(Q)
}
\arguments{
  \item{Q}{a symmetric matrix, maybe non-positive.}
}
\details{
 This is used internally as an extension of \code{chol} that works on a positive matrix.
}
\value{
 A mtrix M suth that \eqn{XX^T=Q}.
}
\seealso{\code{\link{chol}}}
\keyword{file}



\eof
\name{climate}
\docType{data}
\alias{climate}
\title{Winter Average Temperatures}
\description{The data frame \code{climate}, obrained from the Carbon Dioxide Information and Analysis Center, has 690 rows and 5 columns of data representing station winter temperature measurements.}

\usage{
data(climate)
}
\format{
The data frame contains the following columns:

temp a numeric vector of temperatures in celsius.

lat, long numeric vectors identifying the lattitudes and longitudes of the stations in.

lat.degree, long.degree  numeric vectors identifying the lattitudes and longitudes of the stations in degree.
}

\details{The station winter average temperatures were the averages of the December, January and Febuary monthly average temperatures obtained from the Jones/Wigley data files obtainable from the CDIAC at Oak Ridge National Laboratory in the files ndp020r1/jonesnh.data.Z and ndp020r1/jonessh.dat.Z in the pbu directory at 128.219.24.36.
}

\source{
Jones, P., Wigley, T. and Briffa, K.. lobal and hemisphere temperature anaomalies-land and marine instrumental records. In T. Boden, D. Kaiser, R. Sepanski, and F. Stoss, editors, Trends '93: A Compendium of Data on Global Change, ORNL/CDIAC-65, pages  603-608, Oak Ridge, TN 1994. CDIAC, Oak Ridge National Laboratory.
}
\keyword{datasets}

\eof
\name{dcrdr}
\alias{dcrdr}

\title{Interface to Fortran Subroutine dcrdr}
\description{
  Calculate some matrix operations needed to construct Bayesian confidence intervals
}
\usage{
dcrdr(rkpk.obj, r)
}
\arguments{
  \item{rkpk.obj}{an object returned from calling dsidr}
  \item{r}{a matrix to evaluate reproducing kernels on grid points}
}
\value{
See the document for the corresponding Fortran subroutine.
}
\keyword{file}



\eof
\name{deviance.ssr}
\alias{deviance.ssr}
\title{
Model Deviance
} 
\description{
Extract deviance from a fitted ssr object
}

\usage{
deviance.ssr(object,residuals=FALSE, ...)
}
\arguments{
  \item{object}{a fitted \code{ssr} object}.
  \item{residuals}{
 a logical value. If 'TRUE', deviance residuals are returned. If 'FALSE', the sum of deviance residuals squares is returned. Default is FALSE.}
  \item{\dots}{other arguments, currently unused.}
}
\details{
       This is a method for the function \code{deviance}  for  objects
       inheriting from class \code{ssr}.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{ \code{\link{ssr}}}
\keyword{file}


\eof
\name{dmudr}
\alias{dmudr}
\title{
Interface of dmudr subroutine in RKPACK
}
\description{
To calculate a spline estimate with multiple smoothing parameters
}
\usage{
dmudr(y, q, s, weight = NULL, vmu = "v", theta = NULL, varht = NULL, 
    tol = 0, init = 0, prec = 1e-06, maxit = 30)
}
\arguments{
 \item{y}{
  a numerical vector representing the response.
  }
  \item{q}{
  a list, or an array, of square matrices of the same order as the length of y, which are the reproducing kernels evaluated at the design points.
  }
  \item{s}{
  the design matrix of the null space \eqn{H_0} of size (length-of-y,\eqn{dim(H_0)}), with elements equal to the bases of \eqn{H_0} evaluated at design points.
  }
  \item{weight}{
   a weight matrix for penalized weighted least-square: \eqn{(y-f)'W(y-f)+n\lambda J(f)}. Default is NULL for iid random errors.
  }
  \item{vmu}{
  a character string specifying a method for choosing the smoothing  parameter.  "v", "m" and "u" represent GCV, GML and UBR respectively. "u\eqn{\sim}{~}", only used for non-Gaussian family, specifies UBR with estimated variance. Default is "v".
  }
   \item{theta}{
  If `init=1', theta includes intial values for smoothing parameters. Default is NULL.
  }
  \item{varht}{
  needed only when vmu="u", which gives the fixed variance in calculation of the UBR function. Default is NULL.
  }
  \item{tol}{
  the tolerance for truncation in the tridiagonalization. Default is 0.0.
  }
  \item{init}{
  an integer of 0 or 1 indicating if initial values are provided for theta. If init=1, initial values are provided using theta. Default is 0.
  }
  \item{prec}{
  precision requested for the minimum score value, where precision is the weaker of the absolute and relative precisions. Default is \eqn{1e-06}.
  }
  \item{maxit}{
   maximum number of iterations allowed. Default is 30.
   }
}
\value{
\item{info}{
  an integer that provides error message. info=-1 indicates dimension error, 
info=-2 indicates \eqn{F_{2}^{T} Q_{*}^{\theta} F_{2} !>= 0}, info=-3 indicates tuning parameters are out of scope, info=-4 indicates fails to converge within maxite steps, info=-5 indicates fails to find a reasonable descent direction, info>0 indicates the matrix S is rank deficient with \eqn{info=rank(S)+1}.
  }
   \item{fit}{
   fitted values.
   }
   \item{c}{
   estimates of c.
   }
   \item{d}{
   estimates of d.
   }
   \item{resi}{
   vector of residuals.
   }
   \item{varht}{
   estimate of variance.
   }
  \item{theta}{
   estimates of parameters \eqn{log10(\theta)}. }
  \item{nlaht}{
  the estimate of \eqn{log10(nobs*\lambda)}.
  }
  \item{score}{
  the minimum GCV/GML/UBR score at the estimated smoothing parameters. 
  }
  \item{df}{
  equavilent degree of freedom.
  }
  \item{nobs}{
  length(y), number of observations.
  }
  \item{nnull}{
  dim(\eqn{H_0}), number of bases.
  }
  \item{nq}{
  length(rk), number of reproducing kernels.
  }
  \item{s,q,y}{
  changed from the inputs.
  }
}
\references{
Gu, C. (1989). RKPACK and its applications: Fitting smoothing spline models. Proceedings of the Statistical Computing Section, ASA, 42-51.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{dsidr}}, \code{\link{gdsidr}}, \code{\link{gdmudr}}, \code{\link{ssr}}
}
\keyword{file}

\eof
\name{dog}
\docType{data}
\alias{dog}
\title{Coronary Ainus Potassium Concentrations}
\description{The \code{dog} data frame has 252 rows and 4 columns of data considered by Grizzle and Alen (1969)
}
\usage{
data(dog)
}
\format{
The data frame contains the following columns:

y a numeric vector of meansurements of coronary sinus postassium concentrations.

group a vector of group index for the four groups of dogs.

dog a vector of integers identifying dogs.

time a numeric vector of time points measurements were made.
}

\details{The data are coronary sinus potassium concentrations measured on each of 36 dogs. These 36 dogs were divided into 4 treatment groups, and the measurements on each dog were taken every two minutes from 1 to 13 minutes after occlusion.}

\source{
Grizzle, J. E. and Allen, D. M. (1969). Analysis of growth and dose response curves, Biometrics 25: 357-381.
}
\keyword{datasets}



\eof
\name{ dsidr }
\alias{dsidr}
\title{Interface of dsidr subroutines in RKPACK}
\description{
To calculate a spline estimate with a single smoothing parameter
}
\usage{dsidr(y, q, s=NULL, weight=NULL, vmu="v", varht=NULL, 
limnla=c(-10, 3), job=-1, tol=0)
}
\arguments{
  \item{y}{
   a numerical vector representing the response.
  }
  \item{q}{
   a square matrix of the same order as the length of y, with elements equal to the reproducing kernel evaluated at the design points.
  }
  \item{s}{
  the design matrix of the null space \eqn{H_0} of size (length(y),dim(\eqn{H_0})), 
with elements equal to the bases of \eqn{H_0} evaluated at design points. Default is NULL, representing an empty NULL space.}
  \item{weight}{
  A weight matrix for penalized weighted least-square: \eqn{(y-f)'W(y-f)+n\lambda J(f)}. Default is NULL for iid random errors.
  }
 \item{vmu}{
  a character string specifying a method for choosing the smoothing  parameter.  "v", "m" and "u" represent GCV, GML and UBR respectively. 
"u\eqn{\sim}{~}", only used for non-Gaussian family, specifies UBR with estimated variance. Default is "v".
 }
 \item{varht}{
  needed only when vmu="u", which gives the fixed variance in calculation of the UBR function. Default is NULL.
  }
  \item{limnla}{
  a vector of length 2, specifying a search range for the  n times smoothing parameter on \eqn{log10} scale. Default is \eqn{(-10, 3)}.
  }
  \item{job}{
  an integer representing the optimization method used to find the smoothing parameter. 
The  options are job=-1: golden-section search on (limnla(1), limnla(2)); 
job=0: golden-section search with interval specified automatically; 
job >0: regular grid search on  \eqn{[limnla(1), limnla(2)]} with \#(grids) = job + 1. Default is -1. 
  }
  \item{tol }{
  tolerance for truncation used in `dsidr'. Default is 0.0, which sets to square of machine precision.
  }
}
\value{
  \item{info}{
   an integer that provides error message. info=0 indicates normal termination, info=-1 indicates dimension error, info=-2 indicates
 \eqn{F_{2}^{T} Q F_{2} !>= 0}, info=-3 indicates vmu is out of scope, and info>0 indicates the matrix S is rank 
deficient with info=rank(S)+1. 
   }
  \item{ fit}{
  fitted values.
  }
  \item{c}{
  estimates of c.
  }
  \item{d}{
  estimates of d.
  }
  \item{resi}{
  vector of residuals.
  }
  \item{varht}{
  estimate of variance.
  }
  \item{nlaht}{
  the estimate of log10(nobs*lambda).
  }
  \item{limnla}{
  searching range for nlaht. 
  }
  \item{score}{
  the minimum GCV/GML/UBR score at the estimated smoothing parameter. When job>0, it gives a vector of GCV/GML/UBR functions evaluated at regular grid points.
  }
  \item{df}{
  equavilent degree of freedom.
  }
  \item{nobs}{
  length(y), number of observations.
  }
  \item{nnull}{
  dim(\eqn{H_0}), number of bases.
  }
  \item{s,qraux,jpvt}{
   QR decomposition of S=FR, as from Linpack `dqrdc'.
   }
  \item{q}{
   first dim(\eqn{H_0}) columns gives \eqn{F^{T} Q F_{1}}, and its bottom-right corner gives tridiagonalization of \eqn{F_{2}^{T} Q F_{2}}.
   }
}
\references{
Gu, C. (1989). RKPACK and its applications: Fitting smoothing spline models. Proceedings of the Statistical Computing Section, ASA, 42-51.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{dmudr}}, \code{\link{gdsidr}}, \code{\link{gdmudr}}, \code{\link{ssr}}
}
\keyword{file}

\eof
\name{dsms}
\alias{dsms}
\title{Interface to Fortran Subroutine dsms }
\description{
  Calculate a matrix operation needed to construct Bayesian confidence intervals
}
\usage{
dsms(rkpk.obj)
}
\arguments{
  \item{rkpk.obj}{an object returned from calling dsidr}
}

\value{
a matrix. See the corresponding Fortran subroutine. 
}
\keyword{file}

\eof
\name{gdmudr}
\alias{gdmudr}
\title{Interface of dbmdr, dbimdr, dgmdr, dpmdr in GRKPACK.}
\description{
To calculate a spline estimate with multiple smoothing parameters for non-Gaussian data
}
\usage{
gdmudr(y, q, s, family, vmu = "v", varht = NULL, 
    init = 0, theta = NULL, tol1 = 0, tol2 = 0, prec1 = 1e-06, 
    maxit1 = 30, prec2 = 1e-06, maxit2 = 30) 
}
\arguments{
   \item{y}{
   a numerical vector representing the response, or a matrix of two columns for binomial data with the first column as the largest possible counts and the second column as the counts actually obsered.
    }
   \item{q}{
   a list, or an array, of square matrices of the same order as the length of y, which are the reproducing kernels evaluated at the design points.
   }
   \item{s}{
   the design matrix of the null space \eqn{H_0} of size (length-of-y,\eqn{dim(H_0)}), with elements equal to the bases of \eqn{H_0} evaluated at design points.
   }
   \item{family}{
   a string specifying the family of distribution. Families  supported  are  "binary", "binomial", "poisson" and "gamma" for Bernoulli, binomial, poisson, and gamma distributions respectively. Canonical links are used except for Gamma family where log link is used.
  }
   \item{vmu}{
   a character string specifying a method for choosing the smoothing  parameter.  "v", "m" and "u" represent GCV, GML and UBR respectively. 
"u\eqn{\sim}{~}", only used for non-Gaussian family, specifies UBR with estimated variance. Default is "v".
  }
  \item{varht}{
  needed only when vmu="u", which gives the fixed variance in calculation of the UBR function. Default is 1.0.
  }
  \item{init}{
   an integer of 0 or 1 indicating if initial values are provided for theta. If init=1, initial values are provided using theta. Default is 0.
  }
  \item{theta}{
  If `init=1', theta includes intial values for smoothing parameters. Default is NULL.
  }
  \item{tol1}{
  the tolerance for elements of w's. Default is 0.0 which sets to square of machine precision. 
  }
  \item{tol2}{
  tolerance for truncation used in `dsidr'. Default is 0.0 which sets to square of machine precision.
  }
  \item{prec1}{
  precision requested for the minimum score value, where precision is the weaker of the absolute and relative precisions. Default is 1e-06.
  }
  \item{maxit1}{
   maximum number of iterations allowed for DMUDR subroutine. Default is 30.
  }
  \item{prec2}{
  precision requested for stopping the iteration. Default is \eqn{1e-06}.
  }
  \item{maxit2}{
  maximum number of iterations allowed for the iteration in GRKPACK. Default is 30.
  }
}
\value{
  \item{info}{
  an integer that provides error message. info=-1 indicates dimension error, 
info=-2 idicates \eqn{F_{2}^{T} Q_{*}^{theta} F_{2} !>= 0}, info=-3 indicates tuning parameters are out of scope, info=-4 indicates dmudr fails to converge within maxit1 steps, info=-5 indicates dmudr fails to find a reasonable descent direction, info=-6 indicates GRKPACK fails to converge within maxit2 steps, info=-7 indicates there are some w's equals to zero, 
info>0 indicates the matrix S is rank deficient with \eqn{info=rank(S)+1}.
  }
  \item{fit}{
  estimate of the function at design points.
  }
  \item{c}{
  estimates of c.
  }
  \item{ d}{
  estimates of d.
  }
  \item{resi}{
   vector of working residuals.
  }
  \item{varht}{
  estimate of dispersion parameter.
  }
  \item{theta}{
  estimates of parameters \eqn{log10(theta)}. 
  }
  \itme{nlaht}{
  the estimate of \eqn{log10(nobs*lambda)}.
  }
  \item{score}{
  the minimum GCV/GML/UBR score at the estimated smoothing parameters. 
  }
  \item{df}{
   equavilent degree of freedom.
  }
  \item{nobs}{
  length-of-y, number of observations.
  }
  \item{nnull}{
  \eqn{dim(H_0)}, number of bases.
  }
  \item{nq}{
  length(rk), number of reproducing kernels.
  }
  \item{s,q,y,init,maxit2}{
  changed from the inputs.
  }
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Wang, Y. (1997). GRKPACK: Fitting Smoothing Spline ANOVA Models for Exponential Families. Communications in Statistics: Simulation and Computation, 24: 1037-1059.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{dsidr}}, \code{\link{dmudr}}, \code{\link{gdsidr}}, \code{\link{ssr}}
}
\keyword{file}

\eof
\name{gdsidr}
\alias{gdsidr}
\title{
Interface of dbsdr, dbisdr, dgsdr, dpsdr in GRKPACK.
}
\description{
To calculate a spline estimate with single smoothing parameter for non-Gaussian data.
}
\usage{
gdsidr(y, q, s, family, vmu="v", varht=NULL, limnla=c(-10, 3), 
maxit=30, job=-1, tol1=0, tol2=0, prec=1e-06)
}
\arguments{
 \item{ y}{
  a numerical vector representing the response, or a matrix of two columns for binomial data with the first column as the largest possible counts and the second column as the counts actually obsered.
  }
 \item{q}{
  a square matrix of the same order as the length of y, with elements equal to the reproducing kernel evaluated at the design points.
  }
  \item{s}{
  the design matrix of the null space \eqn{H_0} of size (length-of-y,dim(\eqn{H_0})), with elements equal to the bases of \eqn{H_0} evaluated at design points.
  }
  \item{family}{
  a string specifying the family of distribution. Families  supported  are  "binary", "binomial", "poisson" and "gamma" for Bernoulli, binomial, poisson, and gamma distributions respectively. Canonical links are used except for Gamma family where a log link is used.
  }
  \item{vmu}{
  a character string specifying a method for choosing the smoothing  parameter.  "v", "m" and "u" represent GCV, GML and UBR respectively. "u\eqn{\sim}{~}", only used for non-Gaussian family, specifies UBR with estimated variance. Default is "v".
  }
  \item{varht}{
  needed only when vmu="u", which gives the fixed variance in calculation of the UBR function. Default is 1.0.
  }
  \item{limnla}{
  a vector of length 2, specifying a search range for the  n times smoothing parameter on log10 scale. Default is (-10, 3).
  }
  \item{maxit}{
  maximum number of iterations allowed for the iteration in GRKPACK.
  }
  \item{job}{
  an integer representing the optimization method used to find the smoothing parameter. 
The  options are job=-1: golden-section search on (limnla(1), limnla(2)); 
job=0: golden-section search with interval specified automatically; 
job >0: regular grid search on  [limnla(1), limnla(2)] with \#(grids) = job + 1. Default is -1. 
  }
  \item{tol1}{
  the tolerance for elements of w's. Default is 0.0 which sets to square of machine precision. 
  }
  \item{tol2}{
  tolerance for truncation used in `dsidr'. Default is 0.0 which sets to square of machine precision.
  }
  \item{prec}{
  precision requested for stopping the iteration. Default is \eqn{1e-06}.
  }
}
\value{
  \item{info}{
   an integer that provides error message. info=0 indicates normal termination, info=-1 indicates dimension error, 
info=-2 indicates \eqn{F_{2}^{T} Q F_{2} !>= 0}, info=-3 indicates vmu is out of scope, info=-4 indicates the algorithm fails to converge at the maxiter steps, info=-5 indicates there are some w's equals to zero, and info>0 indicates the matrix S is rank deficient with info=rank(S)+1. 
   }
  \item{fit}{
   estimate of the function at design points.
   }
  \item{c}{
   estimates of c.
  }
  \item{d}{
  estimates of d.
  }
  \item{resi}{
   vector of working residuals.
   }
  \item{varht}{
  estimate of dispersion parameter.
  }
  \item{nlaht}{
  the estimate of \eqn{log10(nobs*lambda)}.
  }
  \item{limnla}{
  searching range for nlaht. 
  }
  \item{score}{
  the minimum GCV/GML/UBR score at the estimated smoothing parameter. When job>0, it gives a vector of GCV/GML/UBR functions evaluated at regular grid points.
  }
  \item{df}{
   equavilent degree of freedom.
  }
  \item{nobs}{
  length-of-y, number of observations.
  }
  \item{nnull}{
   \eqn{dim(H_0)}, number of bases.
  }
  \item{s,qraux,jpvt}{
  QR decomposition of S=FR, as from Linpack `dqrdc'.
  }
  \item{q}{
   first \eqn{dim(H_0)} columns gives \eqn{F^{T} Q F_{1}}, and its bottom-right corner gives tridiagonalization of \eqn{F_{2}^{T} Q F_{2}}.
   }
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Wang, Y. (1997). GRKPACK: Fitting Smoothing Spline ANOVA Models for Exponential Families. Communications in Statistics: Simulation and Computation, 24: 1037-1059.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{dsidr}}, \code{\link{dmudr}}, \code{\link{gdmudr}}, \code{\link{ssr}}
}
\keyword{file}

\eof
\name{hat.ssr}
\alias{hat.ssr}
\title{
Extract the Hat Matrix from a ssr Object}
}
\description{
Calculate the hat matrix for a \code{ssr} object.
}
\usage{ 
hat.ssr(ssr.obj)
}
\arguments{
   \item{ssr.obj}{
   a fitted ssr object.
   }
}
\details{
The hat matrix may be used for diagnosis. Note that the full name hat.ssr shoud be used since the function hat already exist.
}
 
\value{
returned is the hat (influence, smoother) matrix.
}
\reference{ 
Eubank, R. L. (1984). The Hat Matrix for Smoothing Splines. Statistics and Probability Letters, 2:9-14.

Eubank, R. L. (1985). Diagnostics for Smoothing Splines. Journal of the Royal Statistical Society B. 47: 332-341.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}
}
\examples{
\dontrun{library(MASS)}
\dontrun{fit1<- ssr(accel~times, data=mcycle, scale=T, rk=cubic(times))}
\dontrun{h <- hat.ssr(fit1)}
}
\keyword{file}


\eof
\name{horm.cort}
\docType{data}
\alias{horm.cort}
\title{Hormone Measurements of Cortisol}
\description{The \code{horm.cort} data frame has 425 rows and 4 columns of data representing measurement of cortisol on 36 individuals.}

\usage{
data(horm.cort)
}
\format{
The data frame contains the following columns:

ID a vector of index indicating individuals on whom measures were made.

time a numeric vector of time points of every 2 hours in 24 hours. The time is scaled into [0, 1].

type a vector of character strings identifying the groups, "normal", "depressed", or "cushing", which the individuals belong to.

conc cortisol concentration measurements in \eqn{log10} scale.
}

\details{Blood samples were collected every 2 hours for 24 hours from three group of healthy normal volunteers and volunteers with depresession and suchsing syndrome. They were analyzed for parameters that measure hormones of the hypothalamic-pituitary axix. Human circadian thythm is one of the research objective. In this data set, only measurements of cortisol concetration were included.}

\source{
This data set was extracted from a stress study conducted in the medical center of the University of Michigan.
}
\references{
Wang, Y. and Brown, M. B. (1996). A Flexible Model for Human Circadian Rhythms. Biometrics 52, 588-596.

Yuedong Wang, Chunlei Ke and Morton B. Brown (2003), Shape Invariant Modelling of Circadian Rhythms with Random Effects and Smoothing Spline ANOVA Decompositions. Biometrics, 59:804-812.
}
\keyword{datasets}

\eof
\name{ident}
\alias{ident}
\title{Scaling a Vector}
\description{
Perform standarization of vector relative to another.
}
\usage{
ident(x, y = x)
}
\arguments{
  \item{x}{a numeric vector, matrix or data frame}
  \item{y}{an optional numeric vector, matrix or data frame. Default is x.}
}
\details{
Scale \code{y} based on \code{x} component by component. For example, if both are a matrix, 
\eqn{y[,i]=(y[,]-min(x[,i]))/(max(x[,i])-min(x[,i]))}.
}
\value{
 a scaled \code{y}.
}
\keyword{file}



\eof
\name{intervals.nnr}
\alias{intervals.nnr}
\title{
Calculate Predictions and Approximate Posterior Standard Deviations for Spline Estimates From a nnr Object
}
\description{
Approximate posterior standard deviations are calculated for the spline estimate of
nonparametric functions from a \code{nnr} object, based on which approximate Bayesian
confidence intervals may be constructed.
}
\usage{
intervals.nnr(object,level=0.95, newdata=NULL, terms=<see below>, pstd=TRUE,level=0.95, ...)
}
\arguments{
\item{nnr.obj}{
an object inheriting from class \code{nnr}, representing a 
nonlinear nonparametric regression model fit.
}
\item{newdata}{
a data frame on which the fitted spline estimates are to be evaluated. 
Only those predictors, referred in \code{func} of \code{nnr} fitting, have to
be present. The variable names of the data frame should correspond 
to the function(s)' arguments appearing in the opion func=  of nnr.
Default is NULL, where predictions are made at the same values 
used to fit the object.
}
\item{level}{set as 0.95, unused currently}
\item{terms }{
an optional named list of vectors or matrices containing 0's and 1's  collecting one or several combinations 
of the components of spline estimates in the fitted snr object. The length and names of the list shall match those of 
the unknown functions appearing in the 'snr' fit object. For the case of a single function, a vector of 0's 
and 1's can also be accepted. A value "1" at a particular position means that the component at 
that position is collected. Default is a vector of 1's, representing the overall fits of all unknown functions.  
}
\item{pstd}{
an optional logic value.
If TRUE (the default), the posterior standard deviations are calculated. 
Orelse, only the predictions are calculated.
Computation required for posterior standard deviations could be intensive. 
}
\item{level}{a numeric value set as 0.95.}
\item{\dots}{other arguments, currently unused.}
}
\value{
an object of class \code{bCI} is returned, which is a list of length 2. 
Its first element is a matrix which contains predictions for 
combinations specified by \code{terms}, and second element is a matrix which contains 
corresponding posterior standard deviations. 
}
\details{
The standard deviation returned is based on approximate Bayesian confidence 
intervals as formulated in Ke and Wang (2002). 
}
\references{
Ke, C. and Wang, Y. (2002). Nonlinear Nonparametric Regression Models. Submitted.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{nnr}}, \code{\link{plot.bCI}}}
}
\examples{

## fit a generalized varying coefficient models
data(Arosa)
Arosa$csmonth <- (Arosa$month-0.5)/12
Arosa$csyear <- (Arosa$year-1)/45
ozone.fit <- nnr(thick~f1(csyear)+exp(f2(csyear))*f3(csmonth),
        func=list(f1(x)~list(~I(x-.5),cubic(x)), f2(x)~list(~I(x-.5)-1,cubic(x)),
        f3(x)~list(~sin(2*pi*x)+cos(2*pi*x)-1,lspline(x,type="sine0"))),
        data=Arosa[Arosa$year\%\%2==1,], spar="m", start=list(f1=mean(thick),f2=0,f3=sin(csmonth)),
	control=list(backfit=1))

x <- seq(0,1,len=50)
u <- seq(0,1,len=50)

## calculate Bayesian confidence limits for all components of all functions
p.ozone.fit <- intervals(ozone.fit, newdata=list(csyear=x,csmonth=u),
                 terms=list(f1=matrix(c(1,1,1,1,1,0,0,0,1),nrow=3,byrow=TRUE),
	                    f2=matrix(c(1,1,1,0,0,1),nrow=3,byrow=TRUE),
                            f3=matrix(c(1,1,1,1,1,0,0,0,1),nrow=3,byrow=TRUE)))	
\dontrun{plot(p.ozone.fit, x.val=x)}
}
\keyword{file}


\eof
\name{intervals.slm}
\alias{intervals.slm}
\title{
Calculate Predictions and Posterior Standard Deviations of Spline Estimates From a slm Object
}
\description{
Provide a way  to calculate approximate posterior standard deviations and fitted 
values at any specified values for any combinations of elements of the spline 
estimate of nonparametric functions from a \code{slm} object, based on which 
approximate Bayesian confidence intervals may be constructed.
}
\usage{
intervals.slm(object, level=0.95, newdata=NULL, terms=<see below>, pstd=TRUE, level=0.95, ...)
}
\arguments{
\item{object}{
an object inheriting from class "slm", representing a semi-parametric nonlinear regression model fit.
}
\item{level}{set as 0.95, unused currently}
\item{newdata}{
an optional data frame on which the fitted spline estimate is to be evaluated. 
}
\item{terms }{
an optional vector of 0's and 1's collecting a combination of components, or a matrix of 0's and 1's 
collecting several combinations of components, in a fitted ssr object. All components include bases on 
the right side of \eqn{\mbox{\textasciitilde}}{~} in the formula and reproducing kernels in the rk list. Note that the first component 
is usually a constant function if it is not specifically excluded in the formula. A value "1" at a particular 
position means that the component at that position is collected. Default is a vector of 1's, 
representing the overall fit. 
}
\item{pstd}{
an optional logic value.
If TRUE (the default), the posterior standard deviations are calculated. 
Orelse, only the predictions are calculated.
Computation required for posterior standard deviations could be intensive. 
}
\item{level}{a numeric value set as 0.95.}
\item{\dots}{other arguments, currently unused.}
}
\value{
an object of class \code{bCI} is returned, which is a list of length 2. Its first element is a matrix which contains predictions for 
combinations specified by \code{terms}, and second element is a matrix which contains 
corresponding posterior standard deviations. 
}
\details{
The standard deviation returned is based on approximate Bayesian confidence intervals as formulated
in Wang (1998). 
}
\references{
Wang, Y. (1998). Mixed-effects smoothing spline ANOVA. Journal of the Royal Statistical Society, Series B 60, 159-174.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{slm}}, \code{\link{plot.bCI}}, \code{\link{predict.ssr}}
}
\examples{
data(dog)
# fit a SLM model with random effects for dogs
dog.fit<-slm(y~group*time, rk=list(cubic(time), shrink1(group),
    rk.prod(kron(time-0.5),shrink1(group)),rk.prod(cubic(time), 
    shrink1(group))), random=list(dog=~1), data=dog)

intervals(dog.fit)
}
\keyword{file}

\eof
\name{intervals.snm}
\alias{intervals.snm}
\title{
Calculate Predictions and Approximate Posterior Standard Deviations for Spline Estimate From a snm Object
}
\description{
Provide a way  to calculate approximate posterior standard deviations and fitted 
values at any specified values for any combinations of elements of the spline 
estimate of nonparametric functions from a snm object, based on which 
approximate Bayesian confidence intervals may be constructed.
}
\usage{
intervals.snm(object,level=0.95, newdata=NULL, terms=<see below>, pstd=TRUE, level=0.95, ...)
}
\arguments{
\item{snm.obj}{
an object inheriting from class snm, representing a semi-parametric 
nonlinear mixed effects model fit.
}
\item{level}{set as 0.95, unused currently}
\item{newdata}{
a data frame on which the fitted spline estimates are to be evaluated. 
Only those predictors, referred in 'func' of 'snm' fitting, have to
be present. The variable names of the data frame should correspond 
to the function(s)' arguments appearing in the opion func=  of snm.
Default is NULL, where predictions are made at the same values 
used to fit the object.
}
\item{terms }{
an optional vector of 0's and 1's collecting a combination of 
components, or a matrix of 0's and 1's collecting several combinations 
of components of spline estimates in a fitted snm object. Note that 
in the cases of multiple functions, the order of all componets is 
collection of base functions for all functions followed by RK's. 
A value "1" at a particular position means that the component at 
that position is collected. Default is a vector of 1's, 
representing the overall fit. 
}
\item{pstd}{
an optional logic value. If TRUE (the default), approximate posterior 
standard deviations are calculated. Orelse, only the predictions 
are calculated. Computation required for posterior standard deviations 
could be intensive. 
}
\item{level}{a numeric value set as 0.95.}
\item{\dots}{other arguments, currently unused.}
}
\value{
an object of class \code{bCI} is returned, which is a list of length 2. 
Its first element is a matrix which contains predictions for 
combinations specified by "terms", and second element is a matrix 
which contains corresponding posterior standard deviations. 
}
\details{
The standard deviation returned is based on approximate Bayesian 
confidence intervals as formulated in Ke and Wang (2001). 
}
\references{
Ke, C. and Wang, Y. (2001). Semi-parametric Nonlinear Mixed Effects 
Models and Their Applications. JASA 96:1272-1298.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{snm}}, \code{\link{plot.bCI}}, \code{\link{predict.ssr}}
}
\examples{
data(horm.cort)

## extract normal dubjects
cort.nor<- horm.cort[horm.cort$type=="normal",]

## fit a self-modelling model with random effects
cort.fit<- snm(conc~b1+exp(b2)*f(time-alogit(b3)), 
  func=f(u)~list(periodic(u)), fixed=list(b1~1), 
  random=pdDiag(b1+b2+b3~1), data=cort.nor, 
  groups= ~ID,start=mean(cort.nor$conc))

## note the variable name of newdata
intervals(cort.fit, newdata=data.frame(u=seq(0,1,len=50)))
}
\keyword{file}


\eof
\name{intervals.snr}
\alias{intervals.snr}
\title{
Calculate Predictions and Approximate Posterior Standard Deviations for Spline Estimates From a snr Object
}
\description{
Approximate posterior standard deviations are calculated for the spline estimate of
nonparametric functions from a snr object, based on which approximate Bayesian
confidence intervals may be constructed.
}
\usage{
intervals.snr(object, level=0.95, newdata=NULL, terms=<see below>, pstd=TRUE, level=0.95, ...)
}
\arguments{
\item{object}{
an object inheriting from class 'snr', representing a 
semi-parametric nonlinear regression model fit.
}
\item{level}{set as 0.95, unused currently}
\item{newdata}{
a data frame on which the fitted spline estimates are to be evaluated. 
Only those predictors, referred in 'func' of 'snr' fitting, have to
be present. The variable names of the data frame should correspond 
to the function(s)' arguments appearing in the opion func=  of snr.
Default is NULL, where predictions are made at the same values 
used to fit the object.
}
\item{terms }{
an optional named list of vectors or matrices containing 0's and 1's  collecting one or several combinations 
of the components of spline estimates in the fitted snr object. The length and names of the list shall match those of 
the unknown functions appearing in the 'snr' fit object. For the case of a single function, a vector of 0's 
and 1's can also be accepted. A value "1" at a particular position means that the component at 
that position is collected. Default is a vector of 1's, representing the overall fits of all unknown functions. 
}
\item{pstd}{
an optional logic value.
If TRUE (the default), the posterior standard deviations are calculated. 
Orelse, only the predictions are calculated.
Computation required for posterior standard deviations could be intensive. 
}
\item{level}{a numeric value set as 0.95.}
\item{\dots}{other arguments, currently unused.}
}
\value{
a named list of objects of class "bCI" is returned, each component of which is a list of length 2. 
Within each component, the first element is a matrix which contains predictions for 
combinations specified by "terms", and the second element is a matrix which contains 
corresponding posterior standard deviations. 
}
\details{
The standard deviation returned is based on approximate Bayesian confidence 
intervals as formulated in Ke (2000). 
}
\references{
Ke, C. (2000). Semi-parametric Nonlinear Regression and Mixed Effects 
Models. PhD thesis, University of California, Santa Barbara.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snr}}, \code{\link{plot.bCI}}, \code{\link{predict.ssr}}
}
\examples{

data(CO2)
options(contrasts=rep("contr.treatment", 2))  

## get start values  
co2.fit1 <- nlme(uptake~exp(a1)*(1-exp(-exp(a2)*(conc-a3))), 
                 fixed=list(a1+a2~Type*Treatment,a3~1), 
                 random=a1~1, groups=~Plant, 
                 start=c(log(30),0,0,0,log(0.01),0,0,0,50),
                 data=CO2)

M <- model.matrix(~Type*Treatment, data=CO2)[,-1]

## fit a SNR model
co2.fit2 <- snr(uptake~exp(a1)*f(exp(a2)*(conc-a3)),
                func=f(u)~list(~I(1-exp(-u))-1,lspline(u, type="exp")),
                params=list(a1~M-1, a3~1, a2~Type*Treatment),
                start=list(params=co2.fit1$coe$fixed[c(2:4,9,5:8)]), data=CO2)

p.co2.fit2<- intervals(co2.fit2, newdata=data.frame(u=seq(0,10,len=50)))

}
\keyword{file}


\eof
\name{kron}
\alias{kron}
\title{Calculate reproducing kernels for one-dimensional space}
\description{Return a matrix evaluating reproducing kernels for the one-dimensional space usually spanned by a vector}
\usage{ kron(x,y=x)
}
\arguments{
   \item{x} {a vector or a list of numerical values which spans the one-dimensional space.}
   \item{y} {a vector/list ofnumerical values. Default is x.}
}
\value{
a matrix with the numbers of row and column equal to the length of x and y respectively. 
The [i, j] element is the reproducing kernel evaluated at the ith element of x and jth element of y.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{kronecker}},\code{\link{ssr}}
}
\examples{
x<-runif(10)
kron(x)
}
\keyword{file}

\eof
\name{lspline}
\alias{lspline}
\title{
Calculate Reproducing Kernels for Some L-splines
}
\description{
Return a matrix evaluating reproducing kernels for some L-splines at observed points.
}
\usage{
lspline(x,y=x, type="exp", \dots)
}
\arguments{
\item{x}{
a numeric vector on which reproducing kerenls are evaluated.
}
\item{y}{
an optional vector, specifying the second argument of reproducing kernels. Default is \code{x}.
}
\item{type}{
a string indicating the type of L-splines. Available options 
are "exp", "logit","sine", "sine1", and "linSinCos". Default is "exp".
}
\item{\dots}{
other arguments needed.}
}
\value{
a matrix with the numbers of row and column equal to the lengths of x and y respectively.
The [i, j] element is the reproducing kernel evaluated at (x[i], y[j]). 
}
\details{
Denote L as the differential oprator, \eqn{H_0} as the null (kernel) space. The available kernels
correspond to the following L:
\itemize{
    \item exp: \eqn{L=rD+D^2}, \eqn{H_0=span\{1,exp(-rx)\}}. \eqn{r>0}, default to be 1;\cr
    \item logit: \eqn{L=D-1/(1+e^t)}, \eqn{H_0=span\{e^t/(1+e^t)\}};\cr
    \item sine0: \eqn{L=D^2+(2\pi)^2}, \eqn{H_0=span\{sin(2\pi x),cos(2\pi x)\}};\cr
    \item sine1: \eqn{L=D(D^2+(2\pi)^2)}, \eqn{H_0=span\{1, sin(2\pi x),cos(2\pi x)\}};\cr
    \item linSinCos: \eqn{L=D^4+D^2}, \eqn{H_0=spac\{1, x, sin(x), cos(x)\}}.
}
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Heckman, N and Ramsay, J. O. (2000). Penalised regression with model-based penalties.
To appear in Canadian Journal of Statisitcs.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}
}
\examples{
x<- seq(0,1, len=20)
lspline(x, type="exp", r=1.5)
}
\keyword{file}



\eof
\name{nnr.control}
\alias{nnr.control}
\title{Set Control Parameters for nnr}
\description{
Control parameters supplied in the function call replace 
the defaults to be used in calling \code{nnr}.
}
\usage{
nnr.control(job = -1, tol = 0, max.iter = 50, init = 0, limnla = c(-10, 
    0), varht = NULL, theta = NULL, prec = 1e-06, maxit = 30, 
    method = "NR", increment = 1e-04, backfit = 5, converg = "coef", 
    toler = 0.001)   
}
\arguments{
\item{job}{
  an integer representing the optimization method used to find the smoothing parameter. 
The options are job=-1: golden-section search on (limnla(1), limnla(2)); 
job=0: golden-section search with interval specified automatically; 
job >0: regular grid search on  [limnla(1), limnla(2)] with \#(grids) = job + 1. 
Default is -1. 
  }
\item{ tol }{
  tolerance for truncation used in `dsidr'. Default is 0.0, which sets to square of machine precision.
  }
\item{max.iter}{maximum number of iterations allowed for the Gauss-Newton/Newton-Raphson iteration.}
\item{init}{
  an integer of 0 or 1 indicating if initial values are provided for theta. If init=1, initial values are provided using theta. Default is 0.
  }
\item{limnla}{
  a vector of length 2, specifying a search range for the  n times smoothing parameter on log10 scale. Default is (-10, 0).
  }
 \item{ varht}{
  needed only when vmu="u", which gives the fixed variance in calculation of the UBR function. Default is NULL.
  }
 \item{theta}{
  If `init=1', theta includes intial values for smoothing parameters. Default is NULL.
  }
 \item{ prec}{
  precision requested for the minimum score value, where precision is the weaker of the absolute and relative precisions. Default is 1e-06.
  }
  \item{ maxit}{
   maximum number of iterations allowed. Default is 30.
   }
\item{method}{a character string specifying a method for iterations, "GN" for Gauss-Newton and "NR" for Newton-Raphson. Default is "GN".}
\item{increment} {specifies a small value as increment to calcuate derivatives. Default is 1e-04.}
\item{backfit}{ an integer representing the number of backfitting iterations for multiple functions. Default is 5.}
\item{converg}{	an optional character, with possible values "coef" and "ortho", specifying the convergence 
	criterion to be used. "coef" uses the change of estimate of parameters and functions to
	assess convergence, and "ortho" uses a criterion similar to the relative offset used in nls. Default is "coef".
	}
\item{toler}{tolerance for convergence of the algorithm. Default is 0.001.}
}
\value{returned is a list includes all re-seted control parameters.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{nnr}}, \code{\link{dsidr}},\code{\link{dmudr}}
}
\examples{
## use Newton-Raphson 
nnr.control(method="NR")
}
\keyword{file}

\eof
\name{nnr}
\alias{nnr}
\title{
Nonlinear Non-parametric Regression
}
\description{
Fit a nonlinear nonparametric regression models with spline smoothing based on extended Gauss-Newton/Newton-Raphson and backfitting.
}
\usage{
nnr(formula, func, spar="v", data=sys.parent(), start=list(),verbose=FALSE,  control=list())
}
\arguments{
\item{formula}{
a model formula, with the response on the left of a \eqn{\mbox{\textasciitilde}}{~} operator and on the right an expression representing 
the mean function with a nonparametric function appearing with a symbol, e.g. f. 
}
\item{func}{
a required formula specifying the spline components necessary to estimate the non-parametric function. 
On the left of a \eqn{\mbox{\textasciitilde}}{~} operator is the unknow function symbol as well as its arguments, while the right side 
is a list of two components, an optional \code{nb} and a required \code{rk}. \code{nb} and \code{rk} are 
similar to \code{formula} and \code{rk} in \code{ssr}. A missing \code{nb} denotes an empty null space.   
}
\item{spar}{
a character string specifying a method for choosing the smoothing parameter. "v", "m" and "u" represent  GCV, GML and
UBR respectively. Default is "v" for GCV.
}
\item{data}{
an optional data frame.
}
\item{start}{
a list of vectors or expressions which input inital values for the unknown functions. If expressions,
the argument(s) inside should be the same as in \code{func}. The length of \code{start} should be the same as 
the number of unknown functions. If named, the names of the list should match those in "func". If not named, the order 
of the list is taken as that appearing in "func".
}
\item{verbose}{
an optional logical numerical value. If \code{TRUE}, information on
the evolution of the iterative algorithm is printed. Default is \code{FALSE}.
}
\item{control}{
an optional list of control values to be used.  See nnr.control for details.
}}
\value{
an object of class \code{nnr} is returned, containing fitted values, fitted function values as well as 
other information used to assess the estimate.
}
\details{
A nonlinear nonparametric model is fitted using the algorithms developed in Ke and Wang (2002).
}
\references{
Ke, C. and Wang, Y. (2002). Nonlinear Nonparametric Regression Models. Submitted.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{nnr.control}}, \code{\link{ssr}}, \code{\link{print.nnr}}, \code{\link{summary.nnr}}, \code{\link{intervals.nnr}}
}
\examples{
x<- 1:100/100
y<- exp(sin(2*pi*x))+0.3*rnorm(x)
fit<- nnr(y~exp(f(x)), func=list(f(u)~list(~u, cubic(u))), start=list(0))

## fit a generalized varying coefficient models
data(Arosa)
Arosa$csmonth <- (Arosa$month-0.5)/12
Arosa$csyear <- (Arosa$year-1)/45
ozone.vc.fit <- nnr(thick~f1(csyear)+exp(f2(csyear))*f3(csmonth),
        func=list(f1(x)~list(~I(x-.5),cubic(x)), f2(x)~list(~I(x-.5)-1,cubic(x)),
        f3(x)~list(~sin(2*pi*x)+cos(2*pi*x)-1,lspline(x,type="sine0"))),
        data=Arosa[Arosa$year\%\%2==1,], spar="m", start=list(f1=mean(thick),f2=0,f3=sin(csmonth)),
        control=list(backfit=1))
}
\keyword{file}







\eof
\name{periodic}
\alias{periodic}
\title{Calculate Reproducing Kernels for Periodic Polynomial Splines with Period 1}
\description{
Return a matrix evaluating reproducing kernels for periodic polynomial splines at observed points.
}
\usage{
periodic(s, t=s, order=2)
}
\arguments{
	\item{s}{a numeric vector.}
	\item{t}{an optional vector. Default is the same as s.}
	\item{order}{an optional integer sepcifying the order of the polynomial spline. Default is 2 for the 
periodic cubic spline.}
}
\value{
a matrix with the numbers of row and column equal to the lengths of s and t respectively.
The [i, j] element is the reproducing kernel evaluated at (s[i], t[j]). }
\details{
The general formula of the reproducing kernel is sum of an infinite series, which is approximated
by taking the first 50 terms. For the case of order=2, the close form is available and used.}
\reference{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Gu, C. (2001). Smoothing Spline ANOVA Modes. Chapman and Hall.
}
\seealso{
\code{\link{cubic}}, \code{\link{lspline}}
}
\examples{
x<- seq(0, 1, len=100)
periodic(x, order=3)
}
\keyword{file}



\eof
\name{plot.bCI}
\alias{plot.bCI}
\title{
Bayesian Confidence Interval Plot of a Smoothing Spline Fit
}
\description{
Create trellis plots of a nonparametric function fit together
with its (approximate) 95\% Bayesian confidence intervals from 
a ssr/slm/snr/snm object.
}
\usage{
plot.bCI(x, x.val=NULL, type.name=NULL, \dots)
}
\arguments{
\item{x}{
an object of class "bCI" containing point evaluation of the unknown
function and/or corresponding posterior standard devaitions.
}
\item{x.val}{
an optional vector representing values of argument based on which the 
function is to evaluate.
}
\item{type.name}{
an optional character vector specifying the names of fits.
}
\item{\dots}{
options suitable for xyplot.
}}
\details{
This function is to visualize a spline fit by use of trellis graphic facility 
with Bayesian confidence intervals superposed. Multi-panel plots, based on xyplot,
are suitable for SS ANOVA decomposition of a spline estimate. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{xyplot}}, \code{\link{predict.ssr}}, \code{\link{intervals.slm}}, 
\code{\link{intervals.snr}}, \code{\link{intervals.snm}}
}
\examples{
x<- seq(0, 1, len=100)
y<- 2*sin(2*pi*x)+rnorm(x)*0.5

fit<- ssr(y~x, cubic(x))
p.fit<- predict(fit)
\dontrun{plot(p.fit)}
\dontrun{plot(p.fit,type.name="fit")}
}
\keyword{file}

\eof
\name{plot.ssr}
\alias{plot.ssr}
\title{Generate Diagnostic Plots for a ssr Object
}
\description{
Creates a set of plots suitable  for  assessing  a  fitted smoothing spline model of class \code{ssr}.
}
\usage{
plot.ssr(x, ask=FALSE)
}
\arguments{
   \item{x}{
    a \code{ssr} object.
   }
   \item{ask}{
   if TRUE, plot.ssr operates in interactive mode.
   }
}


\details{
This function is a method for the  generic  function  plot for  class \code{ssr}.  
It can be invoked by calling plot for an object of the appropriate class, 
or  directly  by  calling plot.ssr regardless of the class of the object.

An appropriate x-y plot is produced to display  diagnostic plots.  These can be one or all of the following choices:
\itemize{
         \item Estimate of function with CIs 
         \item Residuals against Fitted values
         \item Response against Fitted values
         \item Normal QQplot of Residuals
}

The first plot of estimate of function with CIs is only useful for univariate smoothing spline fits.      

When ask=TRUE, rather than produce  each  plot  sequentially,  plot.ssr  displays a menu listing all the plots that can be produced. If the menu is not desired but a  pause  between plots  is  still  wanted  one  must  set par(ask=TRUE) before
invoking this command with argument ask=FALSE.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{plot}, \code{ssr}, \code{predict.ssr}
}
\examples{
\dontrun{library(MASS)}
\dontrun{fit1<- ssr(accel~times, data=mcycle, scale=TRUE, rk=cubic(times))}
\dontrun{plot(fit1,ask=TRUE)}
}
\keyword{file}

\eof
\name{predict.slm}
\alias{predict.slm}
\title{
Predict Method for Semiparametric Linear Mixed Effects Model Fits 
}
\description{
Predicted Values on different levels of random effects with the spline fit
as part of fixed effects
}
\usage{
predict.slm(object, newdata=NULL, ...)
}
\arguments{
\item{object}{
an object inheriting from class \code{slm}, representing a semi-parametric linear
mixed effects model fit.
}
\item{newdata }{
a data frame containing the values at which predictions are required.
Only those predictors, referred to in the right side of the formula in
the object, need to be present by name in newdata. Default is NULL, where 
predictions are made at the same values used to  compute the object. 
}
\item{\dots}{other arguments, but currently unused.}
}
\value{
returned is a data.frame with  columns given by the predictions at different levels
and the grouping factors. Note that the smooth part of the spline fit is
regarded as fixed.
}
\references{
Wang, Y. (1998) Mixed Effects Smoothing Spline ANOVA. JRSS, Series B, 
60:159--174.

Pinherio, J. C. and Bates, D. M. (2000) Mixed-effects Models in S and S-Plus. Springer.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{slm}}
}

\examples{
data(dog)

dog.fit<-slm(y~group*time, rk=list(cubic(time), shrink1(group),
    rk.prod(kron(time-0.5),shrink1(group)),rk.prod(cubic(time), 
    shrink1(group))), random=list(dog=~1), data=dog)

predict(dog.fit)
}
\keyword{file}


\eof
\name{predict.snm}
\alias{predict.snm}
\title{
Predictions from a Semiparametric Nonlinear Mixed Effects Model Fit
}
\description{
The predictions are obtained on a semiparametric nonlinear mixed effects model object 
by replacing the unknown functuons and the unknown parameters with their estimates. 
Of note, only a population level of predictions is available. 
}
\usage{
predict.snm(object, newdata, ...)
}
\arguments{
\item{object}{
a fitted \code{snm} object.
}
\item{newdata}{
a data frame containing the values at which predictions are required. 
Default are data used to fit the object.
}
\item{\dots}{other arguments, but currently unused.}
}
\value{
a vector of prediction values, obtained by evaluating the model in the frame \code{newdata}
}
\details{
This function is a method for the generic function predict for class \code{snm}. 
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Ke, C. and Wang, Y. (2001). Semi-parametric Nonlinear Mixed Effects Models and
Their Applications. JASA.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snm}}, \code{\link{predict}}
}
\keyword{file}



\eof
\name{predict.snr}
\alias{predict.snr}
\title{
Predict Method from a Semiparametric Nonlinear Regression Model Fit
}
\description{
The predictions on a semiparametric nonlinear regression model object are obtained by 
substituting the unknwon functions together with unknown parameters with their estimates 
and evaluating the regression functional based on provided or default covariate values.
}
\usage{
predict.snr(object, newdata, ...)
}
\arguments{
\item{object}{
a fitted \code{snr} object.
}
\item{newdata}{
a data frame containing the values at which predictions are required. 
Default are NULL, where data used to produce the fit are to be taken.
}
\item{\dots}{other arguments, but currently unused.}
}
\value{
a vector of prediction values, obtained by evaluating the model in the frame \code{newdata}.
}
\details{
This function is a method for the generic function predict for class \code{snr} 
}
\references{
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.


Ke, C. (2000). Semi-parametric Nonlinear Regression and Mixed Effects 
Models. PhD thesis, University of California, Santa Barbara.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snr}}
}
\keyword{file}



\eof
\name{predict.ssr}
\alias{predict.ssr}
\title{ 
Calculate Predictions and Posterior Standard Deviations for a ssr Object 
}
\description{ 
Provide a way to calculate predictions at any specified values for any combinations of elements in the fitted model. Posterior standard deviations may be used to construct Bayesian confidence intervals. 
}
\usage{ 
predict.ssr(object, newdata=NULL, terms, pstd=TRUE, ...) 
}
\arguments{ 
 \item{object}{
  a fitted \code{ssr} object. 
  }
 \item{newdata}{
  an optional data frame containing the values at which predictions are required. Default is NULL, where predictions are made at the same values used to  compute the object. Note that if scale=T, the newdata is on the original scale before transformation. 
  }
  \item{terms }{
an optional vector of 0's and 1's collecting a combination of components, or a matrix of 0's and 1's collecting several combinations of components, in a fitted ssr object. All components include bases on the right side of \eqn{\mbox{\textasciitilde}}{~} in the formula and reproducing kernels in the rk list. Note that the first component is usually a constant function if it is not specifically excluded in the formula. A value "1" at a particular position means that the component at that position is collected. Default is a vector of 1's, representing the overall fit. 
  }
 \item{pstd}{
  an optional logic value. If TRUE (the default), the posterior standard deviations are calculated. Otherwise, only the predictions are calculated. Computation required for posterior standard deviations could be intensive. 
  }
\item{\dots}{other arguments, but currently unused.}
}
\details{
This function is a method for the generic function predict for class \code{ssr}. 
It can be used to construct Bayesian confidence intervals for any combinations 
of components in the fitted model. 
}
\value{ 
an object of class \code{bCI} is returned, which is a list of length 2. Its first element is a matrix which contains predictions for combinations specified by \code{terms}, and second element is a matrix which contains corresponding posterior standard deviations. 
}
\references{ 
Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{ssr}}, \code{\link{plot.bCI}}
}
\examples{
data(acid)

# tp.pseudo calculates the pseudo kernel
acid.fit<- ssr( ph ~ t1 + x1 + x2, rk = list(tp.pseudo(t1), 
       tp.pseudo(list(x1, x2))), spar = "m", data=acid)

# extract the main effect of t1 
grid <- seq(min(acid$t1),max(acid$t1),length=100)
p <- predict(acid.fit,data.frame(t1=grid,x1=0,x2=0),
     terms=c(0,1,0,0,1,0))

# extract the main effect of (x1,x2) 
grid <- expand.grid(x1=seq(min(acid$x1),max(acid$x1),length=20),
     x2=seq(min(acid$x2),max(acid$x2),length=20))
p <- predict(acid.fit,data.frame(t1=0,x1=grid$x1,x2=grid$x2),
     terms=c(0,0,1,1,0,1),pstd=FALSE)

}
\keyword{file}

\eof
\name{ print.anova.ssr}
\alias{ print.anova.ssr}
\title{
Print an anova.ssr Object
}
\description{
Calculate and output p-values for tests available.
}
\usage{
print.anova.ssr(x, ...)
}
\arguments{
 \item{x}{
an object inheriting from class anova.ssr, generally obtained by 
applying the anova.ssr method to an ssr object.
}
\item{\dots}{other available arguments, currently unused.}
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{anova.ssr}}, \code{\link{ssr}}
}
\keyword{file}

\eof
\name{print.nnr}
\alias{print.nnr}
\title{
Print Values
}
\description{
Print the arguments of a 'nnr' object.
}
\usage{
print.nnr(x, ...)
}
\arguments{
\item{x}{a \code{nnr} object}
\item{\dots}{unused argument}
}
\details{
This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{nnr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{nnr}}
}
\keyword{file}


\eof
\name{print.slm}
\alias{print.slm}
\title{
Print Values
}
\description{
Print the arguments of a \code{slm} object.
}

\usage{
print.slm(x, ...)
}
\arguments{
\item{x}{a \code{slm} object}
\item{\dots}{unused argument}
}
\details{
This is a method for  the  function  \code{print}  for  objects
       inheriting from class \code{slm}.  
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{slm}}
}
\keyword{file}


\eof
\name{print.snm}
\alias{print.snm}
\title{
Print Values
}
\description{
Print the arguments of a 'snm' object.
}
\usage{
print.snm(x, ...)
}
\arguments{
\item{x}{ a \code{snm} object}
\item{\dots}{unused argument}
}

\details{This is a method for  the  function \code{print}  for  objects
       inheriting from class `snm'. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{slm}}, \code{\link{print}}
}
\keyword{file}




\eof
\name{print.snr}
\alias{print.snr}
\title{
Print Values
}
\description{
Print the arguments of a \code{snr} object.
}
\usage{
print.snr(x, ...)
}
\arguments{
\item{x}{ a \code{snr} object}
\item{\dots}{unused argument}
}
\details{
This is a method for  the  function  \code{print}  for  objects
       inheriting from class \code{snr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{snr}}
}
\keyword{file}


\eof
\name{
print.ssr
}
\alias{print.ssr}
\title{
Print Values
}
\description{
Print the arguments of a \code{ssr} object.
}
\usage{
print.ssr(x, ...)
}
\arguments{
  \item{x}{a \code{ssr} object}
  \item{\dots}{unused argument}
}
\details{
This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{ssr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{ssr}}
}
\keyword{file}

\eof
\name{print.summary.nnr}
\alias{print.summary.nnr}
\title{Print Vales}
\description{
Print the arguments of a \code{summary.nnr} object
}
\usage{
print.summary.nnr(x, ...)
}
\arguments{
  \item{x}{ an object of class \code{summary.nnr}}
  \item{\dots}{unused argument}
}
\details{
 This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{summary.nnr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{nnr}}, \code{\link{summary.nnr}}
}
\keyword{file}




\eof
\name{print.summary.slm}
\alias{print.summary.slm}
\title{Print Values }
\description{
Print the arguments of a \code{summary.slm} object
}
\usage{
print.summary.slm(x, ...)
}
\arguments{
  \item{x}{ an object of class \code{summary.slm}}
  \item{\dots}{unused argument}
}
\details{
 This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{summary.slm}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{slm}}, \code{\link{summary.slm}}
}
\keyword{file}




\eof
\name{print.summary.snm}
\alias{print.summary.snm}
\title{Print Values }
\description{
Print the arguments of a \code{summary.snm} object
}
\usage{
print.summary.snm(x, ...)
}
\arguments{
  \item{x}{ an object of class \code{summary.snm}}
  \item{\dots}{unused argument}
}
\details{
 This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{summary.snm}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{snm}}, \code{\link{summary.snm}}
}
\keyword{file}




\eof
\name{print.summary.snr}
\alias{print.summary.snr}
\title{Print Values }
\description{
Print the arguments of a \code{summary.snr} object
}
\usage{
print.summary.snr(x, ...)
}
\arguments{
  \item{x}{ an object of class \code{summary.snr}}
  \item{\dots}{unused argument}
}
\details{
 This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{summary.snr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{snr}}, \code{\link{summary.snr}}
}
\keyword{file}


\eof
\name{print.summary.ssr}
\alias{print.summary.ssr}
\title{Print Values }
\description{
Print the arguments of a \code{summary.ssr} object
}
\usage{
print.summary.ssr(x, ...)
}
\arguments{
  \item{x}{ an object of class \code{summary.ssr}}
  \item{\dots}{unused argument.}
}
\details{
 This is a method for  the  function \code{print}  for  objects
       inheriting from class \code{summary.ssr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
   \code{\link{ssr}}, \code{\link{summary.ssr}}
}
\keyword{file}



\eof
\name{rk.prod}
\alias{rk.prod}
\title{
Calculate product of reproducing kernels
}
\description{
Return a matix as product of reproducing kernels
}
\usage{
rk.prod(x, \dots)
}
\arguments{
	\item{x}{
	a matrix evaluating a reproducing kernel, or a vector.
	}
	\item{\dots}{
	optional lists of matrices evaluating reproducing kernels or vectors. All matrics
	must have the same dimensions. All vectors must have the same length. The length of
	each vector must equal to the column  and row numbers of each matrix.
	}
}
\value{
a matrix as the product of reproducing kernels. If one argument is a vector, a \code{kron}
kernel is constructed first.
}
\details{
The product of reproducing kernels is agian a reproducing kernel. In SS ANOVA, product
of reproduing kernels is often used to model interaction spline terms.
}
\references{
Gu, C. and Wahba, G. (1993a). Smoothing Spline ANOVA with component-wise Bayesian confidence intervals.
Journal of Computational and Graphical Statistics 55, 353--368.

Gu, C. and Wahba, G. (1993b). Semiparametric analysis of variance with tensor product thin plate
splines. JRSS B 55, 353--368. 
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{\code{\link{kron}}, \code{\link{ssr}}}
\examples{
x1<- 1:10/10
x2<- runif(10)
rk.prod(cubic(x1), periodic(x2))
}
\keyword{file}



\eof
\name{slm}
\alias{slm}
\title{
Fit a Semi-parametric Linear Mixed Effects Model
}
\description{
Returns an object of class \code{slm} that represents a
semi-parametric linear mixed effects model fit. 
}
\usage{
slm(formula, rk, data=sys.parent(), random, weights=NULL, 
correlation=NULL, control=<see below>)
}
\arguments{
\item{formula}{
a formula object, with the response on the left of a \eqn{\sim}{~} operator, and the bases 
of the null space \eqn{H_0} of the non-parametric function and other terms, separated by + operators, on the right.
}
\item{rk}{
a list of expressions that specify the reproducing kernels of the spline function(s), \eqn{R^1,\dots,R^p} for spaces \eqn{H_1,\dots,H_p}. See the help file of ssr for more details.
}
\item{data}{
An optional data frame containing the variables appearing in \code{formula}, \code{random}, \code{rk}, \code{correlation}, \code{weights}. 
By default, the variables are taken from the environment from which \code{slm} is called.
}
\item{random}{
A named list of formulae, lists of formulae, or pdMat objects, which defines
nested random effects structures. See help file of lme for more details.
}
\item{weights}{
An optional \code{varFun} object or one-sided formula describing the within-group heteroscedasticity stucture. 
See the help file of \code{lme} for more details.
}
\item{correlation}{
An optional \code{corStruct} object specifying the within-group correlation structure. See \code{lme} for more details.
}
\item{control}{
an optional list of any applicable control parameters from \code{lme}.
}}
\value{
An object of class \code{slm} is returned. Generic functions such as print, summary, predict and intervals have
methods to show the results of the fit.
}
\details{
This generic function fits a semi-parametric linear mixed effects model (or non-parametric mixed effects models) 
as described in Wang (1998), but allowing for general random and correlation structures. Because the connection
to a linear mixed effects model is adopted, only GML is available to choose smoothing parameters.
}
\references{
Wang, Y. (1998) Mixed Effects Smoothing Spline ANOVA. JRSS, Series B, 60:159--174.

Pinherio, J. C. and Bates, D. M. (2000) Mixed-effects Models in S and S-Plus. Springer.       
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{ssr}}, \code{\link{lme}}, \code{\link{varFunc}}, 
\code{\link{corClasses}}, \code{\link{predict.slm}}, \code{\link{intervals.slm}},
\code{\link{print.slm}},\code{\link{summary.slm}}
}
\examples{
## SS ANOVA is used to model "time" and "group" 
## with random intercept for "dog".
data(dog)

dog.fit<- slm(y~group*time, rk=list(cubic(time), shrink1(group),
    	rk.prod(kron(time-0.5),shrink1(group)),rk.prod(cubic(time), 
    	shrink1(group))), random=list(dog=~1), data=dog)
}
\keyword{file}



\eof
\name{snm.control}
\alias{snm.control}
\title{
Set Control Parameters for snm
}
\description{
Control parameters supplied in the function call replace 
the defaults to be used in calling \code{snm}.
}
\usage{
snm.control(rkpk.control, nlme.control, prec.out=0.0005, 
  maxit.out=30, converg="COEF", incDelta)
}
\arguments{
\item{rkpk.control}{
a optional list of control parameters for dsidr or dmudr to estimate the unknown
functions.
}
\item{nlme.control}{
a list of control parameters for the nonlinear regression step, 
the same as nlmeControl. Default is \code{list(returnObject = T, maxIter = 5)}.
}
\item{prec.out}{
tolerance for convergence criterion. Default is 0.0005.
}
\item{maxit.out}{
maximum number of iterations for the algorithm. Default is 30.
}
\item{converg}{
an optional character, with possible values "COEF" and "PRSS", specifying the convergence 
criterion to be used. "COEF" uses the change of estimate of parameters and functions to
assess convergence, and "PRSS" uses penalized residual sums of squares. Default is "COEF".
}
\item{incDelta}{specifies a small value as increment to calcuate derivatives. Default is 0.001.
}
}
\value{
Returned is a list includes all re-seted control parameters.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snm}},\code{\link{nlme}}, \code{\link{dsidr}}, \code{\link{dmudr}}, \code{\link{nlmeControl}}
}
\examples{
## set maximum iteration to be 50
snm.control(maxit.out=50)
}
\keyword{file}


\eof
\name{snm}
\alias{snm}
\title{
Fit a Semi-parametric Nonlinear Mixed-effects Model
}
\description{
This generic function fits a semi-paramteric nonlinear mixed-effects model 
in the formulation described in Ke and Wang (2001). Current version only allows linear dependence on non-parametric 
functions.
}
\usage{
snm(formula, func, data=sys.parent(), fixed, random=fixed, 
groups, start, spar="v", verbose=FALSE, method="REML", control=NULL, 
correlation=NULL, weights=NULL)
}
\arguments{
\item{formula}{
a formula object, with the response on the left of a ~ operator, and an expression 
of variables, parameters and non-parametric functions on the right.
}
\item{func}{
a list of spline formulae each specifying the spline components necessary to 
estimate each non-parametric function. On the left of a \eqn{\mbox{\textasciitilde}}{~} operator of each component 
is the unknow function symbol(s) as well as its arguments, while the right side is a 
list of two components \code{nb}, an optional one-side formula for representing the null 
space's bases, and a required \code{rk} structure. \code{nb} and \code{rk} are similar to \code{formula} 
and \code{rk} in ssr. A missing \code{nb} denotes an empty null space. 
}
\item{fixed}{
a two-sided formula specifying models for the fixed effects.
The syntax of \code{fixed} in \code{nlme} is adopted.
}
\item{start}{
a numeric vector, the same length as the number of fixed effects, supplying starting
values for the fixed effects.
}
\item{spar}{
a character string specifying a method for choosing the smoothing parameter. "v", "m" and "u" represent  GCV, GML and
UBR respectively. Default is "v" for GCV.
}
\item{data}{
An optional data frame containing the variables appearing in \code{formula}
, \code{random}, \code{rk}, \code{correlation}, \code{weights}. By default, the variables 
are taken from the environment from which \code{snm} is called.
}
\item{random}{
an optional random effects structure specifying models for the random effects.
The same syntax of \code{random} in \code{nlme} is assumed.
}
\item{groups}{
an optional one-sided formula of the form ~g1 (single level) or ~g1/\dots/gQ 
(multiple levels of nesting), specifying the partitions of the data over 
which the random effects vary. g1,\dots,gQ must evaluate to factors in data. 
See nlme for details.	 
}
\item{verbose}{
an optional logical numerical value. If \code{TRUE}, information on
the evolution of the iterative algorithm is printed. Default is
\code{FALSE}.
}
\item{method}{
 a character string. If 'REML' the model is fit by maximizing the restricted 
log-likelihood. If 'ML' the log-likelihood is maximized. Default is 'ML. 
}
\item{control}{
a list of parameters to control the performance of the algorithm.
}
\item{correlation}{
an optional \code{corStruct} object describing the within-group correlation 
structure. See the documentation of corClasses for a description of the available corStruct classes. 
Default is NULL, corresponding to no within-in group correlations.
}
\item{weights}{
an optional \code{varFunc} object or one-sided formula describing the 
within-group heteroscedasticity structure. If given as a formula, 
it is used as the argument to \code{varFixed}, corresponding to fixed variance weights. 
See the documentation on varClasses for a description of the available varFunc 
classes. Defaults to NULL, corresponding to homoscesdatic within-group errors.
}}
\value{
an object of class \code{snm} is returned, representing a semi-parametric nonlinear
mixed effects model fit. Generic functions such as print, summary, predict and
intervals have methods to show the results of the fit.
}
\references{
Ke, C. and Wang, Y. (2001). Semi-parametric Nonlinear Mixed Effects Models and
Their Applications. JASA 96:1272-1298.

Pinheiro, J.C. and Bates, D. M. (2000). Mixed-Effects Models in S
and S-PLUS. Springer.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{nlme}}, \code{\link{predict.snm}}, \code{\link{intervals.snm}}, \code{\link{snm.control}},
\code{\link{print.snm}},\code{\link{summary.snm}}
}
\examples{
data(CO2)

options(contrasts=rep("contr.treatment", 2))	
co2.fit1 <- nlme(uptake~exp(a1)*(1-exp(-exp(a2)*(conc-a3))), 
                 fixed=list(a1+a2~Type*Treatment,a3~1), 
                 random=a1~1, groups=~Plant, 
                 start=c(log(30),0,0,0,log(0.01),0,0,0,50),
                 data=CO2)

M <- model.matrix(~Type*Treatment, data=CO2)[,-1]
co2.fit2 <- snm(uptake~exp(a1)*f(exp(a2)*(conc-a3)),
                func=f(u)~list(~I(1-exp(-u))-1,lspline(u, type="exp")),
                fixed=list(a1~M-1,a3~1,a2~Type*Treatment),
                random=list(a1~1), group=~Plant, verbose=TRUE,
                start=co2.fit1$coe$fixed[c(2:4,9,5:8)], data=CO2)
}
\keyword{file}

\eof
\name{snr.control}
\alias{snr.control}
\title{
Set Control Parameters for snr
}
\description{
Control parameters supplied in the function call replace 
the defaults to be used in calling \code{snr}.
}
\usage{
snr.control(rkpk.control = list(job = -1, tol = 0, init = 0, limnla = c(-10, 
    0), varht = NULL, theta = NULL, prec = 1e-06, maxit = 30), 
    nls.control = list(returnObject = TRUE, maxIter = 5), incDelta = 0.001, 
    prec.out = 0.001, maxit.out = 30, converg = "COEF", method = "GN", 
    backfit = 5) 
}
\arguments{
	\item{rkpk.control}{
	a optional list of control parameters for dsidr or dmudr to estimate the unknown
	functions. Default is "list(job = -1, tol = 0, init = 0, limnla = c(-10, 
    	0), varht = NULL, theta = NULL, prec = 1e-06, maxit = 30)".
	}
	\item{nls.control}{
	a list of control parameters for the nonlinear regression step, 
	the same as gnlsControl. Default is "list(returnObject = TRUE, maxIter = 5).
	}
        \item{incDelta}{the incremental value to be used to calculate derivatives for the unknown functions. Default is 0.001} 
	\item{prec.out}{
	tolerance for convergence criterion. Default is 0.0001.
	}
	\item{maxit.out}{
	maximum number of iterations for the algorithm. Default is 30.
	}
	\item{converg}{
	an optional character, with possible values \code{COEF} and \code{PRSS}, specifying the convergence 
	criterion to be used. \code{COEF} uses the change of estimate of parameters and functions to
	assess convergence, and \code{PRSS} uses penalized residual sums of squares. Default is \code{COEF}.
	}
	\item{method}{ an optional string of value either \code{GN} for Gauss-Newton or \code{NR} for Newton-Raphson 
           iteration methods to estimate the unknown functions. Default is \code{GN}.}
	\item{backfit}{ an integer to set the number of backfitting iterations inside the loop. Default is 5}.
}
\value{
returned is a list includes all re-seted control parameters.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{snr}}, \code{\link{dsidr}}, \code{\link{dmudr}}, \code{\link{gnls}}, \code{\link{gnlsControl}}
}
\examples{
## use Newton-Raphson iteration and only a single backfitting
snr.control(method="NR", backfit=1)
}
\keyword{file}

\eof
\name{snr}
\alias{snr}
\title{
Fit A Semi-parametric Nonlinear Regression Model
}
\description{
This generic function fits a Semi-parametric Nonlinear Regression Model as formulated in Ke (2000).
}
\usage{
snr(formula, func, params, data = sys.parent(), start, 
    spar = "v", verbose = FALSE, control = list(), correlation = NULL, 
    weights = NULL) 
}
\arguments{
\item{formula}{
a model formula, with the response on the left of a \eqn{\mbox{\textasciitilde}}{~} operator 
and on the right an expression representing the mean function 
with at least one unknown function appearing with a symbol, 
e.g. f. If "data" is present, all names except the nonparametric 
function(s) used in the formula should be defined as parameters 
or variables in the data frame.
}
\item{func}{
a list of spline formulae each specifying the spline components 
necessary to estimate each non-parametric function. On the left 
of a  \eqn{\mbox{\textasciitilde}}{~} operator of each component is the unknow function symbol(s) 
as well as its arguments, while the right side is a list of two 
components \code{nb}, an optional one-side formula for representing 
the null space's bases, and a required \code{rk} structure. \code{nb} and 
\code{rk} are similar to \code{formula} and \code{rk} in ssr. A missing \code{nb} 
denotes an empty null space.   
}
\item{params}{
a two-sided formula specifying models for the parameters. 
The syntax of \code{params} in \code{gnls} is adopted. See \code{gnls} for details.
}
\item{data}{
an optional data frame containing the variables named in model, 
params, correlation and weights. By default the variables are taken 
from the environment from which snr is called.	
}
\item{start}{
a numeric list with two components: "params=", a vector of the size of the length of the unknown parameters, 
providing inital values for the paramters, and "f=" a list of vectors or expressions which input inital values for the unknown functions. 
If the unknown functions appear linear in the model, the intial values then are not necessary. 
}
\item{spar}{
a character string specifying a method for choosing the smoothing parameter. "v", "m" and "u" represent  GCV, GML and
UBR respectively. Default is "v" for GCV.
}
\item{verbose}{
an optional logical numerical value. If \code{TRUE}, information on
the evolution of the iterative algorithm is printed. Default is
\code{TRUE}.
}
\item{control}{
an optional list of control parameters. See \code{snr.control} for details.
}
\item{correlation}{
an optional \code{corStruct} as in gnls. Default is NULL, corresponding to uncorrelation.
}
\item{weights }{
an optional \code{varFunc} structure as in \code{gnls}. Default is NULL, representing equal variances.
}}
\value{
An object of class \code{snr} is returned, representing a semi-parametric 
nonlinear regression fit. Generic functions such as print, summary, 
intervals and predict have methods to show the results of  the  fit.
}
\details{
A semi-parametric regression model is generalization of self-modeling 
regression, nonlinear regression and smoothing spline models, including 
as special cases (nonlinear) partial spline models, varying coefficients 
models, PP regression and some other popular models. 'snr' is 
implemented with an alternate iterative procedures with smoothing splines 
to estimate the unknown functions and general nonlinear regression to
estimate parameters.
}
\references{
Ke, C. (2000). Semi-parametric Nonlinear Regression and Mixed Effects 
Models. PhD thesis, University of California, Santa Barbara.

Pinheiro, J.C. and Bates, D. M. (2000). Mixed-Effects Models in S
and S-PLUS. Springer.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}.}
\seealso{
\code{\link{intervals.snr}},  \code{\link{predict.snr}}, \code{\link{snr.control}}, 
\code{\link{gnls}}
}
\examples{
data(CO2)
options(contrasts=rep("contr.treatment", 2))    
co2.fit1 <- nlme(uptake~exp(a1)*(1-exp(-exp(a2)*(conc-a3))), 
                 fixed=list(a1+a2~Type*Treatment,a3~1), 
                 random=a1~1, groups=~Plant, 
                 start=c(log(30),0,0,0,log(0.01),0,0,0,50),
                 data=CO2)

M <- model.matrix(~Type*Treatment, data=CO2)[,-1]

## fit a SNR model
co2.fit2 <- snr(uptake~exp(a1)*f(exp(a2)*(conc-a3)),
                func=f(u)~list(~I(1-exp(-u))-1,lspline(u, type="exp")),
                params=list(a1~M-1, a3~1, a2~Type*Treatment),
                start=list(params=co2.fit1$coe$fixed[c(2:4,9,5:8)]), data=CO2)
}
\keyword{file}

\eof
\name{sphere}
\alias{sphere}
\title{
Calculate Pseudo Reproducing Kernels for Spherical Splines
}
\description{
Return a matrix evaluating reproducing kernels for splines on a sphere.
}
\usage{
sphere(x, y=x, order=2)
}
\arguments{
\item{x}{
a matrix of two columns or a list of two components, representing observed 
latitude and longitude respectively.
}
\item{y}{
a matrix of two columns or a list of two components, representing 
latitude and longitude respectively. Default is the same as x.
}
\item{order}{
an optional integer sepcifying the order of the spherical spline. Available are
2, 3, 4, 5 and 6, with a default 2.
}}
\value{
a matrix with the numbers of row and column equal to the lengths of x and y respectively.
The [i, j] element is the reproducing kernel evaluated at \eqn{(x[i,], y[j,])} 
(or \eqn{((x[[1]][i], x[[2]][i]), (y[[1]][j], y[[2]][j]))} for lists). 
}
\details{
The kernel for sperical splines is a series inconvenient to compute. This pseudo kernel
is based on a topological equivalence as described in Wahba (1981), for which cases the
closed form can be derived.
}
\references{
Wahba, G. (1981). Spline Interprolation and Smoothing on the Sphere. SIAM J. Sci. Stat.Comput.,
Vol. 2, No. 1, March 1981.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.
}
\author{Chunlei Ke \email{chunlei\_ke@pstat.ucsb.edu} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{periodic}}
}
\examples{
x<- seq(0, 2*pi, len=10)
y<- seq(-pi/2, pi/2, len=10)
s.ker<- sphere(cbind(x, y), order=3)
}
\keyword{file}

\eof
\name{ssr.object}
\alias{ssr.object}
\title{ A fitted ssr Object}
\description{
An object returned by the \code{ssr} function, inheriting from class \code{ssr},
and representing a fitted smoothing spline model. Objects of this
class have methods for the generic functions \code{predict}, \code{print} and
\code{summary}. }
\value{
The following components must be included in a legitimate \code{ssr} object: 
\item{call}{a list containing an image of the \code{ssr} call that produced the object}
\item{coef}{estimated coefficients for the spline estimate}
\item{lambda}{a vector representing the estimate smoothing parameters}
\item{fitted}{fitted values of the unknown mean function}
\item{family}{the distribution family used}
\item{cor.est}{estiamted parameters, if any, in corMatrix}
\item{var.est}{estiamted parameters, if any, in varFunc}
\item{s}{design matrix extracted from \code{formula}}
\item{q}{a list of matrices representing reproducing kernels evaluated at design points.}
\item{residuals}{working residuals from the fit. }
\item{df}{equivalent degrees of freedom. It is calculated as the trace of the hat matrix.}
\item{weight}{a matrix representing the covariance matrix. It is NULL for iid data.}
\item{rkpk.obj}{an object representing fits from dsidr/dmudr/gdsidr/gdmudr. See help files 
        for dsidr/dmudr/gdsidr/gdmudr for more details.}
\item{scale}{a logical value, specifying if scaling is used.}
}

\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}

\seealso{
\code{\link{ssr}}, \code{\link{predict.ssr}}, \code{\link{summary.ssr}}, 
\code{\link{plot.ssr}}, \code{\link{dsidr}}, \code{\link{dmudr}}, \code{\link{gdsidr}},
\code{\link{gdmudr}}
}
\keyword{file}

\eof
\name{ssr}
\alias{ssr}
\title{Fit a General Smoothing Spline Regression Model}
\description{
Returns an object of class ssr which is a general/generalized/correlated smoothing spline fit. 
}
\usage{
ssr(formula, rk, data = sys.parent(), subset, weights = NULL, 
	correlation = NULL, family = "gaussian", scale = FALSE, 
	spar = "v", varht = NULL, limnla = c(-10, 3), control = list())
}
\arguments{
  \item{formula}{a \code{formula} object, with the response on the left of a \eqn{\mbox{\textasciitilde}}{~} operator, and 
the bases of the null space \eqn{H_0}, separated by + operators, on the right. 
Thus it specifies the parametric part of the model that contains functions 
which are not penalized. }
  \item{rk}{
a list of expressions specifying reproducing kernels \eqn{R^1},\dots,\eqn{R^p} for \eqn{H_1},\dots,\eqn{H_p}. 
For \eqn{p=1}, rk may be specified with given functions. Supported functions are: "linear", 
"cubic", "quintic", and "septic" for linear, cubic, quintic and septic polynomial 
splines with "linear2", "cubic2", "quintic2", and "septic2" for another construction;
"periodic" for periodic splines; "shrink0" and "shrink1" for Stein's shrink-toward-zero and 
shrink-toward-mean estimates; "tps" for thin-plate-splines; "lspline" for L-splines. 
For details on these kernels, see their help files. Users may also write their own functions.}
  \item{data}{a data frame containing the variables occurring in the formula and the \code{rk}. If this option is not specified, 
the variables should be on the search list. Missing values are not allowed. }
  \item{subset}{ an optional expression indicating which subset of the rows of the  data should be used in the fit.  
This can be a logical vector (which is replicated to have length equal to the number of observations), 
a numeric vector indicating which observation numbers are to be  included, or a character vector  
of the row names to be included.  All observations are included by default.}
  \item{weights}{ a vector or a matrix specifying known weights for weighted smoothing, or a varFunc structure 
specifying a variance function structure. Its length, if a vector, or its number of columns and rows, 
if a matrix, must be equal to the length of responses. See documentations of nlme for availabe 
varFunc structures. The default is that all weights are equal. }
  \item{correlation}{  a corStruct object describing the correlation structure for random errors. See documentations 
of corClasses for availabe correlation structures. Default is NULL for no correlation.}
  \item{family}{an optional string specifying the distribution family. Families supported are "binary", "binomial", 
"poisson", "gamma" and "gaussian" for Bernoulli, binomial, poisson, gamma and Gaussian distributions 
respectively. Default is "gaussian". }
  \item{scale}{an optional logical value. If `TRUE', all covariates appearing in "rk" will be scaled into 
interval [0, 1]. This transformation will affect predict.ssr. Default is FALSE. }
  \item{spar}{ a character string specifying a method for choosing the smoothing parameter. "v", "m" and "u" represent 
GCV, GML and UBR respectively. "u\eqn{\sim}{~}", only used for non-Gaussian families, specifies UBR with an estimated variance. 
Default is "v". }
  \item{varht}{ needed only when 'u' is chosen for 'method', which gives the fixed variance in calculation of the UBR function. 
Default is NULL for `family="gaussian"' and 1 for all other families. }
  \item{limnla}{a vector of length one or two, specifying a search range for log10(n*lambda), where lambda is the smoothing 
parameter and n is the sample size. If it is a single value, the smoothing parameter will be fixed at this value. 
This option is only applicable to spline smoothing with a single smoothing parameter. }
  \item{control}{a list of iteration and algorithmic constants. See ssr.control for details and default values. }
}
\details{
We adopt notations in Wahba (1990) for the general spline and smoothing spline ANOVA models. 
Specifically, the functional relationship between the predictor and independent variable is unknown 
and is assumed to be in a reproducing kernel Hilbert space H. H is decomposed into \eqn{H_0} and 
\eqn{H_1+...+H_p}, where the null space \eqn{H_0} is a finite dimensional space spanned by 
bases specified at the right side of \eqn{\mbox{\textasciitilde}}{~} in formula, and 
\eqn{H_1},\dots ,\eqn{H_p} are reproducing kernel Hilbert spaces with reproducing kernel specified in the list rk. 

The function is estimated from weighted penalized least square. ssr can be used to fit the general spline and smoothing spline ANOVA models (Wahba, 1990), generalized spline models (Wang, 1997) and correlated spline models (Wang, 1998). ssr can also fit partial spline model with additional parametric terms specified in the formula (Wahba, 1990).

ssr could be slow and memory intensive, especially for large sample size and/or when p is large. 
For fitting a cubic spline with CV or GCV estimate of the smoothing parameter, 
the S-Plus function \code{smooth.spline} is more efficient.

Components can be extracted using extractor functions predict, deviance, residuals, and summary. The output can be modified using update.  
}
\value{
an object of class \code{ssr} is  returned. See ssr.object for details. 
}
\references{ 
Gu, C. (1989). RKPACK and its applications: Fitting smoothing spline models. Proceedings of the Statistical Computing Section, ASA, 42-51.

Gu, C. (2002). Smoothing Spline ANOVA. Spinger, New York.

Wahba, G. (1990). Spline Models for Observational Data. SIAM, Vol. 59.

Wang, Y. (1995). GRKPACK: Fitting Smoothing Spline ANOVA Models for Exponential Families. Communications in Statistics: Simulation and Computation, 24: 1037-1059.

Wang, Y. (1998) Smoothing Spline Models with Correlated Random Errors. JASA, 93:341-348.

Ke, C. and Wang, Y. (2002) ASSIST: A Suite of S-plus functions Implementing Spline smoothing Techniques. 
Available at: \url{http://www.pstat.ucsb.edu/faculty/yuedong }}
\author{Yuedong Wang \email{yuedong@pstat.ucsb.edu} and Chunlei Ke \email{chunlei\_ke@yahoo.com} }

\seealso{ \code{\link{deviance.ssr}}, \code{\link{hat.ssr}},  \code{\link{plot.ssr}}, 
	\code{\link{predict.ssr}}, \code{\link{print.ssr}}, 
	\code{\link{ssr.object}}, \code{\link{summary.ssr}}, \code{\link{smooth.spline}}.}

\examples{
\dontrun{library(MASS)}
# fitting a cubic spline
\dontrun{fit1<- ssr(accel~times, data=mcycle, scale=T, rk=cubic(times))}
\dontrun{summary(fit1)}

# using GML to choose the smoothing parameter
\dontrun{fit2<- update(fit1, spar="m")}

data(acid)
## fit an additive thin plate spline
acid.fit<- ssr( ph ~ t1 + x1 + x2, rk = list(tp(t1), tp(list(x1, x2))), 
        data = acid, spar = "m", scale = FALSE)
acid.fit
}
\keyword{file }




\eof
\name{summary.nnr}
\alias{summary.nnr}
\title{
Object Summaries
}
\description{
Summarize a \code{nnr} object
}
\usage{
summary.nnr(object, ...)
}
\arguments{
\item{object}{a fitted \code{nnr} object.}
\item{\dots}{unused argument}
}
\details{
This is a method for the function  \code{summary}  for  objects inheriting from class
 \code{nnr}.  See summary for the general behavior of this function.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{nnr}}, \code{\link{print.nnr}}
}
\keyword{file}


\eof
\name{summary.slm}
\alias{summary.slm}
\title{
Object Summaries
}
\description{
Summarize a \code{slm} object
}
\usage{
summary.slm(object, ...)
}
\arguments{
\item{object}{a fitted \code{slm} object.}
\item{\dots}{unused argument}
}
\details{
This is a method for the function  \code{summary}  for  objects inheriting 
from class \code{slm}.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{slm}}, \code{\link{print.slm}}
}
\keyword{file}


\eof
\name{summary.snm}
\alias{summary.snm}
\title{
Object Summaries
}
\description{
Summarize a \code{snm} object
}
\usage{
summary.snm(object, ...)
}
\arguments{
\item{object}{a fitted 'snm' object.}
\item{\dots}{unused argument}
}
\details{
This is a method for the function  \code{summary}  for  objects inheriting from class
 \code{snm}. 
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snm}}, \code{\link{print.snm}}
}
\keyword{file}

\eof
\name{summary.snr}
\alias{summary.snr}
\title{
Object Summaries
}
\description{
Summarize a 'snr' object
}
\usage{
summary.snr(object, ...)
}
\arguments{
\item{object}{a fitted \code{snr} object.}
\item{\dots}{unused argument}
}
\details{
This is a method for the function  \code{summary}  for  objects inheriting from class
 \code{snr}.  See summary for the general behavior of this function.
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{snr}}, \code{\link{print.snr}}
}
\keyword{file}



\eof
\name{summary.ssr}
\alias{summary.ssr}
\title{
Summarize a ssr object
}
\description{
Provides a synopsis of a \code{ssr} object and perform tests.
}
\usage{
summary.ssr(object, ...)
}
\arguments{
  \item{object}{ a fitted \code{ssr} object. }
  \item{\dots}{unused option.}
}
\details{
This is a method for the function  \code{summary}  for  objects inheriting 
from class \code{ssr}. 
}
\author{Chunlei Ke \email{chunlei\_ke@yahoo.com} and Yuedong Wang \email{yuedong@pstat.ucsb.edu}}
\seealso{
\code{\link{ssr}}, \code{\link{print.ssr}}
}
\keyword{file}


\eof
\name{wesdr}
\docType{data}
\alias{wesdr}
\title{Wisconsin Epidemiological Study of Diabetic Retinopathy}
\description{The \code{wesdr} data frame has 669 rows and 5 columns of data
from an ongoing epidemiological study of a cohort of patients receiving their medical care in an 11-country area in southern Wisconsin.}

\usage{
data(wesdr)
}
\section{Format}{
This data frame contains the following columns:

num a numeric vector giving IDs for individuals.

dur a numeric vector of duration of at baseline in year.

gly a numeric vector of glycosylated hemoglobin, a measuer of hyperglycemia.

bmi a numeric vecttor of body mass index, weight in \eqn{kg/(height in meter)^2}.

prg a vector of 0 or 1's representing disease progression for each individual.
}

\details{ The progression of diabetic retinopathy was assessed together with a number of medical, demographic, ocular and other covariates and the retinopathy scores.}

\section{Source}{
Klein, R., Klein, B. E. K., Moss, S. E., Davis, M. D. and Demets, D. L. (1989a). The Wisconsin epidemiologic study of diabetic retinopathy. IX. Four year incidence and progression of diabetic retinopathy when age at diagnosis is less than 30 years. Arch. Ophthalmal. 107, 237-243.

Klein, R., Klein, B. E. K., Moss, S. E., Davis, M. D. and Demets, D. L. (1989b). The Wisconsin epidemiologic study of diabetic retinopathy. X. Four year incidence and progression of diabetic retinopathy when age at diagnosis is less than 30 years. Arch. Ophthalmal. 107, 244-249.
}
\keyword{datasets}


\eof
\name{xyplot2}
\alias{xyplot2}
\title{Extension of XYPLOT}
\description{
Extend \code{xyplot} to superpose one or more symbols to each panel.
}
\usage{
xyplot2(formula, data, type = "l", ...)
}
\arguments{
  \item{formula}{a two-sided formula as accepted in \code{xyplot}}
  \item{data}{a list of data frames. Each component shall be able to evaluate the vatiables appearing in \code{formula}}
  \item{type}{a vector of characters to indicate what type of plots are to draw. Default is line.}
  \item{\dots}{any options as accepted in \code{xyplot}}
}
\value{
On each panel, several plot types, the length of \code{data}, are superposed.
}
\keyword{file}



\eof
