asypow.n               package:asypow               R Documentation

_A_s_y_m_p_t_o_t_i_c _S_a_m_p_l_e _S_i_z_e

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates the sample size required to obtain the desired power
     for a test via likelihood ratio methods.

_U_s_a_g_e:

            asypow.n(asypow.obj, power, significance)

_A_r_g_u_m_e_n_t_s:

asypow.obj: The object returned from asypow.noncent. 

   power: The desired power of the test. 

significance: The desired significance level of the test. 

_V_a_l_u_e:

     Returns the  sample size needed to achieve specified power at the
     specified significance level.

_R_e_f_e_r_e_n_c_e_s:

     Cox, D.R. and Hinkley, D.V. (1974). _Theoretical Statistics_
     Chapman and Hall, London.

_S_e_e _A_l_s_o:

     'asypow.noncent',  'asypow.sig',  'asypow.power'

_E_x_a_m_p_l_e_s:

     # Three Sample Poisson Example :
     #    Three independent Poisson processes produce events at
     #    mean rates of 1, 2 and 3 per day. For how many days
     #    must the processes be observed to have an 80% chance
     #    of detecting that the means are different at an
     #    overall significance level of 0.05?
     # Step 1 : Find the information matrix
     pois.mean <- c(1,2,3)
     info.pois <- info.poisson.kgroup(pois.mean, group.size=3)
     # Step 2: Create the constraints matrix
     constraints <- matrix(c(2,1,2,2,2,3),ncol=3,byrow=TRUE)
     # Step 3: Find the noncentrality parameter and
     #         degrees of freedom for the test
     poisson.object <- asypow.noncent(pois.mean, info.pois, constraints)
     # Step 4: Compute sample size needed for 
     #         0.8 power with significance level 0.05
     n.pois <- asypow.n(poisson.object, 0.8, 0.05)
     # Step 5: Divide the sample size by 3 (the number of processes)
     #         to get the number of days required.
     n.days <- n.pois/3
     print(n.days)

