asypow.sig              package:asypow              R Documentation

_A_s_y_m_p_t_o_t_i_c _S_i_g_n_i_f_i_c_a_n_c_e

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates the significance level of a test via likelihood ratio
     methods.

_U_s_a_g_e:

          asypow.sig(asypow.obj, sample.size, power)

_A_r_g_u_m_e_n_t_s:

asypow.obj: The object returned from asypow.noncent. 

sample.size: The sample size of the test. 

   power: The power of the test. 

_V_a_l_u_e:

     Returns the significance level of the test.

_R_e_f_e_r_e_n_c_e_s:

     Cox, D.R. and Hinkley, D.V. (1974). _Theoretical Statistics_
     Chapman and Hall, London.

_S_e_e _A_l_s_o:

     'asypow.noncent',  'asypow.n',  'asypow.power'

_E_x_a_m_p_l_e_s:

     # Single Group Binomial Example:
     #    Consider testing the null hypothesis that the binomial
     #    probability is p = .2 when the actual probability is .4.
     #    What significance level corresponding to a sample
     #    size of 47 and power of .8?
     # Step 1: Find the information matrix
     info.binom <- info.binomial.kgroup(.4)
     # Step 2: Create the constraints matrix
     constraints <- c(1, 1, .2)
     # Step 3: Find the noncentrality parameter and
     #         degrees of freedom for the test
     binom.object <- asypow.noncent(.4, info.binom, constraints)
     # Step 4: Compute the power of a test with
     #         sample size of 47 and a significance level 0.05
     sig.binom <- asypow.sig(binom.object, 47, 0.8)
     print(sig.binom)

