\name{asypow-internal}
\title{Internal asypow objects}
\alias{asypow.constraints}
\alias{asypow.construct.a}
\alias{asypow.theta.ho}
\alias{cdfchn}
\alias{derivs.link}
\alias{info.binomial.one}
\alias{info.expsurv.one}
\alias{info.ordinal.cat}
\alias{info.ordinal.one}
\alias{info.poisson.one}
\alias{invlogit}
\alias{k.blocks}
\alias{k.blocks.info}
\alias{logit}
\alias{transformPhi}
\description{Various internal asypow functions}
\keyword{internal}



\eof
\name{asypow.n}
\alias{asypow.n}
\title{
        Asymptotic Sample Size
}
\description{
        Calculates the sample size required to obtain the desired power for a test
        via likelihood ratio methods.
}
\usage{
       asypow.n(asypow.obj, power, significance)
}
\arguments{
       \item{asypow.obj}{
               The object returned from asypow.noncent.
}
       \item{power}{
               The desired power of the test.
}
       \item{significance}{
               The desired significance level of the test.
}}
\value{
     Returns the  sample size needed to achieve specified power at the
     specified significance level.
}
\references{
     Cox, D.R. and Hinkley, D.V. (1974).
     \emph{Theoretical Statistics}
     Chapman and Hall, London.
}
\seealso{
      \code{\link{asypow.noncent}}, 
      \code{\link{asypow.sig}}, 
      \code{\link{asypow.power}}
}
\examples{
# Three Sample Poisson Example :
#    Three independent Poisson processes produce events at
#    mean rates of 1, 2 and 3 per day. For how many days
#    must the processes be observed to have an 80\% chance
#    of detecting that the means are different at an
#    overall significance level of 0.05?
# Step 1 : Find the information matrix
pois.mean <- c(1,2,3)
info.pois <- info.poisson.kgroup(pois.mean, group.size=3)
# Step 2: Create the constraints matrix
constraints <- matrix(c(2,1,2,2,2,3),ncol=3,byrow=TRUE)
# Step 3: Find the noncentrality parameter and
#         degrees of freedom for the test
poisson.object <- asypow.noncent(pois.mean, info.pois, constraints)
# Step 4: Compute sample size needed for 
#         0.8 power with significance level 0.05
n.pois <- asypow.n(poisson.object, 0.8, 0.05)
# Step 5: Divide the sample size by 3 (the number of processes)
#         to get the number of days required.
n.days <- n.pois/3
print(n.days)
}
\concept{sample}
\keyword{htest}
% Converted by Sd2Rd version 1.21.

\eof
\name{asypow.noncent}
\alias{asypow.noncent}
\title{
    Asymptotic Noncentrality Parameter
}
\description{
    Given an information matrix, alternative hypothesis parameter values, and
    constraints that create the null hypothesis from the alternative,
    calculates noncentrality parameter, degrees of freedom and parameter
    value estimates under the null hypothesis.
}
\usage{
    asypow.noncent(theta.ha, info.mat, constraints, 
               nobs.ell=1, get.ho=TRUE)
}
\arguments{
\item{theta.ha}{
   Array of parameter values under the alternative hypothesis.
}
\item{info.mat}{
   The information matrix, the second derivate matrix of the
   expected log likelihood under the alternative hypothesis.
   The negative of the hessian matrix.
}
\item{constraints}{
   The constraints which set the null hypothesis from the
   alternative hypothesis. They are in matrix form.
    CONSTRAINT[,1] is 1 for setting parameter to a value
                   2 for equality of two parameters
    CONSTRAINT[,2] is case on CONSTRAINT[,1]
               (1) Index of parameter to set to value
               (2) Index of one of two parameters to 
                   be set equal
    CONSTRAINT[,3] is case on CONSTRAINT[,1]
               (1) Value to which parameter is set
               (2) Index of other of two parameters
                   to be set equal


}
\item{nobs.ell}{
   The number of observations used in computing the information
   matrix.  That is, info.mat is that for nobs.ell observations.
   Default is 1, which is the correct value for all of the 'info.'
   routines supplied here.
}
\item{ get.ho}{
   If TRUE, estimates of the parameter values under the null
   hypothesis are calculated and returned, otherwise not.
   Default is TRUE.
}}
\value{
   Returns a list including
}
\item{w}{
     The noncentrality parameter for 1 observation.
}
\item{df}{
     The degrees of freedom of the test
}
\item{theta.ho}{
     Estimates of the parameter values under the null hypothesis.
}}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{asypow.n}}, 
    \code{\link{asypow.sig}}, 
    \code{\link{asypow.power}}
}
\examples{
# Three Sample Poisson Example :
#    Three independent Poisson processes produce events at
#    mean rates of 1, 2 and 3 per day. 
# Find the information matrix
pois.mean <- c(1,2,3)
info.pois <- info.poisson.kgroup(pois.mean,group.size=3)
# Create the constraints matrix
constraints <- matrix(c(2,1,2,2,2,3),ncol=3,byrow=TRUE)
# Calculate noncentrality parameter, degrees of freedom and parameter
# value estimates under the null hypothesis for the test.
poisson.object <- asypow.noncent(pois.mean,info.pois,constraints)
}
\keyword{htest}
\concept{noncentrality}
% Converted by Sd2Rd version 1.21.


\eof
\name{asypow.power}
\alias{asypow.power}
\concept{Power calculations}
\title{
   Asymptotic Power
}
\description{
   Calculates the power of a test via likelihood ratio methods.
}
\usage{
     asypow.power(asypow.obj, sample.size, significance)
}
\arguments{
\item{asypow.obj}{
   The object returned from asypow.noncent.
}
\item{sample.size}{
   The sample size of the study.
}
\item{significance}{
   The significance level of the test.
}}
\value{
   Returns the power of the test.
}
\references{
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
}
\seealso{
   \code{\link{asypow.noncent}}, 
   \code{\link{asypow.n}}, 
   \code{\link{asypow.sig}}
}
\examples{
# Single Group Binomial Example:
#    Consider testing the null hypothesis that the binomial
#    probability is p = .2 with a sample size of 47 and
#    signficance level of 0.05. What is the power of the
#    test if p is actually .4?
# Step 1: Find the information matrix
info.binom <- info.binomial.kgroup(.4)
# Step 2: Create the constraints matrix
constraints <- c(1, 1, .2)
# Step 3: Find the noncentrality parameter and
#         degrees of freedom for the test
binom.object <- asypow.noncent(.4, info.binom, constraints)
# Step 4: Compute the power of a test with
#         sample size of 47 and a significance level 0.05
power.binom <- asypow.power(binom.object, 47, 0.05)
print(power.binom)
}
\keyword{htest}
\concept{power}
% Converted by Sd2Rd version 1.21.


\eof
\name{asypow.sig}
\alias{asypow.sig}
\title{
   Asymptotic Significance
}
\description{
   Calculates the significance level of a test via likelihood ratio methods.
}
\usage{
     asypow.sig(asypow.obj, sample.size, power)
}
\arguments{
\item{asypow.obj}{
   The object returned from asypow.noncent.
}
\item{sample.size}{
   The sample size of the test.
}
\item{power}{
   The power of the test.
}}
\value{
   Returns the significance level of the test.
}
\references{
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
}
\seealso{
   \code{\link{asypow.noncent}}, 
   \code{\link{asypow.n}}, 
   \code{\link{asypow.power}}
}
\examples{
# Single Group Binomial Example:
#    Consider testing the null hypothesis that the binomial
#    probability is p = .2 when the actual probability is .4.
#    What significance level corresponding to a sample
#    size of 47 and power of .8?
# Step 1: Find the information matrix
info.binom <- info.binomial.kgroup(.4)
# Step 2: Create the constraints matrix
constraints <- c(1, 1, .2)
# Step 3: Find the noncentrality parameter and
#         degrees of freedom for the test
binom.object <- asypow.noncent(.4, info.binom, constraints)
# Step 4: Compute the power of a test with
#         sample size of 47 and a significance level 0.05
sig.binom <- asypow.sig(binom.object, 47, 0.8)
print(sig.binom)
}
\keyword{htest}
\concept{signficance}
% Converted by Sd2Rd version 1.21. 




\eof
\name{info.binomial.design}
\alias{info.binomial.design}
\title{
   Expected Information Matrix for a Binomial Design
}
\description{
   Calculates the expected information matrix for a binomial
   design where the parameter \eqn{p}{p}, probability of an event,
   depends on a covariate, \eqn{x}{x}, through a logistic,
   \eqn{p = \exp(u) / (1 + \exp(u))}
       {p = exp(u)/(1+exp(u))}, or complementary log,
   \eqn{p = 1 - \exp(-\exp(u))}
       {p = 1 - exp(-exp(u))}, model. The variable \eqn{u}{u} is either a
   linear, 
   \eqn{u = a + b x}{u = a + b*x}, or quadratic, 
   \eqn{u = a + b x + c x^2}{u = a + b*x + c*x^2},
   function of the covariate \eqn{x}{x}.
}
\usage{
   info.binomial.design(model="linear", link="logistic", theta,
                     xpoints, natx=1, group.size=1)
}
\arguments{
\item{theta}{
    Matrix of parameters for the linear combination of the covariate
    x. Each row represents a group so theta[i,] is c(a,b)
    if model = "linear" or theta[i,] is c(a,b,c) if model = "quadratic".
}
\item{xpoints}{
    Matrix of covariate values for each group. If there is only
    1 group or all groups have the same covariate value, xpoints
    should be a vector; otherwise, the number of rows in xpoints
    must equal the number of rows in theta.
}
\item{model}{
    One of \{"linear", "quadratic"\}. Specifies the function
    of the covariate x that will be used.
    Linear indicates, 
    \eqn{u = a + b x}{u = a + b*x}, and
    quadratic indicates, 
    \eqn{u = a + b x + c x^2}{u = a + b*x + c*x^2}.
    Only enough to ensure a unique match need be supplied.
}
\item{link}{
    One of \{"logistic", "complementary log"\}. Specifies the link
    between the linear or quadratic combination of the covariate \eqn{x}{x}
    and the parameter of the Binomial model, \eqn{p}{p}. Logistic indicates
    \eqn{p = \exp(u) / (1 + \exp(u))}{p = exp(u)/(1+exp(u))}, 
    and complementary log indicates,
    \eqn{p = 1 - \exp(-\exp(u))}{p = 1 - exp(-exp(u))}.
    Only enough to ensure a unique match need be supplied.
}
\item{natx}{
    Needed only if there are unequal sample sizes used at any of the values
    in xpoints. At covariate value xpoint[i,j] there are natx[i,j] observations.
    If specified, the dimensions of natx should be the same as the
    dimensions of xpoints.
}
\item{group.size}{
    Needed only if there are to be several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified relative
    sizes.  If this value is specified, it should be a vector whose
    length is the same as the number of rows in theta.
}}
\value{
    The information matrix for one observation for this design.

    If model = "linear" and there are \eqn{k}{k} groups, the information
    matrix is a square \eqn{(2 k) \times (2 k)}{(2*k)x(2*k)} matrix which is indexed
    by the parameters (a,b) for group 1, then (a,b) for group 2, etc.


   If model = "quadratic", the information matrix is a square
   \eqn{(3 k)\times (3 k)}{(3*k)x(3*k)} matrix which is 
   indexed by the parameter (a,b,c)
   for group 1, then (a,b,c) for group 2, etc.
}
\references{
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
}
\seealso{
   \code{\link{info.poisson.design}}, 
   \code{\link{info.ordinal.design}}, 
   \code{\link{info.expsurv.design}}
}
\examples{
# Find the information matrix for a 2 group
# logistic binomial Design with a quadratic
# combination of covariate x and different
# sample sizes at each point
abc <- rbind(c(1.2, .9, .3),c(0.33, .21, .05))
covar <- c(1, 2, 3,  4,5)
sample.size <- rbind(c(10,11,12,10,9), c(8,7,10,8,9))
info.binom <- info.binomial.design(model="quadratic", link="logistic", 
                                theta = abc, xpoints = covar,
                                natx=sample.size)
print(info.binom)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.  




\eof
\name{info.binomial.kgroup}
\alias{info.binomial.kgroup}
\title{
   Expected Information Matrix for Single or Multiple Group Binomial
}
\description{
   Calculates expected information matrix for a single observation
   for single or multiple group binomial distribution.


   The natural null hypothesis for a single group is that that the probability
   is some specified value.  For multiple groups, the natural null hypothesis
   is that the group probabilities are the same.
}
\usage{
   info.binomial.kgroup(p, group.size=1)
}
\arguments{
\item{p}{
    Scalar or vector of probability values.  The i'th component is the
    (alternative hypothesis or true) probability of an event in the i'th
    group.
}
\item{group.size}{
    Needed only if there are several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified relative
    sizes.  If this value is specified, it should be a vector whose
    length is the same as  p.  
}}
\value{
   Expected information matrix for a single observation.  The matrix is
   square with each dimension the number of groups.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.poisson.kgroup}}, 
    \code{\link{info.ordinal.kgroup}}, 
    \code{\link{info.expsurv.kgroup}}
}
\examples{
# Find the information matrix for a 2 sample binomial with
# probability of events .2 and .4 and sample sizes 10 and 11
info.binom <- info.binomial.kgroup(c(.2,.4), c(10,11))
print(info.binom)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.




\eof
\name{info.expsurv.design}
\alias{info.expsurv.design}
\title{
    Expected Information Matrix for a Clinical Trial with Exponential 
    Survival Design
}
\description{
    Calculates expected information matrix for a clinical trial with 
    exponential survival.


   The clinical trial will accrue subjects over a time period \eqn{L}{L}.
   Each subject will enter the study at a random time between 0 
   and \eqn{L}{L}, so the subject's follow up time, \eqn{U}{U}, will be uniformly
   distributed between 0 and \eqn{L}{L}. A subject with follow up
   time \eqn{U}{U}, can die at a time \eqn{t}{t} between 0 and \eqn{U}{U}, 
   or the subject can
   be withdrawn alive at time \eqn{U}{U}. The density of time to death
   is exponential distribution with hazard, \eqn{w}{w}.


   The parameter \eqn{w}{w} depends on a covariate, \eqn{x}{x}, 
   via the exponentiation
   of a linear or quadratic function of \eqn{x}{x}, 
   \eqn{w= \exp(a+b x)}{w = exp(a + b*x)}
   or \eqn{w= \exp(a+b x + c x^2)}{w = exp(a + b*x + c*x^2)}.


   This model is both the proportional hazards model and the accelerated
   failure model for exponential survival.
}
\usage{
   info.expsurv.design(model="linear", theta, L, xpoints,
                    natx=1, group.size=1)
}
\arguments{
\item{theta}{
    Matrix of parameters for the linear combination of the covariate
    x. Each row represents a group so theta[i,] = c(a,b)
    if model = "linear" or theta[i,] = c(a,b,c) if model = "quadratic".
}
\item{L}{
    The length of the clinical trial. If all groups have the same
    trial length, L should be a single number; otherwise, L should
    be a vector the same length as the number of rows in w 
    where L[i] is the length of the clinical trial for the i'th group.
}
\item{xpoints}{
    Matrix of covariate values for each group. If there is only
    1 group or all groups have the same covariate value, xpoints
    should be a vector; otherwise, the number of rows in xpoints
    must each the number of rows in theta.
}
\item{model}{
    One of \{"linear", "quadratic"\}. Specifies the function
    of the covariate x that will be used.
    Linear indicates, \eqn{u = a + b x}{u = a + b*x}, and
    quadratic indicates, 
    \eqn{u = a+ b x + c x^2}{u = a + b*x + c*x^2}.
    Only enough to ensure a unique match need be supplied.
}
\item{natx}{
   Needed only if there are unequal sample sizes used at any of the values
   in xpoints. At covariate value xpoint[i,j] there are natx[i,j] observations.
   If specified, the dimensions of natx should be the same as the
   dimensions of xpoints.
}
\item{group.size}{
   Needed only if there are to be several groups with unequal sample
   sizes.  The value of the i'th component is the relative sample size of
   the i'th group.  The calculation made is for a single observation
   spread over the several groups in proportion to the specified relative
   sizes.  If this value is specified, it should be a vector whose
   length is the same as the number of columns in theta.
}}
\value{
   The information matrix for one observation for this design.


   If model = "linear" and there are k groups, the information
   matrix is a square 
   \eqn{(2 k)\times (2 k)}{(2*k)x(2*k)} matrix which is indexed
   by the parameters (a,b) for group 1, then (a,b) for group 2, etc.


   If model = "quadratic", the information matrix is a square
   \eqn{(3 k)\times (3 k)}{(3*k)x(3*k)} matrix which is 
   indexed by the parameter (a,b,c)
   for group 1, then (a,b,c) for group 2, etc.
}
\references{
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
}
\seealso{
   \code{\link{info.binomial.design}}, 
   \code{\link{info.poisson.design}}, 
   \code{\link{info.ordinal.design}}
}
\examples{
# Find the information matrix for a clinical trial
# with hazard w(x) = -0.848 + 0.7*x which lasts
# three years and has 10 x values equally spaced
# between -3 and 3 with equal sample sizes.
ab <- c(-.848, .7)
covar <- seq(-3, 3, length=10)
LL <- 3
info.expsurv <- info.expsurv.design(theta = ab, L = LL, xpoints = covar)
print(info.expsurv)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21. 


\eof
\name{info.expsurv.kgroup}
\alias{info.expsurv.kgroup}
\title{
   Expected Information Matrix for a Single or Multiple Group 
   Clinical Trial with Exponential Survival
}
\description{
   Calculates expected information matrix for a single observation
   for a single or multiple group clinical trial with exponential
   survival.


   The clinical trial will accrue subjects over a time period \eqn{L}{L}.
   Each subject will enter the study at a random time between 0 
   and \eqn{L}{L}, so the subject's follow up time, \eqn{U}{U}, will be uniformly
   distributed between 0 and \eqn{L}{L}. A subject with follow up
   time \eqn{U}{U}, can die at a time \eqn{t}{t} between 0 and \eqn{U}{U}, 
   or the subject can
   be withdrawn alive at time \eqn{U}{U}. The density of time to death
   is exponential distribution with hazard, \eqn{w}{w}.
}
\usage{
   info.expsurv.kgroup(w, L, group.size=1)
}
\arguments{
\item{w}{
    Scalar  or  vector of   exponential   rates (reciprocals of  the  mean
    survival time ) for the groups. The i'th component is the (alternative
    hypothesis or true) rate of the i'th group.
}
\item{L}{
    The length of the clinical trial. If all groups have the same
    trial length, L should be a single number; otherwise, L should
    be a vector the same length as w where L[i] is the length
    of the clinical trial for the i'th group.
}
\item{group.size}{
    Needed only if there are to be several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified sample
    size.  If this value is specified, it should be a vector of the same
    length as lambda.
}}
\value{
    Expected information matrix for a single observation.  The matrix is
    square with dimension equal to the number of groups.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.binomial.kgroup}}, 
    \code{\link{info.poisson.kgroup}}, 
    \code{\link{info.ordinal.kgroup}}
}
\examples{
# Find the information matrix for a clinical trial of
# length 3 with hazard 1
info.expsurv <- info.expsurv.kgroup(1, 3)
print(info.expsurv)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21, and hand-edited. 




\eof
\name{info.mvlogistic}
\alias{info.mvlogistic}
\title{
    Expected Information Matrix for a Multivariate Logistic Model
}
\description{
   Calculates the expected information matrix for a multivariate
   logistic model where the parameter \eqn{p}{p}, probability of an event,
   depends on the covariates, 
   \eqn{x = c(x[1], x[2], \ldots, x[n]}{x = c(x[1], x[2], \dots, x[n])}, 
   through a logistic, 
   \eqn{p = \exp(u) / (1 + \exp(u))}{p = exp(u)/(1+exp(u))}, model. 
   The variable \eqn{u}{u} is a linear combination of the covariates via a set of
   coefficients, 
   \eqn{\mbox{coef} = c(\mbox{coef}[1],\ldots, \mbox{coef}[n]) }{coef = c(coef[1], coef[2], \dots, coef[n])},
   \eqn{u = \sum_{i=1}^n \mbox{coef}[i] x[i]}{u = Sum (coef[i] * x[i]) i = 1, \dots ,n}.


   The usual use of this routine is for tabulated data in which case the
   x's will all be 0 or 1 valued indicator variables.
}
\usage{
    info.mvlogistic(coef, design, rss=1)
}
\arguments{
\item{coef}{
    Vector of length p (number of covariates) giving coefficients
    of variables.
}
\item{design}{
    Matrix of dimension \eqn{n \times p}{(n X p)} 
    each row of which gives values of
    covariates at one of the n design points.


    Note: Most models will include a constant term and the column of
    design corresponding to this term will be identically 1.
}
\item{rss}{
    The relative sample size at each design point. The default
    is the same sample size at each design point. If changed from
    the default, rss should be a vector of length n.
}}
\value{
    The information matrix for one observation for this design.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.mvloglin}}
}
\examples{
# Find the information matrix for a multivariate
# logistic design with variables x, y and z
#    Define coefficient matrix so that 
#    u = 1 + .5*x + .7*y + .9*z
coef <- c(1, .5, .7, .9)
#    Define the design matrix so that there are 10 design points
intercept <- rep(1, 10)
x <- rnorm(10)
y <- rnorm(10)
z <- rnorm(10)
design <- cbind(intercept, x, y, z)
#    Use info.mvlogistic to find the information matrix for
#    this design
info.xyz <- info.mvlogistic(coef, design)
print(info.xyz)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.   




\eof
\name{info.mvloglin}
\alias{info.mvloglin}
\title{
       Expected Information Matrix for a Multivariate Log-Linear Model
}
\description{
       Calculates the expected information matrix for a multivariate
       log-linear model where the parameter \eqn{p}{p}, 
       probability of an event,
       depends on the covariates, 
       \eqn{x = c(x[1], \ldots, x[n])}{x = c(x[1], x[2], \dots, x[n])}, 
       through an exponential, 
       \eqn{p = \exp(u)}{p = exp(u)}.
        The variable \eqn{u}{u} is a log-linear combination of the 
      covariates via a set of
      coefficients, 
      \eqn{\mbox{coef} = c( \mbox{coef}[1], \ldots, \mbox{coef}[n]}{coef = c(coef[1], coef[2], \dots, coef[n])},
      \eqn{u = \sum_{i=1}^n \log(\mbox{coef}[i] x[i] )}{u = Sum (log(coef[i]) * x[i]) i = 1, \dots ,n}.


     The usual use of this routine is for tabulated data in which case the
     x's will all be 0 or 1 valued indicator variables.


}
\usage{
        info.mvloglin(coef, design, rss=1)
}
\arguments{
\item{coef}{
    Vector of length p (number of covariates) giving coefficients
    of variables.
}
\item{design}{
    Matrix of dimension 
    \eqn{n \times p}{(n X p)} each row of which gives values of
    covariates at one of the n design points.


    Note: Most models will include a constant term and the column of
    design corresponding to this term will be identically 1.
}
\item{rss}{
   The relative sample size at each design point. The default
   is the same sample size at each design point. If changed from
   the default, rss should be a vector of length n.
}}
\value{
   The information matrix for one observation for this design.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.mvlogistic}}
}
\examples{
# Find the information matrix for a multivariate
# log-linear design with variables x, y and z
#    Define coefficient matrix so that 
#    u = .1 + .2*x + .3*y + .3*z
coef <- c(.1, .2, .3, .4)
#    Define the design matrix so that there are 10 design points
intercept <- rep(1, 10)
x <- seq(.1, .2, length=10)
y <- seq(.25, .3, length=10)
z <- seq(.2, .3, length=10)
design <- cbind(intercept, x, y, z)
#    Use info.mvloglin to find the information matrix for
#    this design
info.xyz <- info.mvloglin(coef, design)
print(info.xyz)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.   



\eof
\name{info.ordinal.design}
\alias{info.ordinal.design}
\title{
    Expected Information Matrix for an Ordinal Design
}
\description{
    Calculates the expected information matrix for an ordinal
    design where the parameters \eqn{p_j}{p[j]}, 
    probability of an event
    in category \eqn{j}{j} or less, depend on a covariate, 
    \eqn{x}{x}, through a logistic,
    \eqn{p_j = \exp( u_j) / (1+ \exp(u_j)}{p[j] = exp(u[j])/(1+exp(u[j]))}, 
    or complementary log,
    \eqn{p_j = 1 - \exp( - \exp( u_j))}{p[j] = 1 - exp(-exp(u[j]))}, 
    model. The variable \eqn{u_j}{u[j]} is a
    linear, 
    \eqn{u_j = a_j + b x}{u[j] = a[j] + b*x}, or quadratic, 
    \eqn{u_j = a_j + b x + c x^2}{u[j] = a[j] + b*x + c*x^2}, 
    function of the covariate \eqn{x}{x}.
}
\usage{
    info.ordinal.design(model="linear", link="logistic", theta,
                     xpoints, natx=1, group.size=1)
}
\arguments{
\item{theta}{
    Matrix of parameters for the linear combination of the covariate
    x. Each row represents a group so if model = "linear"


    \deqn{\theta[i,] = c( a[1], a[2], a[3], \ldots, a[r-1], b)}{theta[i,] = c(a[1],a[2],a[3],\dots,a[r-1],b)}


    where \eqn{r}{r} is the number of categories. If model = "quadratic" 


     \deqn{\theta[i,] = c(a[1], a[2], \ldots, a[r-1],b,c)}%
          {theta[i,] = c(a[1],a[2],a[3],\dots,a[r-1],b,c)}
}
\item{xpoints}{
    Matrix of covariate values for each group. If there is only
    1 group or all groups have the same covariate value, xpoints
    should be a vector; otherwise, the number of rows in xpoints
    must equal the number of rows in theta.
}
\item{model}{
    One of \{"linear", "quadratic"\}. Specifies the function
    of the covariate x that will be used.
    Linear indicates, 
    \eqn{u_j = a_j + b x}{u[j] = a[j] + b*x}, and
    quadratic indicates, 
    \eqn{u_j = a_j + b x + c x^2, \quad  j=1, \ldots, r-1}{u[j] = a[j] + b*x + c*x^2 j = 1,\dots,r-1}.
    Only enough to ensure a unique match need be supplied.
}
\item{link}{
    One of \{"logistic", "complementary log"\}. Specifies the link
    between the linear or quadratic combination of the covariate \eqn{x}{x}
    and the parameters of the ordinal model, 
    \eqn{p_j}{p[j]}. Logistic indicates
    \eqn{p_j = \exp(u_j) / (1 + \exp(u_j))}{p[j] = exp(u[j])/(1+exp(u[j]))}, 
    and complementary log indicates,
    \eqn{p_j = 1 - \exp( -\exp(u_j)), \quad j=1, \ldots, r-1}{p[j] = 1 - exp(-exp(u[j])) j = 1,\dots,r-1}.
    Only enough to ensure a unique match need be supplied.
}
\item{natx}{
    Needed only if there are unequal sample sizes used at any of the values
    in xpoints. At covariate value xpoint[i,j] there are natx[i,j] observations.
    If specified, the dimensions of natx should be the same as the
    dimensions of xpoints.
}
\item{group.size}{
    Needed only if there are to be several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified relative
    sizes.  If this value is specified, it should be a vector whose
    length is the same as the number of rows in theta.
}}
\value{
    The information matrix for one observation for this design.

    If model = "linear" and there are \eqn{r}{r} categories and \eqn{k}{k} groups,
    the information matrix is a square \eqn{(r k)\times (r k)}{(r*k)x(r*k)} 
    matrix which is indexed by the parameters 
    \eqn{a[1], a[2], \ldots, a[r-1], b}{(a[1], a[2], \dots, a[r-1], b)}
    for group 1, then 
    \eqn{(a[1], a[2], \ldots, a[r-1], b)}{(a[1], a[2], \dots, a[r-1], b)} for group 2, etc.

    If model = "quadratic", the information matrix is a square
    \eqn{((r+1)k)\times ((r+1)k)}{((r+1)*k)x((r+1)*k)} 
     matrix which is indexed by the parameters
    \eqn{(a[1], a[2], \ldots, a[r-1], b,c)}{(a[1], a[2], \dots, a[r-1], b, c)} for group 1, 
    then 
    \eqn{(a[1], a[2], \ldots, a[r-1], b, c)}{(a[1], a[2], \dots, a[r-1], b, c)} for group 2, etc.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
      \code{\link{info.binomial.design}}, 
      \code{\link{info.poisson.design}}, 
      \code{\link{info.expsurv.design}}
}
\examples{
# Find the information matrix for an ordinal design
# with one group and equal sample sizes.
# Assume 4 categories and use a logistic
# line and quadratic model. Let
# u[1] = 1 + 2.5*x
# u[2] = 2 + 2.5*x
# u[3] = 3 + 2.5*x
# Use values x = -3,0,3
theta <- c(1, 2, 3, 2.5)
covar <- c(-3, 0, 3)
info.ord <- info.ordinal.design(theta = theta, xpoints = covar)
print(info.ord)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.    




\eof
\name{info.ordinal.kgroup}
\alias{info.ordinal.kgroup}
\title{
    Expected Information Matrix for Single or 
    Multiple Group Ordinal Observations
}
\description{
    Calculates expected information matrix for a single observation for 
    ordered outcomes in a single or multiple groups.  


    The natural null hypothesis for a single group is that the probabilities of 
    the outcomes is some specified set of values.  For multiple groups, the
    natural null hypothesis is that the probabilities are the same.
}
\usage{
    info.ordinal.kgroup(p, group.size=1)
}
\arguments{
\item{p}{
    If there are \eqn{n}{n} ordered outcome categories and \eqn{k}{k} 
    groups then \eqn{p}{p} will have
    dimension \eqn{k \times (n-1)}{k X (n-1)}.  
    If the number of groups is one, then \eqn{p}{p} can be
    a vector of length (n-1).

    Within a single group, \eqn{p_i}{p[i]} is the probability that the outcome of a
    trial is some category \eqn{j}{j} with \eqn{j \le i}{j <= i}.  
    Consequently, the \eqn{p_i}{p[i]} must be
    monotonely increasing with \eqn{k}{k}.  
    If there are \eqn{n}{n} categories, of necessity
    \eqn{p_n=1}{p[n] == 1}, so this redundant value is not included.

    Within a single group, the probability that the outcome is
    category 1 is \eqn{p_1}{p[1]}.  
    For \eqn{2 \le i \le n}{2 <= i < n} the probability that the outcome is
    category \eqn{k}{k} is 
    \eqn{p_i - p_{i-1}}{p[i] - p[i-1]}.  
    The probability of outcome \eqn{n}{n} is 
    \eqn{1 - p_{n-1}}{1 - p[n-1]}.
}
\item{group.size}{
    Needed only if there are to be several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified sample
    size.  If this value is specified, it should be a vector whose
    length is the row dimension of  p.  
}}
\value{
    Expected information matrix for a single observation.  The matrix is
    dimensioned 
    \eqn{(k(n-1))\times (k(n-1))}%
        {( k*(n-1) ) X ( k*(n-1) )}.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.binomial.kgroup}}, 
    \code{\link{info.poisson.kgroup}}, 
    \code{\link{info.expsurv.kgroup}}
}
\examples{
# Find the information matrix for a 2 group ordinal
# model with 4 categories.
p1 <- c(.1, .2, .3)  # Probabilities for group 1
p2 <- c(.2, .5, .7)  # Probabilities for group 2
p <- rbind(p1,p2)
ngrps <- c(.4, .6)  # Percentage of data in each group
info.ord <- info.ordinal.kgroup(p, ngrps)
print(info.ord)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.




\eof
\name{info.poisson.design}
\alias{info.poisson.design}
\title{
    Expected Information Matrix for a Poisson Design
}
\description{
    Calculates the expected information matrix for a Poisson
    design where the parameter \eqn{\lambda}{lambda}, the mean of the
    distribution, depends on a covariate, \eqn{x}{x}, via the exponentiation
    of a linear or quadratic function of \eqn{x}{x}, 
    \eqn{\lambda = \exp(a + b x)}{lambda = exp(a + b*x)}
    or 
    \eqn{\lambda = \exp(a + b x + c x^2)}{lambda = exp(a + b*x + c*x^2)}.
}
\usage{
    info.poisson.design(model="linear", theta, xpoints,
                           natx=1, group.size=1)
}
\arguments{
\item{theta}{
    Matrix of parameters for the linear combination of the covariate
    x. Each row represents a group so theta[i,] = c(a,b)
    if model = "linear" or theta[i,] = c(a,b,c) if model = "quadratic".
}
\item{xpoints}{
    Matrix of covariate values for each group. If there is only
    1 group or all groups have the same covariate value, xpoints
    should be a vector; otherwise, the number of rows in xpoints
    must each the number of rows in theta.
}
\item{model}{
    One of \{"linear", "quadratic"\}. Specifies the function
    of the covariate x that will be used.
    Linear indicates, 
    \eqn{u = a + b x}{u = a + b*x}, and
    quadratic indicates, 
    \eqn{u = a + bx + c x^2}{u = a + b*x + c*x^2}.
    Only enough to ensure a unique match need be supplied.
}
\item{natx}{
    Needed only if there are unequal sample sizes used at any of the values
    in xpoints. At covariate value xpoint[i,j] there are natx[i,j] observations.
    If specified, the dimensions of natx should be the same as the
    dimensions of xpoints.
}
\item{group.size}{
    Needed only if there are to be several groups with unequal sample
    sizes.  The value of the i'th component is the relative sample size of
    the i'th group.  The calculation made is for a single observation
    spread over the several groups in proportion to the specified relative
    sizes.  If this value is specified, it should be a vector whose
    length is the same as the number of columns in theta.
}}
\value{
    The information matrix for one observation for this design.

    If model = "linear" and there are k groups, the information
    matrix is a square 
    \eqn{(2 k)\times (2 k)}{(2*k)x(2*k)} matrix which is indexed
    by the parameters (a,b) for group 1, then (a,b) for group 2, etc.

    If model = "quadratic", the information matrix is a square
    \eqn{(3 k)\times (3 k)}{(3*k)x(3*k)} matrix which is indexed by the 
    parameter (a,b,c)
    for group 1, then (a,b,c) for group 2, etc.
}
\references{
    Cox, D.R. and Hinkley, D.V. (1974).
    \emph{Theoretical Statistics}
    Chapman and Hall, London.
}
\seealso{
    \code{\link{info.binomial.design}}, 
    \code{\link{info.ordinal.design}}, 
    \code{\link{info.expsurv.design}}
}
\examples{
# Find the information matrix for a 2 group
# logistic Poisson design with a quadratic
# combination of covariate x and different
# sample sizes at each point
abc <- rbind(c(1.2,.9,.3), c(0.33,.21,.05))
covar <- c(1, 2, 3, 4, 5)
sample.size <- rbind(c(10,11,12,10,9), c(8,7,10,8,9))
info.poiss <- info.poisson.design(model="quadratic",
                                theta = abc, xpoints = covar,
                                natx=sample.size)
print(info.poiss)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.   




\eof
\name{info.poisson.kgroup}
\alias{info.poisson.kgroup}
\title{
    Expected Information Matrix for Single or Multiple Group Poisson
}
\description{
    Calculates expected information matrix for a single observation
    for single or multiple group Poisson distribution.

   The natural null hypothesis for a single group is that that the mean
   is some specified value.  For multiple groups, the natural null hypothesis
   is that the group means are the same.
}
\usage{
   info.poisson.kgroup(lambda, group.size=1)
}
\arguments{
\item{lambda}{
   Scalar or vector of Poisson means for the groups.  The i'th component
   is the (alternative hypothesis or true) mean of the i'th group.
}
\item{group.size}{
   Needed only if there are to be several groups with unequal sample
   sizes.  The value of the i'th component is the relative sample size of
   the i'th group.  The calculation made is for a single observation
   spread over the several groups in proportion to the specified sample
   size.  If this value is specified, it should be a vector of the same
   length as lambda.
}}
\value{
   Expected information matrix for a single observation.  The matrix is
   square with dimension equal to the number of groups.
}
\references{
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
}
\seealso{
   \code{\link{info.binomial.kgroup}}, 
   \code{\link{info.ordinal.kgroup}}, 
   \code{\link{info.expsurv.kgroup}}
}
\examples{
# Find the information matrix for a 3 sample Poisson with
# means 1, 2 and 3 and equal sample sizes
info.pois <- info.poisson.kgroup(c(1,2,3))
print(info.pois)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.   


\eof
\name{info.reparam}
\alias{info.reparam}
\title{
    Reparameterize Expected Information Matrix
}
\description{
    Calculates the expected information matrix after reparameterization
    of a model using the method of propagation of error.
}
\usage{
    info.reparam(theta, info.mat, dg)
}
\arguments{
\item{theta}{
    Matrix of parameters of the linear part of the model.
    Each row represents a group. This is under the original
    parameterization.
}
\item{info.mat}{
    The information matrix under the original parameterization.
}
\item{dg}{
     A function that computes the partial derivatives of g, the
     transformation function. Let g.i be the function
     which transforms the vector of old parameters, theta,
     into the i'th element of the new parameters. The function dg should take
     theta and return a matrix whose [i,j] element
     is the derivative of g.i with respect to theta[j]
}}
\value{
     Returns the expected information matrix under the new parameterization.
}
\references{
    Bishop, Y.M., Fienberg, S.E., and Holland, P.W. (1975)
    \emph{Discrete Multivariate analysis: Theory and Practice}
    MIT Press, Cambridge, Mass.
\cr
   Cox, D.R. and Hinkley, D.V. (1974).
   \emph{Theoretical Statistics}
   Chapman and Hall, London.
\cr
   Tong, Y.L. (1990).
   \emph{The Multivariate Normal Distribution}
   Springer-Verlag, New York.
}
\examples{
# A logistic model posits that the probability of response
# is a logtistic function of a + b*x.
# Consider the value of x that produces 50\%
# response, x = -a/b. Since -a/b is not one of the parameters
# of the model, we must reparameterize to
# roe[1] = -a/b
# roe[2] = b
dg <- function(theta) {
# theta is a vector of length 2 containing c(a,b)
# dg <- [d{roe[1]}/d{a} d{roe[1]}/d{b}
#        d{roe[2]}/d{a} d{roe[2]}/d{b}]
  a <- theta[1]
  b <- theta[2]
  return(matrix(c(-1/b,a/b^2,0,1), nrow=2, ncol=2, byrow=TRUE))
}
# Let a = -0.9 and b = .7
theta <- c(-.9, .7)
# assign a set of covariate values
covar <- c(0.3, .9, 1.3, 2.5)
# Use info.binomial.design to calculate the information
# matrix under the original parameterization
info.orig <- info.binomial.design(model="linear", link="logistic", 
                                  theta=theta, xpoints=covar)
# Get the information matrix of the reparameterized model
info.new <- info.reparam(theta, info.orig, dg)
print(info.new)
}
\keyword{htest}
\concept{information}
% Converted by Sd2Rd version 1.21.

\eof
