\name{boot.cfa}
\alias{boot.cfa}
\title{Bootstrap-CFA}
\description{ The bootstrap-CFA tries to replicate the pattern of significant configurations by
re-sampling. 
}
\usage{
boot.cfa(configs, cnts, runs=100, sig.item="sig.z",...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{configs}{ Contains the configurations. This can be a dataframe or a matrix. The dataframe can contain numbers,
              characters, factors, or booleans. The matrix can consist of numbers, characters or booleans 
              (factors are implicitely re-converted to numerical levels). There must be >=3 columns.
            }
  \item{cnts}{ Contains the counts for the configuration. If it is set to NA, a count of one is assumed for every
               row. This allows untabulated data to be processed. \code{cnts} must be a vector.
              }

  \item{runs}{Number of samples to be drawn.}
  \item{sig.item}{Indicator of significance in the result table (sig.z,sig.chisq,sig.perli,sig.zl,
sig.zl.corr). Do not forget to set the proper parameters for the CFA if sig.perli,sig.zl or
sig.zl.corr are to be used!}
  \item{\dots}{Parameters to be to relayed to the CFA}
}
\details{
 Takes 'runs' samples and does as many CFAs while counting how many times this configuration 
was  considered to be significant. 

Repeated-measures CFAs (mcfa) are not provided.

This is a heuristic method rather than a strict test of significance since there 
is no adjustment for multiple testing whatsoever. The advantage  is a more reliable picture
compared to splitting the original data, doing a CFA, and checking if the configurations re-appear 
in a CFA with the other half of the data. 
}
\value{
  \item{cnt.antitype}{Number of antiypes}
  \item{cnt.type }{Number of types}
  \item{pct.types}{Number of types in percent}
  \item{cnt.sig}{Number of significant results}
  \item{pct.cnt.sig}{Number of significant results in percent}
}
\references{ 
   Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
   Psychologie und Medizin, Beltz Psychologie Verlagsunion
}
\author{Stefan Funke <s.funke@t-online.de>}

\note{\code{boot.cfa()} performs many CFAs which are by themselves slow, so the execution can
be \bold{very} time-consuming, especially if a sufficiently high value for \code{runs} was selected}

\seealso{ \code{\link{cfa}}, \code{\link{scfa}}}



\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
boot.cfa(configs,counts,runs=25) 
}

\keyword{multivariate}
\keyword{htest}


\eof
\name{cfa}
\alias{cfa}
\title{ Analysis of configuration frequencies}
\description{
  This is the main function which will call scfa() und mcfa() as required.
}
\usage{
cfa(cfg, cnts=NA, sorton="chisq", sort.descending=TRUE, format.labels=TRUE, 
    casewise.delete.empty=TRUE, 
    binom.test=F, exact.binom.test=F, exact.binom.limit=10, 
    perli.correct=F, lehmacher=F, lehmacher.corr=TRUE, 
    alpha=0.05, bonferroni=TRUE)
}
\arguments{
  \item{cfg}{ Contains the configurations. This can be a dataframe or a matrix. The dataframe can contain numbers,
              characters, factors, or booleans. The matrix can consist of numbers, characters, or booleans 
              (factors are implicitely re-converted to numerical levels). There must be >=3 columns.
            }
  \item{cnts}{ Contains the counts for the configuration. If it is set to NA, a count of one is assumed for every
               row. This allows untabulated data to be processed. \code{cnts} can be a vector or a matrix/dataframe with >=2 columns.
              }
  \item{sorton}{ Determines the sorting order of the output table. Can be set to \code{chisq}, \code{n}, or \code{label}.}
  \item{sort.descending}{ Sort in descending order}
  \item{format.labels}{ Format the labels of the configuration. This makes to output wider but it will increase the
        readability.}
  \item{casewise.delete.empty}{ If set to TRUE all configurations containing a NA in any column will be deleted. Otherwise
        NA is handled as the string "NA" and will appear as a valid configuration.}
  \item{binom.test}{ Use z approximation for binomial test.}
  \item{exact.binom.test}{ Do an exact binomial test.}
  \item{exact.binom.limit}{ Maximum n for which an exact binomial test is performed (n >10 causes p to become inexact).}
  \item{perli.correct}{ Use Perli's correction for multiple test.}
  \item{lehmacher}{ Use Lehmacher's correction for multiple test.}
  \item{lehmacher.corr}{ Use a continuity correction for Lehmacher's correction.}
  \item{alpha}{Alpha level}
  \item{bonferroni}{Do Bonferroni adjustment for multiple test (irrelevant for Perli's and Lehmacher's test).}
}
\details{
  The cfa is used to sift large tables of nominal data. Usually it is used for dichotomous 
  variables but can be extended to three or more possible values. There should be at least three configuration variables
  in \code{cfg} - otherwise a simple contigency table would do.
  All tests of significance are two-sided: They test for both types or antitypes, i.e. if n is significantly larger or
  smaller than the expected value.
  The usual caveats for testing contigency tables apply. If a configuration has a n <5 an exact test
  should be used. As an alternative the least interesting configuration variable can be left out (if
  it is not essential) which will automatically increase the n for the remaining configurations.
}
\value{ Some of these elements will only be returned when the corresponding argument
        in the function call has been set. The relation is obvious due to corresponding names.
  \item{table}{The cfa output table}
  \item{table["label"]}{Label for the given configuration}
  \item{table["n"]}{Observed n for this configuration} 
  \item{table["expected"]}{Expected n for this configuration} 
  \item{table["Q"]}{Coefficient of pronouncedness (varies between 0 and 1)} 
  \item{table["chisq"]}{Chi squared for the given configuration} 
  \item{table["p.chisq"]}{p for the chi squared test} 
  \item{table["sig.chisq"]}{Is it significant (will Bonferroni-adjust if argument \code{bonferroni} 
  is set)} 
  \item{table["z"]}{z-approximation for chi squared}
  \item{table["p.z"]}{p of z-test}
  \item{table["sig.z"]}{Is it significant (will Bonferroni-adjust if argument \code{bonferroni} 
  is set)?}
  \item{table["x.perli"]}{Statistic for Perli's test}
  \item{table["sig.perli"]}{Is it significant (this is designed as a multiple test)?}
  \item{table["zl"]}{z for Lehmacher's test}
  \item{table["sig.zl"]}{Is it significant (this is designed as a multiple test)?}  
  \item{table["zl.corr"]}{z for Lehmacher's test (with continuity correction)}
  \item{table["sig.zl.corr"]}{Is it significant (this is designed as a multiple test)?}
  \item{table["p.exact.bin"]}{p for exact binomial test} 
  \item{summary.stats}{Summary stats for entire table}
  \item{summary.stats["totalchisq"]}{Total chi squared} 
  \item{summary.stats["df"]}{Degrees of freedom}
  \item{summary.stats["p"]}{p for the chi squared test}
  \item{summary.stats["sum of counts"]}{Sum of all counts}
  \item{levels}{Levels for each configuration. Should all be 2 for the bivariate case} 
}
\references{ Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin. Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse in
     Psychologie und Medizin. Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990
     }
\author{Stefan Funke <s.funke@t-online.de>}
\note{There are no hard-coded limits in the program so even large tables can be processed. 
     The output table can be very wide if the levels of factors variables are long  strings so `options(width=..)'
     may need to be adjusted. 

     The object returned has the class scfa if a one-sample CFA was performed or 
     the class mcfa if a repeated-measures CFA was performed. \code{cfa()} decides which
     one is appropriate by looking at \code{cnts}: If it is a vector, it will do a
     simple CFA. If it is a dataframe or matrix with 2 or more columns, a repeated-measures
     CFA ist done.
     }

\section{WARNING }{Note than spurious "significant" configurations are likely to appear in very large tables.
     The results should therefore be replicated before they are accepted as real. \code{boot.cfa} can be helpful to check
     the results.} 

\seealso{ \code{\link{scfa}}, \code{\link{mcfa}}}

\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
cfa(configs,counts) 
}
\keyword{multivariate}
\keyword{htest}








\eof
\name{hier.cfa}
\alias{hier.cfa}
\title{Hierachical analysis of configuration frequencies}
\description{Recursively eliminates one variable in the configuration to generate all possible
sub-tables and performs a global chi-squared-test on them
}
\usage{
hier.cfa(configs, cnts)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{configs}{ Contains the configurations. This can be a dataframe or a matrix. The dataframe can contain numbers,
              characters, factors or booleans. The matrix can consist of numbers, characters or booleans 
              (factors are implicitely re-converted to numerical levels). There must be >=3 columns.
            }
  \item{cnts}{ Contains the counts for the configuration. If it is set to NA, a count of one is assumed for every
               row. This allows untabulated data to be processed. \code{cnts} can be a vector or a matrix/dataframe with >=2 columns.
              }
}
\details{The hierarchical CFA assists in the selection of configuration variables by showing
which variables contribute the most to the variability. If eliminating a variable does not
markedly decrease the global chi squared the variable is likely to be redundant, provided there are
no extraneous reasons for retaining it. 

The output is in decreasing order of chi squared so the most useful combinations of 
variables come first.
  
}
\value{
  \item{chisq}{Global chi squared}
  \item{df}{Degrees of freedom for this subtable}
  \item{order}{Order (number of configuration variables)}
}
\references{Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion}
\author{Stefan Funke <s.funke@t-online.de>}

\note{The p for the test of significance ist provided by the print method}

\seealso{\code{\link{cfa}}, \code{\link{scfa}}, \code{\link{mcfa}}}

\examples{# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
hier.cfa(configs,counts) 
}

\keyword{multivariate}
\keyword{htest}

\eof
\name{mcfa}
\alias{mcfa}
\title{ Two or more-sample CFA}
\description{
  Performs an analysis of configuration frequencies if two or more sets of counts exist. This
  function is not generally called by the user but will be used by \code{cfa()}.
}
\usage{
mcfa(cfg, cnts=NA, sorton="chisq", sort.descending=TRUE, format.labels=TRUE)
}
\arguments{
  \item{cfg}{Contains the configurations. This can be a dataframe or a matrix. The dataframe can contain numbers,
              characters, factors or booleans. The matrix can consist of numbers, characters or booleans 
              (factors are implicitely re-converted to numerical levels). There must be >=3 columns.}
  \item{cnts}{ Contains the counts for the configuration. \code{cnts} is a matrix or dataframe with 2 or more columns.}
  \item{sorton}{ Determines the sorting order of the output. Can be set to \code{chisq}, \code{n}, or \code{label}.}
  \item{sort.descending}{Sort in descending order }
  \item{format.labels}{Format the labels of the configuration. This makes to output wider but it will increase the
        readability.}
}

\details{ This function is the "engine" \code{cfa()} will use. It does
the aggregation, summing up, and will calculate chi squared. All tests of significance are left to  \code{cfa()} 
}

\value{ The function returns the following list:
  \item{labels}{Configuration label} 
  \item{sums}{Sums for each configuration and each variable in the configuration}
  \item{counts}{Matrix of observed n of the given configuration}
  \item{expected}{Matrix of expected n for the given configuration}
  \item{chisq}{Chi squared for each configuration} 
}
\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }
     
\author{Stefan Funke <s.funke@t-online.de>}
\note{There are no hard-coded limits in the program so even large tables can be processed. 
     }

\seealso{ \code{\link{cfa}}, \code{\link{scfa}}}

\examples{ 
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts1<-trunc(runif(250)*10) 
counts2<-trunc(runif(250)*10)
mcfa(configs,cbind(counts1,counts2))
}

\keyword{multivariate}
\keyword{htest}












\eof
\name{plot.bcfa}
\alias{plot.bcfa}
\title{Plotting method for a bcfa object}
\description{Plots an object of the class \code{bcfa}}

\usage{
plot.bcfa(x,...)
}

\arguments{
  \item{x}{An object of the class \code{bcfa} which is returned by the function 
  \code{boot.cfa()}}
  \item{...}{Any arguments to be given to \code{plot}}
}
\details{
  Plots the number of cases considered significant vs. the number of cases considered
  to be a type (n > expected). 

  This is in some way like other plots of quality versus quantity.

  Configurations can be identified by left-clicking on them until the
  right mouse button is pressed. The labels of the configurations selected will be displayed
  in the text window.
}
\value{
Returns a vector of the configurations selected with their name set to the labels
}

\references{None - plots have been rarely used with the CFA}
\author{Stefan Funke <s.funke@t-online.de>}

\note{This function is usually invoked plotting an object returned by 
\code{boot.cfa}}

\seealso{ \code{\link{boot.cfa}}}

\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
plot(boot.cfa(configs,counts,runs=25))
}

\keyword{multivariate}
\keyword{htest}


\eof
\name{plot.hcfa}
\alias{plot.hcfa}
\title{Plotting method for a hcfa object}
\description{
Plots an object of the class \code{hcfa}
}
\usage{
plot.hcfa(x,...)
}
\arguments{
  \item{x}{An object of the class hcfa}
  \item{...}{Any arguments to be used by \code{plot}}
}
\details{ A dotchart is generated which plots chi squared vs. the order of the configuration 
(i.e. the number of configuration variables it contains).
}
\value{
Returns NULL.
}

\references{None - plots have been rarely used with the CFA}
\author{Stefan Funke <s.funke@t-online.de>}

\note{This function is usually invoked plotting an object returned by 
\code{hier.cfa}}

\seealso{ \code{\link{cfa}}, \code{\link{hier.cfa}}}


\examples{
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
plot(hier.cfa(configs,counts))
}

\keyword{multivariate}
\keyword{htest}

\eof
\name{plot.mcfa}
\alias{plot.mcfa}
\title{ Plotting method for a mcfa object}
\description{
Plots an object of the class \code{mcfa}
}
\usage{
plot.mcfa(x,...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{An object of the class \code{mcfa} which is returned by the function 
  \code{cfa()} (rather than \code{mcfa()}) which performs a repeated measures CFA (two or more columns of counts)}
  \item{...}{Any arguments to be used by \code{plot}}

}
\details{
Plots chi squared vs. the sum of all counts for this configuration which indicates 
pronouncedness of the configuration vs. practical importance. 
Configurations can be identified by left-clicking on them until the
right mouse button is pressed. The labels of the configurations selected will be displayed
in the text window.
}
\value{Returns a list of the labels of the configurations selected.
}

\references{None - plots have been rarely used with the CFA}
\author{Stefan Funke <s.funke@t-online.de>}

\note{This function is usually invoked plotting an object returned by 
\code{cfa}}

\seealso{ \code{\link{cfa}}, \code{\link{mcfa}}}


\examples{
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts1<-trunc(runif(250)*10)
counts2<-trunc(runif(250)*10)

plot(cfa(configs,cbind(counts1,counts2)))

}
\keyword{multivariate}
\keyword{htest}

\eof
\name{plot.scfa}
\alias{plot.scfa}
\title{ Plotting method for a scfa object}
\description{Plots an object of the class \code{scfa}
}
\usage{
plot.scfa(x,...)
}
\arguments{
  \item{x}{An object of the class \code{scfa} which is returned by the function 
  \code{cfa()} (rather than \code{scfa()}) which performs a simple CFA (one column of counts)}
  \item{...}{Any arguments to be used by \code{plot}}
}
\details{
Plots chi squared vs. n which indicates pronouncedness of the configuration vs. 
practical importance. Configurations can be identified by left-clicking on them until the
right mouse button is pressed. The labels of the configurations selected will be displayed
in the text window.
}
\value{
  Returns a list of the labels of the configurations selected.
}

\references{None - plots have been rarely used with the CFA}
\author{Stefan Funke <s.funke@t-online.de>}

\note{This function is usually invoked plotting an object returned by 
\code{cfa}}

\seealso{ \code{\link{cfa}}, \code{\link{scfa}}}


\examples{# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
plot(cfa(configs,counts))
}

\keyword{multivariate}
\keyword{htest}



\eof
\name{print.bcfa}
\alias{print.bcfa}
\title{Print an object of the class hcfa}
\description{
  Printing method for an object returned by  \code{boot.cfa()}
}
\usage{
print.bcfa(x,...)
}
\arguments{
  \item{x}{An object of the class bcfa}
  \item{...}{Additional arguments given to \code{print}}
}
\details{
  This function is usually called implicitely.
}
\value{Returns NULL
}

\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }


\author{Stefan Funke <s.funke@t-online.de>}

\seealso{ \code{\link{boot.cfa}}}

\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
result<-boot.cfa(configs,counts,runs=25) 
print(result)
}

\keyword{multivariate}
\keyword{htest}



\eof
\name{print.hcfa}
\alias{print.hcfa}
\title{Print an object of the class hcfa}
\description{
  Printing method for an object returned by  \code{hier.cfa()}
}
\usage{
print.hcfa(x,...)
}
\arguments{
  \item{x}{An object of the class hcfa}
  \item{...}{Additional arguments given to \code{print}}
}
\details{
  This function is usually called implicitely.
}
\value{ Returns NULL.
}

\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }


\author{Stefan Funke <s.funke@t-online.de>}

\seealso{ \code{\link{hier.cfa}}}

\examples{
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
result<-hier.cfa(configs,counts) 
print(result)
}

\keyword{multivariate}
\keyword{htest}

\eof
\name{print.mcfa}
\alias{print.mcfa}
\title{Print an object of the class mcfa}
\description{
  Printing method for one of two possible objects returned by  \code{cfa()}
}
\usage{
print.mcfa(x,...)
}
\arguments{
  \item{x}{An object of the class mcfa}
  \item{...}{Additional arguments given to \code{print}}
}
\details{
  This function is usually called implicitely.
}
\value{Returns NULL
}
\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }


\author{Stefan Funke <s.funke@t-online.de>}

\note{Note that \code{cfa()} will return an object with the class scfa if there is only one
row of counts. If there are two or more of them, an object with the class mcfa is returned.
In contrast \code{scfa()} and \code{mcfa()} return a list which has no class of it's own.}

\seealso{ \code{\link{cfa}}, \code{\link{mcfa}}}

\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts1<-trunc(runif(250)*10) 
counts2<-trunc(runif(250)*10)
result<-cfa(configs,cbind(counts1,counts2))
print(result)
}

\keyword{multivariate}
\keyword{htest}



\eof
\name{print.scfa}
\alias{print.scfa}
\title{Print an object of the class scfa}
\description{
  Printing method for one of two possible objects returned by  \code{cfa()}
}
\usage{
print.scfa(x,...)
}
\arguments{
  \item{x}{An object of the class scfa}
  \item{...}{Additional arguments given to \code{print}}
}
\details{
  This function is usually called implicitely.
}
\value{Returns NULL}
\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     in Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }


\author{Stefan Funke <s.funke@t-online.de>}

\note{Note that \code{cfa()} will return an object with the class scfa if there is only one
row of counts. If there are two or more of them, an object with the class mcfa is returned.
In contrast \code{scfa()} and \code{mcfa()} return a list which has no class of it's own.}

\seealso{ \code{\link{cfa}}, \code{\link{scfa}}}


\examples{
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
result<-cfa(configs,counts) 
print(result)
}

\keyword{multivariate}
\keyword{htest}


\eof
\name{scfa}
\alias{scfa}
\title{ One sample CFA}
\description{
  Performs a configuration frequency analysis if only one set of counts exists. This
  function is not generally called by the user but will be used by \code{cfa()}.
}

\usage{
scfa(cfg, cnt=NA, sorton="chisq", sort.descending=TRUE, format.labels=TRUE)
}

\arguments{
  \item{cfg}{Contains the configurations. This can be a dataframe or a matrix. The dataframe can contain numbers,
              characters, factors or booleans. The matrix can consist of numbers, characters or booleans 
              (factors are implicitely re-converted to numerical levels). There must be >=3 columns.}
  \item{cnt}{ Contains the counts for the configuration. If it is set to NA, a count of one is assumed for every
               row. This allows untabulated data to be processed. \code{cnts} is a vector.}
  \item{sorton}{ Determines the sorting order of the output. Can be set to \code{chisq}, \code{n}, or \code{label}.}
  \item{sort.descending}{Sort in descending order }
  \item{format.labels}{Format the labels of the configuration. This makes to output wider but it will increase the
        readability.}
}
\details{ This function is the "engine" \code{cfa()} will use. It does the aggregation, summing up,
and will calculate chi squared. All tests of significance are left to  \code{cfa()} 
}

\value{ The function returns the following list:
  \item{labels}{Configuration label} 
  \item{n.levels}{Number of levels for each configuration}
  \item{sums}{Sums for each configuration and each variable in the configuration}
  \item{counts}{Observed n of the given configuration}
  \item{expected}{Expected n for the given configuration}
  \item{chisq}{Chi squared for each configuration} 
}
\references{Krauth J., Lienert G. A. (1973, Reprint 1995) Die
     Konfigurationsfrequenzanalyse (KFA) und ihre Anwendung in
     Psychologie und Medizin, Beltz Psychologie Verlagsunion
     
     Lautsch, E., von Weber S. (1995) Methoden und Anwendungen der Konfigurationsfrequenzanalyse 
     Psychologie und Medizin, Beltz Psychologie Verlagsunion

     Eye, A. von (1990) Introduction to configural frequency analysis.
     The search for types and anti-types in cross-classification. 
     Cambride 1990 }
     
\author{Stefan Funke <s.funke@t-online.de>}
\note{There are no hard-coded limits in the program so even large tables can be processed. 
     }

\seealso{ \code{\link{cfa}}, \code{\link{mcfa}}}

\examples{ 
# library(cfa) if not yet loaded
# Some random configurations:
configs<-cbind(c("A","B")[rbinom(250,1,0.3)+1],c("C","D")[rbinom(250,1,0.1)+1],
          c("E","F")[rbinom(250,1,0.3)+1],c("G","H")[rbinom(250,1,0.1)+1])
counts<-trunc(runif(250)*10)
scfa(configs,counts) 
}

\keyword{multivariate}
\keyword{htest}












\eof
