\name{chron-internal}
\title{Internal chron objects}
\alias{clock2frac}
\alias{convert.chron}
\alias{convert.dates}
\alias{convert.times}
\alias{count.events}
\alias{count.fields.str}
\alias{day.abb}
\alias{day.name}
\alias{format<-}
\alias{frac2clock}
\alias{julian2mine}
\alias{mine2julian}
\alias{month.length}
\alias{my.axis}
\alias{new.chron}
\alias{origin}
\alias{origin<-}
\alias{parse.format}
\alias{unpaste}
\alias{year.expand}
\alias{year.strict}
\description{
  Internal chron objects.
}
\usage{
clock2frac(str)
convert.chron(x, format = c(dates = "m/d/y", times = "h:m:s"), origin.,
              sep = " ", enclose = c("(", ")"), \dots)
convert.dates(dates. = NULL, format = "m/d/y", origin., length. = 0, 
              \dots)
convert.times(times = NULL, format = "h:m:s", length. = 0, \dots)
count.events(x, by)
count.fields.str(str, sep = "")
day.abb
day.name
frac2clock(f)
julian2mine(x)
mine2julian(str)
month.length
my.axis(x, simplify = TRUE, \dots)
new.chron(x, new.origin = c(1, 1, 1970), shift = julian(new.origin[1], 
          new.origin[2], new.origin[3], c(0, 0, 0)))
origin(x)
parse.format(format, year.abb = getOption("chron.year.abb"), \dots)
unpaste(str, sep = "/", fnames = NULL, nfields = NULL,
        first = c(1, 3, 5), width = 2)
year.expand(y, cut.off = 30, century = c(1900, 2000), \dots)
year.strict(\dots)
}
\details{
  These are not to be called by the user.
}
\keyword{utilities}
\keyword{internal}

\eof
\name{chron}
\alias{chron}
\alias{as.chron}
\alias{as.chron.default}
\alias{as.chron.POSIXt}
\alias{is.chron}
\alias{as.data.frame.chron}
\alias{format.chron}
\alias{print.chron}
\title{
  Create a Chronological Object 
}
\description{
  Create chrononogical objects which represent dates and times of day.
}
\usage{
chron(dates., times., format = c(dates = "m/d/y", times = "h:m:s"),
      out.format, origin.)
}
\arguments{
  \item{dates.}{character or numeric vector specifying dates.  If
    character, \code{dates.} are assumed to be in one of the date
    formats below; if numeric, \code{dates.} are assumed to be Julian
    dates, i.e., number of days since \code{origin.}.}
  \item{times.}{optional character or numeric vector specifying times of
    day.  If character, \code{times.} are assumed to be in one of the
    time formats below; if numeric, \code{times.} are assumed to be
    fractions of a day.}
  \item{format}{vector or list specifying the input format of the input.
    The format can be either strings specifying one of the recognized
    formats below or a list of user-supplied functions to convert dates
    from character into Julian dates and vice versa.

    The dates format can be any permutation of the characters
    \code{"d"}, \code{"m"}, or \code{"y"} delimited by a separator
    (possibly null), e.g., \code{"m/d/y"}, \code{"d-m-y"}, \code{"ymd"},
    are all valid; the format can also be permutations of the words
    \code{"day"}, \code{"month"} and \code{"year"} (with non-null
    separator), which produces the month name, e.g., \code{"month day
      year"} produces \code{"April 20 1992"}, \code{"day mon year"}
      produces \code{"20 Apr 1992"}.

    The times format can be any permutation of \code{"h"}, \code{"m"},
    and \code{"s"} separated by any one non-special character.  The
    default is \code{"h:m:s"}.}
  \item{out.format}{vector or list specifying date and time format for
    printing and output.  Default is same as \code{format}.}
  \item{origin.}{a vector specifying the date with respect to which
    Julian dates are computed.  Default is
    \code{c(month = 1, day = 1, year = 1970)};
    you may set the option \code{chron.origin} to specify your own
    default, e.g.,
    \code{options(chron.origin = c(month=1, day=1, year=1990))}.}
}
\value{
  An object of class \code{"times"} if only \code{times.} were
  specified, \code{"dates"} if only \code{dates.}, or \code{"chron"} if
  both \code{dates.} and \code{times.} were supplied.  All these inherit
  from class \code{"times"}.

  These objects represent dates and times of day, and allow the
  following arithmetic and summaries:  subtraction \code{d1-d2},
  constant addition \code{d1+constants}, all logical comparisons,
  summaries \code{min()}, \code{max()}, and \code{range()} (which drop
  NAs by default); constants specify days (fractions are converted to
  time-of-day, e.g., 2.5 represents 2 days and 12 hours).  Operations
  such as sorting, differencing, etc., are automatically handled.

  There are methods for \code{as.character()}, \code{as.numeric()},
  \code{cut()}, \code{is.na()}, \code{print()}, \code{summary()},
  \code{plot()}, \code{lines()}, \code{lag()}, and the usual subsetting
  functions \code{[}, \code{[<-}.
  The functions \code{days()}, \code{months()}, \code{quarters()},
  \code{years()}, \code{weeks()}, \code{weekdays()}, \code{hours()},
  \code{minutes()}, and \code{seconds()} take any \code{chron} object as
  input and extract the corresponding time interval. 
  \code{cut()} is used to create ordered factors from \code{chron}
  objects.  Chronological objects may be used with the modeling software.

  The current implementation of \code{chron} objects does not handle
  time zones nor daylight savings time.
}
\seealso{
  \code{\link{dates}},
  \code{\link{times}},
  \code{\link{julian.default}},
  \code{\link{cut.dates}},
  \code{\link{seq.dates}}.
}
\examples{
dts <- dates(c("02/27/92", "02/27/92", "01/14/92",
               "02/28/92", "02/01/92"))
dts
# [1] 02/27/92 02/27/92 01/14/92 02/28/92 02/01/92
tms <- times(c("23:03:20", "22:29:56", "01:03:30",
               "18:21:03", "16:56:26"))
tms
# [1] 23:03:20 22:29:56 01:03:30 18:21:03 16:56:26
x <- chron(dates = dts, times = tms)
x
# [1] (02/27/92 23:03:19) (02/27/92 22:29:56) (01/14/92 01:03:30)
# [4] (02/28/92 18:21:03) (02/01/92 16:56:26)

# We can add or subtract scalars (representing days) to dates or
# chron objects:
c(dts[1], dts[1] + 10)
# [1] 02/27/92 03/08/92
dts[1] - 31
# [1] 01/27/92

# We can substract dates which results in a times object that
# represents days between the operands:
dts[1] - dts[3]
# Time in days:
# [1] 44

# Logical comparisons work as expected:
dts[dts > "01/25/92"]
# [1] 02/27/92 02/27/92 02/28/92 02/01/92
dts > dts[3]
# [1]  TRUE  TRUE FALSE  TRUE  TRUE

# Summary operations which are sensible are permitted and work as
# expected:
range(dts)
# [1] 01/14/92 02/28/92
diff(x)
# Time in days:
# [1]  -0.02319444 -44.89335648  45.72052083 -27.05876157
sort(dts)[1:3]
# [1] 01/14/92 02/01/92 02/27/92
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{cut.dates}
\alias{cut.dates}
\title{
  Create a Factor from a Chron or Dates Object
}
\description{
  Divide the range of a chron or dates object \code{x} into intervals
  and code the values in \code{x} according to which interval they fall.
}
\usage{
\method{cut}{dates}(x, breaks, labels, start.on.monday = TRUE, \dots)
}
\arguments{
  \item{x}{chron or dates object (see \code{chron}), character dates
    such as \code{"10/04/91"} or Julian dates).}
  \item{breaks}{either a vector of break points (a \code{dates} vector,
    character dates such as \code{"10/04/91"} or Julian dates), a
    constant specifying number of equally spaced intervals extending
    from \code{min(x)-1} to \code{max(x)+1}, or one of the strings in
    \code{c("days", "weeks", "months", "year")} specifying a time
    period.}
  \item{labels}{character labels for intervals.}
  \item{start.on.monday}{should  weeks be assumed to start on Mondays?
    Default is \code{TRUE}.  Set to \code{FALSE} if weeks start on
    Sundays; for other days of the week specify the corresponding
    number: Sunday == 0, Monday == 1, Tuesday == 2, \dots{}, Saturday ==
    6.}
  \item{\dots}{further arguments to be passed to or from methods.}
}
\value{an ordered factor whose levels represent the various time
  intervals.}
\seealso{
  \code{\link{seq.dates}}}
\examples{
# days from 07/01/92 thru 07/15/92 fell into 3 Monday-started weeks
cut(dates("07/01/92") + 0:14, "weeks")
# [1] week 1 week 1 week 1 week 1 week 1 week 2 week 2 week 2 
# [9] week 2 week 2 week 2 week 2 week 3 week 3 week 3

dts <- dates(c("02/27/92", "02/27/92", "01/14/92",
               "02/28/92", "02/01/92"))
cut(dts, "months")
# [1] Feb 92 Feb 92 Jan 92 Feb 92 Feb 92
boxplot(runif(5) ~ cut(dts, "months"))
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{dates}
\alias{dates}
\alias{times}
\alias{Math.dates}
\alias{Ops.dates}
\alias{Summary.dates}
\alias{[<-.dates}
\alias{all.equal.dates}
\alias{as.data.frame.dates}
\alias{c.dates}
\alias{format.dates}
\alias{print.dates}
\alias{trunc.dates}
\alias{Math.times}
\alias{Ops.times}
\alias{Summary.times}
\alias{[.times}
\alias{[<-.times}
\alias{[[.times}
\alias{as.character.times}
\alias{as.data.frame.times}
\alias{axis.times}
\alias{c.times}
\alias{diff.times}
\alias{format.times}
\alias{format<-.times}
\alias{hist.times}
\alias{identify.times}
\alias{is.na.times}
\alias{lines.times}
\alias{mean.times}
\alias{plot.times}
\alias{points.times}
\alias{print.times}
\alias{quantile.times}
\alias{summary.times}
\title{
  Generate Dates and Times Components from Input
}
\description{
  Create objects which represent dates or times.
}
\usage{
dates(x, \dots)
times(x, \dots)
}
\arguments{
  \item{x}{a chron object, a character vector, or a numeric vector
    specifying time. If character, it must be in a format recognized by
    \code{chron()}.  If numeric, it specifies Julian dates, i.e., number
    of days since an origin.}
  \item{...}{parameters for \code{chron()}.}
}
\value{
  An object of class \code{dates} or \code{times}, depending of the
  function called.

  These functions return objects inheriting from dates and times,
  respectively.  They call \code{chron()} if \code{x} does not belong to
  any of the chronological classes.
}
\examples{
dts <- dates(c("02/27/92", "02/27/92", "01/14/92",
               "02/28/92", "02/01/92"))
dts
# [1] 02/27/92 02/27/92 01/14/92 02/28/92 02/01/92
class(dts)

x <- chron(dates = c("02/27/92", "02/27/92", "01/14/92", "02/28/92"),
           times = c("23:03:20", "22:29:56", "01:03:30", "18:21:03"))
dates(x)
# [1] 02/27/92 02/27/92 01/14/92 02/28/92
}
\seealso{
  \code{\link{chron}},
  \code{\link{times}},
  \code{\link{seq.dates}},
  \code{\link{cut.dates}}
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{day.of.week}
\alias{day.of.week}
\alias{julian.default}
\alias{leap.year}
\alias{month.day.year}
\title{
  Convert between Julian and Calendar Dates
}
\description{
  Utility functions to convert between Julian dates (numbers of days
  since an origin, by default 1970-01-01) and calendar dates given by
  year, month, and day within the month.
}
\usage{
\method{julian}{default}(x, d, y, origin., \dots)
month.day.year(jul, origin.)
leap.year(y)
day.of.week(month, day, year)
}
\arguments{
  \item{x, month}{vector of month numbers.}
  \item{d, day}{vector of day numbers.}
  \item{y, year}{vector of years.}
  \item{jul}{vector of Julian Dates, i.e., number of days since
    \code{origin.}.}
  \item{origin.}{vector specifying the origin as month, day, and year.
    If missing, it defaults to \code{getOption("chron.origin")} if this
    is non-null, otherwise
    \code{c(month = 1, day = 1, year = 1970)}.}
  \item{\dots}{further arguments to be passed to or from methods.}
}
\value{
  A vector of Julian dates (number of days since \code{origin.}) when
  \code{julian()} is called, or a list with members \code{month},
  \code{day}, \code{year} corresponding to the input Julian dates if
  \code{month.day.year()} is called.  \code{leap.year()} returns a
  logical vector indicating whether the corresponding year is a leap
  year.
  \code{day.of.week()} returns a number between 0 and 6 to specify day
  of the week--0 refers to Sunday.

  These functions were taken from Becker, Chambers, and Wilks (1988),
  and were slightly modified to take \code{chron} and \code{dates}
  objects; some also take the extra argument \code{origin.}.
  %The original functions are stored in the \code{library(example)}.
}
\seealso{
  \code{\link{chron}},
  \code{\link{dates}},
  \code{\link{times}}
}
\examples{
julian(1, 1, 1970)
# [1] 0
unlist(month.day.year(0))
# month   day  year 
#     1     1  1970 
}
\keyword{chron}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{days}
\alias{days}
\alias{months.default}
\alias{quarters.default}
\alias{weekdays.default}
\alias{years}
\title{
  Return Various Periods from a Chron or Dates Object
}
\description{
  Given a chron or dates object, extract the year, quarter, month, day
  (within the month) or weekday (days within the week) of the date it
  represents.
}
\usage{
days(x)
\method{weekdays}{default}(x, abbreviate = TRUE)
\method{months}{default}(x, abbreviate = TRUE)
\method{quarters}{default}(x, abbreviate = TRUE)
years(x)
}
\arguments{
  \item{x}{
    a dates object.
  }
  \item{abbreviate}{
    should abbreviated names be returned? Default is \code{TRUE}.
}}
\value{
  an ordered factor corresponding to days, weekdays, months, quarters,
  or years of \code{x} for the respective function.
}
\seealso{
  \code{\link{is.weekend}}, \code{\link{is.holiday}}
}
\examples{
dts <- dates("07/01/78") + trunc(50 * rnorm(30))
plot(weekdays(dts))
plot(months(dts))
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{hours}
\alias{hours}
\alias{minutes}
\alias{seconds}
\title{
  Return Hours, Minutes, or Seconds from a Times Object
}
\description{
  Given a chron or times object, extract the hours, minutes or seconds
  of the time it represents.
}
\usage{
hours(x)
minutes(x)
seconds(x)
}
\arguments{
  \item{x}{an object inheriting from class \code{"times"}.}
}
\value{
  the corresponding time period as an ordered factor.
}
\examples{
x <- chron(dates = c("02/27/92", "02/27/92", "01/14/92", "02/28/92"),
           times = c("23:03:20", "22:29:56", "01:03:30", "18:21:03"))
h <- hours(x)
y <- runif(4)
boxplot(y ~ h)
}
\seealso{
  \code{\link{chron}},
  \code{\link{dates}},
  \code{\link{times}}
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{is.holiday}
\alias{is.holiday}
\alias{is.weekend}
\alias{.Holidays}
\title{
  Find Weekends and Holidays in a Chron or Dates Object
}
\description{
  Determine the date represented by a chron or dates object is a weekend
  or a holiday.
}
\usage{
is.weekend(x)
is.holiday(x, holidays)
.Holidays
}
\arguments{
  \item{x}{an object inheriting from \code{"dates"}, or coercible to
    \code{"chron"}.}
  \item{holidays}{optional \code{"chron"} or \code{"dates"} object
    listing holidays.  If argument \code{holidays} is missing, either
    the value of the object \code{.Holidays} (if it exists) or
    \code{NULL} will be used.}
}
\value{
  a logical object indicating whether the corresponding date is a
  weekend in the case of \code{is.weekend()} or a holiday in the case of
  \code{is.holiday()}.
}
\seealso{
  \code{\link{days}},
  \code{\link{weekdays.default}},
  \code{\link{months.default}},
  \code{\link{quarters.default}},
  \code{\link{years}};
  \code{\link{chron}},
  \code{\link{dates}},
  \code{\link{cut.dates}},
  \code{\link{seq.dates}}
}
\examples{
dts <- dates("01/01/98") + trunc(365 * runif(50))
table(is.weekend(dts))

.Holidays
# New Year Memorial Indepen. Labor day Thanksgiving Christmas 
# 01/01/92 05/25/92 07/04/92  09/07/92     11/26/92  12/25/92
# NOTE:  Only these 6 holidays from 1992 are defined by default!
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
\name{seq.dates}
\alias{seq.dates}
\title{
  Generate Chron or Dates Sequences
}
\description{
  Generate a regular sequence of dates.
}
\usage{
seq.dates(from, to, by = "days", length., \dots)
}
\arguments{
  \item{from}{starting date; it can be a chron or dates object, a
    character string, e.g., \code{"05/23/91"}, or a Julian date.}
  \item{to}{ending date, like \code{from}.}
  \item{by}{either a numeric value or one of the valid strings
    \code{"days"}, \code{"weeks"}, \code{"months"}, or \code{"years"}.}
  \item{length.}{optional number of elements in the sequence.}
  \item{\dots}{further arguments to be passed to or from methods.}
}
\value{a sequence with values (\code{form}, \code{from + by},
  \code{from + 2*by}, \code{\dots{}}, \code{to}) of class
  \code{class(from)} and origin \code{origin(from)}. 
  Note that \code{from} must be less than or equal to the argument
  \code{to}.
}
\examples{
seq.dates("01/01/92", "12/31/92", by = "months")
# [1] 01/01/92 02/01/92 03/01/92 04/01/92 05/01/92 06/01/92
# [7] 07/01/92 08/01/92 09/01/92 10/01/92 11/01/92 12/01/92

end.of.the.month <- seq.dates("02/29/92", by = "month", length = 15)
end.of.the.month
#  [1] 02/29/92 03/31/92 04/30/92 05/31/92 06/30/92 07/31/92
#  [7] 08/31/92 09/30/92 10/31/92 11/30/92 12/31/92 01/31/93
# [13] 02/28/93 03/31/93 04/30/93
}
\seealso{
  \code{\link{chron}},
  \code{\link{dates}},
  \code{\link{cut.dates}}
}
% Converted by Sd2Rd version 0.2-a3.
\keyword{chron}

\eof
