retrieve.nc            package:clim.pact            R Documentation

_R_e_t_r_i_e_v_e _d_a_t_a _f_r_o_m _a _n_e_t_C_D_F _f_i_l_e

_D_e_s_c_r_i_p_t_i_o_n:

     Reads a netCDF file and picks out vectors that look like lngitude,
     latitude and time. Returns the first 3-D field in the file. See
     also 'cdfextract' (large data files). 

     This version uses 'cdfcont' to obtain vital meta data for handling
     the data in the netCDF file and constructing a 'field' object.

     This routine unfortunately only currently works on Linux platforms
     since the  'ncdf'-package is only available for Linux systems.

_U_s_a_g_e:

     retrieve.nc(filename=file.path("data","ncep_t2m.nc"),v.nam="AUTO",
                             l.scale=TRUE,greenwich=TRUE,
                             x.nam="lon",y.nam="lat",z.nam="lev",t.nam="tim",
                             x.rng=NULL,y.rng=NULL,t.rng=NULL,force.chron=TRUE)

_A_r_g_u_m_e_n_t_s:

filename: name of netCDF file.

   v.nam: name of variable. "AUTO" -> smart search.

 l.scale: 'TRUE' uses scaling.factor and add.offset.

greenwich: 'TRUE' centres maps on Greenwhich meridian (0 deg E).

   x.nam: Name of x-dimension.

   y.nam: Name of y-dimension.

   z.nam: Name of z-dimension.

   t.nam: Name of time-axis.

   x.rng: Region to extract.

   y.rng: Region to extract.

   t.rng: Time interval to extract.

force.chron: Check for monotonic chronological order (no jumping back
          and forth in time).

_V_a_l_u_e:

     A "field.object" list:

       dat     a 3-D matrix with the data.
       lon     a vector of longitudes.
       lat     a vector of latitudes.
       tim     a vector of times from time.0 (see attributes).
       lev     a vector of vertical levels (NULL for single level).
       v.name  variable name.
       id.x    ID labels for the spatial grid (for mixed fields, see 'mixFields').
       id.t    ID labels for the time axis (for combined fields).
       yy      a vector of years corresponding to 'tim'.
       mm      a vector of months corresponding to 'tim'.
       dd      a vector of days corresponding to 'tim'.
       n.fld   number of fields (for mixed fields, see 'mixFields').
       id.lon  ID labels along the longitudes (for mixed fields, see 'mixFields').
       id.lat  ID labels along the latitudes (for mixed fields, see 'mixFields').

     .

_A_u_t_h_o_r(_s):

     R.E. Benestad

_E_x_a_m_p_l_e_s:

     ## Not run: 
     X.1 <- retrieve.nc("data/mpi-gsdio_t2m.nc",
                        x.rng=c(-60,40),y.rng=c(50,75))
     X.2 <- retrieve.nc("data/mpi-gsdio_slp.nc",
                        x.rng=c(-60,40),y.rng=c(50,75))

     # The definition of a 'field' object is:
     ny<-length(slp$lat); nx<-length(slp$lon)
     slp  <- list(dat=X.2$dat,lon=X.2$lon,lat=X.2$lat,tim=X.2$tim,lev=X.2$lev,
                  v.name=X.2$v.nam,id.x=X.2$id.x,id.t=X.2$id.t,
                  yy=X.2$yy,mm=X.2$mm,dd=X.2$dd,n.fld=1,
                  id.lon=rep(X.2$v.name,nx),id.lat=rep(X.2$v.name,ny),
                  attributes=dat.att)
      class(slp) <- c("field")

     ## End(Not run)

